/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.CountrySpecification;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.zzl;
import java.util.ArrayList;
import java.util.Collection;

public final class MaskedWalletRequest
implements SafeParcelable {
    public static final Parcelable.Creator<MaskedWalletRequest> CREATOR = new zzl();
    private final int mVersionCode;
    String zzbcq;
    boolean zzbdl;
    boolean zzbdm;
    boolean zzbdn;
    String zzbdo;
    String zzbcj;
    String zzbdp;
    Cart zzbcA;
    boolean zzbdq;
    boolean zzbdr;
    CountrySpecification[] zzbds;
    boolean zzbdt;
    boolean zzbdu;
    ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> zzbdv;
    PaymentMethodTokenizationParameters zzbdw;
    ArrayList<Integer> zzbdx;

    public static Builder newBuilder() {
        MaskedWalletRequest maskedWalletRequest = new MaskedWalletRequest();
        maskedWalletRequest.getClass();
        return maskedWalletRequest.new Builder();
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzl.zza(this, dest, flags);
    }

    MaskedWalletRequest(int versionCode, String merchantTransactionId, boolean phoneNumberRequired, boolean shippingAddressRequired, boolean useMinimalBillingAddress, String estimatedTotalPrice, String currencyCode, String merchantName, Cart cart, boolean shouldRetrieveWalletObjects, boolean isBillingAgreement, CountrySpecification[] allowedShippingCountrySpecifications, boolean allowPrepaidCard, boolean allowDebitCard, ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> allowedCountrySpecificationsForShipping, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, ArrayList<Integer> allowedCardNetworks) {
        this.mVersionCode = versionCode;
        this.zzbcq = merchantTransactionId;
        this.zzbdl = phoneNumberRequired;
        this.zzbdm = shippingAddressRequired;
        this.zzbdn = useMinimalBillingAddress;
        this.zzbdo = estimatedTotalPrice;
        this.zzbcj = currencyCode;
        this.zzbdp = merchantName;
        this.zzbcA = cart;
        this.zzbdq = shouldRetrieveWalletObjects;
        this.zzbdr = isBillingAgreement;
        this.zzbds = allowedShippingCountrySpecifications;
        this.zzbdt = allowPrepaidCard;
        this.zzbdu = allowDebitCard;
        this.zzbdv = allowedCountrySpecificationsForShipping;
        this.zzbdw = paymentMethodTokenizationParameters;
        this.zzbdx = allowedCardNetworks;
    }

    MaskedWalletRequest() {
        this.mVersionCode = 3;
        this.zzbdt = true;
        this.zzbdu = true;
    }

    public String getMerchantTransactionId() {
        return this.zzbcq;
    }

    public boolean isPhoneNumberRequired() {
        return this.zzbdl;
    }

    public boolean isShippingAddressRequired() {
        return this.zzbdm;
    }

    public boolean useMinimalBillingAddress() {
        return this.zzbdn;
    }

    public String getEstimatedTotalPrice() {
        return this.zzbdo;
    }

    public String getCurrencyCode() {
        return this.zzbcj;
    }

    public String getMerchantName() {
        return this.zzbdp;
    }

    public Cart getCart() {
        return this.zzbcA;
    }

    public boolean isBillingAgreement() {
        return this.zzbdr;
    }

    public CountrySpecification[] getAllowedShippingCountrySpecifications() {
        return this.zzbds;
    }

    public boolean allowPrepaidCard() {
        return this.zzbdt;
    }

    public boolean allowDebitCard() {
        return this.zzbdu;
    }

    public ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> getAllowedCountrySpecificationsForShipping() {
        return this.zzbdv;
    }

    public PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzbdw;
    }

    public ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzbdx;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setMerchantTransactionId(String merchantTransactionId) {
            MaskedWalletRequest.this.zzbcq = merchantTransactionId;
            return this;
        }

        public Builder setPhoneNumberRequired(boolean phoneNumberRequired) {
            MaskedWalletRequest.this.zzbdl = phoneNumberRequired;
            return this;
        }

        public Builder setShippingAddressRequired(boolean shippingAddressRequired) {
            MaskedWalletRequest.this.zzbdm = shippingAddressRequired;
            return this;
        }

        public Builder setUseMinimalBillingAddress(boolean useMinimalBillingAddress) {
            MaskedWalletRequest.this.zzbdn = useMinimalBillingAddress;
            return this;
        }

        public Builder setEstimatedTotalPrice(String estimatedTotalPrice) {
            MaskedWalletRequest.this.zzbdo = estimatedTotalPrice;
            return this;
        }

        public Builder setCurrencyCode(String currencyCode) {
            MaskedWalletRequest.this.zzbcj = currencyCode;
            return this;
        }

        public Builder setMerchantName(String merchantName) {
            MaskedWalletRequest.this.zzbdp = merchantName;
            return this;
        }

        public Builder setCart(Cart cart) {
            MaskedWalletRequest.this.zzbcA = cart;
            return this;
        }

        public Builder setIsBillingAgreement(boolean isBillingAgreement) {
            MaskedWalletRequest.this.zzbdr = isBillingAgreement;
            return this;
        }

        public Builder setAllowPrepaidCard(boolean allowPrepaidCard) {
            MaskedWalletRequest.this.zzbdt = allowPrepaidCard;
            return this;
        }

        public Builder setAllowDebitCard(boolean allowDebitCard) {
            MaskedWalletRequest.this.zzbdu = allowDebitCard;
            return this;
        }

        public Builder addAllowedCountrySpecificationForShipping(com.google.android.gms.identity.intents.model.CountrySpecification countrySpecification) {
            if (MaskedWalletRequest.this.zzbdv == null) {
                MaskedWalletRequest.this.zzbdv = new ArrayList();
            }
            MaskedWalletRequest.this.zzbdv.add(countrySpecification);
            return this;
        }

        public Builder addAllowedCountrySpecificationsForShipping(Collection<com.google.android.gms.identity.intents.model.CountrySpecification> countrySpecifications) {
            if (countrySpecifications != null) {
                if (MaskedWalletRequest.this.zzbdv == null) {
                    MaskedWalletRequest.this.zzbdv = new ArrayList();
                }
                MaskedWalletRequest.this.zzbdv.addAll(countrySpecifications);
            }
            return this;
        }

        public Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            MaskedWalletRequest.this.zzbdw = paymentMethodTokenizationParameters;
            return this;
        }

        public Builder addAllowedCardNetwork(int allowedCardNetwork) {
            if (MaskedWalletRequest.this.zzbdx == null) {
                MaskedWalletRequest.this.zzbdx = new ArrayList();
            }
            MaskedWalletRequest.this.zzbdx.add(allowedCardNetwork);
            return this;
        }

        public Builder addAllowedCardNetworks(Collection<Integer> allowedCardNetworks) {
            if (allowedCardNetworks != null) {
                if (MaskedWalletRequest.this.zzbdx == null) {
                    MaskedWalletRequest.this.zzbdx = new ArrayList();
                }
                MaskedWalletRequest.this.zzbdx.addAll(allowedCardNetworks);
            }
            return this;
        }

        public MaskedWalletRequest build() {
            return MaskedWalletRequest.this;
        }
    }
}

