/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzh;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PutDataRequest
extends zza {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new zzh();
    private static final long zzbQX = TimeUnit.MINUTES.toMillis(30L);
    private static final Random zzbQY = new SecureRandom();
    final int mVersionCode;
    private final Uri mUri;
    private final Bundle zzbQZ;
    private byte[] zzbeh;
    private long zzbRa;

    PutDataRequest(int n, Uri uri, Bundle bundle, byte[] byArray, long l) {
        this.mVersionCode = n;
        this.mUri = uri;
        this.zzbQZ = bundle;
        this.zzbQZ.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.zzbeh = byArray;
        this.zzbRa = l;
    }

    private PutDataRequest(int n, Uri uri) {
        this(n, uri, new Bundle(), null, zzbQX);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    public static PutDataRequest createFromDataItem(DataItem dataItem) {
        PutDataRequest putDataRequest = PutDataRequest.zzy(dataItem.getUri());
        for (Map.Entry<String, DataItemAsset> entry : dataItem.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                String string = String.valueOf(entry.getKey());
                throw new IllegalStateException(string.length() != 0 ? "Cannot create an asset for a put request without a digest: ".concat(string) : new String("Cannot create an asset for a put request without a digest: "));
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(dataItem.getData());
        return putDataRequest;
    }

    public static PutDataRequest zzy(Uri uri) {
        return new PutDataRequest(2, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!string.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(zzbQY.nextLong());
        Uri uri = PutDataRequest.zziq(stringBuilder.toString());
        return new PutDataRequest(2, uri);
    }

    public static PutDataRequest create(String string) {
        Uri uri = PutDataRequest.zziq(string);
        return PutDataRequest.zzy(uri);
    }

    private static Uri zziq(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.zzbeh;
    }

    public PutDataRequest setData(byte[] byArray) {
        this.zzbeh = byArray;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzbQZ.keySet()) {
            hashMap.put(string, (Asset)this.zzbQZ.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle zzSE() {
        return this.zzbQZ;
    }

    public Asset getAsset(String string) {
        return (Asset)this.zzbQZ.getParcelable(string);
    }

    public boolean hasAsset(String string) {
        return this.zzbQZ.containsKey(string);
    }

    public PutDataRequest putAsset(String string, Asset asset) {
        zzac.zzw((Object)string);
        zzac.zzw((Object)((Object)asset));
        this.zzbQZ.putParcelable(string, (Parcelable)asset);
        return this;
    }

    public PutDataRequest removeAsset(String string) {
        this.zzbQZ.remove(string);
        return this;
    }

    public long zzSF() {
        return this.zzbRa;
    }

    public boolean isUrgent() {
        return this.zzbRa == 0L;
    }

    public PutDataRequest setUrgent() {
        this.zzbRa = 0L;
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        String string = String.valueOf(this.zzbeh == null ? "null" : Integer.valueOf(this.zzbeh.length));
        stringBuilder.append(new StringBuilder(7 + String.valueOf(string).length()).append("dataSz=").append(string).toString());
        int n = this.zzbQZ.size();
        stringBuilder.append(new StringBuilder(23).append(", numAssets=").append(n).toString());
        String string2 = String.valueOf(this.mUri);
        stringBuilder.append(new StringBuilder(6 + String.valueOf(string2).length()).append(", uri=").append(string2).toString());
        long l = this.zzbRa;
        stringBuilder.append(new StringBuilder(35).append(", syncDeadline=").append(l).toString());
        if (!bl) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.zzbQZ.keySet();
        for (String string3 : set) {
            String string4 = String.valueOf(this.zzbQZ.getParcelable(string3));
            stringBuilder.append(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("\n    ").append(string3).append(": ").append(string4).toString());
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

