/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.wearable.zze;
import java.util.Arrays;

public class Asset
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zze();
    private byte[] zzbeL;
    private String zzbSO;
    public ParcelFileDescriptor zzbSP;
    public Uri uri;

    Asset(byte[] byArray, String string, ParcelFileDescriptor parcelFileDescriptor, Uri uri) {
        this.zzbeL = byArray;
        this.zzbSO = string;
        this.zzbSP = parcelFileDescriptor;
        this.uri = uri;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n | 1);
    }

    public static Asset createFromRef(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(null, string, null, null);
    }

    public static Asset createFromBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(byArray, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(null, null, parcelFileDescriptor, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(null, null, null, uri);
    }

    public byte[] getData() {
        return this.zzbeL;
    }

    public String getDigest() {
        return this.zzbSO;
    }

    public ParcelFileDescriptor getFd() {
        return this.zzbSP;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.zzbeL, this.zzbSO, this.zzbSP, this.uri});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)((Object)object);
        return Arrays.equals(this.zzbeL, asset.zzbeL) && zzaa.equal((Object)this.zzbSO, (Object)asset.zzbSO) && zzaa.equal((Object)this.zzbSP, (Object)asset.zzbSP) && zzaa.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzbSO == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzbSO);
        }
        if (this.zzbeL != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.zzbeL.length);
        }
        if (this.zzbSP != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zzbSP);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

