/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzh;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class PutDataRequest
extends zza {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new zzh();
    private static final long zzbRj = TimeUnit.MINUTES.toMillis(30L);
    private static final Random zzbRk = new SecureRandom();
    private final Uri mUri;
    private final Bundle zzbRl;
    private byte[] zzbec;
    private long zzbRm;

    PutDataRequest(Uri uri, Bundle bundle, byte[] byArray, long l) {
        this.mUri = uri;
        this.zzbRl = bundle;
        this.zzbRl.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.zzbec = byArray;
        this.zzbRm = l;
    }

    private PutDataRequest(Uri uri) {
        this(uri, new Bundle(), null, zzbRj);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PutDataRequest putDataRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)putDataRequest.getUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Bundle)putDataRequest.zzbRl, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (byte[])putDataRequest.getData(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (long)putDataRequest.zzbRm);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static PutDataRequest createFromDataItem(DataItem dataItem) {
        PutDataRequest putDataRequest = PutDataRequest.zzt(dataItem.getUri());
        for (Map.Entry<String, DataItemAsset> entry : dataItem.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                String string = String.valueOf(entry.getKey());
                throw new IllegalStateException(string.length() != 0 ? "Cannot create an asset for a put request without a digest: ".concat(string) : new String("Cannot create an asset for a put request without a digest: "));
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(dataItem.getData());
        return putDataRequest;
    }

    public static PutDataRequest zzt(Uri uri) {
        return new PutDataRequest(uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!string.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(zzbRk.nextLong());
        Uri uri = PutDataRequest.zzgl(stringBuilder.toString());
        return new PutDataRequest(uri);
    }

    public static PutDataRequest create(String string) {
        return PutDataRequest.zzt(PutDataRequest.zzgl(string));
    }

    private static Uri zzgl(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.zzbec;
    }

    public PutDataRequest setData(byte[] byArray) {
        this.zzbec = byArray;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzbRl.keySet()) {
            hashMap.put(string, (Asset)this.zzbRl.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Asset getAsset(String string) {
        return (Asset)this.zzbRl.getParcelable(string);
    }

    public boolean hasAsset(String string) {
        return this.zzbRl.containsKey(string);
    }

    public PutDataRequest putAsset(String string, Asset asset) {
        zzbr.zzu((Object)string);
        zzbr.zzu((Object)((Object)asset));
        this.zzbRl.putParcelable(string, (Parcelable)asset);
        return this;
    }

    public PutDataRequest removeAsset(String string) {
        this.zzbRl.remove(string);
        return this;
    }

    public boolean isUrgent() {
        return this.zzbRm == 0L;
    }

    public PutDataRequest setUrgent() {
        this.zzbRm = 0L;
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        String string = String.valueOf(this.zzbec == null ? "null" : Integer.valueOf(this.zzbec.length));
        stringBuilder.append(new StringBuilder(7 + String.valueOf(string).length()).append("dataSz=").append(string).toString());
        int n = this.zzbRl.size();
        stringBuilder.append(new StringBuilder(23).append(", numAssets=").append(n).toString());
        String string2 = String.valueOf(this.mUri);
        stringBuilder.append(new StringBuilder(6 + String.valueOf(string2).length()).append(", uri=").append(string2).toString());
        long l = this.zzbRm;
        stringBuilder.append(new StringBuilder(35).append(", syncDeadline=").append(l).toString());
        if (!bl) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        for (String string3 : this.zzbRl.keySet()) {
            String string4 = String.valueOf(this.zzbRl.getParcelable(string3));
            stringBuilder.append(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("\n    ").append(string3).append(": ").append(string4).toString());
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

