/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.wearable.zze;
import java.util.Arrays;

public class Asset
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zze();
    private byte[] zzbdY;
    private String zzbQX;
    private ParcelFileDescriptor zzbQY;
    private Uri uri;

    Asset(byte[] byArray, String string, ParcelFileDescriptor parcelFileDescriptor, Uri uri) {
        this.zzbdY = byArray;
        this.zzbQX = string;
        this.zzbQY = parcelFileDescriptor;
        this.uri = uri;
    }

    public void writeToParcel(Parcel parcel, int n) {
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        Asset asset = this;
        int n3 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (byte[])asset.zzbdY, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)asset.getDigest(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)asset.zzbQY, (int)n2, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)asset.uri, (int)n2, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n3);
    }

    public static Asset createFromRef(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(null, string, null, null);
    }

    public static Asset createFromBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(byArray, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(null, null, parcelFileDescriptor, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(null, null, null, uri);
    }

    public final byte[] getData() {
        return this.zzbdY;
    }

    public String getDigest() {
        return this.zzbQX;
    }

    public ParcelFileDescriptor getFd() {
        return this.zzbQY;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.zzbdY, this.zzbQX, this.zzbQY, this.uri});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)((Object)object);
        return Arrays.equals(this.zzbdY, asset.zzbdY) && zzbe.equal((Object)this.zzbQX, (Object)asset.zzbQX) && zzbe.equal((Object)this.zzbQY, (Object)asset.zzbQY) && zzbe.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzbQX == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzbQX);
        }
        if (this.zzbdY != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.zzbdY.length);
        }
        if (this.zzbQY != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zzbQY);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

