/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzdlz;
import com.google.android.gms.internal.zzdma;
import com.google.android.gms.internal.zzdmb;
import com.google.android.gms.internal.zzfjr;
import com.google.android.gms.internal.zzfjs;
import com.google.android.gms.wearable.Asset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class DataMap {
    public static final String TAG = "DataMap";
    private final HashMap<String, Object> zzaln = new HashMap();

    public DataMap() {
    }

    public static DataMap fromBundle(@NonNull Bundle bundle) {
        bundle.setClassLoader(Asset.class.getClassLoader());
        DataMap dataMap = new DataMap();
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            String string2 = string;
            DataMap dataMap2 = dataMap;
            if (object instanceof String) {
                dataMap2.putString(string2, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                dataMap2.putInt(string2, (Integer)object);
                continue;
            }
            if (object instanceof Long) {
                dataMap2.putLong(string2, (Long)object);
                continue;
            }
            if (object instanceof Double) {
                dataMap2.putDouble(string2, (Double)object);
                continue;
            }
            if (object instanceof Float) {
                dataMap2.putFloat(string2, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof Boolean) {
                dataMap2.putBoolean(string2, (Boolean)object);
                continue;
            }
            if (object instanceof Byte) {
                dataMap2.putByte(string2, (Byte)object);
                continue;
            }
            if (object instanceof byte[]) {
                dataMap2.putByteArray(string2, (byte[])object);
                continue;
            }
            if (object instanceof String[]) {
                dataMap2.putStringArray(string2, (String[])object);
                continue;
            }
            if (object instanceof long[]) {
                dataMap2.putLongArray(string2, (long[])object);
                continue;
            }
            if (object instanceof float[]) {
                dataMap2.putFloatArray(string2, (float[])object);
                continue;
            }
            if (object instanceof Asset) {
                dataMap2.putAsset(string2, (Asset)((Object)object));
                continue;
            }
            if (object instanceof Bundle) {
                dataMap2.putDataMap(string2, DataMap.fromBundle((Bundle)object));
                continue;
            }
            if (object instanceof ArrayList) {
                switch (DataMap.zze((ArrayList)object)) {
                    case 0: {
                        dataMap2.putStringArrayList(string2, (ArrayList)object);
                        break;
                    }
                    case 1: {
                        dataMap2.putStringArrayList(string2, (ArrayList)object);
                        break;
                    }
                    case 3: {
                        dataMap2.putStringArrayList(string2, (ArrayList)object);
                        break;
                    }
                    case 2: {
                        dataMap2.putIntegerArrayList(string2, (ArrayList)object);
                        break;
                    }
                    case 5: {
                        dataMap2.putDataMapArrayList(string2, DataMap.arrayListFromBundleArrayList((ArrayList)object));
                    }
                }
            }
        }
        return dataMap;
    }

    public static DataMap fromByteArray(@NonNull byte[] byArray) {
        try {
            return zzdlz.zza(new zzdma(zzdmb.zzaa(byArray), new ArrayList<Asset>()));
        }
        catch (zzfjr zzfjr2) {
            throw new IllegalArgumentException("Unable to convert data", zzfjr2);
        }
    }

    public static ArrayList<DataMap> arrayListFromBundleArrayList(@NonNull ArrayList<Bundle> arrayList) {
        ArrayList<DataMap> arrayList2 = new ArrayList<DataMap>();
        ArrayList<Bundle> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Bundle bundle = arrayList3.get(i);
            Bundle bundle2 = bundle;
            arrayList2.add(DataMap.fromBundle(bundle2));
        }
        return arrayList2;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        for (String string : this.zzaln.keySet()) {
            DataMap.zzb(bundle, string, this.zzaln.get(string));
        }
        return bundle;
    }

    public byte[] toByteArray() {
        return zzfjs.zzc((zzfjs)zzdlz.zza((DataMap)this).zzlmg);
    }

    public int size() {
        return this.zzaln.size();
    }

    public boolean isEmpty() {
        return this.zzaln.isEmpty();
    }

    public void clear() {
        this.zzaln.clear();
    }

    public boolean containsKey(@NonNull String string) {
        return this.zzaln.containsKey(string);
    }

    public <T> T get(@NonNull String string) {
        return (T)this.zzaln.get(string);
    }

    public Object remove(@NonNull String string) {
        return this.zzaln.remove(string);
    }

    public void putAll(@NonNull DataMap dataMap) {
        for (String string : dataMap.keySet()) {
            this.zzaln.put(string, dataMap.get(string));
        }
    }

    public Set<String> keySet() {
        return this.zzaln.keySet();
    }

    public void putBoolean(@NonNull String string, boolean bl) {
        this.zzaln.put(string, bl);
    }

    public void putByte(@NonNull String string, byte by) {
        this.zzaln.put(string, by);
    }

    public void putInt(@NonNull String string, int n) {
        this.zzaln.put(string, n);
    }

    public void putLong(@NonNull String string, long l) {
        this.zzaln.put(string, l);
    }

    public void putFloat(@NonNull String string, float f) {
        this.zzaln.put(string, Float.valueOf(f));
    }

    public void putDouble(@NonNull String string, double d) {
        this.zzaln.put(string, d);
    }

    public void putString(@NonNull String string, String string2) {
        this.zzaln.put(string, string2);
    }

    public void putAsset(@NonNull String string, Asset asset) {
        this.zzaln.put(string, (Object)asset);
    }

    public void putDataMap(@NonNull String string, DataMap dataMap) {
        this.zzaln.put(string, dataMap);
    }

    public void putDataMapArrayList(@NonNull String string, ArrayList<DataMap> arrayList) {
        this.zzaln.put(string, arrayList);
    }

    public void putIntegerArrayList(@NonNull String string, ArrayList<Integer> arrayList) {
        this.zzaln.put(string, arrayList);
    }

    public void putStringArrayList(@NonNull String string, ArrayList<String> arrayList) {
        this.zzaln.put(string, arrayList);
    }

    public void putByteArray(@NonNull String string, byte[] byArray) {
        this.zzaln.put(string, byArray);
    }

    public void putLongArray(@NonNull String string, long[] lArray) {
        this.zzaln.put(string, lArray);
    }

    public void putFloatArray(@NonNull String string, float[] fArray) {
        this.zzaln.put(string, fArray);
    }

    public void putStringArray(@NonNull String string, String[] stringArray) {
        this.zzaln.put(string, stringArray);
    }

    public boolean getBoolean(@NonNull String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(@NonNull String string, boolean bl) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return bl;
        }
        try {
            return (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "Boolean", bl, classCastException);
            return bl;
        }
    }

    public byte getByte(@NonNull String string) {
        return this.getByte(string, (byte)0);
    }

    public byte getByte(@NonNull String string, byte by) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return by;
        }
        try {
            return (Byte)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "Byte", by, classCastException);
            return by;
        }
    }

    public int getInt(@NonNull String string) {
        return this.getInt(string, 0);
    }

    public int getInt(@NonNull String string, int n) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return n;
        }
        try {
            return (Integer)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "Integer", classCastException);
            return n;
        }
    }

    public long getLong(@NonNull String string) {
        return this.getLong(string, 0L);
    }

    public long getLong(@NonNull String string, long l) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return l;
        }
        try {
            return (Long)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "long", classCastException);
            return l;
        }
    }

    public float getFloat(@NonNull String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(@NonNull String string, float f) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return f;
        }
        try {
            return ((Float)object).floatValue();
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "Float", Float.valueOf(f), classCastException);
            return f;
        }
    }

    public double getDouble(@NonNull String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(@NonNull String string, double d) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return d;
        }
        try {
            return (Double)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "Double", d, classCastException);
            return d;
        }
    }

    public String getString(@NonNull String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String getString(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (String)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "String", classCastException);
            return null;
        }
    }

    public Asset getAsset(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (Asset)((Object)object);
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "Asset", classCastException);
            return null;
        }
    }

    public DataMap getDataMap(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (DataMap)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, TAG, classCastException);
            return null;
        }
    }

    public ArrayList<Integer> getIntegerArrayList(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "ArrayList<Integer>", classCastException);
            return null;
        }
    }

    public ArrayList<String> getStringArrayList(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "ArrayList<String>", classCastException);
            return null;
        }
    }

    public ArrayList<DataMap> getDataMapArrayList(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "ArrayList<DataMap>", classCastException);
            return null;
        }
    }

    public byte[] getByteArray(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "byte[]", classCastException);
            return null;
        }
    }

    public long[] getLongArray(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (long[])object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "long[]", classCastException);
            return null;
        }
    }

    public float[] getFloatArray(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (float[])object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "float[]", classCastException);
            return null;
        }
    }

    public String[] getStringArray(@NonNull String string) {
        Object object = this.zzaln.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (String[])object;
        }
        catch (ClassCastException classCastException) {
            DataMap.zza(string, object, "String[]", classCastException);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataMap)) {
            return false;
        }
        DataMap dataMap = (DataMap)object;
        DataMap dataMap2 = this;
        if (dataMap2.size() != dataMap.size()) {
            return false;
        }
        for (String string : dataMap2.keySet()) {
            Object t = dataMap2.get(string);
            Object t2 = dataMap.get(string);
            if (t instanceof Asset) {
                if (!(t2 instanceof Asset)) {
                    return false;
                }
                Asset asset = (Asset)((Object)t2);
                Asset asset2 = (Asset)((Object)t);
                if (asset2 == null || asset == null ? asset2 == asset : (!TextUtils.isEmpty((CharSequence)asset2.getDigest()) ? asset2.getDigest().equals(asset.getDigest()) : Arrays.equals(asset2.getData(), asset.getData()))) continue;
                return false;
            }
            if (t instanceof String[]) {
                if (!(t2 instanceof String[])) {
                    return false;
                }
                if (Arrays.equals((String[])t, (String[])t2)) continue;
                return false;
            }
            if (t instanceof long[]) {
                if (!(t2 instanceof long[])) {
                    return false;
                }
                if (Arrays.equals((long[])t, (long[])t2)) continue;
                return false;
            }
            if (t instanceof float[]) {
                if (!(t2 instanceof float[])) {
                    return false;
                }
                if (Arrays.equals((float[])t, (float[])t2)) continue;
                return false;
            }
            if (t instanceof byte[]) {
                if (!(t2 instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])t, (byte[])t2)) continue;
                return false;
            }
            if (t == null || t2 == null) {
                if (t == t2) break;
                return false;
            }
            if (t.equals(t2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 29 * this.zzaln.hashCode();
    }

    public String toString() {
        return this.zzaln.toString();
    }

    private static void zza(String string, Object object, String string2, ClassCastException classCastException) {
        DataMap.zza(string, object, string2, "<null>", classCastException);
    }

    private static void zza(String string, Object object, String string2, Object object2, ClassCastException classCastException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Key ");
        stringBuilder.append(string);
        stringBuilder.append(" expected ");
        stringBuilder.append(string2);
        stringBuilder.append(" but value was a ");
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append(".  The default value ");
        stringBuilder.append(object2);
        stringBuilder.append(" was returned.");
        Log.w((String)TAG, (String)stringBuilder.toString());
        Log.w((String)TAG, (String)"Attempt to cast generated internal exception:", (Throwable)classCastException);
    }

    private static void zzb(Bundle bundle, String string, Object object) {
        if (object instanceof String) {
            bundle.putString(string, (String)object);
            return;
        }
        if (object instanceof Integer) {
            bundle.putInt(string, ((Integer)object).intValue());
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (object instanceof Float) {
            bundle.putFloat(string, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Boolean) {
            bundle.putBoolean(string, ((Boolean)object).booleanValue());
            return;
        }
        if (object instanceof Byte) {
            bundle.putByte(string, ((Byte)object).byteValue());
            return;
        }
        if (object instanceof byte[]) {
            bundle.putByteArray(string, (byte[])object);
            return;
        }
        if (object instanceof String[]) {
            bundle.putStringArray(string, (String[])object);
            return;
        }
        if (object instanceof long[]) {
            bundle.putLongArray(string, (long[])object);
            return;
        }
        if (object instanceof float[]) {
            bundle.putFloatArray(string, (float[])object);
            return;
        }
        if (object instanceof Asset) {
            bundle.putParcelable(string, (Parcelable)((Asset)((Object)object)));
            return;
        }
        if (object instanceof DataMap) {
            bundle.putParcelable(string, (Parcelable)((DataMap)object).toBundle());
            return;
        }
        if (object instanceof ArrayList) {
            switch (DataMap.zze((ArrayList)object)) {
                case 0: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    return;
                }
                case 1: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    return;
                }
                case 3: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    return;
                }
                case 2: {
                    bundle.putIntegerArrayList(string, (ArrayList)object);
                    return;
                }
                case 4: {
                    ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                    ArrayList arrayList2 = (ArrayList)object;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        DataMap dataMap = (DataMap)e;
                        arrayList.add(dataMap.toBundle());
                    }
                    bundle.putParcelableArrayList(string, arrayList);
                }
            }
        }
    }

    private static int zze(ArrayList<?> arrayList) {
        if (arrayList.isEmpty()) {
            return 0;
        }
        ArrayList<?> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Object obj = arrayList2.get(i);
            Object obj2 = obj;
            if (obj == null) continue;
            if (obj2 instanceof Integer) {
                return 2;
            }
            if (obj2 instanceof String) {
                return 3;
            }
            if (!(obj2 instanceof DataMap)) continue;
            return 4;
        }
        return 1;
    }
}

