/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzh;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class PutDataRequest
extends zzbgl {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new zzh();
    private static final long zza = TimeUnit.MINUTES.toMillis(30L);
    private static final Random zzb = new SecureRandom();
    private final Uri zzc;
    private final Bundle zzd;
    private byte[] zze;
    private long zzf;

    @Hide
    PutDataRequest(Uri uri, Bundle bundle, byte[] byArray, long l) {
        this.zzc = uri;
        this.zzd = bundle;
        this.zzd.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.zze = byArray;
        this.zzf = l;
    }

    private PutDataRequest(Uri uri) {
        this(uri, new Bundle(), null, zza);
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        com.google.android.gms.common.internal.zzc.zza((Object)parcel, (Object)"dest must not be null");
        Parcel parcel2 = parcel;
        PutDataRequest putDataRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)putDataRequest.getUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Bundle)putDataRequest.zzd, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (byte[])putDataRequest.getData(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (long)putDataRequest.zzf);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static PutDataRequest createFromDataItem(@NonNull DataItem dataItem) {
        com.google.android.gms.common.internal.zzc.zza((Object)dataItem, (Object)"source must not be null");
        PutDataRequest putDataRequest = PutDataRequest.zza(dataItem.getUri());
        for (Map.Entry<String, DataItemAsset> entry : dataItem.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                String string = String.valueOf(entry.getKey());
                throw new IllegalStateException(string.length() != 0 ? "Cannot create an asset for a put request without a digest: ".concat(string) : new String("Cannot create an asset for a put request without a digest: "));
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(dataItem.getData());
        return putDataRequest;
    }

    @Hide
    public static PutDataRequest zza(@NonNull Uri uri) {
        com.google.android.gms.common.internal.zzc.zza((Object)uri, (Object)"uri must not be null");
        return new PutDataRequest(uri);
    }

    public static PutDataRequest createWithAutoAppendedId(@NonNull String string) {
        com.google.android.gms.common.internal.zzc.zza((Object)string, (Object)"pathPrefix must not be null");
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!string.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(zzb.nextLong());
        Uri uri = PutDataRequest.zza(stringBuilder.toString());
        return new PutDataRequest(uri);
    }

    public static PutDataRequest create(@NonNull String string) {
        com.google.android.gms.common.internal.zzc.zza((Object)string, (Object)"path must not be null");
        return PutDataRequest.zza(PutDataRequest.zza(string));
    }

    @Hide
    private static Uri zza(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.zzc;
    }

    public byte[] getData() {
        return this.zze;
    }

    public PutDataRequest setData(byte[] byArray) {
        this.zze = byArray;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzd.keySet()) {
            hashMap.put(string, (Asset)this.zzd.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Asset getAsset(@NonNull String string) {
        com.google.android.gms.common.internal.zzc.zza((Object)string, (Object)"key must not be null");
        return (Asset)this.zzd.getParcelable(string);
    }

    public boolean hasAsset(@NonNull String string) {
        com.google.android.gms.common.internal.zzc.zza((Object)string, (Object)"key must not be null");
        return this.zzd.containsKey(string);
    }

    public PutDataRequest putAsset(@NonNull String string, @NonNull Asset asset) {
        zzbq.zza((Object)string);
        zzbq.zza((Object)((Object)asset));
        this.zzd.putParcelable(string, (Parcelable)asset);
        return this;
    }

    public PutDataRequest removeAsset(@NonNull String string) {
        com.google.android.gms.common.internal.zzc.zza((Object)string, (Object)"key must not be null");
        this.zzd.remove(string);
        return this;
    }

    public boolean isUrgent() {
        return this.zzf == 0L;
    }

    public PutDataRequest setUrgent() {
        this.zzf = 0L;
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        String string = String.valueOf(this.zze == null ? "null" : Integer.valueOf(this.zze.length));
        stringBuilder.append(new StringBuilder(7 + String.valueOf(string).length()).append("dataSz=").append(string).toString());
        int n = this.zzd.size();
        stringBuilder.append(new StringBuilder(23).append(", numAssets=").append(n).toString());
        String string2 = String.valueOf(this.zzc);
        stringBuilder.append(new StringBuilder(6 + String.valueOf(string2).length()).append(", uri=").append(string2).toString());
        long l = this.zzf;
        stringBuilder.append(new StringBuilder(35).append(", syncDeadline=").append(l).toString());
        if (!bl) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        for (String string3 : this.zzd.keySet()) {
            String string4 = String.valueOf(this.zzd.getParcelable(string3));
            stringBuilder.append(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("\n    ").append(string3).append(": ").append(string4).toString());
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

