/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zza;
import com.google.android.gms.wearable.internal.zzek;
import com.google.android.gms.wearable.internal.zzep;
import com.google.android.gms.wearable.internal.zzeq;
import com.google.android.gms.wearable.internal.zzer;
import com.google.android.gms.wearable.internal.zzfu;
import com.google.android.gms.wearable.internal.zzgc;
import com.google.android.gms.wearable.internal.zzgx;
import com.google.android.gms.wearable.internal.zzhb;
import com.google.android.gms.wearable.internal.zzhh;
import com.google.android.gms.wearable.internal.zzhi;
import com.google.android.gms.wearable.internal.zzhj;
import com.google.android.gms.wearable.internal.zzhk;
import com.google.android.gms.wearable.internal.zzhp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public final class zzhg
extends zzab<zzep> {
    private final ExecutorService zzimc;
    private final zzer<Object> zzlvl = new zzer();
    private final zzer<Object> zzlvm = new zzer();
    private final zzer<ChannelApi.ChannelListener> zzlvn = new zzer();
    private final zzer<DataApi.DataListener> zzlvo = new zzer();
    private final zzer<MessageApi.MessageListener> zzlvp = new zzer();
    private final zzer<Object> zzlvq = new zzer();
    private final zzer<Object> zzlvr = new zzer();
    private final zzer<CapabilityApi.CapabilityListener> zzlvs = new zzer();
    private final zzhp zzlvt;

    public zzhg(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzr zzr2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, zzr2, Executors.newCachedThreadPool(), zzhp.zzeu(context));
    }

    private zzhg(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzr zzr2, ExecutorService executorService, zzhp zzhp2) {
        super(context, looper, 14, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzimc = (ExecutorService)zzbq.checkNotNull((Object)executorService);
        this.zzlvt = zzhp2;
    }

    protected final String zzhm() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected final String zzalq() {
        if (this.zzlvt.zzof("com.google.android.wearable.app.cn")) {
            return "com.google.android.wearable.app.cn";
        }
        return "com.google.android.gms";
    }

    protected final String zzhn() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    public final boolean zzahn() {
        return !this.zzlvt.zzof("com.google.android.wearable.app.cn");
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.v((String)"WearableClient", (String)new StringBuilder(41).append("onPostInitHandler: statusCode ").append(n).toString());
        }
        if (n == 0) {
            this.zzlvl.zzbt(iBinder);
            this.zzlvm.zzbt(iBinder);
            this.zzlvn.zzbt(iBinder);
            this.zzlvo.zzbt(iBinder);
            this.zzlvp.zzbt(iBinder);
            this.zzlvq.zzbt(iBinder);
            this.zzlvr.zzbt(iBinder);
            this.zzlvs.zzbt(iBinder);
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final void zza(@NonNull zzj zzj2) {
        if (!this.zzahn()) {
            try {
                Bundle bundle = this.getContext().getPackageManager().getApplicationInfo((String)"com.google.android.wearable.app.cn", (int)128).metaData;
                int n = bundle != null ? bundle.getInt("com.google.android.wearable.api.version", 0) : 0;
                if (n < zzf.GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                    Intent intent;
                    Context context;
                    int n2 = zzf.GOOGLE_PLAY_SERVICES_VERSION_CODE;
                    Log.w((String)"WearableClient", (String)new StringBuilder(80).append("Android Wear out of date. Requires API version ").append(n2).append(" but found ").append(n).toString());
                    Context context2 = context = this.getContext();
                    Intent intent2 = new Intent("com.google.android.wearable.app.cn.UPDATE_ANDROID_WEAR").setPackage("com.google.android.wearable.app.cn");
                    if (context.getPackageManager().resolveActivity(intent2, 65536) != null) {
                        intent = intent2;
                    } else {
                        Uri uri = Uri.parse((String)"market://details").buildUpon().appendQueryParameter("id", "com.google.android.wearable.app.cn").build();
                        intent = new Intent("android.intent.action.VIEW", uri);
                    }
                    this.zza(zzj2, 6, PendingIntent.getActivity((Context)context2, (int)0, (Intent)intent, (int)0));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zza(zzj2, 16, null);
                return;
            }
        }
        super.zza(zzj2);
    }

    public final void zza(zzn<DataApi.DataItemResult> zzn2, PutDataRequest putDataRequest) throws RemoteException {
        Object object = putDataRequest.getAssets().entrySet().iterator();
        while (object.hasNext()) {
            Object object2 = object.next().getValue();
            if (object2.getData() != null || object2.getDigest() != null || object2.getFd() != null || object2.getUri() != null) continue;
            String string = String.valueOf(putDataRequest.getUri());
            String string2 = String.valueOf(object2);
            throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Put for ").append(string).append(" contains invalid asset: ").append(string2).toString());
        }
        object = PutDataRequest.zzs(putDataRequest.getUri());
        ((PutDataRequest)((Object)object)).setData(putDataRequest.getData());
        if (putDataRequest.isUrgent()) {
            ((PutDataRequest)((Object)object)).setUrgent();
        }
        ArrayList<FutureTask<Boolean>> arrayList = new ArrayList<FutureTask<Boolean>>();
        for (Map.Entry entry : putDataRequest.getAssets().entrySet()) {
            Object object3;
            Asset asset = (Asset)((Object)entry.getValue());
            if (asset.getData() != null) {
                String string;
                ParcelFileDescriptor[] parcelFileDescriptorArray;
                try {
                    parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    string = String.valueOf((Object)putDataRequest);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Unable to create ParcelFileDescriptor for asset in request: ").append(string).toString(), iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    object3 = String.valueOf((Object)asset);
                    string = String.valueOf(parcelFileDescriptorArray[0]);
                    String string3 = String.valueOf(parcelFileDescriptorArray[1]);
                    Log.d((String)"WearableClient", (String)new StringBuilder(61 + String.valueOf(object3).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("processAssets: replacing data with FD in asset: ").append((String)object3).append(" read:").append(string).append(" write:").append(string3).toString());
                }
                ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
                byte[] byArray = asset.getData();
                ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
                zzhg zzhg2 = this;
                object3 = new FutureTask<Boolean>(new zzhh(zzhg2, parcelFileDescriptor, byArray));
                arrayList.add((FutureTask<Boolean>)object3);
                this.zzimc.submit((Runnable)object3);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    object3 = Asset.createFromFd(this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r"));
                    ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), (Asset)((Object)object3));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ((zza)new zzhb(zzn2, arrayList)).zza(new zzfu(4005, null));
                    object3 = String.valueOf(asset.getUri());
                    Log.w((String)"WearableClient", (String)new StringBuilder(28 + String.valueOf(object3).length()).append("Couldn't resolve asset URI: ").append((String)object3).toString());
                    return;
                }
            }
            ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), asset);
        }
        ((zzep)this.zzalw()).zza((zzek)new zzhb(zzn2, arrayList), (PutDataRequest)((Object)object));
    }

    public final void zza(zzn<DataApi.GetFdForAssetResult> zzn2, Asset asset) throws RemoteException {
        ((zzep)this.zzalw()).zza((zzek)new zzgx(zzn2), asset);
    }

    public final void zza(zzn<Status> zzn2, String string, Uri uri, boolean bl) {
        try {
            boolean bl2 = bl;
            Uri uri2 = uri;
            String string2 = string;
            zzn<Status> zzn3 = zzn2;
            zzhg zzhg2 = this;
            zzbq.checkNotNull(zzn3);
            zzbq.checkNotNull((Object)string2);
            zzbq.checkNotNull((Object)uri2);
            this.zzimc.execute(new zzhi(zzhg2, uri2, zzn3, bl2, string2));
            return;
        }
        catch (RuntimeException runtimeException) {
            zzn2.zzu(new Status(8));
            throw runtimeException;
        }
    }

    public final void zza(zzn<Status> zzn2, String string, Uri uri, long l, long l2) {
        try {
            long l3 = l2;
            long l4 = l;
            Uri uri2 = uri;
            String string2 = string;
            zzn<Status> zzn3 = zzn2;
            zzhg zzhg2 = this;
            zzbq.checkNotNull(zzn3);
            zzbq.checkNotNull((Object)string2);
            zzbq.checkNotNull((Object)uri2);
            zzbq.zzb((l4 >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l4});
            zzbq.zzb((l3 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l3});
            this.zzimc.execute(new zzhj(zzhg2, uri2, zzn3, string2, l4, l3));
            return;
        }
        catch (RuntimeException runtimeException) {
            zzn2.zzu(new Status(8));
            throw runtimeException;
        }
    }

    public final void zza(zzn<Status> zzn2, DataApi.DataListener dataListener, zzci<DataApi.DataListener> zzci2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzlvo.zza(this, zzn2, dataListener, zzhk.zza(zzci2, intentFilterArray));
    }

    public final void zza(zzn<Status> zzn2, MessageApi.MessageListener messageListener, zzci<MessageApi.MessageListener> zzci2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzlvp.zza(this, zzn2, messageListener, zzhk.zzb(zzci2, intentFilterArray));
    }

    public final void zza(zzn<Status> zzn2, CapabilityApi.CapabilityListener capabilityListener, zzci<CapabilityApi.CapabilityListener> zzci2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzlvs.zza(this, zzn2, capabilityListener, zzhk.zzd(zzci2, intentFilterArray));
    }

    public final void zza(zzn<Status> zzn2, ChannelApi.ChannelListener channelListener, zzci<ChannelApi.ChannelListener> zzci2, String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzlvn.zza(this, zzn2, channelListener, zzhk.zzc(zzci2, intentFilterArray));
            return;
        }
        zzgc zzgc2 = new zzgc(string, channelListener);
        this.zzlvn.zza(this, zzn2, zzgc2, zzhk.zza(zzci2, string, intentFilterArray));
    }

    public final void zza(zzn<Status> zzn2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzlvo.zza(this, zzn2, dataListener);
    }

    public final void zza(zzn<Status> zzn2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzlvp.zza(this, zzn2, messageListener);
    }

    public final void zza(zzn<Status> zzn2, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzlvs.zza(this, zzn2, capabilityListener);
    }

    public final void zza(zzn<Status> zzn2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzlvn.zza(this, zzn2, channelListener);
            return;
        }
        zzgc zzgc2 = new zzgc(string, channelListener);
        this.zzlvn.zza(this, zzn2, zzgc2);
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wearable.internal.IWearableService");
        if (iInterface instanceof zzep) {
            return (zzep)iInterface;
        }
        return new zzeq(iBinder2);
    }
}

