/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.wearable.zze;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="AssetCreator")
public class Asset
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zze();
    @SafeParcelable.Field(id=2, getter="getData")
    private byte[] data;
    @SafeParcelable.Field(id=3, getter="getDigest")
    private String zze;
    @SafeParcelable.Field(id=4)
    private ParcelFileDescriptor zzf;
    @SafeParcelable.Field(id=5)
    private Uri uri;

    @SafeParcelable.Constructor
    Asset(@SafeParcelable.Param(id=2) byte[] byArray, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) ParcelFileDescriptor parcelFileDescriptor, @SafeParcelable.Param(id=5) Uri uri) {
        this.data = byArray;
        this.zze = string;
        this.zzf = parcelFileDescriptor;
        this.uri = uri;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Asserts.checkNotNull((Object)parcel);
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        Asset asset = this;
        int n3 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])asset.data, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)asset.getDigest(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)asset.zzf, (int)n2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)asset.uri, (int)n2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n3);
    }

    public static Asset createFromRef(@NonNull String string) {
        Asserts.checkNotNull((Object)string);
        return new Asset(null, string, null, null);
    }

    @VisibleForTesting
    public static Asset createFromBytes(@NonNull byte[] byArray) {
        Asserts.checkNotNull((Object)byArray);
        return new Asset(byArray, null, null, null);
    }

    @VisibleForTesting
    public static Asset createFromFd(@NonNull ParcelFileDescriptor parcelFileDescriptor) {
        Asserts.checkNotNull((Object)parcelFileDescriptor);
        return new Asset(null, null, parcelFileDescriptor, null);
    }

    @VisibleForTesting
    public static Asset createFromUri(@NonNull Uri uri) {
        Asserts.checkNotNull((Object)uri);
        return new Asset(null, null, null, uri);
    }

    public final byte[] getData() {
        return this.data;
    }

    public String getDigest() {
        return this.zze;
    }

    public ParcelFileDescriptor getFd() {
        return this.zzf;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.data, this.zze, this.zzf, this.uri});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)((Object)object);
        return Arrays.equals(this.data, asset.data) && Objects.equal((Object)this.zze, (Object)asset.zze) && Objects.equal((Object)this.zzf, (Object)asset.zzf) && Objects.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zze == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zze);
        }
        if (this.data != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.data.length);
        }
        if (this.zzf != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zzf);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

