/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataClient;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzbw;
import com.google.android.gms.wearable.internal.zzck;
import com.google.android.gms.wearable.internal.zzcl;
import com.google.android.gms.wearable.internal.zzcm;
import com.google.android.gms.wearable.internal.zzcn;
import com.google.android.gms.wearable.internal.zzco;
import com.google.android.gms.wearable.internal.zzcp;
import com.google.android.gms.wearable.internal.zzcq;
import com.google.android.gms.wearable.internal.zzcr;
import com.google.android.gms.wearable.internal.zzcs;
import com.google.android.gms.wearable.internal.zzcv;
import com.google.android.gms.wearable.internal.zzcw;
import com.google.android.gms.wearable.internal.zzgj;

public final class zzcj
extends DataClient {
    private final DataApi zzdi = new zzbw();

    public zzcj(@NonNull Context context, @NonNull GoogleApi.Settings settings) {
        super(context, settings);
    }

    public zzcj(@NonNull Activity activity, @NonNull GoogleApi.Settings settings) {
        super(activity, settings);
    }

    @Override
    public final Task<DataItem> putDataItem(@NonNull PutDataRequest putDataRequest) {
        return PendingResultUtil.toTask(this.zzdi.putDataItem(this.asGoogleApiClient(), putDataRequest), (PendingResultUtil.ResultConverter)zzck.zzbx);
    }

    @Override
    public final Task<DataItem> getDataItem(@NonNull Uri uri) {
        return PendingResultUtil.toTask(this.zzdi.getDataItem(this.asGoogleApiClient(), uri), (PendingResultUtil.ResultConverter)zzcl.zzbx);
    }

    @Override
    public final Task<DataItemBuffer> getDataItems() {
        return PendingResultUtil.toTask(this.zzdi.getDataItems(this.asGoogleApiClient()), (PendingResultUtil.ResultConverter)zzcm.zzbx);
    }

    @Override
    public final Task<DataItemBuffer> getDataItems(@NonNull Uri uri) {
        return PendingResultUtil.toTask(this.zzdi.getDataItems(this.asGoogleApiClient(), uri), (PendingResultUtil.ResultConverter)zzcn.zzbx);
    }

    @Override
    public final Task<DataItemBuffer> getDataItems(@NonNull Uri uri, int n) {
        return PendingResultUtil.toTask(this.zzdi.getDataItems(this.asGoogleApiClient(), uri, n), (PendingResultUtil.ResultConverter)zzco.zzbx);
    }

    @Override
    public final Task<Integer> deleteDataItems(@NonNull Uri uri) {
        return PendingResultUtil.toTask(this.zzdi.deleteDataItems(this.asGoogleApiClient(), uri), (PendingResultUtil.ResultConverter)zzcp.zzbx);
    }

    @Override
    public final Task<Integer> deleteDataItems(@NonNull Uri uri, int n) {
        return PendingResultUtil.toTask(this.zzdi.deleteDataItems(this.asGoogleApiClient(), uri, n), (PendingResultUtil.ResultConverter)zzcq.zzbx);
    }

    @Override
    public final Task<DataClient.GetFdForAssetResponse> getFdForAsset(@NonNull Asset asset) {
        return PendingResultUtil.toTask(this.zzdi.getFdForAsset(this.asGoogleApiClient(), asset), (PendingResultUtil.ResultConverter)zzcr.zzbx);
    }

    @Override
    public final Task<DataClient.GetFdForAssetResponse> getFdForAsset(@NonNull DataItemAsset dataItemAsset) {
        return PendingResultUtil.toTask(this.zzdi.getFdForAsset(this.asGoogleApiClient(), dataItemAsset), (PendingResultUtil.ResultConverter)zzcs.zzbx);
    }

    @Override
    public final Task<Void> addListener(@NonNull DataClient.OnDataChangedListener onDataChangedListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzgj.zzc("com.google.android.gms.wearable.DATA_CHANGED")};
        return this.zza(onDataChangedListener, intentFilterArray);
    }

    @Override
    public final Task<Void> addListener(@NonNull DataClient.OnDataChangedListener onDataChangedListener, @NonNull Uri uri, int n) {
        Asserts.checkNotNull((Object)uri, (Object)"uri must not be null");
        Preconditions.checkArgument((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzgj.zza("com.google.android.gms.wearable.DATA_CHANGED", uri, n);
        return this.zza(onDataChangedListener, new IntentFilter[]{intentFilter});
    }

    private final Task<Void> zza(DataClient.OnDataChangedListener onDataChangedListener, IntentFilter[] intentFilterArray) {
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onDataChangedListener, (Looper)this.getLooper(), (String)"DataListener");
        zzcv zzcv2 = new zzcv(onDataChangedListener, intentFilterArray, listenerHolder, null);
        zzcw zzcw2 = new zzcw(onDataChangedListener, listenerHolder.getListenerKey(), null);
        return this.doRegisterEventListener(zzcv2, zzcw2);
    }

    @Override
    public final Task<Boolean> removeListener(@NonNull DataClient.OnDataChangedListener onDataChangedListener) {
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onDataChangedListener, (Looper)this.getLooper(), (String)"DataListener");
        return this.doUnregisterEventListener(listenerHolder.getListenerKey());
    }
}

