/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class zzdc
implements DataItem {
    private Uri uri;
    private byte[] data;
    private Map<String, DataItemAsset> zzdo;

    public zzdc(DataItem dataItem) {
        this.uri = dataItem.getUri();
        this.data = dataItem.getData();
        HashMap<String, DataItemAsset> hashMap = new HashMap<String, DataItemAsset>();
        for (Map.Entry<String, DataItemAsset> entry : dataItem.getAssets().entrySet()) {
            if (entry.getKey() == null) continue;
            hashMap.put(entry.getKey(), (DataItemAsset)entry.getValue().freeze());
        }
        this.zzdo = Collections.unmodifiableMap(hashMap);
    }

    public final boolean isDataValid() {
        return true;
    }

    @Override
    public final Uri getUri() {
        return this.uri;
    }

    @Override
    public final byte[] getData() {
        return this.data;
    }

    @Override
    public final Map<String, DataItemAsset> getAssets() {
        return this.zzdo;
    }

    @Override
    public final DataItem setData(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        boolean bl = Log.isLoggable((String)"DataItem", (int)3);
        zzdc zzdc2 = this;
        StringBuilder stringBuilder = new StringBuilder("DataItemEntity{ ");
        String string = String.valueOf(zzdc2.uri);
        stringBuilder.append(new StringBuilder(4 + String.valueOf(string).length()).append("uri=").append(string).toString());
        string = String.valueOf(zzdc2.data == null ? "null" : Integer.valueOf(zzdc2.data.length));
        stringBuilder.append(new StringBuilder(9 + String.valueOf(string).length()).append(", dataSz=").append(string).toString());
        int n = zzdc2.zzdo.size();
        stringBuilder.append(new StringBuilder(23).append(", numAssets=").append(n).toString());
        if (bl && !zzdc2.zzdo.isEmpty()) {
            stringBuilder.append(", assets=[");
            String string2 = "";
            for (Map.Entry<String, DataItemAsset> entry : zzdc2.zzdo.entrySet()) {
                String string3 = string2;
                String string4 = entry.getKey();
                String string5 = entry.getValue().getId();
                stringBuilder.append(new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append(string4).append(": ").append(string5).toString());
                string2 = ", ";
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

