/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zznm;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzaKH;
    private final DataMap zzaKG;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzaKH = putDataRequest;
        this.zzaKG = new DataMap();
        if (dataMap != null) {
            this.zzaKG.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.zzn(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.zzaKH.getUri();
    }

    public DataMap getDataMap() {
        return this.zzaKG;
    }

    public PutDataRequest asPutDataRequest() {
        zznm.zza zza2 = zznm.zza(this.zzaKG);
        this.zzaKH.setData(zzny.zzf((zzny)zza2.zzaMX));
        int n = zza2.zzaMY.size();
        for (int i = 0; i < n; ++i) {
            String string = Integer.toString(i);
            Asset asset = zza2.zzaMY.get(i);
            if (string == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string + " " + asset));
            }
            this.zzaKH.putAsset(string, asset);
        }
        return this.zzaKH;
    }
}

