/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.AmsEntityUpdateParcelable;
import com.google.android.gms.wearable.internal.AncsNotificationParcelable;
import com.google.android.gms.wearable.internal.CapabilityInfoParcelable;
import com.google.android.gms.wearable.internal.ChannelEventParcelable;
import com.google.android.gms.wearable.internal.MessageEventParcelable;
import com.google.android.gms.wearable.internal.NodeParcelable;
import com.google.android.gms.wearable.internal.zzav;
import com.google.android.gms.wearable.zzj;
import java.util.List;

public abstract class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener,
NodeApi.zza {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private volatile int zzacB = -1;
    private String zzOZ;
    private Handler zzaZc;
    private IBinder zzacE;
    private Object zzaZd = new Object();
    private boolean zzLA;

    public void onCreate() {
        super.onCreate();
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            Log.d((String)"WearableLS", (String)("onCreate: " + this.getPackageName()));
        }
        this.zzOZ = this.getPackageName();
        HandlerThread handlerThread = new HandlerThread("WearableListenerService");
        handlerThread.start();
        this.zzaZc = new Handler(handlerThread.getLooper());
        this.zzacE = new zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object = this.zzaZd;
        synchronized (object) {
            this.zzLA = true;
            if (this.zzaZc == null) {
                throw new IllegalStateException("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()?");
            }
            this.zzaZc.getLooper().quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzacE;
        }
        return null;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEvents) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node peer) {
    }

    @Override
    public void onPeerDisconnected(Node peer) {
    }

    @Override
    public void onConnectedNodes(List<Node> connectedNodes) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onInputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onOutputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    private void zzCs() throws SecurityException {
        int n = Binder.getCallingUid();
        if (n == this.zzacB) {
            return;
        }
        if (GooglePlayServicesUtil.zze((Context)this, (int)n)) {
            this.zzacB = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    private class zza
    extends zzav.zza {
        boolean zzaZe = false;

        zza() {
            this.zzaZe = WearableListenerService.this instanceof zzj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzad(final DataHolder dataHolder) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onDataItemChanged: " + WearableListenerService.this.zzOZ + ": " + dataHolder));
            }
            WearableListenerService.this.zzCs();
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    dataHolder.close();
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DataEventBuffer dataEventBuffer = new DataEventBuffer(dataHolder);
                        try {
                            WearableListenerService.this.onDataChanged(dataEventBuffer);
                        }
                        finally {
                            dataEventBuffer.release();
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final MessageEventParcelable messageEventParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onMessageReceived: " + messageEventParcelable));
            }
            WearableListenerService.this.zzCs();
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onMessageReceived(messageEventParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final NodeParcelable nodeParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onPeerConnected: " + WearableListenerService.this.zzOZ + ": " + nodeParcelable));
            }
            WearableListenerService.this.zzCs();
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onPeerConnected(nodeParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzb(final NodeParcelable nodeParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onPeerDisconnected: " + WearableListenerService.this.zzOZ + ": " + nodeParcelable));
            }
            WearableListenerService.this.zzCs();
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onPeerDisconnected(nodeParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectedNodes(final List<NodeParcelable> connectedNodes) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onConnectedNodes: " + WearableListenerService.this.zzOZ + ": " + connectedNodes));
            }
            WearableListenerService.this.zzCs();
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onConnectedNodes(connectedNodes);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final CapabilityInfoParcelable capabilityInfoParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onConnectedCapabilityChanged: " + capabilityInfoParcelable));
            }
            WearableListenerService.this.zzCs();
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onCapabilityChanged(capabilityInfoParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final AncsNotificationParcelable ancsNotificationParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onNotificationReceived: " + ancsNotificationParcelable));
            }
            if (!this.zzaZe) {
                return;
            }
            WearableListenerService.this.zzCs();
            final zzj zzj2 = (zzj)WearableListenerService.this;
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        zzj2.zza(ancsNotificationParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final AmsEntityUpdateParcelable amsEntityUpdateParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onEntityUpdate: " + amsEntityUpdateParcelable));
            }
            if (!this.zzaZe) {
                return;
            }
            WearableListenerService.this.zzCs();
            final zzj zzj2 = (zzj)WearableListenerService.this;
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        zzj2.zza(amsEntityUpdateParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final ChannelEventParcelable channelEventParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onChannelEvent: " + channelEventParcelable));
            }
            WearableListenerService.this.zzCs();
            Object object = WearableListenerService.this.zzaZd;
            synchronized (object) {
                if (WearableListenerService.this.zzLA) {
                    return;
                }
                WearableListenerService.this.zzaZc.post(new Runnable(){

                    @Override
                    public void run() {
                        channelEventParcelable.zza(WearableListenerService.this);
                    }
                });
            }
        }
    }
}

