/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.internal.zzad;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DataItemParcelable
implements SafeParcelable,
DataItem {
    public static final Parcelable.Creator<DataItemParcelable> CREATOR = new zzad();
    final int mVersionCode;
    private final Uri mUri;
    private final Map<String, DataItemAsset> zzbap;
    private byte[] zzayG;

    DataItemParcelable(int versionCode, Uri uri, Bundle assetBundle, byte[] data) {
        this.mVersionCode = versionCode;
        this.mUri = uri;
        HashMap<String, DataItemAsset> hashMap = new HashMap<String, DataItemAsset>();
        assetBundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (String string : assetBundle.keySet()) {
            hashMap.put(string, (DataItemAssetParcelable)assetBundle.getParcelable(string));
        }
        this.zzbap = hashMap;
        this.zzayG = data;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzad.zza(this, dest, flags);
    }

    public DataItemParcelable zzCH() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    @Override
    public Uri getUri() {
        return this.mUri;
    }

    @Override
    public byte[] getData() {
        return this.zzayG;
    }

    public DataItemParcelable zzv(byte[] byArray) {
        this.zzayG = byArray;
        return this;
    }

    @Override
    public Map<String, DataItemAsset> getAssets() {
        return this.zzbap;
    }

    public Bundle zzCr() {
        Bundle bundle = new Bundle();
        bundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (Map.Entry<String, DataItemAsset> entry : this.zzbap.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)new DataItemAssetParcelable(entry.getValue()));
        }
        return bundle;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataItem", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("DataItemParcelable[");
        stringBuilder.append("@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append(",dataSz=" + (this.zzayG == null ? "null" : Integer.valueOf(this.zzayG.length)));
        stringBuilder.append(", numAssets=" + this.zzbap.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set<String> set = this.zzbap.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.zzbap.get(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ DataItem setData(byte[] x0) {
        return this.zzv(x0);
    }

    public /* synthetic */ Object freeze() {
        return this.zzCH();
    }
}

