/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzh;
import java.io.IOException;
import java.io.InputStream;

public final class zzw
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient client, final PutDataRequest request) {
        return client.zza((zzc.zza)new zzh<DataApi.DataItemResult>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<DataApi.DataItemResult>)this, request);
            }

            public DataApi.DataItemResult zzbp(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzbp(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient client, final Uri uri) {
        return client.zza((zzc.zza)new zzh<DataApi.DataItemResult>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzbp(Status status) {
                return new zzb(status, null);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbp(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client) {
        return client.zza((zzc.zza)new zzh<DataItemBuffer>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zzn((zzc.zzb<DataItemBuffer>)this);
            }

            protected DataItemBuffer zzbq(Status status) {
                return new DataItemBuffer(DataHolder.zzbp((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbq(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, Uri uri) {
        return this.getDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        return client.zza((zzc.zza)new zzh<DataItemBuffer>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<DataItemBuffer>)this, uri, filterType);
            }

            protected DataItemBuffer zzbq(Status status) {
                return new DataItemBuffer(DataHolder.zzbp((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbq(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, Uri uri) {
        return this.deleteDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        return client.zza((zzc.zza)new zzh<DataApi.DeleteDataItemsResult>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zzb((zzc.zzb<DataApi.DeleteDataItemsResult>)this, uri, filterType);
            }

            protected DataApi.DeleteDataItemsResult zzbr(Status status) {
                return new zzc(status, 0);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbr(status);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final Asset asset) {
        this.zza(asset);
        return client.zza((zzc.zza)new zzh<DataApi.GetFdForAssetResult>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbs(Status status) {
                return new zzd(status, null);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbs(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final DataItemAsset asset) {
        return client.zza((zzc.zza)new zzh<DataApi.GetFdForAssetResult>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbs(Status status) {
                return new zzd(status, null);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzbs(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, DataApi.DataListener listener) {
        return this.zza(client, listener, null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return googleApiClient.zza((zzc.zza)new zza(googleApiClient, dataListener, intentFilterArray));
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, final DataApi.DataListener listener) {
        return client.zza((zzc.zza)new zzh<Status>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<Status>)this, listener);
            }

            public Status zzd(Status status) {
                return status;
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    private static final class zza
    extends zzh<Status> {
        private DataApi.DataListener zzbak;
        private IntentFilter[] zzbal;

        private zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
            super(googleApiClient);
            this.zzbak = dataListener;
            this.zzbal = intentFilterArray;
        }

        protected void zza(zzbn zzbn2) throws RemoteException {
            zzbn2.zza((zzc.zzb<Status>)this, this.zzbak, this.zzbal);
            this.zzbak = null;
            this.zzbal = null;
        }

        public Status zzd(Status status) {
            this.zzbak = null;
            this.zzbal = null;
            return status;
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzd(status);
        }
    }

    public static class zzd
    implements DataApi.GetFdForAssetResult {
        private final Status zzQA;
        private volatile ParcelFileDescriptor zzbao;
        private volatile InputStream zzaZW;
        private volatile boolean mClosed = false;

        public zzd(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzQA = status;
            this.zzbao = parcelFileDescriptor;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.zzbao;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.zzbao == null) {
                return null;
            }
            if (this.zzaZW == null) {
                this.zzaZW = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbao);
            }
            return this.zzaZW;
        }

        public void release() {
            if (this.zzbao == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.zzaZW != null) {
                    this.zzaZW.close();
                } else {
                    this.zzbao.close();
                }
                this.mClosed = true;
                this.zzbao = null;
                this.zzaZW = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class zzc
    implements DataApi.DeleteDataItemsResult {
        private final Status zzQA;
        private final int zzban;

        public zzc(Status status, int n) {
            this.zzQA = status;
            this.zzban = n;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public int getNumDeleted() {
            return this.zzban;
        }
    }

    public static class zzb
    implements DataApi.DataItemResult {
        private final Status zzQA;
        private final DataItem zzbam;

        public zzb(Status status, DataItem dataItem) {
            this.zzQA = status;
            this.zzbam = dataItem;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public DataItem getDataItem() {
            return this.zzbam;
        }
    }
}

