/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzbfc;
    private final DataMap zzbfb;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzbfc = putDataRequest;
        this.zzbfb = new DataMap();
        if (dataMap != null) {
            this.zzbfb.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.zzo(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.zzbfc.getUri();
    }

    public DataMap getDataMap() {
        return this.zzbfb;
    }

    public PutDataRequest asPutDataRequest() {
        zzrs.zza zza2 = zzrs.zza(this.zzbfb);
        this.zzbfc.setData(zzse.zzf((zzse)zza2.zzbhz));
        int n = zza2.zzbhA.size();
        for (int i = 0; i < n; ++i) {
            String string = Integer.toString(i);
            Asset asset = zza2.zzbhA.get(i);
            if (string == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string + " " + asset));
            }
            this.zzbfc.putAsset(string, asset);
        }
        return this.zzbfc;
    }
}

