/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzbo;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.internal.zzo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
implements SafeParcelable,
Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzo();
    final int mVersionCode;
    private final String zzRz;
    private final String zzbeZ;
    private final String mPath;

    ChannelImpl(int versionCode, String token, String nodeId, String path) {
        this.mVersionCode = versionCode;
        this.zzRz = (String)zzx.zzw((Object)token);
        this.zzbeZ = (String)zzx.zzw((Object)nodeId);
        this.mPath = (String)zzx.zzw((Object)path);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzo.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelImpl{versionCode=" + this.mVersionCode + ", token='" + this.zzRz + '\'' + ", nodeId='" + this.zzbeZ + '\'' + ", path='" + this.mPath + '\'' + "}";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)other;
        return this.zzRz.equals(channelImpl.zzRz) && zzw.equal((Object)channelImpl.zzbeZ, (Object)this.zzbeZ) && zzw.equal((Object)channelImpl.mPath, (Object)this.mPath) && channelImpl.mVersionCode == this.mVersionCode;
    }

    public int hashCode() {
        return this.zzRz.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.zzbeZ;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    public String getToken() {
        return this.zzRz;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client) {
        return client.zzb((zzlb.zza)new zzi<Status>(client){

            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zzt((zzlb.zzb<Status>)this, ChannelImpl.this.zzRz);
            }

            protected Status zzd(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client, final int errorCode) {
        return client.zzb((zzlb.zza)new zzi<Status>(client){

            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zzh((zzlb.zzb<Status>)this, ChannelImpl.this.zzRz, errorCode);
            }

            protected Status zzd(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient client) {
        return client.zzb((zzlb.zza)new zzi<Channel.GetInputStreamResult>(client){

            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zzu((zzlb.zzb<Channel.GetInputStreamResult>)this, ChannelImpl.this.zzRz);
            }

            public Channel.GetInputStreamResult zzbl(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzbl(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient client) {
        return client.zzb((zzlb.zza)new zzi<Channel.GetOutputStreamResult>(client){

            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zzv((zzlb.zzb<Channel.GetOutputStreamResult>)this, ChannelImpl.this.zzRz);
            }

            public Channel.GetOutputStreamResult zzbm(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzbm(status);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient client, final Uri uri, final boolean append) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        return client.zzb((zzlb.zza)new zzi<Status>(client){

            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza((zzlb.zzb<Status>)this, ChannelImpl.this.zzRz, uri, append);
            }

            public Status zzd(Status status) {
                return status;
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, Uri uri) {
        return this.sendFile(client, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, final Uri uri, final long startOffset, final long length) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)this.zzRz, (Object)"token is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        zzx.zzb((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{startOffset});
        zzx.zzb((length >= 0L || length == -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{length});
        return client.zzb((zzlb.zza)new zzi<Status>(client){

            protected void zza(zzbo zzbo2) throws RemoteException {
                zzbo2.zza((zzlb.zzb<Status>)this, ChannelImpl.this.zzRz, uri, startOffset, length);
            }

            public Status zzd(Status status) {
                return status;
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        return com.google.android.gms.wearable.internal.zzb.zza(client, ChannelImpl.zzfx(this.zzRz), listener);
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)listener, (Object)"listener is null");
        return client.zza((zzlb.zza)new zzl.zzb(client, listener, this.zzRz));
    }

    private static zzb.zza<ChannelApi.ChannelListener> zzfx(final String string) {
        return new zzb.zza<ChannelApi.ChannelListener>(){

            @Override
            public void zza(zzbo zzbo2, zzlb.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzlm<ChannelApi.ChannelListener> zzlm2) throws RemoteException {
                zzbo2.zza(zzb2, channelListener, zzlm2, string);
            }
        };
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status zzSC;
        private final OutputStream zzbgh;

        zzb(Status status, OutputStream outputStream) {
            this.zzSC = (Status)zzx.zzw((Object)status);
            this.zzbgh = outputStream;
        }

        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.zzbgh;
        }

        public void release() {
            if (this.zzbgh != null) {
                try {
                    this.zzbgh.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status zzSC;
        private final InputStream zzbgg;

        zza(Status status, InputStream inputStream) {
            this.zzSC = (Status)zzx.zzw((Object)status);
            this.zzbgg = inputStream;
        }

        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public InputStream getInputStream() {
            return this.zzbgg;
        }

        public void release() {
            if (this.zzbgg != null) {
                try {
                    this.zzbgg.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

