/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.AmsEntityUpdateParcelable;
import com.google.android.gms.wearable.internal.AncsNotificationParcelable;
import com.google.android.gms.wearable.internal.CapabilityInfoParcelable;
import com.google.android.gms.wearable.internal.ChannelEventParcelable;
import com.google.android.gms.wearable.internal.MessageEventParcelable;
import com.google.android.gms.wearable.internal.NodeParcelable;
import com.google.android.gms.wearable.internal.zzaw;
import com.google.android.gms.wearable.zzj;
import java.util.List;

public abstract class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener,
NodeApi.zza {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private String zzTJ;
    private Handler zzbro;
    private IBinder zzakD;
    private final Object zzbrp = new Object();
    private boolean zzQl;

    public void onCreate() {
        super.onCreate();
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            Log.d((String)"WearableLS", (String)("onCreate: " + new ComponentName(this.getPackageName(), this.getClass().getName()).flattenToShortString()));
        }
        this.zzTJ = this.getPackageName();
        HandlerThread handlerThread = new HandlerThread("WearableListenerService");
        handlerThread.start();
        this.zzbro = new Handler(handlerThread.getLooper());
        this.zzakD = new zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            Log.d((String)"WearableLS", (String)("onDestroy: " + new ComponentName(this.getPackageName(), this.getClass().getName()).flattenToShortString()));
        }
        Object object = this.zzbrp;
        synchronized (object) {
            this.zzQl = true;
            if (this.zzbro == null) {
                throw new IllegalStateException("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()?");
            }
            this.zzbro.getLooper().quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzakD;
        }
        return null;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEvents) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node peer) {
    }

    @Override
    public void onPeerDisconnected(Node peer) {
    }

    @Override
    public void onConnectedNodes(List<Node> connectedNodes) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onInputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onOutputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    private final class zza
    extends zzaw.zza {
        private volatile int zzakz = -1;

        private zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzag(final DataHolder dataHolder) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataEventBuffer dataEventBuffer = new DataEventBuffer(dataHolder);
                    try {
                        WearableListenerService.this.onDataChanged(dataEventBuffer);
                    }
                    finally {
                        dataEventBuffer.release();
                    }
                }
            };
            boolean bl = false;
            try {
                bl = this.zzb(runnable, "onDataItemChanged", dataHolder);
            }
            finally {
                if (!bl) {
                    dataHolder.close();
                }
            }
        }

        @Override
        public void zza(final MessageEventParcelable messageEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onMessageReceived(messageEventParcelable);
                }
            };
            this.zzb(runnable, "onMessageReceived", messageEventParcelable);
        }

        @Override
        public void zza(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerConnected(nodeParcelable);
                }
            };
            this.zzb(runnable, "onPeerConnected", nodeParcelable);
        }

        @Override
        public void zzb(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerDisconnected(nodeParcelable);
                }
            };
            this.zzb(runnable, "onPeerDisconnected", nodeParcelable);
        }

        @Override
        public void onConnectedNodes(final List<NodeParcelable> connectedNodes) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onConnectedNodes(connectedNodes);
                }
            };
            this.zzb(runnable, "onConnectedNodes", connectedNodes);
        }

        @Override
        public void zza(final CapabilityInfoParcelable capabilityInfoParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onCapabilityChanged(capabilityInfoParcelable);
                }
            };
            this.zzb(runnable, "onConnectedCapabilityChanged", capabilityInfoParcelable);
        }

        @Override
        public void zza(final AncsNotificationParcelable ancsNotificationParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    zzj zzj2 = (zzj)WearableListenerService.this;
                    zzj2.zza(ancsNotificationParcelable);
                }
            };
            this.zza(runnable, "onNotificationReceived", ancsNotificationParcelable);
        }

        @Override
        public void zza(final AmsEntityUpdateParcelable amsEntityUpdateParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    zzj zzj2 = (zzj)WearableListenerService.this;
                    zzj2.zza(amsEntityUpdateParcelable);
                }
            };
            this.zza(runnable, "onEntityUpdate", amsEntityUpdateParcelable);
        }

        @Override
        public void zza(final ChannelEventParcelable channelEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    channelEventParcelable.zza(WearableListenerService.this);
                }
            };
            this.zzb(runnable, "onChannelEvent", channelEventParcelable);
        }

        private boolean zza(Runnable runnable, String string, Object object) {
            boolean bl = WearableListenerService.this instanceof zzj;
            if (!bl) {
                return false;
            }
            return this.zzb(runnable, string, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zzb(Runnable runnable, String string, Object object) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.zzTJ, object));
            }
            this.zzIx();
            Object object2 = WearableListenerService.this.zzbrp;
            synchronized (object2) {
                if (WearableListenerService.this.zzQl) {
                    return false;
                }
                WearableListenerService.this.zzbro.post(runnable);
            }
            return true;
        }

        private void zzIx() throws SecurityException {
            int n = Binder.getCallingUid();
            if (n == this.zzakz) {
                return;
            }
            if (GooglePlayServicesUtil.zzf((Context)WearableListenerService.this, (int)n)) {
                this.zzakz = n;
                return;
            }
            throw new SecurityException("Caller is not GooglePlayServices");
        }
    }
}

