/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.ChannelImpl;
import com.google.android.gms.wearable.internal.zzn;

public final class ChannelEventParcelable
implements SafeParcelable {
    public static final Parcelable.Creator<ChannelEventParcelable> CREATOR = new zzn();
    final int mVersionCode;
    final ChannelImpl zzbsc;
    final int type;
    final int zzbsa;
    final int zzbsb;

    ChannelEventParcelable(int versionCode, ChannelImpl channel, int type, int closeReason, int appErrorCode) {
        this.mVersionCode = versionCode;
        this.zzbsc = channel;
        this.type = type;
        this.zzbsa = closeReason;
        this.zzbsb = appErrorCode;
    }

    public void zza(ChannelApi.ChannelListener channelListener) {
        switch (this.type) {
            case 1: {
                channelListener.onChannelOpened(this.zzbsc);
                break;
            }
            case 2: {
                channelListener.onChannelClosed(this.zzbsc, this.zzbsa, this.zzbsb);
                break;
            }
            case 3: {
                channelListener.onInputClosed(this.zzbsc, this.zzbsa, this.zzbsb);
                break;
            }
            case 4: {
                channelListener.onOutputClosed(this.zzbsc, this.zzbsa, this.zzbsb);
                break;
            }
            default: {
                Log.w((String)"ChannelEventParcelable", (String)("Unknown type: " + this.type));
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzn.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelEventParcelable[versionCode=" + this.mVersionCode + ", channel=" + this.zzbsc + ", type=" + ChannelEventParcelable.zzlG(this.type) + ", closeReason=" + ChannelEventParcelable.zzlH(this.zzbsa) + ", appErrorCode=" + this.zzbsb + "]";
    }

    private static String zzlG(int n) {
        switch (n) {
            case 1: {
                return "CHANNEL_OPENED";
            }
            case 2: {
                return "CHANNEL_CLOSED";
            }
            case 4: {
                return "OUTPUT_CLOSED";
            }
            case 3: {
                return "INPUT_CLOSED";
            }
        }
        return Integer.toString(n);
    }

    private static String zzlH(int n) {
        switch (n) {
            case 1: {
                return "CLOSE_REASON_DISCONNECTED";
            }
            case 2: {
                return "CLOSE_REASON_REMOTE_CLOSE";
            }
            case 3: {
                return "CLOSE_REASON_LOCAL_CLOSE";
            }
            case 0: {
                return "CLOSE_REASON_NORMAL";
            }
        }
        return Integer.toString(n);
    }
}

