/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.wearable.zze;
import java.util.Arrays;

public class Asset
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zze();
    final int mVersionCode;
    private byte[] zzaRo;
    private String zzbBA;
    public ParcelFileDescriptor zzbBB;
    public Uri uri;

    Asset(int n, byte[] byArray, String string, ParcelFileDescriptor parcelFileDescriptor, Uri uri) {
        this.mVersionCode = n;
        this.zzaRo = byArray;
        this.zzbBA = string;
        this.zzbBB = parcelFileDescriptor;
        this.uri = uri;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n | 1);
    }

    public static Asset createFromRef(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, string, null, null);
    }

    public static Asset createFromBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, byArray, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, parcelFileDescriptor, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.zzaRo;
    }

    public String getDigest() {
        return this.zzbBA;
    }

    public ParcelFileDescriptor getFd() {
        return this.zzbBB;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.zzaRo, this.zzbBA, this.zzbBB, this.uri});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)((Object)object);
        return Arrays.equals(this.zzaRo, asset.zzaRo) && zzz.equal((Object)this.zzbBA, (Object)asset.zzbBA) && zzz.equal((Object)this.zzbBB, (Object)asset.zzbBB) && zzz.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzbBA == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzbBA);
        }
        if (this.zzaRo != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.zzaRo.length);
        }
        if (this.zzbBB != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zzbBB);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

