/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzacj;
import com.google.android.gms.internal.zzack;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.wearable.Asset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class DataMap {
    public static final String TAG = "DataMap";
    private final HashMap<String, Object> zzbBI = new HashMap();

    public static DataMap fromBundle(Bundle bundle) {
        bundle.setClassLoader(Asset.class.getClassLoader());
        DataMap dataMap = new DataMap();
        for (String string : bundle.keySet()) {
            DataMap.zza(dataMap, string, bundle.get(string));
        }
        return dataMap;
    }

    public static DataMap fromByteArray(byte[] byArray) {
        try {
            return zzacj.zza(new zzacj.zza(zzack.zzF(byArray), new ArrayList<Asset>()));
        }
        catch (zzami zzami2) {
            throw new IllegalArgumentException("Unable to convert data", zzami2);
        }
    }

    public static ArrayList<DataMap> arrayListFromBundleArrayList(ArrayList<Bundle> arrayList) {
        ArrayList<DataMap> arrayList2 = new ArrayList<DataMap>();
        for (Bundle bundle : arrayList) {
            arrayList2.add(DataMap.fromBundle(bundle));
        }
        return arrayList2;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        for (String string : this.zzbBI.keySet()) {
            DataMap.zzb(bundle, string, this.zzbBI.get(string));
        }
        return bundle;
    }

    public byte[] toByteArray() {
        return zzamj.toByteArray((zzamj)zzacj.zza((DataMap)this).zzbEe);
    }

    public int size() {
        return this.zzbBI.size();
    }

    public boolean isEmpty() {
        return this.zzbBI.isEmpty();
    }

    public void clear() {
        this.zzbBI.clear();
    }

    public boolean containsKey(String string) {
        return this.zzbBI.containsKey(string);
    }

    public <T> T get(String string) {
        return (T)this.zzbBI.get(string);
    }

    public Object remove(String string) {
        return this.zzbBI.remove(string);
    }

    public void putAll(DataMap dataMap) {
        for (String string : dataMap.keySet()) {
            this.zzbBI.put(string, dataMap.get(string));
        }
    }

    public Set<String> keySet() {
        return this.zzbBI.keySet();
    }

    public void putBoolean(String string, boolean bl) {
        this.zzbBI.put(string, bl);
    }

    public void putByte(String string, byte by) {
        this.zzbBI.put(string, by);
    }

    public void putInt(String string, int n) {
        this.zzbBI.put(string, n);
    }

    public void putLong(String string, long l) {
        this.zzbBI.put(string, l);
    }

    public void putFloat(String string, float f) {
        this.zzbBI.put(string, Float.valueOf(f));
    }

    public void putDouble(String string, double d) {
        this.zzbBI.put(string, d);
    }

    public void putString(String string, String string2) {
        this.zzbBI.put(string, string2);
    }

    public void putAsset(String string, Asset asset) {
        this.zzbBI.put(string, (Object)asset);
    }

    public void putDataMap(String string, DataMap dataMap) {
        this.zzbBI.put(string, dataMap);
    }

    public void putDataMapArrayList(String string, ArrayList<DataMap> arrayList) {
        this.zzbBI.put(string, arrayList);
    }

    public void putIntegerArrayList(String string, ArrayList<Integer> arrayList) {
        this.zzbBI.put(string, arrayList);
    }

    public void putStringArrayList(String string, ArrayList<String> arrayList) {
        this.zzbBI.put(string, arrayList);
    }

    public void putByteArray(String string, byte[] byArray) {
        this.zzbBI.put(string, byArray);
    }

    public void putLongArray(String string, long[] lArray) {
        this.zzbBI.put(string, lArray);
    }

    public void putFloatArray(String string, float[] fArray) {
        this.zzbBI.put(string, fArray);
    }

    public void putStringArray(String string, String[] stringArray) {
        this.zzbBI.put(string, stringArray);
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return bl;
        }
        try {
            return (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "Boolean", bl, classCastException);
            return bl;
        }
    }

    public byte getByte(String string) {
        return this.getByte(string, (byte)0);
    }

    public byte getByte(String string, byte by) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return by;
        }
        try {
            return (Byte)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "Byte", by, classCastException);
            return by;
        }
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public int getInt(String string, int n) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return n;
        }
        try {
            return (Integer)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "Integer", classCastException);
            return n;
        }
    }

    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    public long getLong(String string, long l) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return l;
        }
        try {
            return (Long)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "long", classCastException);
            return l;
        }
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return f;
        }
        try {
            return ((Float)object).floatValue();
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "Float", Float.valueOf(f), classCastException);
            return f;
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return d;
        }
        try {
            return (Double)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "Double", d, classCastException);
            return d;
        }
    }

    public String getString(String string, String string2) {
        String string3 = this.getString(string);
        return string3 == null ? string2 : string3;
    }

    public String getString(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (String)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "String", classCastException);
            return null;
        }
    }

    public Asset getAsset(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (Asset)((Object)object);
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "Asset", classCastException);
            return null;
        }
    }

    public DataMap getDataMap(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (DataMap)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, TAG, classCastException);
            return null;
        }
    }

    public ArrayList<Integer> getIntegerArrayList(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "ArrayList<Integer>", classCastException);
            return null;
        }
    }

    public ArrayList<String> getStringArrayList(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "ArrayList<String>", classCastException);
            return null;
        }
    }

    public ArrayList<DataMap> getDataMapArrayList(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (ArrayList)object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "ArrayList<DataMap>", classCastException);
            return null;
        }
    }

    public byte[] getByteArray(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "byte[]", classCastException);
            return null;
        }
    }

    public long[] getLongArray(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (long[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "long[]", classCastException);
            return null;
        }
    }

    public float[] getFloatArray(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (float[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "float[]", classCastException);
            return null;
        }
    }

    public String[] getStringArray(String string) {
        Object object = this.zzbBI.get(string);
        if (object == null) {
            return null;
        }
        try {
            return (String[])object;
        }
        catch (ClassCastException classCastException) {
            this.zza(string, object, "String[]", classCastException);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataMap)) {
            return false;
        }
        return DataMap.zza(this, (DataMap)object);
    }

    public int hashCode() {
        return 29 * this.zzbBI.hashCode();
    }

    public String toString() {
        return this.zzbBI.toString();
    }

    private void zza(String string, Object object, String string2, ClassCastException classCastException) {
        this.zza(string, object, string2, "<null>", classCastException);
    }

    private void zza(String string, Object object, String string2, Object object2, ClassCastException classCastException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Key ");
        stringBuilder.append(string);
        stringBuilder.append(" expected ");
        stringBuilder.append(string2);
        stringBuilder.append(" but value was a ");
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append(".  The default value ");
        stringBuilder.append(object2);
        stringBuilder.append(" was returned.");
        Log.w((String)TAG, (String)stringBuilder.toString());
        Log.w((String)TAG, (String)"Attempt to cast generated internal exception:", (Throwable)classCastException);
    }

    private static boolean zza(DataMap dataMap, DataMap dataMap2) {
        if (dataMap.size() != dataMap2.size()) {
            return false;
        }
        for (String string : dataMap.keySet()) {
            Object t = dataMap.get(string);
            Object t2 = dataMap2.get(string);
            if (t instanceof Asset) {
                if (!(t2 instanceof Asset)) {
                    return false;
                }
                if (DataMap.zza((Asset)((Object)t), (Asset)((Object)t2))) continue;
                return false;
            }
            if (t instanceof String[]) {
                if (!(t2 instanceof String[])) {
                    return false;
                }
                if (Arrays.equals((String[])t, (String[])t2)) continue;
                return false;
            }
            if (t instanceof long[]) {
                if (!(t2 instanceof long[])) {
                    return false;
                }
                if (Arrays.equals((long[])t, (long[])t2)) continue;
                return false;
            }
            if (t instanceof float[]) {
                if (!(t2 instanceof float[])) {
                    return false;
                }
                if (Arrays.equals((float[])t, (float[])t2)) continue;
                return false;
            }
            if (t instanceof byte[]) {
                if (!(t2 instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])t, (byte[])t2)) continue;
                return false;
            }
            if (t == null || t2 == null) {
                return t == t2;
            }
            if (t.equals(t2)) continue;
            return false;
        }
        return true;
    }

    private static boolean zza(Asset asset, Asset asset2) {
        if (asset == null || asset2 == null) {
            return asset == asset2;
        }
        if (!TextUtils.isEmpty((CharSequence)asset.getDigest())) {
            return asset.getDigest().equals(asset2.getDigest());
        }
        return Arrays.equals(asset.getData(), asset2.getData());
    }

    private static void zza(DataMap dataMap, String string, Object object) {
        if (object instanceof String) {
            dataMap.putString(string, (String)object);
        } else if (object instanceof Integer) {
            dataMap.putInt(string, (Integer)object);
        } else if (object instanceof Long) {
            dataMap.putLong(string, (Long)object);
        } else if (object instanceof Double) {
            dataMap.putDouble(string, (Double)object);
        } else if (object instanceof Float) {
            dataMap.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            dataMap.putBoolean(string, (Boolean)object);
        } else if (object instanceof Byte) {
            dataMap.putByte(string, (Byte)object);
        } else if (object instanceof byte[]) {
            dataMap.putByteArray(string, (byte[])object);
        } else if (object instanceof String[]) {
            dataMap.putStringArray(string, (String[])object);
        } else if (object instanceof long[]) {
            dataMap.putLongArray(string, (long[])object);
        } else if (object instanceof float[]) {
            dataMap.putFloatArray(string, (float[])object);
        } else if (object instanceof Asset) {
            dataMap.putAsset(string, (Asset)((Object)object));
        } else if (object instanceof Bundle) {
            dataMap.putDataMap(string, DataMap.fromBundle((Bundle)object));
        } else if (object instanceof ArrayList) {
            switch (DataMap.zzf((ArrayList)object)) {
                case 0: {
                    dataMap.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 1: {
                    dataMap.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 3: {
                    dataMap.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 2: {
                    dataMap.putIntegerArrayList(string, (ArrayList)object);
                    break;
                }
                case 5: {
                    dataMap.putDataMapArrayList(string, DataMap.arrayListFromBundleArrayList((ArrayList)object));
                }
            }
        }
    }

    private static void zzb(Bundle bundle, String string, Object object) {
        if (object instanceof String) {
            bundle.putString(string, (String)object);
        } else if (object instanceof Integer) {
            bundle.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
        } else if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
        } else if (object instanceof Float) {
            bundle.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            bundle.putBoolean(string, ((Boolean)object).booleanValue());
        } else if (object instanceof Byte) {
            bundle.putByte(string, ((Byte)object).byteValue());
        } else if (object instanceof byte[]) {
            bundle.putByteArray(string, (byte[])object);
        } else if (object instanceof String[]) {
            bundle.putStringArray(string, (String[])object);
        } else if (object instanceof long[]) {
            bundle.putLongArray(string, (long[])object);
        } else if (object instanceof float[]) {
            bundle.putFloatArray(string, (float[])object);
        } else if (object instanceof Asset) {
            bundle.putParcelable(string, (Parcelable)((Asset)((Object)object)));
        } else if (object instanceof DataMap) {
            bundle.putParcelable(string, (Parcelable)((DataMap)object).toBundle());
        } else if (object instanceof ArrayList) {
            switch (DataMap.zzf((ArrayList)object)) {
                case 0: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 1: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 3: {
                    bundle.putStringArrayList(string, (ArrayList)object);
                    break;
                }
                case 2: {
                    bundle.putIntegerArrayList(string, (ArrayList)object);
                    break;
                }
                case 4: {
                    ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                    for (DataMap dataMap : (ArrayList)object) {
                        arrayList.add(dataMap.toBundle());
                    }
                    bundle.putParcelableArrayList(string, arrayList);
                }
            }
        }
    }

    private static int zzf(ArrayList<?> arrayList) {
        if (arrayList.isEmpty()) {
            return 0;
        }
        for (Object obj : arrayList) {
            if (obj == null) continue;
            if (obj instanceof Integer) {
                return 2;
            }
            if (obj instanceof String) {
                return 3;
            }
            if (obj instanceof DataMap) {
                return 4;
            }
            if (!(obj instanceof Bundle)) continue;
            return 5;
        }
        return 1;
    }
}

