/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.AmsEntityUpdateParcelable;
import com.google.android.gms.wearable.internal.AncsNotificationParcelable;
import com.google.android.gms.wearable.internal.CapabilityInfoParcelable;
import com.google.android.gms.wearable.internal.ChannelEventParcelable;
import com.google.android.gms.wearable.internal.MessageEventParcelable;
import com.google.android.gms.wearable.internal.NodeParcelable;
import com.google.android.gms.wearable.internal.zzaw;
import com.google.android.gms.wearable.zzb;
import com.google.android.gms.wearable.zzd;
import java.util.List;

public abstract class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private String zzZC;
    private Handler zzbBU;
    private IBinder zzaqQ;
    private final Object zzbBV = new Object();
    private boolean zzbBW;

    public void onCreate() {
        super.onCreate();
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            String string = String.valueOf(new ComponentName(this.getPackageName(), this.getClass().getName()).flattenToShortString());
            Log.d((String)"WearableLS", (String)(string.length() != 0 ? "onCreate: ".concat(string) : new String("onCreate: ")));
        }
        this.zzZC = this.getPackageName();
        HandlerThread handlerThread = new HandlerThread("WearableListenerService");
        handlerThread.start();
        this.zzbBU = new Handler(handlerThread.getLooper());
        this.zzaqQ = new zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            String string = String.valueOf(new ComponentName(this.getPackageName(), this.getClass().getName()).flattenToShortString());
            Log.d((String)"WearableLS", (String)(string.length() != 0 ? "onDestroy: ".concat(string) : new String("onDestroy: ")));
        }
        Object object = this.zzbBV;
        synchronized (object) {
            this.zzbBW = true;
            if (this.zzbBU == null) {
                throw new IllegalStateException("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()?");
            }
            this.zzbBU.getLooper().quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzaqQ;
        }
        return null;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEventBuffer) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node node) {
    }

    @Override
    public void onPeerDisconnected(Node node) {
    }

    public void onConnectedNodes(List<Node> list) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onInputClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onOutputClosed(Channel channel, int n, int n2) {
    }

    public void onNotificationReceived(zzd zzd2) {
    }

    public void onEntityUpdate(zzb zzb2) {
    }

    private final class zza
    extends zzaw.zza {
        private volatile int zzaqn = -1;

        private zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzaq(final DataHolder dataHolder) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DataEventBuffer dataEventBuffer = new DataEventBuffer(dataHolder);
                    try {
                        WearableListenerService.this.onDataChanged(dataEventBuffer);
                    }
                    finally {
                        dataEventBuffer.release();
                    }
                }
            };
            boolean bl = false;
            try {
                bl = this.zza(runnable, "onDataItemChanged", dataHolder);
            }
            finally {
                if (!bl) {
                    dataHolder.close();
                }
            }
        }

        @Override
        public void zza(final MessageEventParcelable messageEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onMessageReceived(messageEventParcelable);
                }
            };
            this.zza(runnable, "onMessageReceived", messageEventParcelable);
        }

        @Override
        public void zza(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerConnected(nodeParcelable);
                }
            };
            this.zza(runnable, "onPeerConnected", nodeParcelable);
        }

        @Override
        public void zzb(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerDisconnected(nodeParcelable);
                }
            };
            this.zza(runnable, "onPeerDisconnected", nodeParcelable);
        }

        @Override
        public void onConnectedNodes(final List<NodeParcelable> list) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onConnectedNodes(list);
                }
            };
            this.zza(runnable, "onConnectedNodes", list);
        }

        @Override
        public void zza(final CapabilityInfoParcelable capabilityInfoParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onCapabilityChanged(capabilityInfoParcelable);
                }
            };
            this.zza(runnable, "onConnectedCapabilityChanged", capabilityInfoParcelable);
        }

        @Override
        public void zza(final AncsNotificationParcelable ancsNotificationParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onNotificationReceived(ancsNotificationParcelable);
                }
            };
            this.zza(runnable, "onNotificationReceived", ancsNotificationParcelable);
        }

        @Override
        public void zza(final AmsEntityUpdateParcelable amsEntityUpdateParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onEntityUpdate(amsEntityUpdateParcelable);
                }
            };
            this.zza(runnable, "onEntityUpdate", amsEntityUpdateParcelable);
        }

        @Override
        public void zza(final ChannelEventParcelable channelEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    channelEventParcelable.zza(WearableListenerService.this);
                }
            };
            this.zza(runnable, "onChannelEvent", (Object)channelEventParcelable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(Runnable runnable, String string, Object object) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.zzZC, object));
            }
            this.zzNs();
            Object object2 = WearableListenerService.this.zzbBV;
            synchronized (object2) {
                if (WearableListenerService.this.zzbBW) {
                    return false;
                }
                WearableListenerService.this.zzbBU.post(runnable);
            }
            return true;
        }

        private void zzNs() throws SecurityException {
            int n = Binder.getCallingUid();
            if (n == this.zzaqn) {
                return;
            }
            if (GooglePlayServicesUtil.zze((Context)WearableListenerService.this, (int)n)) {
                this.zzaqn = n;
                return;
            }
            throw new SecurityException("Caller is not GooglePlayServices");
        }
    }
}

