/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.PutDataResponse;
import com.google.android.gms.wearable.internal.zzav;
import com.google.android.gms.wearable.internal.zzax;
import com.google.android.gms.wearable.internal.zzay;
import com.google.android.gms.wearable.internal.zzbj;
import com.google.android.gms.wearable.internal.zzbo;
import com.google.android.gms.wearable.internal.zzbq;
import com.google.android.gms.wearable.internal.zzt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class zzbp
extends zzk<zzax> {
    private final ExecutorService zzbqx;
    private final zzay<Object> zzbDK = new zzay();
    private final zzay<Object> zzbDL = new zzay();
    private final zzay<ChannelApi.ChannelListener> zzbDM = new zzay();
    private final zzay<DataApi.DataListener> zzbDN = new zzay();
    private final zzay<MessageApi.MessageListener> zzbDO = new zzay();
    private final zzay<NodeApi.NodeListener> zzbDP = new zzay();
    private final zzay<Object> zzbDQ = new zzay();
    private final zzay<CapabilityApi.CapabilityListener> zzbDR = new zzay();

    public zzbp(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzg zzg2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, zzg2, Executors.newCachedThreadPool());
    }

    zzbp(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzg zzg2, ExecutorService executorService) {
        super(context, looper, 14, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzbqx = (ExecutorService)zzaa.zzz((Object)executorService);
    }

    protected String zzhT() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected String zzhU() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected zzax zzeF(IBinder iBinder) {
        return zzax.zza.zzeD(iBinder);
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)new StringBuilder(41).append("onPostInitHandler: statusCode ").append(n).toString());
        }
        if (n == 0) {
            this.zzbDK.zzeE(iBinder);
            this.zzbDL.zzeE(iBinder);
            this.zzbDM.zzeE(iBinder);
            this.zzbDN.zzeE(iBinder);
            this.zzbDO.zzeE(iBinder);
            this.zzbDP.zzeE(iBinder);
            this.zzbDQ.zzeE(iBinder);
            this.zzbDR.zzeE(iBinder);
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zza(zznt.zzb<DataApi.DataItemResult> zzb2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Object object = entry22.getValue();
            if (object.getData() != null || object.getDigest() != null || object.getFd() != null || object.getUri() != null) continue;
            String string = String.valueOf(putDataRequest.getUri());
            String string2 = String.valueOf(object);
            throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Put for ").append(string).append(" contains invalid asset: ").append(string2).toString());
        }
        PutDataRequest putDataRequest2 = PutDataRequest.zzu(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        if (putDataRequest.isUrgent()) {
            putDataRequest2.setUrgent();
        }
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            Object object;
            ParcelFileDescriptor parcelFileDescriptor;
            Asset asset = (Asset)((Object)entry3.getValue());
            if (asset.getData() != null) {
                String string;
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    string = String.valueOf((Object)putDataRequest);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Unable to create ParcelFileDescriptor for asset in request: ").append(string).toString(), iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    object = String.valueOf((Object)asset);
                    string = String.valueOf(parcelFileDescriptor[0]);
                    String string3 = String.valueOf(parcelFileDescriptor[1]);
                    Log.d((String)"WearableClient", (String)new StringBuilder(61 + String.valueOf(object).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("processAssets: replacing data with FD in asset: ").append((String)object).append(" read:").append(string).append(" write:").append(string3).toString());
                }
                putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptor[0]));
                object = this.zza(parcelFileDescriptor[1], asset.getData());
                entry22.add(object);
                this.zzbqx.submit((Runnable)object);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    parcelFileDescriptor = this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r");
                    object = Asset.createFromFd(parcelFileDescriptor);
                    putDataRequest2.putAsset((String)entry3.getKey(), (Asset)((Object)object));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    new zzbo.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)).zza(new PutDataResponse(4005, null));
                    object = String.valueOf(asset.getUri());
                    Log.w((String)"WearableClient", (String)new StringBuilder(28 + String.valueOf(object).length()).append("Couldn't resolve asset URI: ").append((String)object).toString());
                    return;
                }
            }
            putDataRequest2.putAsset((String)entry3.getKey(), asset);
        }
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
    }

    private FutureTask<Boolean> zza(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean zzji() {
                String string;
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    string = String.valueOf(parcelFileDescriptor);
                    Log.d((String)"WearableClient", (String)new StringBuilder(36 + String.valueOf(string).length()).append("processAssets: writing data to FD : ").append(string).toString());
                }
                string = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    Object object;
                    string.write(byArray);
                    string.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        object = String.valueOf(parcelFileDescriptor);
                        Log.d((String)"WearableClient", (String)new StringBuilder(27 + String.valueOf(object).length()).append("processAssets: wrote data: ").append((String)object).toString());
                    }
                    object = true;
                    return object;
                }
                catch (IOException iOException) {
                    String string2 = String.valueOf(parcelFileDescriptor);
                    Log.w((String)"WearableClient", (String)new StringBuilder(36 + String.valueOf(string2).length()).append("processAssets: writing data failed: ").append(string2).toString());
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            String string3 = String.valueOf(parcelFileDescriptor);
                            Log.d((String)"WearableClient", (String)new StringBuilder(24 + String.valueOf(string3).length()).append("processAssets: closing: ").append(string3).toString());
                        }
                        string.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzji();
            }
        });
    }

    public void zza(zznt.zzb<DataApi.DataItemResult> zzb2, Uri uri) throws RemoteException {
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzk(zzb2), uri);
    }

    public void zzv(zznt.zzb<DataItemBuffer> zzb2) throws RemoteException {
        ((zzax)this.zztm()).zzb(new zzbo.zzl(zzb2));
    }

    public void zza(zznt.zzb<DataItemBuffer> zzb2, Uri uri, int n) throws RemoteException {
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzl(zzb2), uri, n);
    }

    public void zzb(zznt.zzb<DataApi.DeleteDataItemsResult> zzb2, Uri uri, int n) throws RemoteException {
        ((zzax)this.zztm()).zzb((zzav)new zzbo.zze(zzb2), uri, n);
    }

    public void zza(zznt.zzb<MessageApi.SendMessageResult> zzb2, String string, String string2, byte[] byArray) throws RemoteException {
        ((zzax)this.zztm()).zza(new zzbo.zzt(zzb2), string, string2, byArray);
    }

    public void zza(zznt.zzb<DataApi.GetFdForAssetResult> zzb2, Asset asset) throws RemoteException {
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzm(zzb2), asset);
    }

    public void zza(zznt.zzb<DataApi.GetFdForAssetResult> zzb2, DataItemAsset dataItemAsset) throws RemoteException {
        this.zza(zzb2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void zzw(zznt.zzb<NodeApi.GetLocalNodeResult> zzb2) throws RemoteException {
        ((zzax)this.zztm()).zzc(new zzbo.zzn(zzb2));
    }

    public void zzx(zznt.zzb<NodeApi.GetConnectedNodesResult> zzb2) throws RemoteException {
        ((zzax)this.zztm()).zzd(new zzbo.zzj(zzb2));
    }

    public void zzh(zznt.zzb<CapabilityApi.GetCapabilityResult> zzb2, String string, int n) throws RemoteException {
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzg(zzb2), string, n);
    }

    public void zzd(zznt.zzb<CapabilityApi.GetAllCapabilitiesResult> zzb2, int n) throws RemoteException {
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzf(zzb2), n);
    }

    public void zzv(zznt.zzb<CapabilityApi.AddLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzax)this.zztm()).zzd(new zzbo.zza(zzb2), string);
    }

    public void zzw(zznt.zzb<CapabilityApi.RemoveLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzax)this.zztm()).zze(new zzbo.zzs(zzb2), string);
    }

    public void zze(zznt.zzb<ChannelApi.OpenChannelResult> zzb2, String string, String string2) throws RemoteException {
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzp(zzb2), string, string2);
    }

    public void zzx(zznt.zzb<Status> zzb2, String string) throws RemoteException {
        ((zzax)this.zztm()).zzf(new zzbo.zzc(zzb2), string);
    }

    public void zzi(zznt.zzb<Status> zzb2, String string, int n) throws RemoteException {
        ((zzax)this.zztm()).zzb((zzav)new zzbo.zzd(zzb2), string, n);
    }

    public void zzy(zznt.zzb<Channel.GetInputStreamResult> zzb2, String string) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzax)this.zztm()).zza((zzav)new zzbo.zzh(zzb2, zzt2), zzt2, string);
    }

    public void zzz(zznt.zzb<Channel.GetOutputStreamResult> zzb2, String string) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzax)this.zztm()).zzb((zzav)new zzbo.zzi(zzb2, zzt2), zzt2, string);
    }

    public void zza(zznt.zzb<Status> zzb2, String string, Uri uri, boolean bl) {
        try {
            this.zzbqx.execute(this.zzb(zzb2, string, uri, bl));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzx(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zznt.zzb<Status> zzb2, String string, Uri uri, long l, long l2) {
        try {
            this.zzbqx.execute(this.zzb(zzb2, string, uri, l, l2));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzx(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zznt.zzb<Status> zzb2, DataApi.DataListener dataListener, zzou<DataApi.DataListener> zzou2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbDN.zza(this, zzb2, dataListener, zzbq.zza(zzou2, intentFilterArray));
    }

    public void zza(zznt.zzb<Status> zzb2, MessageApi.MessageListener messageListener, zzou<MessageApi.MessageListener> zzou2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbDO.zza(this, zzb2, messageListener, zzbq.zzb(zzou2, intentFilterArray));
    }

    public void zza(zznt.zzb<Status> zzb2, NodeApi.NodeListener nodeListener, zzou<NodeApi.NodeListener> zzou2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbDP.zza(this, zzb2, nodeListener, zzbq.zzc(zzou2, intentFilterArray));
    }

    public void zza(zznt.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, zzou<CapabilityApi.CapabilityListener> zzou2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbDR.zza(this, zzb2, capabilityListener, zzbq.zze(zzou2, intentFilterArray));
    }

    public void zza(zznt.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzou<ChannelApi.ChannelListener> zzou2, String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzbDM.zza(this, zzb2, channelListener, zzbq.zzd(zzou2, intentFilterArray));
        } else {
            zzbj zzbj2 = new zzbj(string, channelListener);
            this.zzbDM.zza(this, zzb2, zzbj2, zzbq.zza(zzou2, string, intentFilterArray));
        }
    }

    public void zza(zznt.zzb<Status> zzb2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzbDN.zza(this, zzb2, dataListener);
    }

    public void zza(zznt.zzb<Status> zzb2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzbDO.zza(this, zzb2, messageListener);
    }

    public void zza(zznt.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzbDP.zza(this, zzb2, nodeListener);
    }

    public void zza(zznt.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzbDR.zza(this, zzb2, capabilityListener);
    }

    public void zza(zznt.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzbDM.zza(this, zzb2, channelListener);
        } else {
            zzbj zzbj2 = new zzbj(string, channelListener);
            this.zzbDM.zza(this, zzb2, zzbj2);
        }
    }

    private Runnable zzb(final zznt.zzb<Status> zzb2, final String string, final Uri uri, final boolean bl) {
        zzaa.zzz(zzb2);
        zzaa.zzz((Object)string);
        zzaa.zzz((Object)uri);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing receiveFileFromChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile used with non-file URI");
                    zzb2.zzx(new Status(10, "Channel.receiveFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                int n = 0x20000000 | (bl ? 0x2000000 : 0);
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string2 = String.valueOf(file);
                    Log.w((String)"WearableClient", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("File couldn't be opened for Channel.receiveFile: ").append(string2).toString());
                    zzb2.zzx(new Status(13));
                    return;
                }
                try {
                    ((zzax)zzbp.this.zztm()).zza((zzav)new zzbo.zzu((zznt.zzb<Status>)zzb2), string, parcelFileDescriptor);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile failed.", (Throwable)remoteException);
                    zzb2.zzx(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close targetFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    private Runnable zzb(final zznt.zzb<Status> zzb2, final String string, final Uri uri, final long l, final long l2) {
        zzaa.zzz(zzb2);
        zzaa.zzz((Object)string);
        zzaa.zzz((Object)uri);
        zzaa.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        zzaa.zzb((l2 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing sendFileToChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile used with non-file URI");
                    zzb2.zzx(new Status(10, "Channel.sendFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string2 = String.valueOf(file);
                    Log.w((String)"WearableClient", (String)new StringBuilder(46 + String.valueOf(string2).length()).append("File couldn't be opened for Channel.sendFile: ").append(string2).toString());
                    zzb2.zzx(new Status(13));
                    return;
                }
                try {
                    ((zzax)zzbp.this.zztm()).zza(new zzbo.zzr((zznt.zzb<Status>)zzb2), string, parcelFileDescriptor, l, l2);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile failed.", (Throwable)remoteException);
                    zzb2.zzx(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close sourceFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    protected /* synthetic */ IInterface zzab(IBinder iBinder) {
        return this.zzeF(iBinder);
    }
}

