/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzbp;
import com.google.android.gms.wearable.internal.zzi;
import java.io.IOException;
import java.io.InputStream;

public final class zzx
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient googleApiClient, final PutDataRequest putDataRequest) {
        return googleApiClient.zzc((zznt.zza)new zzi<DataApi.DataItemResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<DataApi.DataItemResult>)this, putDataRequest);
            }

            public DataApi.DataItemResult zzbG(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbG(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient googleApiClient, final Uri uri) {
        return googleApiClient.zzc((zznt.zza)new zzi<DataApi.DataItemResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzbG(Status status) {
                return new zza(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbG(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zznt.zza)new zzi<DataItemBuffer>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzv((zznt.zzb<DataItemBuffer>)this);
            }

            protected DataItemBuffer zzbH(Status status) {
                return new DataItemBuffer(DataHolder.zzbQ((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbH(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.getDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzaa.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzaa.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zzc((zznt.zza)new zzi<DataItemBuffer>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<DataItemBuffer>)this, uri, n);
            }

            protected DataItemBuffer zzbH(Status status) {
                return new DataItemBuffer(DataHolder.zzbQ((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbH(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.deleteDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzaa.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzaa.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zzc((zznt.zza)new zzi<DataApi.DeleteDataItemsResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzb((zznt.zzb<DataApi.DeleteDataItemsResult>)this, uri, n);
            }

            protected DataApi.DeleteDataItemsResult zzbI(Status status) {
                return new zzb(status, 0);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbI(status);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final Asset asset) {
        this.zza(asset);
        return googleApiClient.zzc((zznt.zza)new zzi<DataApi.GetFdForAssetResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbJ(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbJ(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final DataItemAsset dataItemAsset) {
        return googleApiClient.zzc((zznt.zza)new zzi<DataApi.GetFdForAssetResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<DataApi.GetFdForAssetResult>)this, dataItemAsset);
            }

            protected DataApi.GetFdForAssetResult zzbJ(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbJ(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzbn.zzhE("com.google.android.gms.wearable.DATA_CHANGED")};
        return this.zza(googleApiClient, dataListener, intentFilterArray);
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, Uri uri, int n) {
        zzaa.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzaa.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzbn.zza("com.google.android.gms.wearable.DATA_CHANGED", uri, n);
        return this.zza(googleApiClient, dataListener, new IntentFilter[]{intentFilter});
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, zzx.zza(intentFilterArray), dataListener);
    }

    private static zzb.zza<DataApi.DataListener> zza(final IntentFilter[] intentFilterArray) {
        return new zzb.zza<DataApi.DataListener>(){

            @Override
            public void zza(zzbp zzbp2, zznt.zzb<Status> zzb2, DataApi.DataListener dataListener, zzou<DataApi.DataListener> zzou2) throws RemoteException {
                zzbp2.zza(zzb2, dataListener, zzou2, intentFilterArray);
            }
        };
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient googleApiClient, final DataApi.DataListener dataListener) {
        return googleApiClient.zzc((zznt.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<Status>)this, dataListener);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static class zzc
    implements DataApi.GetFdForAssetResult {
        private final Status zzaaO;
        private volatile ParcelFileDescriptor zzbDe;
        private volatile InputStream zzbCO;
        private volatile boolean mClosed = false;

        public zzc(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzaaO = status;
            this.zzbDe = parcelFileDescriptor;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.zzbDe;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.zzbDe == null) {
                return null;
            }
            if (this.zzbCO == null) {
                this.zzbCO = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbDe);
            }
            return this.zzbCO;
        }

        public void release() {
            if (this.zzbDe == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.zzbCO != null) {
                    this.zzbCO.close();
                } else {
                    this.zzbDe.close();
                }
                this.mClosed = true;
                this.zzbDe = null;
                this.zzbCO = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class zzb
    implements DataApi.DeleteDataItemsResult {
        private final Status zzaaO;
        private final int zzbDd;

        public zzb(Status status, int n) {
            this.zzaaO = status;
            this.zzbDd = n;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public int getNumDeleted() {
            return this.zzbDd;
        }
    }

    public static class zza
    implements DataApi.DataItemResult {
        private final Status zzaaO;
        private final DataItem zzbDc;

        public zza(Status status, DataItem dataItem) {
            this.zzaaO = status;
            this.zzbDc = dataItem;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public DataItem getDataItem() {
            return this.zzbDc;
        }
    }
}

