/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.assetpacks;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.play.core.assetpacks.AssetLocation;
import com.google.android.play.core.assetpacks.AssetPackLocation;
import com.google.android.play.core.assetpacks.zzbl;
import com.google.android.play.core.assetpacks.zzbm;
import com.google.android.play.core.assetpacks.zzbt;
import com.google.android.play.core.assetpacks.zzck;
import com.google.android.play.core.assetpacks.zzed;
import com.google.android.play.core.internal.zzag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

final class zzbh {
    private static final zzag zza;
    private static final long zzb;
    private static final long zzc;
    private final Context zzd;
    private final zzed zze;

    final int zza(String string) {
        return (int)zzbh.zzH(this.zzI(string), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int zzb(String object, int n, long l) throws IOException {
        if (!((File)(object2 = ((zzbh)object2).zzJ((String)object, n, l))).exists()) {
            return 0;
        }
        object = new Properties();
        FileInputStream fileInputStream = new FileInputStream((File)object2);
        try {
            ((Properties)object).load(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Throwable throwable2) {
                throw throwable;
            }
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        if (((Properties)object).getProperty("numberOfMerges") == null) {
            Object object2 = new zzck("Merge checkpoint file corrupt.");
            throw object2;
        }
        try {
            return Integer.parseInt(((Properties)object).getProperty("numberOfMerges"));
        }
        catch (NumberFormatException numberFormatException) {
            object = new zzck("Merge checkpoint file corrupt.", numberFormatException);
            throw object;
        }
    }

    final long zzc(String string) {
        return zzbh.zzH(this.zzg(string, (int)zzbh.zzH(this.zzI(string), true)), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long zzH(File file, boolean bl) {
        if (!file.exists()) {
            return -1L;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (bl && file.listFiles().length > 1) {
            zza.zze("Multiple pack versions found, using highest version code.", new Object[0]);
        }
        try {
            for (File file2 : file.listFiles()) {
                boolean bl2 = file2.getName().equals("stale.tmp");
                if (bl2) continue;
                arrayList.add(Long.valueOf(file2.getName()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            zza.zzc(numberFormatException, "Corrupt asset pack directories.", new Object[0]);
        }
        if (arrayList.isEmpty()) {
            return -1L;
        }
        Collections.sort(arrayList);
        return (Long)arrayList.get(arrayList.size() + -1);
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @VisibleForTesting
    @Nullable
    final AssetLocation zzd(String object, String string, List objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object object2 = new File("assets", string);
        object2 = ((File)object2).getPath();
        for (String string2 : objectArray) {
            AssetLocation assetLocation = zzbt.zza(string2, (String)object2);
            if (assetLocation == null) continue;
            return assetLocation;
        }
        object2 = zza;
        Object[] objectArray2 = new Object[]{string, object, objectArray};
        ((zzag)object2).zza("The asset %s is not present in Asset Pack %s. Searched in APKs: %s", objectArray2);
        return null;
        catch (IOException iOException) {
            String string2;
            object = zza;
            objectArray = new Object[]{string2, string};
            ((zzag)object).zzc(iOException, "Failed to parse APK file '%s' looking for asset '%s'.", objectArray);
            return null;
        }
    }

    @Nullable
    final AssetLocation zze(String string, String string2, AssetPackLocation assetPackLocation) {
        Object object = new File(assetPackLocation.assetsPath(), string2);
        if (((File)object).exists()) {
            string = ((File)object).getPath();
            long l = ((File)object).length();
            object = new zzbl(string, 0L, l);
            return object;
        }
        object = zza;
        Object[] objectArray = new Object[]{string2, string, assetPackLocation.assetsPath()};
        ((zzag)object).zza("The asset %s is not present in Asset Pack %s. Searched in folder: %s", objectArray);
        return null;
    }

    @Nullable
    final AssetPackLocation zzf(String object) throws IOException {
        if ((object2 = ((zzbh)object2).zzr((String)object)) == null) {
            return null;
        }
        object = new File((String)object2, "assets");
        if (!((File)object).isDirectory()) {
            Object object2 = zza;
            Object[] objectArray = new Object[]{object};
            ((zzag)object2).zzb("Failed to find assets directory: %s", objectArray);
            return null;
        }
        object = ((File)object).getCanonicalPath();
        zzbm zzbm2 = new zzbm(0, (String)object2, (String)object);
        return zzbm2;
    }

    private final File zzI(String string) {
        File file = new File(this.zzL(), string);
        return file;
    }

    final File zzg(String string, int n) {
        File file = new File(this.zzI(string), String.valueOf(n));
        return file;
    }

    final File zzh(String string, int n, long l) {
        File file = new File(this.zzg(string, n), String.valueOf(l));
        return file;
    }

    final File zzi(String string, int n, long l) {
        File file = new File(this.zzh(string, n, l), "_metadata");
        return file;
    }

    private final File zzJ(String string, int n, long l) {
        File file = new File(this.zzj(string, n, l), "merge.tmp");
        return file;
    }

    final File zzj(String string, int n, long l) {
        File file = new File(this.zzK(string, n, l), "_packs");
        return file;
    }

    final File zzk(String string, int n, long l) {
        File file = new File(this.zzi(string, n, l), "properties.dat");
        return file;
    }

    private final File zzK(String string, int n, long l) {
        File file = new File(this.zzM(), string);
        File file2 = new File(file, String.valueOf(n));
        File file3 = new File(file2, String.valueOf(l));
        return file3;
    }

    final File zzl(String string, int n, long l) {
        File file = new File(this.zzK(string, n, l), "_slices");
        File file2 = new File(file, "_metadata");
        return file2;
    }

    final File zzm(String string, int n, long l, String string2) {
        File file = new File(this.zzo(string, n, l, string2), "checkpoint_ext.dat");
        return file;
    }

    final File zzn(String string, int n, long l, String string2) {
        File file = new File(this.zzo(string, n, l, string2), "checkpoint.dat");
        return file;
    }

    final File zzo(String string, int n, long l, String string2) {
        File file = new File(this.zzl(string, n, l), string2);
        return file;
    }

    private final File zzL() {
        File file = new File(this.zzd.getFilesDir(), "assetpacks");
        return file;
    }

    private final File zzM() {
        File file = new File(this.zzL(), "_tmp");
        return file;
    }

    final File zzp(String string, int n, long l, String string2) {
        File file = new File(this.zzK(string, n, l), "_slices");
        File file2 = new File(file, "_unverified");
        File file3 = new File(file2, string2);
        return file3;
    }

    final File zzq(String string, int n, long l, String string2) {
        File file = new File(this.zzK(string, n, l), "_slices");
        File file2 = new File(file, "_verified");
        File file3 = new File(file2, string2);
        return file3;
    }

    @Nullable
    final String zzr(String string) throws IOException {
        int n;
        Object object = new File(((zzbh)((Object)zzag2)).zzL(), string);
        if (!((File)object).exists()) {
            zzag zzag2 = zza;
            object = new Object[]{string};
            zzag2.zza("Pack not found with pack name: %s", (Object[])object);
            return null;
        }
        Object[] objectArray = new File((File)object, String.valueOf(((zzbh)((Object)zzag2)).zze.zza()));
        if (!objectArray.exists()) {
            object = zza;
            objectArray = new Object[]{string, ((zzbh)((Object)zzag2)).zze.zza()};
            ((zzag)object).zza("Pack not found with pack name: %s app version: %s", objectArray);
            return null;
        }
        object = objectArray.listFiles();
        if (object == null || (n = ((Object[])object).length) == 0) {
            object = zza;
            objectArray = new Object[]{string, ((zzbh)((Object)zzag2)).zze.zza()};
            ((zzag)object).zza("No pack version found for pack name: %s app version: %s", objectArray);
            return null;
        }
        if (n > 1) {
            object = zza;
            Object[] objectArray2 = new Object[]{string, ((zzbh)((Object)zzag2)).zze.zza()};
            ((zzag)object).zzb("Multiple pack versions found for pack name: %s app version: %s", objectArray2);
            return null;
        }
        return ((File)object[0]).getCanonicalPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    final List zzs(String string) {
        try {
            zzbh zzbh2 = zzbh2.zzd.getPackageManager().getPackageInfo(zzbh2.zzd.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.zzb("Could not find PackageInfo.", new Object[0]);
            return null;
        }
        if (zzbh2 == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (Build.VERSION.SDK_INT >= 21) {
            Object object;
            if (((PackageInfo)zzbh2).splitNames == null || ((PackageInfo)zzbh2).applicationInfo.splitSourceDirs == null) {
                object = zza;
                Object[] objectArray = new Object[]{string};
                ((zzag)object).zza("No splits present for package %s.", objectArray);
                object = null;
            } else {
                int n = Arrays.binarySearch(((PackageInfo)zzbh2).splitNames, string);
                if (n < 0) {
                    object = zza;
                    Object[] objectArray = new Object[]{string};
                    ((zzag)object).zza("Asset Pack '%s' is not installed.", objectArray);
                    object = null;
                } else {
                    object = ((PackageInfo)zzbh2).applicationInfo.splitSourceDirs[n];
                }
            }
            if (object == null) {
                arrayList.add(((PackageInfo)zzbh2).applicationInfo.sourceDir);
                arrayList.addAll(zzbh.zzN((PackageInfo)zzbh2, "config."));
                return arrayList;
            }
            arrayList.add(object);
            arrayList.addAll(zzbh.zzN((PackageInfo)zzbh2, String.valueOf(string).concat(".config.")));
            return arrayList;
        }
        arrayList.add(((PackageInfo)zzbh2).applicationInfo.sourceDir);
        return arrayList;
    }

    @RequiresApi(value=21)
    private static List zzN(PackageInfo packageInfo, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (packageInfo.splitNames == null) {
            return arrayList;
        }
        for (int i = -Arrays.binarySearch(packageInfo.splitNames, string) + -1; i < packageInfo.splitNames.length && packageInfo.splitNames[i].startsWith(string); ++i) {
            arrayList.add(packageInfo.applicationInfo.splitSourceDirs[i]);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List zzO() {
        int n;
        Object[] objectArray;
        ArrayList<Object> arrayList;
        block8: {
            arrayList = new ArrayList<Object>();
            boolean bl = this.zzL().exists();
            if (!bl) return arrayList;
            File[] fileArray = this.zzL().listFiles();
            if (fileArray != null) break block8;
            return arrayList;
        }
        try {
            objectArray = this.zzL().listFiles();
            n = objectArray.length;
        }
        catch (IOException iOException) {
            zzag zzag2 = zza;
            objectArray = new Object[]{iOException};
            zzag2.zzb("Could not process directory while scanning installed packs. %s", objectArray);
            return arrayList;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            boolean bl = ((File)object).getCanonicalPath().equals(this.zzM().getCanonicalPath());
            if (bl) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    final Map zzt() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Iterator iterator = this.zzO().iterator();
        while (iterator.hasNext()) {
            long l;
            int n;
            String string = ((File)iterator.next()).getName();
            if (!this.zzh(string, n = (int)zzbh.zzH(this.zzI(string), true), l = zzbh.zzH(this.zzg(string, n), true)).exists()) continue;
            hashMap.put(string, l);
        }
        return hashMap;
    }

    final Map zzu() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (String string : this.zzv().keySet()) {
            hashMap.put(string, this.zzc(string));
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Map zzv() {
        HashMap<String, AssetPackLocation> hashMap = new HashMap<String, AssetPackLocation>();
        try {
            boolean bl;
            Iterator iterator = this.zzO().iterator();
            while (bl = iterator.hasNext()) {
                File file = (File)iterator.next();
                AssetPackLocation assetPackLocation = this.zzf(file.getName());
                if (assetPackLocation == null) continue;
                hashMap.put(file.getName(), assetPackLocation);
            }
            return hashMap;
        }
        catch (IOException iOException) {
            zzag zzag2 = zza;
            Object[] objectArray = new Object[]{iOException};
            zzag2.zzb("Could not process directory while scanning installed packs: %s", objectArray);
            return hashMap;
        }
    }

    static {
        zzag zzag2;
        zza = zzag2 = new zzag("AssetPackStorage");
        zzb = TimeUnit.DAYS.toMillis(14L);
        zzc = TimeUnit.DAYS.toMillis(28L);
    }

    zzbh(Context context, zzed zzed2) {
        this.zzd = context;
        this.zze = zzed2;
    }

    /*
     * Unable to fully structure code
     */
    final void zzw() {
        block2: for (File var1_2 : this.zzO()) {
            if (var1_2.listFiles() == null) continue;
            zzbh.zzP(var1_2);
            var3_4 = zzbh.zzH(var1_2, false);
            if ((long)this.zze.zza() != var3_4) {
                var6_7 = new File(var1_2, String.valueOf(var3_4));
                var5_5 = new File(var6_7, "stale.tmp");
                var5_5.createNewFile();
            }
lbl11:
            // 4 sources

            while (true) {
                var5_5 = var1_2.listFiles();
                var6_6 = var5_5.length;
                for (var1_3 = 0; var1_3 < var6_6; ++var1_3) {
                    zzbh.zzP(var5_5[var1_3]);
                }
                continue block2;
                break;
            }
        }
        return;
        catch (IOException v0) {
            zzbh.zza.zzb("Could not write staleness marker.", new Object[0]);
            ** continue;
        }
    }

    private static void zzP(File file) {
        if (file.listFiles() == null || file.listFiles().length <= 1) {
            return;
        }
        long l = zzbh.zzH(file, false);
        for (File file2 : file.listFiles()) {
            if (file2.getName().equals(String.valueOf(l)) || file2.getName().equals("stale.tmp")) continue;
            zzbh.zzQ(file2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzx() {
        if (!this.zzM().exists()) {
            return;
        }
        File[] fileArray = this.zzM().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (System.currentTimeMillis() - file.lastModified() > zzb) {
                zzbh.zzQ(file);
            } else {
                zzbh.zzP(file);
            }
            ++n2;
        }
        return;
    }

    final void zzy() {
        for (Object object : ((zzbh)object).zzO()) {
            if (((File)object).listFiles() == null) continue;
            for (File file : ((File)object).listFiles()) {
                File file2 = new File(file, "stale.tmp");
                if (!file2.exists() || System.currentTimeMillis() - file2.lastModified() <= zzc) continue;
                zzbh.zzQ(file);
            }
        }
    }

    final void zzz() {
        zzbh.zzQ(this.zzL());
    }

    final void zzA(String object, int n, long l, int n2) throws IOException {
        File file = ((zzbh)((Object)file)).zzJ((String)object, n, l);
        object = new Properties();
        ((Properties)object).put("numberOfMerges", String.valueOf(n2));
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ((Properties)object).store(fileOutputStream, null);
        ((OutputStream)fileOutputStream).close();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzB(String object, int n, long l) {
        if (!((File)(this = ((zzbh)this).zzI((String)object))).exists()) {
            return;
        }
        File[] fileArray = ((File)this).listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            void var2_6;
            File file = fileArray[n3];
            if (!file.getName().equals(String.valueOf((int)var2_6)) && !file.getName().equals("stale.tmp")) {
                zzbh.zzQ(file);
            } else if (file.getName().equals(String.valueOf((int)var2_6))) {
                void var1_5;
                File[] fileArray2 = file.listFiles();
                int n4 = fileArray2.length;
                boolean bl = false;
                while (var1_5 < n4) {
                    void var3_7;
                    File file2 = fileArray2[var1_5];
                    if (!file2.getName().equals(String.valueOf((long)var3_7))) {
                        zzbh.zzQ(file2);
                    }
                    ++var1_5;
                }
            }
            ++n3;
        }
        return;
    }

    final void zzC(List list) {
        int n = ((zzbh)this).zze.zza();
        for (File file : ((zzbh)this).zzO()) {
            if (list.contains(file.getName()) || zzbh.zzH(file, true) == (long)n) continue;
            zzbh.zzQ(file);
        }
    }

    final boolean zzD(String string) {
        if (!this.zzI(string).exists()) {
            return true;
        }
        return zzbh.zzQ(this.zzI(string));
    }

    final boolean zzE(String string, int n, long l) {
        if (!this.zzK(string, n, l).exists()) {
            return true;
        }
        return zzbh.zzQ(this.zzK(string, n, l));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean zzQ(File file) {
        boolean bl;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = fileArray.length;
            bl = true;
            for (int i = 0; i < n; ++i) {
                bl = zzbh.zzQ(fileArray[i]) & bl;
            }
        } else {
            bl = true;
        }
        if (!file.delete()) {
            return false;
        }
        return bl;
    }

    final boolean zzF(String string, int n, long l) {
        if (!this.zzh(string, n, l).exists()) {
            return true;
        }
        return zzbh.zzQ(this.zzh(string, n, l));
    }

    final boolean zzG(String string) {
        try {
            String string2 = ((zzbh)((Object)string2)).zzr(string);
            return string2 != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

