/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.missingsplits;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import com.google.android.play.core.internal.zzag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class zza {
    private static final zzag zza;
    private final Context zzb;
    private final PackageManager zzc;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List zzd() {
        try {
            ArrayList arrayList = new ArrayList();
            zza zza2 = zza2.zzc.getPackageInfo(zza2.zzb.getPackageName(), 526);
            ProviderInfo[] providerInfoArray = ((PackageInfo)zza2).providers;
            if (providerInfoArray != null) {
                Collections.addAll(arrayList, ((PackageInfo)zza2).providers);
            }
            if ((providerInfoArray = ((PackageInfo)zza2).receivers) != null) {
                Collections.addAll(arrayList, ((PackageInfo)zza2).receivers);
            }
            if ((providerInfoArray = ((PackageInfo)zza2).services) != null) {
                Collections.addAll(arrayList, ((PackageInfo)zza2).services);
            }
            return arrayList;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzag zzag2 = zza;
            Object[] objectArray = new Object[]{nameNotFoundException};
            zzag2.zze("Failed to resolve own package : %s", objectArray);
            return Collections.emptyList();
        }
    }

    static {
        zzag zzag2;
        zza = zzag2 = new zzag("MissingSplitsAppComponentsHelper");
    }

    zza(Context context, PackageManager packageManager) {
        this.zzb = context;
        this.zzc = packageManager;
    }

    final void zza() {
        zza.zzd("Disabling all non-activity components", new Object[0]);
        this.zze(this.zzd(), 2);
    }

    final void zzb() {
        zza.zzd("Resetting enabled state of all non-activity components", new Object[0]);
        this.zze(this.zzd(), 0);
    }

    private final void zze(List object, int n) {
        object = object.iterator();
        while (object.hasNext()) {
            ComponentInfo componentInfo = (ComponentInfo)object.next();
            PackageManager packageManager = this.zzc;
            ComponentName componentName = new ComponentName(componentInfo.packageName, componentInfo.name);
            packageManager.setComponentEnabledSetting(componentName, n, 1);
        }
    }

    final boolean zzc() {
        for (ComponentInfo componentInfo : this.zzd()) {
            PackageManager packageManager = this.zzc;
            ComponentName componentName = new ComponentName(componentInfo.packageName, componentInfo.name);
            if (packageManager.getComponentEnabledSetting(componentName) == 2) continue;
            zza.zza("Not all non-activity components are disabled", new Object[0]);
            return false;
        }
        zza.zza("All non-activity components are disabled", new Object[0]);
        return true;
    }
}

