/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.splitcompat;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.play.core.internal.zzci;
import com.google.android.play.core.splitcompat.zzb;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class zze {
    private final long zza;
    private final Context zzb;
    private File zzc;

    private static File zzq(File serializable, String string) throws IOException {
        File file = new File((File)serializable, string);
        if (!file.getCanonicalPath().startsWith(serializable.getCanonicalPath())) {
            serializable = new IllegalArgumentException("split ID cannot be placed in target directory");
            throw serializable;
        }
        return file;
    }

    private final File zzr() throws IOException {
        File file = new File(this.zzw(), "native-libraries");
        zze.zzu(file);
        return file;
    }

    private final File zzs(String string) throws IOException {
        File file = zze.zzq(((zze)((Object)file)).zzr(), string);
        zze.zzu(file);
        return file;
    }

    public final File zza(String string) throws IOException {
        File file = new File(((zze)((Object)file2)).zzw(), "dex");
        zze.zzu(file);
        File file2 = zze.zzq(file, string);
        zze.zzu(file2);
        return file2;
    }

    public final File zzb() throws IOException {
        File file = new File(this.zzw(), "unverified-splits");
        zze.zzu(file);
        return file;
    }

    private final File zzt() throws IOException {
        File file = new File(this.zzw(), "verified-splits");
        zze.zzu(file);
        return file;
    }

    public final File zzc(String string, String string2) throws IOException {
        return zze.zzq(this.zzs(string), string2);
    }

    public final File zzd() throws IOException {
        File file = new File(this.zzw(), "lock.tmp");
        return file;
    }

    public final File zze(String string) throws IOException {
        return zze.zzq(this.zzb(), zze.zzx(string));
    }

    public final File zzf(File file) throws IOException {
        return zze.zzq(this.zzt(), file.getName());
    }

    public final File zzg(String string) throws IOException {
        return zze.zzq(this.zzt(), zze.zzx(string));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static File zzu(File object) throws IOException {
        if (((File)object).exists()) {
            if (((File)object).isDirectory()) {
                return object;
            }
        } else {
            ((File)object).mkdirs();
            if (((File)object).isDirectory()) {
                return object;
            }
            object = String.valueOf(((File)object).getAbsolutePath());
            String string = "Unable to create directory: ";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            IOException iOException = new IOException((String)object);
            throw iOException;
        }
        object = new IllegalArgumentException("File input must be directory when it exists.");
        throw object;
    }

    private final File zzv() throws IOException {
        File file;
        if (((zze)object).zzc == null) {
            file = ((zze)object).zzb;
            if (file == null) {
                Object object = new IllegalStateException("context must be non-null to populate null filesDir");
                throw object;
            }
            ((zze)object).zzc = file.getFilesDir();
        }
        file = new File(((zze)object).zzc, "splitcompat");
        zze.zzu(file);
        return file;
    }

    private final File zzw() throws IOException {
        File file = new File(this.zzv(), Long.toString(this.zza));
        zze.zzu(file);
        return file;
    }

    private static String zzx(String string) {
        return String.valueOf(string).concat(".apk");
    }

    final List zzh() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = this.zzr().listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                arrayList.add(file.getName());
            }
        }
        return arrayList;
    }

    final Set zzi(String fileArray) throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        if ((fileArray = this.zzs((String)fileArray).listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.isFile()) continue;
                hashSet.add(file);
            }
        }
        return hashSet;
    }

    final Set zzj() throws IOException {
        File file = ((zze)((Object)file)).zzt();
        HashSet<zzb> hashSet = new HashSet<zzb>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isFile() || !file2.getName().endsWith(".apk") || !zze.zzp(file2)) continue;
                String string = file2.getName();
                int n = string.length();
                string = string.substring(0, n + -4);
                zzb zzb2 = new zzb(file2, string);
                hashSet.add(zzb2);
            }
        }
        return hashSet;
    }

    public zze(Context context) throws PackageManager.NameNotFoundException {
        this.zzb = context;
        this.zza = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
    }

    public final void zzk() throws IOException {
        File file = this.zzv();
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string.equals(Long.toString(this.zza))) continue;
                File file2 = new File(file, string);
                string = ((Object)file2).toString();
                long l = this.zza;
                StringBuilder stringBuilder = new StringBuilder(string.length() + 118);
                stringBuilder.append("FileStorage: removing directory for different version code (directory = ");
                stringBuilder.append(string);
                stringBuilder.append(", current version code = ");
                stringBuilder.append(l);
                stringBuilder.append(")");
                Log.d((String)"SplitCompat", (String)stringBuilder.toString());
                zze.zzl(file2);
            }
        }
    }

    public static void zzl(File file) throws IOException {
        Object[] objectArray;
        if (file.isDirectory() && (objectArray = file.listFiles()) != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                zze.zzl((File)objectArray[i]);
            }
        }
        if (file.exists() && !file.delete()) {
            objectArray = new Object[]{file.getAbsolutePath()};
            IOException iOException = new IOException(String.format("Failed to delete '%s'", objectArray));
            throw iOException;
        }
    }

    public static void zzm(File file) {
        file.setWritable(false, true);
        file.setWritable(false, false);
    }

    final void zzn(String string) throws IOException {
        zze.zzl(this.zzs(string));
    }

    final void zzo(File file) throws IOException {
        zzci.zzb(file.getParentFile().getParentFile().equals(this.zzr()), "File to remove is not a native library");
        zze.zzl(file);
    }

    public static boolean zzp(File file) {
        return !file.canWrite();
    }
}

