/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.splitinstall;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.play.core.internal.zzag;
import com.google.android.play.core.splitinstall.zzbg;
import com.google.android.play.core.splitinstall.zzi;
import com.google.android.play.core.splitinstall.zzk;
import com.google.android.play.core.splitinstall.zzr;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;

public final class zzs {
    private static final zzag zza;
    private final Context zzb;
    private final String zzc;

    @Nullable
    private final Bundle zzg() {
        block2: {
            try {
                zzs zzs2 = zzs2.zzb.getPackageManager().getApplicationInfo(zzs2.zzc, 128);
                if (zzs2 != null && ((ApplicationInfo)zzs2).metaData != null) break block2;
                zza.zza("App has no applicationInfo or metaData", new Object[0]);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                zza.zze("App is not found in PackageManager", new Object[0]);
                return null;
            }
            return null;
        }
        return ((ApplicationInfo)zzs2).metaData;
    }

    @Nullable
    public final zzk zza() {
        zzi zzi2;
        Object object;
        Bundle bundle = ((zzs)object).zzg();
        if (bundle == null) {
            zza.zze("No metadata found in Context.", new Object[0]);
            return null;
        }
        int n = bundle.getInt("com.android.vending.splits");
        if (n == 0) {
            zza.zze("No metadata found in AndroidManifest.", new Object[0]);
            return null;
        }
        try {
            object = ((zzs)object).zzb.getResources().getXml(n);
            zzi2 = new zzi();
        }
        catch (Resources.NotFoundException notFoundException) {
            zza.zze("Resource with languages metadata doesn't exist.", new Object[0]);
            return null;
        }
        object = zzbg.zza((XmlPullParser)object, zzi2);
        if (object == null) {
            zza.zze("Can't parse languages metadata.", new Object[0]);
        }
        return object;
    }

    public static String zzb(String string) {
        if (string.startsWith("config.")) {
            return "";
        }
        return string.split("\\.config\\.", 2)[0];
    }

    public final Set zzc() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : ((zzs)this).zzh()) {
            if (zzs.zzf(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Set zzh() {
        Object object;
        HashSet hashSet = new HashSet();
        Object object2 = ((zzs)object).zzg();
        if (object2 != null) {
            if ((object2 = object2.getString("com.android.dynamic.apk.fused.modules")) == null || ((String)object2).isEmpty()) {
                zza.zza("App has no fused modules.", new Object[0]);
            } else {
                Collections.addAll(hashSet, ((String)object2).split(",", -1));
                hashSet.remove("");
                hashSet.remove("base");
            }
        }
        if (Build.VERSION.SDK_INT < 21) {
            return hashSet;
        }
        try {
            object = ((zzs)object).zzb.getPackageManager().getPackageInfo(((zzs)object).zzc, 0);
            object = object != null ? ((PackageInfo)object).splitNames : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.zze("App is not found in PackageManager", new Object[0]);
            object = null;
        }
        if (object != null) {
            object2 = zza;
            Object[] objectArray = new Object[]{Arrays.toString((Object[])object)};
            ((zzag)object2).zza("Adding splits from package manager: %s", objectArray);
            Collections.addAll(hashSet, object);
        } else {
            zza.zza("No splits are found or app cannot be found in package manager.", new Object[0]);
        }
        if ((object = zzr.zza()) != null) {
            hashSet.addAll(object.zza());
        }
        return hashSet;
    }

    @Nullable
    public final Set zzd() {
        Map.Entry entry2 = ((zzs)((Object)iterator)).zza();
        if (entry2 == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = ((zzs)((Object)iterator)).zzh();
        set.add("");
        Iterator iterator = ((zzs)((Object)iterator)).zzc();
        iterator.add("");
        for (Map.Entry entry2 : ((zzk)((Object)entry2)).zza((Collection)((Object)iterator)).entrySet()) {
            if (!set.containsAll((Collection)entry2.getValue())) continue;
            hashSet.add((String)entry2.getKey());
        }
        return hashSet;
    }

    static {
        zzag zzag2;
        zza = zzag2 = new zzag("SplitInstallInfoProvider");
    }

    zzs(Context context) {
        this.zzb = context;
        this.zzc = context.getPackageName();
    }

    public zzs(Context context, String string) {
        this.zzb = context;
        this.zzc = string;
    }

    public static boolean zze(String string) {
        return string.startsWith("config.");
    }

    public static boolean zzf(String string) {
        return string.startsWith("config.") || string.contains(".config.");
    }
}

