/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.tasks;

import androidx.annotation.NonNull;
import com.google.android.play.core.internal.zzci;
import com.google.android.play.core.tasks.Task;
import com.google.android.play.core.tasks.TaskExecutors;
import com.google.android.play.core.tasks.zzm;
import com.google.android.play.core.tasks.zzo;
import com.google.android.play.core.tasks.zzp;
import com.google.android.play.core.tasks.zzq;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static Task<Void> whenAll(Collection<? extends Task<?>> tasks) {
        Iterator iterator;
        if (tasks.isEmpty()) {
            return Tasks.zzb(null);
        }
        zzm<Void> zzm2 = iterator.iterator();
        while (zzm2.hasNext()) {
            if (zzm2.next() != null) continue;
            iterator = new Iterator("null tasks are not accepted");
            throw iterator;
        }
        zzm2 = new zzm<Void>();
        zzq zzq2 = new zzq(iterator.size(), zzm2);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Tasks.zzd((Task)iterator.next(), zzq2);
        }
        return zzm2;
    }

    public static <ResultT> ResultT await(@NonNull Task<ResultT> task) throws ExecutionException, InterruptedException {
        Task<ResultT> task2;
        zzci.zza(task, "Task must not be null");
        if (task2.isComplete()) {
            return (ResultT)Tasks.zzc(task2);
        }
        zzo zzo2 = new zzo(null);
        Tasks.zzd(task2, zzo2);
        zzo2.zza();
        return (ResultT)Tasks.zzc(task2);
    }

    /*
     * WARNING - void declaration
     */
    public static <ResultT> ResultT await(@NonNull Task<ResultT> task, long timeout, @NonNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        void var1_1;
        Object object;
        void var3_2;
        zzci.zza(task, "Task must not be null");
        zzci.zza(var3_2, "TimeUnit must not be null");
        if (((Task)object).isComplete()) {
            return (ResultT)Tasks.zzc(object);
        }
        zzo zzo2 = new zzo(null);
        Tasks.zzd(object, zzo2);
        if (!zzo2.zzb((long)var1_1, (TimeUnit)var3_2)) {
            object = new TimeoutException("Timed out waiting for Task");
            throw object;
        }
        return (ResultT)Tasks.zzc(object);
    }

    private Tasks() {
    }

    public static Task zza(Exception exception) {
        zzm zzm2 = new zzm();
        zzm2.zza(exception);
        return zzm2;
    }

    public static Task zzb(Object object) {
        zzm zzm2 = new zzm();
        zzm2.zzb(object);
        return zzm2;
    }

    private static Object zzc(Task task) throws ExecutionException {
        if (!task.isSuccessful()) {
            ExecutionException executionException = new ExecutionException(task.getException());
            throw executionException;
        }
        return task.getResult();
    }

    private static void zzd(Task task, zzp zzp2) {
        task.addOnSuccessListener(TaskExecutors.zza, zzp2);
        task.addOnFailureListener(TaskExecutors.zza, zzp2);
    }
}

