/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.consent_sdk;

import android.app.Application;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import com.google.android.gms.internal.consent_sdk.zzaj;
import com.google.android.gms.internal.consent_sdk.zzat;
import com.google.android.gms.internal.consent_sdk.zzbh;
import com.google.android.gms.internal.consent_sdk.zzbl;
import com.google.android.gms.internal.consent_sdk.zzbm;
import com.google.android.gms.internal.consent_sdk.zzca;
import com.google.android.gms.internal.consent_sdk.zze;
import com.google.android.gms.internal.consent_sdk.zzi;
import com.google.android.gms.internal.consent_sdk.zzk;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

final class zzbj
implements zzi {
    private final Application zza;
    private final zzbh zzb;
    private final Handler zzc;
    private final Executor zzd;
    private final zze zze;
    private final zzaj zzf;
    private final zzat zzg;

    zzbj(Application application, zzbh zzbh2, Handler handler, Executor executor, zze zze2, zzaj zzaj2, zzat zzat2) {
        this.zza = application;
        this.zzb = zzbh2;
        this.zzc = handler;
        this.zzd = executor;
        this.zze = zze2;
        this.zzf = zzaj2;
        this.zzg = zzat2;
    }

    final void zza(int n, String string, String string2) {
        this.zzg.zza(new zzk(2, String.format(Locale.US, "WebResourceError(%d, %s): %s", n, string2, string)));
    }

    final void zza(String string) {
        String string2 = String.valueOf(string);
        String string3 = string2.length() != 0 ? "Receive consent action: ".concat(string2) : new String("Receive consent action: ");
        Log.d((String)"UserMessagingPlatform", (String)string3);
        Uri uri = Uri.parse((String)string);
        String string4 = uri.getQueryParameter("action");
        String string5 = uri.getQueryParameter("args");
        this.zze.zza(string4, string5, this, this.zzf);
    }

    @Override
    public final Executor zza() {
        Handler handler = this.zzc;
        handler.getClass();
        return zzbm.zza(handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @UiThread
    public final boolean zza(String string, JSONObject jSONObject) {
        switch (string) {
            case "load_complete": {
                this.zzg.zzb();
                return true;
            }
            case "dismiss": {
                int n;
                JSONObject jSONObject2 = jSONObject;
                zzbj zzbj2 = this;
                switch (jSONObject2.optString("status")) {
                    case "personalized": 
                    case "CONSENT_SIGNAL_PERSONALIZED_ADS": {
                        n = 2;
                        break;
                    }
                    case "non_personalized": 
                    case "CONSENT_SIGNAL_NON_PERSONALIZED_ADS": {
                        n = 1;
                        break;
                    }
                    case "CONSENT_SIGNAL_SUFFICIENT": {
                        n = 0;
                        break;
                    }
                    default: {
                        zzbj2.zzg.zzb(new zzk(1, "We are getting something wrong with the webview."));
                        return true;
                    }
                }
                zzbj2.zzg.zza(3, n);
                return true;
            }
            case "browser": {
                Uri uri;
                String string2;
                JSONObject jSONObject3 = jSONObject;
                zzbj zzbj3 = this;
                String string3 = jSONObject3.optString("url");
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string2 = "Action[browser]: empty url.";
                    Log.d((String)"UserMessagingPlatform", (String)string2);
                }
                if ((uri = Uri.parse((String)string3)).getScheme() == null) {
                    String string4 = String.valueOf(string3);
                    string2 = string4.length() != 0 ? "Action[browser]: empty scheme: ".concat(string4) : new String("Action[browser]: empty scheme: ");
                    Log.d((String)"UserMessagingPlatform", (String)string2);
                }
                try {
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    zzbj3.zzb.startActivity(intent);
                    return true;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    String string5 = String.valueOf(string3);
                    zzca.zza(string5.length() != 0 ? "Action[browser]: can not open url: ".concat(string5) : new String("Action[browser]: can not open url: "), activityNotFoundException);
                }
                return true;
            }
            case "configure_app_assets": {
                zzbj zzbj4 = this;
                zzbj4.zzd.execute(new zzbl(zzbj4));
                return true;
            }
        }
        return false;
    }

    @WorkerThread
    private static JSONObject zza(Context context) {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            jSONObject.put("app_name", (Object)context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString());
            Context context2 = context;
            Drawable drawable = context2.getPackageManager().getApplicationIcon(context2.getApplicationInfo());
            if (drawable == null) {
                string = null;
            } else {
                Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                String string2 = String.valueOf(Base64.encodeToString((byte[])byArray, (int)0));
                string = string2.length() != 0 ? "data:image/png;base64,".concat(string2) : new String("data:image/png;base64,");
            }
            jSONObject.put("app_icon", string);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    final /* synthetic */ void zzb() {
        JSONObject jSONObject = zzbj.zza((Context)this.zza);
        this.zzg.zza().zza("UMP_configureFormWithAppAssets", jSONObject);
    }
}

