/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodOverride
implements HttpExecuteInterceptor,
HttpRequestInitializer {
    private final EnumSet<HttpMethod> override;

    public MethodOverride() {
        this.override = EnumSet.noneOf(HttpMethod.class);
    }

    public MethodOverride(EnumSet<HttpMethod> override) {
        this.override = override.clone();
    }

    public void initialize(HttpRequest request) {
        request.setInterceptor((HttpExecuteInterceptor)this);
    }

    public void intercept(HttpRequest request) {
        if (this.overrideThisMethod(request)) {
            HttpMethod method = request.getMethod();
            request.setMethod(HttpMethod.POST);
            request.getHeaders().set("X-HTTP-Method-Override", (Object)method.name());
            request.setAllowEmptyContent(false);
        }
    }

    private boolean overrideThisMethod(HttpRequest request) {
        HttpMethod method = request.getMethod();
        if (method != HttpMethod.GET && method != HttpMethod.POST && this.override.contains(method)) {
            return true;
        }
        switch (method) {
            case PATCH: {
                return !request.getTransport().supportsPatch();
            }
            case HEAD: {
                return !request.getTransport().supportsHead();
            }
        }
        return false;
    }
}

