package com.google.api.gax.grpc;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ChannelPoolSettings extends ChannelPoolSettings {

  private final int minRpcsPerChannel;

  private final int maxRpcsPerChannel;

  private final int minChannelCount;

  private final int maxChannelCount;

  private final int initialChannelCount;

  private final boolean preemptiveRefreshEnabled;

  private AutoValue_ChannelPoolSettings(
      int minRpcsPerChannel,
      int maxRpcsPerChannel,
      int minChannelCount,
      int maxChannelCount,
      int initialChannelCount,
      boolean preemptiveRefreshEnabled) {
    this.minRpcsPerChannel = minRpcsPerChannel;
    this.maxRpcsPerChannel = maxRpcsPerChannel;
    this.minChannelCount = minChannelCount;
    this.maxChannelCount = maxChannelCount;
    this.initialChannelCount = initialChannelCount;
    this.preemptiveRefreshEnabled = preemptiveRefreshEnabled;
  }

  @Override
  public int getMinRpcsPerChannel() {
    return minRpcsPerChannel;
  }

  @Override
  public int getMaxRpcsPerChannel() {
    return maxRpcsPerChannel;
  }

  @Override
  public int getMinChannelCount() {
    return minChannelCount;
  }

  @Override
  public int getMaxChannelCount() {
    return maxChannelCount;
  }

  @Override
  public int getInitialChannelCount() {
    return initialChannelCount;
  }

  @Override
  public boolean isPreemptiveRefreshEnabled() {
    return preemptiveRefreshEnabled;
  }

  @Override
  public String toString() {
    return "ChannelPoolSettings{"
        + "minRpcsPerChannel=" + minRpcsPerChannel + ", "
        + "maxRpcsPerChannel=" + maxRpcsPerChannel + ", "
        + "minChannelCount=" + minChannelCount + ", "
        + "maxChannelCount=" + maxChannelCount + ", "
        + "initialChannelCount=" + initialChannelCount + ", "
        + "preemptiveRefreshEnabled=" + preemptiveRefreshEnabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ChannelPoolSettings) {
      ChannelPoolSettings that = (ChannelPoolSettings) o;
      return this.minRpcsPerChannel == that.getMinRpcsPerChannel()
          && this.maxRpcsPerChannel == that.getMaxRpcsPerChannel()
          && this.minChannelCount == that.getMinChannelCount()
          && this.maxChannelCount == that.getMaxChannelCount()
          && this.initialChannelCount == that.getInitialChannelCount()
          && this.preemptiveRefreshEnabled == that.isPreemptiveRefreshEnabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= minRpcsPerChannel;
    h$ *= 1000003;
    h$ ^= maxRpcsPerChannel;
    h$ *= 1000003;
    h$ ^= minChannelCount;
    h$ *= 1000003;
    h$ ^= maxChannelCount;
    h$ *= 1000003;
    h$ ^= initialChannelCount;
    h$ *= 1000003;
    h$ ^= preemptiveRefreshEnabled ? 1231 : 1237;
    return h$;
  }

  @Override
  public ChannelPoolSettings.Builder toBuilder() {
    return new AutoValue_ChannelPoolSettings.Builder(this);
  }

  static final class Builder extends ChannelPoolSettings.Builder {
    private int minRpcsPerChannel;
    private int maxRpcsPerChannel;
    private int minChannelCount;
    private int maxChannelCount;
    private int initialChannelCount;
    private boolean preemptiveRefreshEnabled;
    private byte set$0;
    Builder() {
    }
    Builder(ChannelPoolSettings source) {
      this.minRpcsPerChannel = source.getMinRpcsPerChannel();
      this.maxRpcsPerChannel = source.getMaxRpcsPerChannel();
      this.minChannelCount = source.getMinChannelCount();
      this.maxChannelCount = source.getMaxChannelCount();
      this.initialChannelCount = source.getInitialChannelCount();
      this.preemptiveRefreshEnabled = source.isPreemptiveRefreshEnabled();
      set$0 = (byte) 0x3f;
    }
    @Override
    public ChannelPoolSettings.Builder setMinRpcsPerChannel(int minRpcsPerChannel) {
      this.minRpcsPerChannel = minRpcsPerChannel;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public ChannelPoolSettings.Builder setMaxRpcsPerChannel(int maxRpcsPerChannel) {
      this.maxRpcsPerChannel = maxRpcsPerChannel;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public ChannelPoolSettings.Builder setMinChannelCount(int minChannelCount) {
      this.minChannelCount = minChannelCount;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public ChannelPoolSettings.Builder setMaxChannelCount(int maxChannelCount) {
      this.maxChannelCount = maxChannelCount;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public ChannelPoolSettings.Builder setInitialChannelCount(int initialChannelCount) {
      this.initialChannelCount = initialChannelCount;
      set$0 |= (byte) 0x10;
      return this;
    }
    @Override
    public ChannelPoolSettings.Builder setPreemptiveRefreshEnabled(boolean preemptiveRefreshEnabled) {
      this.preemptiveRefreshEnabled = preemptiveRefreshEnabled;
      set$0 |= (byte) 0x20;
      return this;
    }
    @Override
    ChannelPoolSettings autoBuild() {
      if (set$0 != 0x3f) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" minRpcsPerChannel");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" maxRpcsPerChannel");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" minChannelCount");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" maxChannelCount");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" initialChannelCount");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" preemptiveRefreshEnabled");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ChannelPoolSettings(
          this.minRpcsPerChannel,
          this.maxRpcsPerChannel,
          this.minChannelCount,
          this.maxChannelCount,
          this.initialChannelCount,
          this.preemptiveRefreshEnabled);
    }
  }

}
