package com.google.api.gax.httpjson;

import com.google.auth.Credentials;
import com.google.protobuf.TypeRegistry;
import java.time.Duration;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_HttpJsonCallOptions extends HttpJsonCallOptions {

  @Nullable
  private final Duration timeout;

  @Nullable
  private final Instant deadline;

  @Nullable
  private final Credentials credentials;

  @Nullable
  private final TypeRegistry typeRegistry;

  private AutoValue_HttpJsonCallOptions(
      @Nullable Duration timeout,
      @Nullable Instant deadline,
      @Nullable Credentials credentials,
      @Nullable TypeRegistry typeRegistry) {
    this.timeout = timeout;
    this.deadline = deadline;
    this.credentials = credentials;
    this.typeRegistry = typeRegistry;
  }

  @Nullable
  @Override
  public Duration getTimeout() {
    return timeout;
  }

  @Nullable
  @Override
  public Instant getDeadline() {
    return deadline;
  }

  @Nullable
  @Override
  public Credentials getCredentials() {
    return credentials;
  }

  @Nullable
  @Override
  public TypeRegistry getTypeRegistry() {
    return typeRegistry;
  }

  @Override
  public String toString() {
    return "HttpJsonCallOptions{"
        + "timeout=" + timeout + ", "
        + "deadline=" + deadline + ", "
        + "credentials=" + credentials + ", "
        + "typeRegistry=" + typeRegistry
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof HttpJsonCallOptions) {
      HttpJsonCallOptions that = (HttpJsonCallOptions) o;
      return (this.timeout == null ? that.getTimeout() == null : this.timeout.equals(that.getTimeout()))
          && (this.deadline == null ? that.getDeadline() == null : this.deadline.equals(that.getDeadline()))
          && (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials()))
          && (this.typeRegistry == null ? that.getTypeRegistry() == null : this.typeRegistry.equals(that.getTypeRegistry()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (timeout == null) ? 0 : timeout.hashCode();
    h$ *= 1000003;
    h$ ^= (deadline == null) ? 0 : deadline.hashCode();
    h$ *= 1000003;
    h$ ^= (credentials == null) ? 0 : credentials.hashCode();
    h$ *= 1000003;
    h$ ^= (typeRegistry == null) ? 0 : typeRegistry.hashCode();
    return h$;
  }

  @Override
  public HttpJsonCallOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends HttpJsonCallOptions.Builder {
    private Duration timeout;
    private Instant deadline;
    private Credentials credentials;
    private TypeRegistry typeRegistry;
    Builder() {
    }
    private Builder(HttpJsonCallOptions source) {
      this.timeout = source.getTimeout();
      this.deadline = source.getDeadline();
      this.credentials = source.getCredentials();
      this.typeRegistry = source.getTypeRegistry();
    }
    @Override
    public HttpJsonCallOptions.Builder setTimeout(Duration timeout) {
      this.timeout = timeout;
      return this;
    }
    @Override
    public HttpJsonCallOptions.Builder setDeadline(Instant deadline) {
      this.deadline = deadline;
      return this;
    }
    @Override
    public HttpJsonCallOptions.Builder setCredentials(Credentials credentials) {
      this.credentials = credentials;
      return this;
    }
    @Override
    public HttpJsonCallOptions.Builder setTypeRegistry(TypeRegistry typeRegistry) {
      this.typeRegistry = typeRegistry;
      return this;
    }
    @Override
    public HttpJsonCallOptions build() {
      return new AutoValue_HttpJsonCallOptions(
          this.timeout,
          this.deadline,
          this.credentials,
          this.typeRegistry);
    }
  }

}
