/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching.v2;

import com.google.api.gax.batching.v2.BatchingSettings;

final class AutoValue_BatchingSettings
extends BatchingSettings {
    private final int elementCountThreshold;
    private final long requestByteThreshold;

    private AutoValue_BatchingSettings(int elementCountThreshold, long requestByteThreshold) {
        this.elementCountThreshold = elementCountThreshold;
        this.requestByteThreshold = requestByteThreshold;
    }

    @Override
    public int getElementCountThreshold() {
        return this.elementCountThreshold;
    }

    @Override
    public long getRequestByteThreshold() {
        return this.requestByteThreshold;
    }

    public String toString() {
        return "BatchingSettings{elementCountThreshold=" + this.elementCountThreshold + ", requestByteThreshold=" + this.requestByteThreshold + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BatchingSettings) {
            BatchingSettings that = (BatchingSettings)o;
            return this.elementCountThreshold == that.getElementCountThreshold() && this.requestByteThreshold == that.getRequestByteThreshold();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.elementCountThreshold;
        h *= 1000003;
        h = (int)((long)h ^ (this.requestByteThreshold >>> 32 ^ this.requestByteThreshold));
        return h;
    }

    @Override
    public BatchingSettings.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BatchingSettings.Builder {
        private Integer elementCountThreshold;
        private Long requestByteThreshold;

        Builder() {
        }

        private Builder(BatchingSettings source) {
            this.elementCountThreshold = source.getElementCountThreshold();
            this.requestByteThreshold = source.getRequestByteThreshold();
        }

        @Override
        public BatchingSettings.Builder setElementCountThreshold(int elementCountThreshold) {
            this.elementCountThreshold = elementCountThreshold;
            return this;
        }

        @Override
        public BatchingSettings.Builder setRequestByteThreshold(long requestByteThreshold) {
            this.requestByteThreshold = requestByteThreshold;
            return this;
        }

        @Override
        BatchingSettings autoBuild() {
            String missing = "";
            if (this.elementCountThreshold == null) {
                missing = missing + " elementCountThreshold";
            }
            if (this.requestByteThreshold == null) {
                missing = missing + " requestByteThreshold";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BatchingSettings(this.elementCountThreshold, this.requestByteThreshold);
        }
    }
}

