package com.google.api.gax.retrying;

import javax.annotation.Generated;
import org.threeten.bp.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TimedAttemptSettings extends TimedAttemptSettings {

  private final RetrySettings globalSettings;

  private final Duration retryDelay;

  private final Duration rpcTimeout;

  private final Duration randomizedRetryDelay;

  private final int attemptCount;

  private final int overallAttemptCount;

  private final long firstAttemptStartTimeNanos;

  private AutoValue_TimedAttemptSettings(
      RetrySettings globalSettings,
      Duration retryDelay,
      Duration rpcTimeout,
      Duration randomizedRetryDelay,
      int attemptCount,
      int overallAttemptCount,
      long firstAttemptStartTimeNanos) {
    this.globalSettings = globalSettings;
    this.retryDelay = retryDelay;
    this.rpcTimeout = rpcTimeout;
    this.randomizedRetryDelay = randomizedRetryDelay;
    this.attemptCount = attemptCount;
    this.overallAttemptCount = overallAttemptCount;
    this.firstAttemptStartTimeNanos = firstAttemptStartTimeNanos;
  }

  @Override
  public RetrySettings getGlobalSettings() {
    return globalSettings;
  }

  @Override
  public Duration getRetryDelay() {
    return retryDelay;
  }

  @Override
  public Duration getRpcTimeout() {
    return rpcTimeout;
  }

  @Override
  public Duration getRandomizedRetryDelay() {
    return randomizedRetryDelay;
  }

  @Override
  public int getAttemptCount() {
    return attemptCount;
  }

  @Override
  public int getOverallAttemptCount() {
    return overallAttemptCount;
  }

  @Override
  public long getFirstAttemptStartTimeNanos() {
    return firstAttemptStartTimeNanos;
  }

  @Override
  public String toString() {
    return "TimedAttemptSettings{"
        + "globalSettings=" + globalSettings + ", "
        + "retryDelay=" + retryDelay + ", "
        + "rpcTimeout=" + rpcTimeout + ", "
        + "randomizedRetryDelay=" + randomizedRetryDelay + ", "
        + "attemptCount=" + attemptCount + ", "
        + "overallAttemptCount=" + overallAttemptCount + ", "
        + "firstAttemptStartTimeNanos=" + firstAttemptStartTimeNanos
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TimedAttemptSettings) {
      TimedAttemptSettings that = (TimedAttemptSettings) o;
      return this.globalSettings.equals(that.getGlobalSettings())
          && this.retryDelay.equals(that.getRetryDelay())
          && this.rpcTimeout.equals(that.getRpcTimeout())
          && this.randomizedRetryDelay.equals(that.getRandomizedRetryDelay())
          && this.attemptCount == that.getAttemptCount()
          && this.overallAttemptCount == that.getOverallAttemptCount()
          && this.firstAttemptStartTimeNanos == that.getFirstAttemptStartTimeNanos();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= globalSettings.hashCode();
    h$ *= 1000003;
    h$ ^= retryDelay.hashCode();
    h$ *= 1000003;
    h$ ^= rpcTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= randomizedRetryDelay.hashCode();
    h$ *= 1000003;
    h$ ^= attemptCount;
    h$ *= 1000003;
    h$ ^= overallAttemptCount;
    h$ *= 1000003;
    h$ ^= (int) ((firstAttemptStartTimeNanos >>> 32) ^ firstAttemptStartTimeNanos);
    return h$;
  }

  @Override
  public TimedAttemptSettings.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends TimedAttemptSettings.Builder {
    private RetrySettings globalSettings;
    private Duration retryDelay;
    private Duration rpcTimeout;
    private Duration randomizedRetryDelay;
    private int attemptCount;
    private int overallAttemptCount;
    private long firstAttemptStartTimeNanos;
    private byte set$0;
    Builder() {
    }
    private Builder(TimedAttemptSettings source) {
      this.globalSettings = source.getGlobalSettings();
      this.retryDelay = source.getRetryDelay();
      this.rpcTimeout = source.getRpcTimeout();
      this.randomizedRetryDelay = source.getRandomizedRetryDelay();
      this.attemptCount = source.getAttemptCount();
      this.overallAttemptCount = source.getOverallAttemptCount();
      this.firstAttemptStartTimeNanos = source.getFirstAttemptStartTimeNanos();
      set$0 = (byte) 7;
    }
    @Override
    public TimedAttemptSettings.Builder setGlobalSettings(RetrySettings globalSettings) {
      if (globalSettings == null) {
        throw new NullPointerException("Null globalSettings");
      }
      this.globalSettings = globalSettings;
      return this;
    }
    @Override
    public TimedAttemptSettings.Builder setRetryDelay(Duration retryDelay) {
      if (retryDelay == null) {
        throw new NullPointerException("Null retryDelay");
      }
      this.retryDelay = retryDelay;
      return this;
    }
    @Override
    public TimedAttemptSettings.Builder setRpcTimeout(Duration rpcTimeout) {
      if (rpcTimeout == null) {
        throw new NullPointerException("Null rpcTimeout");
      }
      this.rpcTimeout = rpcTimeout;
      return this;
    }
    @Override
    public TimedAttemptSettings.Builder setRandomizedRetryDelay(Duration randomizedRetryDelay) {
      if (randomizedRetryDelay == null) {
        throw new NullPointerException("Null randomizedRetryDelay");
      }
      this.randomizedRetryDelay = randomizedRetryDelay;
      return this;
    }
    @Override
    public TimedAttemptSettings.Builder setAttemptCount(int attemptCount) {
      this.attemptCount = attemptCount;
      set$0 |= 1;
      return this;
    }
    @Override
    public TimedAttemptSettings.Builder setOverallAttemptCount(int overallAttemptCount) {
      this.overallAttemptCount = overallAttemptCount;
      set$0 |= 2;
      return this;
    }
    @Override
    public TimedAttemptSettings.Builder setFirstAttemptStartTimeNanos(long firstAttemptStartTimeNanos) {
      this.firstAttemptStartTimeNanos = firstAttemptStartTimeNanos;
      set$0 |= 4;
      return this;
    }
    @Override
    public TimedAttemptSettings build() {
      if (set$0 != 7
          || this.globalSettings == null
          || this.retryDelay == null
          || this.rpcTimeout == null
          || this.randomizedRetryDelay == null) {
        StringBuilder missing = new StringBuilder();
        if (this.globalSettings == null) {
          missing.append(" globalSettings");
        }
        if (this.retryDelay == null) {
          missing.append(" retryDelay");
        }
        if (this.rpcTimeout == null) {
          missing.append(" rpcTimeout");
        }
        if (this.randomizedRetryDelay == null) {
          missing.append(" randomizedRetryDelay");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" attemptCount");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" overallAttemptCount");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" firstAttemptStartTimeNanos");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TimedAttemptSettings(
          this.globalSettings,
          this.retryDelay,
          this.rpcTimeout,
          this.randomizedRetryDelay,
          this.attemptCount,
          this.overallAttemptCount,
          this.firstAttemptStartTimeNanos);
    }
  }

}
