package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.auth.Credentials;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ClientContext extends ClientContext {

  private final List<BackgroundResource> backgroundResources;

  private final ScheduledExecutorService executor;

  @Nullable
  private final Credentials credentials;

  @Nullable
  private final TransportChannel transportChannel;

  private final Map<String, String> headers;

  private final Map<String, String> internalHeaders;

  private final ApiClock clock;

  private final ApiCallContext defaultCallContext;

  @Nullable
  private final Watchdog streamWatchdog;

  private final Duration streamWatchdogCheckInterval;

  @Nullable
  private final String endpoint;

  @Nullable
  private final String quotaProjectId;

  private final ApiTracerFactory tracerFactory;

  @Nullable
  private final String gdchApiAudience;

  private AutoValue_ClientContext(
      List<BackgroundResource> backgroundResources,
      ScheduledExecutorService executor,
      @Nullable Credentials credentials,
      @Nullable TransportChannel transportChannel,
      Map<String, String> headers,
      Map<String, String> internalHeaders,
      ApiClock clock,
      ApiCallContext defaultCallContext,
      @Nullable Watchdog streamWatchdog,
      Duration streamWatchdogCheckInterval,
      @Nullable String endpoint,
      @Nullable String quotaProjectId,
      ApiTracerFactory tracerFactory,
      @Nullable String gdchApiAudience) {
    this.backgroundResources = backgroundResources;
    this.executor = executor;
    this.credentials = credentials;
    this.transportChannel = transportChannel;
    this.headers = headers;
    this.internalHeaders = internalHeaders;
    this.clock = clock;
    this.defaultCallContext = defaultCallContext;
    this.streamWatchdog = streamWatchdog;
    this.streamWatchdogCheckInterval = streamWatchdogCheckInterval;
    this.endpoint = endpoint;
    this.quotaProjectId = quotaProjectId;
    this.tracerFactory = tracerFactory;
    this.gdchApiAudience = gdchApiAudience;
  }

  @Override
  public List<BackgroundResource> getBackgroundResources() {
    return backgroundResources;
  }

  @Override
  public ScheduledExecutorService getExecutor() {
    return executor;
  }

  @Nullable
  @Override
  public Credentials getCredentials() {
    return credentials;
  }

  @Nullable
  @Override
  public TransportChannel getTransportChannel() {
    return transportChannel;
  }

  @Override
  public Map<String, String> getHeaders() {
    return headers;
  }

  @Override
  protected Map<String, String> getInternalHeaders() {
    return internalHeaders;
  }

  @Override
  public ApiClock getClock() {
    return clock;
  }

  @Override
  public ApiCallContext getDefaultCallContext() {
    return defaultCallContext;
  }

  @Nullable
  @Override
  public Watchdog getStreamWatchdog() {
    return streamWatchdog;
  }

  @Nonnull
  @Override
  public Duration getStreamWatchdogCheckInterval() {
    return streamWatchdogCheckInterval;
  }

  @Nullable
  @Override
  public String getEndpoint() {
    return endpoint;
  }

  @Nullable
  @Override
  public String getQuotaProjectId() {
    return quotaProjectId;
  }

  @BetaApi("The surface for tracing is not stable yet and may change in the future.")
  @Nonnull
  @Override
  public ApiTracerFactory getTracerFactory() {
    return tracerFactory;
  }

  @Nullable
  @Override
  public String getGdchApiAudience() {
    return gdchApiAudience;
  }

  @Override
  public String toString() {
    return "ClientContext{"
        + "backgroundResources=" + backgroundResources + ", "
        + "executor=" + executor + ", "
        + "credentials=" + credentials + ", "
        + "transportChannel=" + transportChannel + ", "
        + "headers=" + headers + ", "
        + "internalHeaders=" + internalHeaders + ", "
        + "clock=" + clock + ", "
        + "defaultCallContext=" + defaultCallContext + ", "
        + "streamWatchdog=" + streamWatchdog + ", "
        + "streamWatchdogCheckInterval=" + streamWatchdogCheckInterval + ", "
        + "endpoint=" + endpoint + ", "
        + "quotaProjectId=" + quotaProjectId + ", "
        + "tracerFactory=" + tracerFactory + ", "
        + "gdchApiAudience=" + gdchApiAudience
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ClientContext) {
      ClientContext that = (ClientContext) o;
      return this.backgroundResources.equals(that.getBackgroundResources())
          && this.executor.equals(that.getExecutor())
          && (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials()))
          && (this.transportChannel == null ? that.getTransportChannel() == null : this.transportChannel.equals(that.getTransportChannel()))
          && this.headers.equals(that.getHeaders())
          && this.internalHeaders.equals(that.getInternalHeaders())
          && this.clock.equals(that.getClock())
          && this.defaultCallContext.equals(that.getDefaultCallContext())
          && (this.streamWatchdog == null ? that.getStreamWatchdog() == null : this.streamWatchdog.equals(that.getStreamWatchdog()))
          && this.streamWatchdogCheckInterval.equals(that.getStreamWatchdogCheckInterval())
          && (this.endpoint == null ? that.getEndpoint() == null : this.endpoint.equals(that.getEndpoint()))
          && (this.quotaProjectId == null ? that.getQuotaProjectId() == null : this.quotaProjectId.equals(that.getQuotaProjectId()))
          && this.tracerFactory.equals(that.getTracerFactory())
          && (this.gdchApiAudience == null ? that.getGdchApiAudience() == null : this.gdchApiAudience.equals(that.getGdchApiAudience()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= backgroundResources.hashCode();
    h$ *= 1000003;
    h$ ^= executor.hashCode();
    h$ *= 1000003;
    h$ ^= (credentials == null) ? 0 : credentials.hashCode();
    h$ *= 1000003;
    h$ ^= (transportChannel == null) ? 0 : transportChannel.hashCode();
    h$ *= 1000003;
    h$ ^= headers.hashCode();
    h$ *= 1000003;
    h$ ^= internalHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= clock.hashCode();
    h$ *= 1000003;
    h$ ^= defaultCallContext.hashCode();
    h$ *= 1000003;
    h$ ^= (streamWatchdog == null) ? 0 : streamWatchdog.hashCode();
    h$ *= 1000003;
    h$ ^= streamWatchdogCheckInterval.hashCode();
    h$ *= 1000003;
    h$ ^= (endpoint == null) ? 0 : endpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (quotaProjectId == null) ? 0 : quotaProjectId.hashCode();
    h$ *= 1000003;
    h$ ^= tracerFactory.hashCode();
    h$ *= 1000003;
    h$ ^= (gdchApiAudience == null) ? 0 : gdchApiAudience.hashCode();
    return h$;
  }

  @Override
  public ClientContext.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ClientContext.Builder {
    private List<BackgroundResource> backgroundResources;
    private ScheduledExecutorService executor;
    private Credentials credentials;
    private TransportChannel transportChannel;
    private Map<String, String> headers;
    private Map<String, String> internalHeaders;
    private ApiClock clock;
    private ApiCallContext defaultCallContext;
    private Watchdog streamWatchdog;
    private Duration streamWatchdogCheckInterval;
    private String endpoint;
    private String quotaProjectId;
    private ApiTracerFactory tracerFactory;
    private String gdchApiAudience;
    Builder() {
    }
    private Builder(ClientContext source) {
      this.backgroundResources = source.getBackgroundResources();
      this.executor = source.getExecutor();
      this.credentials = source.getCredentials();
      this.transportChannel = source.getTransportChannel();
      this.headers = source.getHeaders();
      this.internalHeaders = source.getInternalHeaders();
      this.clock = source.getClock();
      this.defaultCallContext = source.getDefaultCallContext();
      this.streamWatchdog = source.getStreamWatchdog();
      this.streamWatchdogCheckInterval = source.getStreamWatchdogCheckInterval();
      this.endpoint = source.getEndpoint();
      this.quotaProjectId = source.getQuotaProjectId();
      this.tracerFactory = source.getTracerFactory();
      this.gdchApiAudience = source.getGdchApiAudience();
    }
    @Override
    public ClientContext.Builder setBackgroundResources(List<BackgroundResource> backgroundResources) {
      if (backgroundResources == null) {
        throw new NullPointerException("Null backgroundResources");
      }
      this.backgroundResources = backgroundResources;
      return this;
    }
    @Override
    public ClientContext.Builder setExecutor(ScheduledExecutorService executor) {
      if (executor == null) {
        throw new NullPointerException("Null executor");
      }
      this.executor = executor;
      return this;
    }
    @Override
    public ClientContext.Builder setCredentials(Credentials credentials) {
      this.credentials = credentials;
      return this;
    }
    @Override
    public ClientContext.Builder setTransportChannel(TransportChannel transportChannel) {
      this.transportChannel = transportChannel;
      return this;
    }
    @Override
    public ClientContext.Builder setHeaders(Map<String, String> headers) {
      if (headers == null) {
        throw new NullPointerException("Null headers");
      }
      this.headers = headers;
      return this;
    }
    @Override
    protected ClientContext.Builder setInternalHeaders(Map<String, String> internalHeaders) {
      if (internalHeaders == null) {
        throw new NullPointerException("Null internalHeaders");
      }
      this.internalHeaders = internalHeaders;
      return this;
    }
    @Override
    public ClientContext.Builder setClock(ApiClock clock) {
      if (clock == null) {
        throw new NullPointerException("Null clock");
      }
      this.clock = clock;
      return this;
    }
    @Override
    public ClientContext.Builder setDefaultCallContext(ApiCallContext defaultCallContext) {
      if (defaultCallContext == null) {
        throw new NullPointerException("Null defaultCallContext");
      }
      this.defaultCallContext = defaultCallContext;
      return this;
    }
    @Override
    public ClientContext.Builder setStreamWatchdog(Watchdog streamWatchdog) {
      this.streamWatchdog = streamWatchdog;
      return this;
    }
    @Override
    public ClientContext.Builder setStreamWatchdogCheckInterval(Duration streamWatchdogCheckInterval) {
      if (streamWatchdogCheckInterval == null) {
        throw new NullPointerException("Null streamWatchdogCheckInterval");
      }
      this.streamWatchdogCheckInterval = streamWatchdogCheckInterval;
      return this;
    }
    @Override
    public ClientContext.Builder setEndpoint(String endpoint) {
      this.endpoint = endpoint;
      return this;
    }
    @Override
    public ClientContext.Builder setQuotaProjectId(String quotaProjectId) {
      this.quotaProjectId = quotaProjectId;
      return this;
    }
    @Override
    public ClientContext.Builder setTracerFactory(ApiTracerFactory tracerFactory) {
      if (tracerFactory == null) {
        throw new NullPointerException("Null tracerFactory");
      }
      this.tracerFactory = tracerFactory;
      return this;
    }
    @Override
    public ClientContext.Builder setGdchApiAudience(String gdchApiAudience) {
      this.gdchApiAudience = gdchApiAudience;
      return this;
    }
    @Override
    public ClientContext build() {
      if (this.backgroundResources == null
          || this.executor == null
          || this.headers == null
          || this.internalHeaders == null
          || this.clock == null
          || this.defaultCallContext == null
          || this.streamWatchdogCheckInterval == null
          || this.tracerFactory == null) {
        StringBuilder missing = new StringBuilder();
        if (this.backgroundResources == null) {
          missing.append(" backgroundResources");
        }
        if (this.executor == null) {
          missing.append(" executor");
        }
        if (this.headers == null) {
          missing.append(" headers");
        }
        if (this.internalHeaders == null) {
          missing.append(" internalHeaders");
        }
        if (this.clock == null) {
          missing.append(" clock");
        }
        if (this.defaultCallContext == null) {
          missing.append(" defaultCallContext");
        }
        if (this.streamWatchdogCheckInterval == null) {
          missing.append(" streamWatchdogCheckInterval");
        }
        if (this.tracerFactory == null) {
          missing.append(" tracerFactory");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ClientContext(
          this.backgroundResources,
          this.executor,
          this.credentials,
          this.transportChannel,
          this.headers,
          this.internalHeaders,
          this.clock,
          this.defaultCallContext,
          this.streamWatchdog,
          this.streamWatchdogCheckInterval,
          this.endpoint,
          this.quotaProjectId,
          this.tracerFactory,
          this.gdchApiAudience);
    }
  }

}
