/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RollupPropertySourceLinkName
implements ResourceName {
    private static final PathTemplate PROPERTY_ROLLUP_PROPERTY_SOURCE_LINK = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/rollupPropertySourceLinks/{rollup_property_source_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String rollupPropertySourceLink;

    @Deprecated
    protected RollupPropertySourceLinkName() {
        this.property = null;
        this.rollupPropertySourceLink = null;
    }

    private RollupPropertySourceLinkName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.rollupPropertySourceLink = (String)Preconditions.checkNotNull((Object)builder.getRollupPropertySourceLink());
    }

    public String getProperty() {
        return this.property;
    }

    public String getRollupPropertySourceLink() {
        return this.rollupPropertySourceLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RollupPropertySourceLinkName of(String property, String rollupPropertySourceLink) {
        return RollupPropertySourceLinkName.newBuilder().setProperty(property).setRollupPropertySourceLink(rollupPropertySourceLink).build();
    }

    public static String format(String property, String rollupPropertySourceLink) {
        return RollupPropertySourceLinkName.newBuilder().setProperty(property).setRollupPropertySourceLink(rollupPropertySourceLink).build().toString();
    }

    public static RollupPropertySourceLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_ROLLUP_PROPERTY_SOURCE_LINK.validatedMatch(formattedString, "RollupPropertySourceLinkName.parse: formattedString not in valid format");
        return RollupPropertySourceLinkName.of((String)matchMap.get("property"), (String)matchMap.get("rollup_property_source_link"));
    }

    public static List<RollupPropertySourceLinkName> parseList(List<String> formattedStrings) {
        ArrayList<RollupPropertySourceLinkName> list = new ArrayList<RollupPropertySourceLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RollupPropertySourceLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RollupPropertySourceLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RollupPropertySourceLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_ROLLUP_PROPERTY_SOURCE_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RollupPropertySourceLinkName rollupPropertySourceLinkName = this;
            synchronized (rollupPropertySourceLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.rollupPropertySourceLink != null) {
                        fieldMapBuilder.put((Object)"rollup_property_source_link", (Object)this.rollupPropertySourceLink);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_ROLLUP_PROPERTY_SOURCE_LINK.instantiate(new String[]{"property", this.property, "rollup_property_source_link", this.rollupPropertySourceLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RollupPropertySourceLinkName that = (RollupPropertySourceLinkName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.rollupPropertySourceLink, that.rollupPropertySourceLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.rollupPropertySourceLink);
    }

    public static class Builder {
        private String property;
        private String rollupPropertySourceLink;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getRollupPropertySourceLink() {
            return this.rollupPropertySourceLink;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setRollupPropertySourceLink(String rollupPropertySourceLink) {
            this.rollupPropertySourceLink = rollupPropertySourceLink;
            return this;
        }

        private Builder(RollupPropertySourceLinkName rollupPropertySourceLinkName) {
            this.property = rollupPropertySourceLinkName.property;
            this.rollupPropertySourceLink = rollupPropertySourceLinkName.rollupPropertySourceLink;
        }

        public RollupPropertySourceLinkName build() {
            return new RollupPropertySourceLinkName(this);
        }
    }
}

