/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model_garden_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

public interface DeployRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.DeployRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The Model Garden model to deploy.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * </pre>
   *
   * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the publisherModelName field is set.
   */
  boolean hasPublisherModelName();

  /**
   *
   *
   * <pre>
   * The Model Garden model to deploy.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * </pre>
   *
   * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The publisherModelName.
   */
  java.lang.String getPublisherModelName();

  /**
   *
   *
   * <pre>
   * The Model Garden model to deploy.
   * Format:
   * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
   * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
   * </pre>
   *
   * <code>string publisher_model_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for publisherModelName.
   */
  com.google.protobuf.ByteString getPublisherModelNameBytes();

  /**
   *
   *
   * <pre>
   * The Hugging Face model to deploy.
   * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
   * </pre>
   *
   * <code>string hugging_face_model_id = 2;</code>
   *
   * @return Whether the huggingFaceModelId field is set.
   */
  boolean hasHuggingFaceModelId();

  /**
   *
   *
   * <pre>
   * The Hugging Face model to deploy.
   * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
   * </pre>
   *
   * <code>string hugging_face_model_id = 2;</code>
   *
   * @return The huggingFaceModelId.
   */
  java.lang.String getHuggingFaceModelId();

  /**
   *
   *
   * <pre>
   * The Hugging Face model to deploy.
   * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
   * </pre>
   *
   * <code>string hugging_face_model_id = 2;</code>
   *
   * @return The bytes for huggingFaceModelId.
   */
  com.google.protobuf.ByteString getHuggingFaceModelIdBytes();

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to deploy the model in.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The destination.
   */
  java.lang.String getDestination();

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to deploy the model in.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for destination.
   */
  com.google.protobuf.ByteString getDestinationBytes();

  /**
   *
   *
   * <pre>
   * Optional. The model config to use for the deployment.
   * If not specified, the default model config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the modelConfig field is set.
   */
  boolean hasModelConfig();

  /**
   *
   *
   * <pre>
   * Optional. The model config to use for the deployment.
   * If not specified, the default model config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The modelConfig.
   */
  com.google.cloud.aiplatform.v1.DeployRequest.ModelConfig getModelConfig();

  /**
   *
   *
   * <pre>
   * Optional. The model config to use for the deployment.
   * If not specified, the default model config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1.DeployRequest.ModelConfigOrBuilder getModelConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The endpoint config to use for the deployment.
   * If not specified, the default endpoint config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the endpointConfig field is set.
   */
  boolean hasEndpointConfig();

  /**
   *
   *
   * <pre>
   * Optional. The endpoint config to use for the deployment.
   * If not specified, the default endpoint config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The endpointConfig.
   */
  com.google.cloud.aiplatform.v1.DeployRequest.EndpointConfig getEndpointConfig();

  /**
   *
   *
   * <pre>
   * Optional. The endpoint config to use for the deployment.
   * If not specified, the default endpoint config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1.DeployRequest.EndpointConfigOrBuilder getEndpointConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The deploy config to use for the deployment.
   * If not specified, the default deploy config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deployConfig field is set.
   */
  boolean hasDeployConfig();

  /**
   *
   *
   * <pre>
   * Optional. The deploy config to use for the deployment.
   * If not specified, the default deploy config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deployConfig.
   */
  com.google.cloud.aiplatform.v1.DeployRequest.DeployConfig getDeployConfig();

  /**
   *
   *
   * <pre>
   * Optional. The deploy config to use for the deployment.
   * If not specified, the default deploy config will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1.DeployRequest.DeployConfigOrBuilder getDeployConfigOrBuilder();

  com.google.cloud.aiplatform.v1.DeployRequest.ArtifactsCase getArtifactsCase();
}
