/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/data_foundry_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for DataFoundryService.GenerateSyntheticData.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.GenerateSyntheticDataRequest}
 */
public final class GenerateSyntheticDataRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.GenerateSyntheticDataRequest)
    GenerateSyntheticDataRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerateSyntheticDataRequest.newBuilder() to construct.
  private GenerateSyntheticDataRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateSyntheticDataRequest() {
    location_ = "";
    outputFieldSpecs_ = java.util.Collections.emptyList();
    examples_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateSyntheticDataRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
        .internal_static_google_cloud_aiplatform_v1_GenerateSyntheticDataRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
        .internal_static_google_cloud_aiplatform_v1_GenerateSyntheticDataRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.class,
            com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.Builder.class);
  }

  private int strategyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object strategy_;

  public enum StrategyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TASK_DESCRIPTION(3),
    STRATEGY_NOT_SET(0);
    private final int value;

    private StrategyCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StrategyCase valueOf(int value) {
      return forNumber(value);
    }

    public static StrategyCase forNumber(int value) {
      switch (value) {
        case 3:
          return TASK_DESCRIPTION;
        case 0:
          return STRATEGY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StrategyCase getStrategyCase() {
    return StrategyCase.forNumber(strategyCase_);
  }

  public static final int TASK_DESCRIPTION_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Generate data from a high-level task description.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
   *
   * @return Whether the taskDescription field is set.
   */
  @java.lang.Override
  public boolean hasTaskDescription() {
    return strategyCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Generate data from a high-level task description.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
   *
   * @return The taskDescription.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TaskDescriptionStrategy getTaskDescription() {
    if (strategyCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_;
    }
    return com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Generate data from a high-level task description.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TaskDescriptionStrategyOrBuilder
      getTaskDescriptionOrBuilder() {
    if (strategyCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_;
    }
    return com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.getDefaultInstance();
  }

  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to run the job.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the Location to run the job.
   * Format: `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COUNT_FIELD_NUMBER = 2;
  private int count_ = 0;

  /**
   *
   *
   * <pre>
   * Required. The number of synthetic examples to generate.
   * For this stateless API, the count is limited to a small number.
   * </pre>
   *
   * <code>int32 count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count.
   */
  @java.lang.Override
  public int getCount() {
    return count_;
  }

  public static final int OUTPUT_FIELD_SPECS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.OutputFieldSpec> outputFieldSpecs_;

  /**
   *
   *
   * <pre>
   * Required. The schema of the desired output, defined by a list of fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.OutputFieldSpec> getOutputFieldSpecsList() {
    return outputFieldSpecs_;
  }

  /**
   *
   *
   * <pre>
   * Required. The schema of the desired output, defined by a list of fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder>
      getOutputFieldSpecsOrBuilderList() {
    return outputFieldSpecs_;
  }

  /**
   *
   *
   * <pre>
   * Required. The schema of the desired output, defined by a list of fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getOutputFieldSpecsCount() {
    return outputFieldSpecs_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The schema of the desired output, defined by a list of fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.OutputFieldSpec getOutputFieldSpecs(int index) {
    return outputFieldSpecs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The schema of the desired output, defined by a list of fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder getOutputFieldSpecsOrBuilder(
      int index) {
    return outputFieldSpecs_.get(index);
  }

  public static final int EXAMPLES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.SyntheticExample> examples_;

  /**
   *
   *
   * <pre>
   * Optional. A list of few-shot examples to guide the model's output style
   * and format.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.SyntheticExample> getExamplesList() {
    return examples_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of few-shot examples to guide the model's output style
   * and format.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.SyntheticExampleOrBuilder>
      getExamplesOrBuilderList() {
    return examples_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of few-shot examples to guide the model's output style
   * and format.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getExamplesCount() {
    return examples_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of few-shot examples to guide the model's output style
   * and format.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SyntheticExample getExamples(int index) {
    return examples_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of few-shot examples to guide the model's output style
   * and format.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SyntheticExampleOrBuilder getExamplesOrBuilder(int index) {
    return examples_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    if (count_ != 0) {
      output.writeInt32(2, count_);
    }
    if (strategyCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_);
    }
    for (int i = 0; i < outputFieldSpecs_.size(); i++) {
      output.writeMessage(4, outputFieldSpecs_.get(i));
    }
    for (int i = 0; i < examples_.size(); i++) {
      output.writeMessage(5, examples_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    if (count_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, count_);
    }
    if (strategyCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_);
    }
    for (int i = 0; i < outputFieldSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, outputFieldSpecs_.get(i));
    }
    for (int i = 0; i < examples_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, examples_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest other =
        (com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (getCount() != other.getCount()) return false;
    if (!getOutputFieldSpecsList().equals(other.getOutputFieldSpecsList())) return false;
    if (!getExamplesList().equals(other.getExamplesList())) return false;
    if (!getStrategyCase().equals(other.getStrategyCase())) return false;
    switch (strategyCase_) {
      case 3:
        if (!getTaskDescription().equals(other.getTaskDescription())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCount();
    if (getOutputFieldSpecsCount() > 0) {
      hash = (37 * hash) + OUTPUT_FIELD_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getOutputFieldSpecsList().hashCode();
    }
    if (getExamplesCount() > 0) {
      hash = (37 * hash) + EXAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getExamplesList().hashCode();
    }
    switch (strategyCase_) {
      case 3:
        hash = (37 * hash) + TASK_DESCRIPTION_FIELD_NUMBER;
        hash = (53 * hash) + getTaskDescription().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for DataFoundryService.GenerateSyntheticData.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.GenerateSyntheticDataRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.GenerateSyntheticDataRequest)
      com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
          .internal_static_google_cloud_aiplatform_v1_GenerateSyntheticDataRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
          .internal_static_google_cloud_aiplatform_v1_GenerateSyntheticDataRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.class,
              com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (taskDescriptionBuilder_ != null) {
        taskDescriptionBuilder_.clear();
      }
      location_ = "";
      count_ = 0;
      if (outputFieldSpecsBuilder_ == null) {
        outputFieldSpecs_ = java.util.Collections.emptyList();
      } else {
        outputFieldSpecs_ = null;
        outputFieldSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (examplesBuilder_ == null) {
        examples_ = java.util.Collections.emptyList();
      } else {
        examples_ = null;
        examplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      strategyCase_ = 0;
      strategy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.DataFoundryServiceProto
          .internal_static_google_cloud_aiplatform_v1_GenerateSyntheticDataRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest build() {
      com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest buildPartial() {
      com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest result =
          new com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest result) {
      if (outputFieldSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          outputFieldSpecs_ = java.util.Collections.unmodifiableList(outputFieldSpecs_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.outputFieldSpecs_ = outputFieldSpecs_;
      } else {
        result.outputFieldSpecs_ = outputFieldSpecsBuilder_.build();
      }
      if (examplesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          examples_ = java.util.Collections.unmodifiableList(examples_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.examples_ = examples_;
      } else {
        result.examples_ = examplesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.count_ = count_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest result) {
      result.strategyCase_ = strategyCase_;
      result.strategy_ = this.strategy_;
      if (strategyCase_ == 3 && taskDescriptionBuilder_ != null) {
        result.strategy_ = taskDescriptionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest other) {
      if (other == com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getCount() != 0) {
        setCount(other.getCount());
      }
      if (outputFieldSpecsBuilder_ == null) {
        if (!other.outputFieldSpecs_.isEmpty()) {
          if (outputFieldSpecs_.isEmpty()) {
            outputFieldSpecs_ = other.outputFieldSpecs_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureOutputFieldSpecsIsMutable();
            outputFieldSpecs_.addAll(other.outputFieldSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.outputFieldSpecs_.isEmpty()) {
          if (outputFieldSpecsBuilder_.isEmpty()) {
            outputFieldSpecsBuilder_.dispose();
            outputFieldSpecsBuilder_ = null;
            outputFieldSpecs_ = other.outputFieldSpecs_;
            bitField0_ = (bitField0_ & ~0x00000008);
            outputFieldSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOutputFieldSpecsFieldBuilder()
                    : null;
          } else {
            outputFieldSpecsBuilder_.addAllMessages(other.outputFieldSpecs_);
          }
        }
      }
      if (examplesBuilder_ == null) {
        if (!other.examples_.isEmpty()) {
          if (examples_.isEmpty()) {
            examples_ = other.examples_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureExamplesIsMutable();
            examples_.addAll(other.examples_);
          }
          onChanged();
        }
      } else {
        if (!other.examples_.isEmpty()) {
          if (examplesBuilder_.isEmpty()) {
            examplesBuilder_.dispose();
            examplesBuilder_ = null;
            examples_ = other.examples_;
            bitField0_ = (bitField0_ & ~0x00000010);
            examplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExamplesFieldBuilder()
                    : null;
          } else {
            examplesBuilder_.addAllMessages(other.examples_);
          }
        }
      }
      switch (other.getStrategyCase()) {
        case TASK_DESCRIPTION:
          {
            mergeTaskDescription(other.getTaskDescription());
            break;
          }
        case STRATEGY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 16:
              {
                count_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getTaskDescriptionFieldBuilder().getBuilder(), extensionRegistry);
                strategyCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.aiplatform.v1.OutputFieldSpec m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.OutputFieldSpec.parser(), extensionRegistry);
                if (outputFieldSpecsBuilder_ == null) {
                  ensureOutputFieldSpecsIsMutable();
                  outputFieldSpecs_.add(m);
                } else {
                  outputFieldSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.aiplatform.v1.SyntheticExample m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.SyntheticExample.parser(),
                        extensionRegistry);
                if (examplesBuilder_ == null) {
                  ensureExamplesIsMutable();
                  examples_.add(m);
                } else {
                  examplesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int strategyCase_ = 0;
    private java.lang.Object strategy_;

    public StrategyCase getStrategyCase() {
      return StrategyCase.forNumber(strategyCase_);
    }

    public Builder clearStrategy() {
      strategyCase_ = 0;
      strategy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TaskDescriptionStrategy,
            com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.Builder,
            com.google.cloud.aiplatform.v1.TaskDescriptionStrategyOrBuilder>
        taskDescriptionBuilder_;

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     *
     * @return Whether the taskDescription field is set.
     */
    @java.lang.Override
    public boolean hasTaskDescription() {
      return strategyCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     *
     * @return The taskDescription.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TaskDescriptionStrategy getTaskDescription() {
      if (taskDescriptionBuilder_ == null) {
        if (strategyCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_;
        }
        return com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.getDefaultInstance();
      } else {
        if (strategyCase_ == 3) {
          return taskDescriptionBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     */
    public Builder setTaskDescription(
        com.google.cloud.aiplatform.v1.TaskDescriptionStrategy value) {
      if (taskDescriptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        strategy_ = value;
        onChanged();
      } else {
        taskDescriptionBuilder_.setMessage(value);
      }
      strategyCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     */
    public Builder setTaskDescription(
        com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.Builder builderForValue) {
      if (taskDescriptionBuilder_ == null) {
        strategy_ = builderForValue.build();
        onChanged();
      } else {
        taskDescriptionBuilder_.setMessage(builderForValue.build());
      }
      strategyCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     */
    public Builder mergeTaskDescription(
        com.google.cloud.aiplatform.v1.TaskDescriptionStrategy value) {
      if (taskDescriptionBuilder_ == null) {
        if (strategyCase_ == 3
            && strategy_
                != com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.getDefaultInstance()) {
          strategy_ =
              com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.newBuilder(
                      (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          strategy_ = value;
        }
        onChanged();
      } else {
        if (strategyCase_ == 3) {
          taskDescriptionBuilder_.mergeFrom(value);
        } else {
          taskDescriptionBuilder_.setMessage(value);
        }
      }
      strategyCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     */
    public Builder clearTaskDescription() {
      if (taskDescriptionBuilder_ == null) {
        if (strategyCase_ == 3) {
          strategyCase_ = 0;
          strategy_ = null;
          onChanged();
        }
      } else {
        if (strategyCase_ == 3) {
          strategyCase_ = 0;
          strategy_ = null;
        }
        taskDescriptionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     */
    public com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.Builder
        getTaskDescriptionBuilder() {
      return getTaskDescriptionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.TaskDescriptionStrategyOrBuilder
        getTaskDescriptionOrBuilder() {
      if ((strategyCase_ == 3) && (taskDescriptionBuilder_ != null)) {
        return taskDescriptionBuilder_.getMessageOrBuilder();
      } else {
        if (strategyCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_;
        }
        return com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Generate data from a high-level task description.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.TaskDescriptionStrategy task_description = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.TaskDescriptionStrategy,
            com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.Builder,
            com.google.cloud.aiplatform.v1.TaskDescriptionStrategyOrBuilder>
        getTaskDescriptionFieldBuilder() {
      if (taskDescriptionBuilder_ == null) {
        if (!(strategyCase_ == 3)) {
          strategy_ = com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.getDefaultInstance();
        }
        taskDescriptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.TaskDescriptionStrategy,
                com.google.cloud.aiplatform.v1.TaskDescriptionStrategy.Builder,
                com.google.cloud.aiplatform.v1.TaskDescriptionStrategyOrBuilder>(
                (com.google.cloud.aiplatform.v1.TaskDescriptionStrategy) strategy_,
                getParentForChildren(),
                isClean());
        strategy_ = null;
      }
      strategyCase_ = 3;
      onChanged();
      return taskDescriptionBuilder_;
    }

    private java.lang.Object location_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to run the job.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to run the job.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to run the job.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to run the job.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the Location to run the job.
     * Format: `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int count_;

    /**
     *
     *
     * <pre>
     * Required. The number of synthetic examples to generate.
     * For this stateless API, the count is limited to a small number.
     * </pre>
     *
     * <code>int32 count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public int getCount() {
      return count_;
    }

    /**
     *
     *
     * <pre>
     * Required. The number of synthetic examples to generate.
     * For this stateless API, the count is limited to a small number.
     * </pre>
     *
     * <code>int32 count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The count to set.
     * @return This builder for chaining.
     */
    public Builder setCount(int value) {

      count_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The number of synthetic examples to generate.
     * For this stateless API, the count is limited to a small number.
     * </pre>
     *
     * <code>int32 count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      count_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.OutputFieldSpec> outputFieldSpecs_ =
        java.util.Collections.emptyList();

    private void ensureOutputFieldSpecsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        outputFieldSpecs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.OutputFieldSpec>(
                outputFieldSpecs_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.OutputFieldSpec,
            com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder,
            com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder>
        outputFieldSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.OutputFieldSpec>
        getOutputFieldSpecsList() {
      if (outputFieldSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(outputFieldSpecs_);
      } else {
        return outputFieldSpecsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getOutputFieldSpecsCount() {
      if (outputFieldSpecsBuilder_ == null) {
        return outputFieldSpecs_.size();
      } else {
        return outputFieldSpecsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.OutputFieldSpec getOutputFieldSpecs(int index) {
      if (outputFieldSpecsBuilder_ == null) {
        return outputFieldSpecs_.get(index);
      } else {
        return outputFieldSpecsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputFieldSpecs(
        int index, com.google.cloud.aiplatform.v1.OutputFieldSpec value) {
      if (outputFieldSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputFieldSpecsIsMutable();
        outputFieldSpecs_.set(index, value);
        onChanged();
      } else {
        outputFieldSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputFieldSpecs(
        int index, com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder builderForValue) {
      if (outputFieldSpecsBuilder_ == null) {
        ensureOutputFieldSpecsIsMutable();
        outputFieldSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        outputFieldSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOutputFieldSpecs(com.google.cloud.aiplatform.v1.OutputFieldSpec value) {
      if (outputFieldSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputFieldSpecsIsMutable();
        outputFieldSpecs_.add(value);
        onChanged();
      } else {
        outputFieldSpecsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOutputFieldSpecs(
        int index, com.google.cloud.aiplatform.v1.OutputFieldSpec value) {
      if (outputFieldSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputFieldSpecsIsMutable();
        outputFieldSpecs_.add(index, value);
        onChanged();
      } else {
        outputFieldSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOutputFieldSpecs(
        com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder builderForValue) {
      if (outputFieldSpecsBuilder_ == null) {
        ensureOutputFieldSpecsIsMutable();
        outputFieldSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        outputFieldSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOutputFieldSpecs(
        int index, com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder builderForValue) {
      if (outputFieldSpecsBuilder_ == null) {
        ensureOutputFieldSpecsIsMutable();
        outputFieldSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        outputFieldSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllOutputFieldSpecs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.OutputFieldSpec> values) {
      if (outputFieldSpecsBuilder_ == null) {
        ensureOutputFieldSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, outputFieldSpecs_);
        onChanged();
      } else {
        outputFieldSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputFieldSpecs() {
      if (outputFieldSpecsBuilder_ == null) {
        outputFieldSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        outputFieldSpecsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeOutputFieldSpecs(int index) {
      if (outputFieldSpecsBuilder_ == null) {
        ensureOutputFieldSpecsIsMutable();
        outputFieldSpecs_.remove(index);
        onChanged();
      } else {
        outputFieldSpecsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder getOutputFieldSpecsBuilder(
        int index) {
      return getOutputFieldSpecsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder getOutputFieldSpecsOrBuilder(
        int index) {
      if (outputFieldSpecsBuilder_ == null) {
        return outputFieldSpecs_.get(index);
      } else {
        return outputFieldSpecsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder>
        getOutputFieldSpecsOrBuilderList() {
      if (outputFieldSpecsBuilder_ != null) {
        return outputFieldSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(outputFieldSpecs_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder addOutputFieldSpecsBuilder() {
      return getOutputFieldSpecsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.OutputFieldSpec.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder addOutputFieldSpecsBuilder(
        int index) {
      return getOutputFieldSpecsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.OutputFieldSpec.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The schema of the desired output, defined by a list of fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.OutputFieldSpec output_field_specs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder>
        getOutputFieldSpecsBuilderList() {
      return getOutputFieldSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.OutputFieldSpec,
            com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder,
            com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder>
        getOutputFieldSpecsFieldBuilder() {
      if (outputFieldSpecsBuilder_ == null) {
        outputFieldSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.OutputFieldSpec,
                com.google.cloud.aiplatform.v1.OutputFieldSpec.Builder,
                com.google.cloud.aiplatform.v1.OutputFieldSpecOrBuilder>(
                outputFieldSpecs_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        outputFieldSpecs_ = null;
      }
      return outputFieldSpecsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.SyntheticExample> examples_ =
        java.util.Collections.emptyList();

    private void ensureExamplesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        examples_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.SyntheticExample>(examples_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SyntheticExample,
            com.google.cloud.aiplatform.v1.SyntheticExample.Builder,
            com.google.cloud.aiplatform.v1.SyntheticExampleOrBuilder>
        examplesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.SyntheticExample> getExamplesList() {
      if (examplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(examples_);
      } else {
        return examplesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getExamplesCount() {
      if (examplesBuilder_ == null) {
        return examples_.size();
      } else {
        return examplesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SyntheticExample getExamples(int index) {
      if (examplesBuilder_ == null) {
        return examples_.get(index);
      } else {
        return examplesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExamples(int index, com.google.cloud.aiplatform.v1.SyntheticExample value) {
      if (examplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExamplesIsMutable();
        examples_.set(index, value);
        onChanged();
      } else {
        examplesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExamples(
        int index, com.google.cloud.aiplatform.v1.SyntheticExample.Builder builderForValue) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.set(index, builderForValue.build());
        onChanged();
      } else {
        examplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExamples(com.google.cloud.aiplatform.v1.SyntheticExample value) {
      if (examplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExamplesIsMutable();
        examples_.add(value);
        onChanged();
      } else {
        examplesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExamples(int index, com.google.cloud.aiplatform.v1.SyntheticExample value) {
      if (examplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExamplesIsMutable();
        examples_.add(index, value);
        onChanged();
      } else {
        examplesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExamples(
        com.google.cloud.aiplatform.v1.SyntheticExample.Builder builderForValue) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.add(builderForValue.build());
        onChanged();
      } else {
        examplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addExamples(
        int index, com.google.cloud.aiplatform.v1.SyntheticExample.Builder builderForValue) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.add(index, builderForValue.build());
        onChanged();
      } else {
        examplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllExamples(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.SyntheticExample> values) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, examples_);
        onChanged();
      } else {
        examplesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExamples() {
      if (examplesBuilder_ == null) {
        examples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        examplesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeExamples(int index) {
      if (examplesBuilder_ == null) {
        ensureExamplesIsMutable();
        examples_.remove(index);
        onChanged();
      } else {
        examplesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SyntheticExample.Builder getExamplesBuilder(int index) {
      return getExamplesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SyntheticExampleOrBuilder getExamplesOrBuilder(
        int index) {
      if (examplesBuilder_ == null) {
        return examples_.get(index);
      } else {
        return examplesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.SyntheticExampleOrBuilder>
        getExamplesOrBuilderList() {
      if (examplesBuilder_ != null) {
        return examplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(examples_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SyntheticExample.Builder addExamplesBuilder() {
      return getExamplesFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.SyntheticExample.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SyntheticExample.Builder addExamplesBuilder(int index) {
      return getExamplesFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.SyntheticExample.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of few-shot examples to guide the model's output style
     * and format.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SyntheticExample examples = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.SyntheticExample.Builder>
        getExamplesBuilderList() {
      return getExamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SyntheticExample,
            com.google.cloud.aiplatform.v1.SyntheticExample.Builder,
            com.google.cloud.aiplatform.v1.SyntheticExampleOrBuilder>
        getExamplesFieldBuilder() {
      if (examplesBuilder_ == null) {
        examplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SyntheticExample,
                com.google.cloud.aiplatform.v1.SyntheticExample.Builder,
                com.google.cloud.aiplatform.v1.SyntheticExampleOrBuilder>(
                examples_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        examples_ = null;
      }
      return examplesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.GenerateSyntheticDataRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.GenerateSyntheticDataRequest)
  private static final com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest();
  }

  public static com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateSyntheticDataRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateSyntheticDataRequest>() {
        @java.lang.Override
        public GenerateSyntheticDataRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateSyntheticDataRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateSyntheticDataRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GenerateSyntheticDataRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
