/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/schedule.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * An instance of a Schedule periodically schedules runs to make API calls based
 * on user specified time specification and API request type.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Schedule}
 */
public final class Schedule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Schedule)
    ScheduleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Schedule.newBuilder() to construct.
  private Schedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Schedule() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Schedule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ScheduleProto
        .internal_static_google_cloud_aiplatform_v1_Schedule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ScheduleProto
        .internal_static_google_cloud_aiplatform_v1_Schedule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Schedule.class,
            com.google.cloud.aiplatform.v1.Schedule.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible state of the schedule.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.Schedule.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The Schedule is active. Runs are being scheduled on the user-specified
     * timespec.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The schedule is paused. No new runs will be created until the schedule
     * is resumed. Already started runs will be allowed to complete.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * The Schedule is completed. No new runs will be scheduled. Already started
     * runs will be allowed to complete. Schedules in completed state cannot be
     * paused or resumed.
     * </pre>
     *
     * <code>COMPLETED = 3;</code>
     */
    COMPLETED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The Schedule is active. Runs are being scheduled on the user-specified
     * timespec.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The schedule is paused. No new runs will be created until the schedule
     * is resumed. Already started runs will be allowed to complete.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The Schedule is completed. No new runs will be scheduled. Already started
     * runs will be allowed to complete. Schedules in completed state cannot be
     * paused or resumed.
     * </pre>
     *
     * <code>COMPLETED = 3;</code>
     */
    public static final int COMPLETED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return PAUSED;
        case 3:
          return COMPLETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Schedule.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Schedule.State)
  }

  public interface RunResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Schedule.RunResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The scheduled run time based on the user-specified schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
     *
     * @return Whether the scheduledRunTime field is set.
     */
    boolean hasScheduledRunTime();

    /**
     *
     *
     * <pre>
     * The scheduled run time based on the user-specified schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
     *
     * @return The scheduledRunTime.
     */
    com.google.protobuf.Timestamp getScheduledRunTime();

    /**
     *
     *
     * <pre>
     * The scheduled run time based on the user-specified schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getScheduledRunTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The response of the scheduled run.
     * </pre>
     *
     * <code>string run_response = 2;</code>
     *
     * @return The runResponse.
     */
    java.lang.String getRunResponse();

    /**
     *
     *
     * <pre>
     * The response of the scheduled run.
     * </pre>
     *
     * <code>string run_response = 2;</code>
     *
     * @return The bytes for runResponse.
     */
    com.google.protobuf.ByteString getRunResponseBytes();
  }

  /**
   *
   *
   * <pre>
   * Status of a scheduled run.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Schedule.RunResponse}
   */
  public static final class RunResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Schedule.RunResponse)
      RunResponseOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RunResponse.newBuilder() to construct.
    private RunResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RunResponse() {
      runResponse_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RunResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ScheduleProto
          .internal_static_google_cloud_aiplatform_v1_Schedule_RunResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ScheduleProto
          .internal_static_google_cloud_aiplatform_v1_Schedule_RunResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Schedule.RunResponse.class,
              com.google.cloud.aiplatform.v1.Schedule.RunResponse.Builder.class);
    }

    private int bitField0_;
    public static final int SCHEDULED_RUN_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp scheduledRunTime_;

    /**
     *
     *
     * <pre>
     * The scheduled run time based on the user-specified schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
     *
     * @return Whether the scheduledRunTime field is set.
     */
    @java.lang.Override
    public boolean hasScheduledRunTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The scheduled run time based on the user-specified schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
     *
     * @return The scheduledRunTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getScheduledRunTime() {
      return scheduledRunTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : scheduledRunTime_;
    }

    /**
     *
     *
     * <pre>
     * The scheduled run time based on the user-specified schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getScheduledRunTimeOrBuilder() {
      return scheduledRunTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : scheduledRunTime_;
    }

    public static final int RUN_RESPONSE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object runResponse_ = "";

    /**
     *
     *
     * <pre>
     * The response of the scheduled run.
     * </pre>
     *
     * <code>string run_response = 2;</code>
     *
     * @return The runResponse.
     */
    @java.lang.Override
    public java.lang.String getRunResponse() {
      java.lang.Object ref = runResponse_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        runResponse_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The response of the scheduled run.
     * </pre>
     *
     * <code>string run_response = 2;</code>
     *
     * @return The bytes for runResponse.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRunResponseBytes() {
      java.lang.Object ref = runResponse_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        runResponse_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getScheduledRunTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runResponse_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, runResponse_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getScheduledRunTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(runResponse_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, runResponse_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Schedule.RunResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Schedule.RunResponse other =
          (com.google.cloud.aiplatform.v1.Schedule.RunResponse) obj;

      if (hasScheduledRunTime() != other.hasScheduledRunTime()) return false;
      if (hasScheduledRunTime()) {
        if (!getScheduledRunTime().equals(other.getScheduledRunTime())) return false;
      }
      if (!getRunResponse().equals(other.getRunResponse())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasScheduledRunTime()) {
        hash = (37 * hash) + SCHEDULED_RUN_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getScheduledRunTime().hashCode();
      }
      hash = (37 * hash) + RUN_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + getRunResponse().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.Schedule.RunResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Status of a scheduled run.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Schedule.RunResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Schedule.RunResponse)
        com.google.cloud.aiplatform.v1.Schedule.RunResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ScheduleProto
            .internal_static_google_cloud_aiplatform_v1_Schedule_RunResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ScheduleProto
            .internal_static_google_cloud_aiplatform_v1_Schedule_RunResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Schedule.RunResponse.class,
                com.google.cloud.aiplatform.v1.Schedule.RunResponse.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Schedule.RunResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getScheduledRunTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        scheduledRunTime_ = null;
        if (scheduledRunTimeBuilder_ != null) {
          scheduledRunTimeBuilder_.dispose();
          scheduledRunTimeBuilder_ = null;
        }
        runResponse_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ScheduleProto
            .internal_static_google_cloud_aiplatform_v1_Schedule_RunResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Schedule.RunResponse getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Schedule.RunResponse.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Schedule.RunResponse build() {
        com.google.cloud.aiplatform.v1.Schedule.RunResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Schedule.RunResponse buildPartial() {
        com.google.cloud.aiplatform.v1.Schedule.RunResponse result =
            new com.google.cloud.aiplatform.v1.Schedule.RunResponse(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Schedule.RunResponse result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.scheduledRunTime_ =
              scheduledRunTimeBuilder_ == null
                  ? scheduledRunTime_
                  : scheduledRunTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.runResponse_ = runResponse_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Schedule.RunResponse) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Schedule.RunResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Schedule.RunResponse other) {
        if (other == com.google.cloud.aiplatform.v1.Schedule.RunResponse.getDefaultInstance())
          return this;
        if (other.hasScheduledRunTime()) {
          mergeScheduledRunTime(other.getScheduledRunTime());
        }
        if (!other.getRunResponse().isEmpty()) {
          runResponse_ = other.runResponse_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getScheduledRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  runResponse_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp scheduledRunTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          scheduledRunTimeBuilder_;

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       *
       * @return Whether the scheduledRunTime field is set.
       */
      public boolean hasScheduledRunTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       *
       * @return The scheduledRunTime.
       */
      public com.google.protobuf.Timestamp getScheduledRunTime() {
        if (scheduledRunTimeBuilder_ == null) {
          return scheduledRunTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : scheduledRunTime_;
        } else {
          return scheduledRunTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       */
      public Builder setScheduledRunTime(com.google.protobuf.Timestamp value) {
        if (scheduledRunTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scheduledRunTime_ = value;
        } else {
          scheduledRunTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       */
      public Builder setScheduledRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (scheduledRunTimeBuilder_ == null) {
          scheduledRunTime_ = builderForValue.build();
        } else {
          scheduledRunTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       */
      public Builder mergeScheduledRunTime(com.google.protobuf.Timestamp value) {
        if (scheduledRunTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && scheduledRunTime_ != null
              && scheduledRunTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getScheduledRunTimeBuilder().mergeFrom(value);
          } else {
            scheduledRunTime_ = value;
          }
        } else {
          scheduledRunTimeBuilder_.mergeFrom(value);
        }
        if (scheduledRunTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       */
      public Builder clearScheduledRunTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        scheduledRunTime_ = null;
        if (scheduledRunTimeBuilder_ != null) {
          scheduledRunTimeBuilder_.dispose();
          scheduledRunTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getScheduledRunTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getScheduledRunTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getScheduledRunTimeOrBuilder() {
        if (scheduledRunTimeBuilder_ != null) {
          return scheduledRunTimeBuilder_.getMessageOrBuilder();
        } else {
          return scheduledRunTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : scheduledRunTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * The scheduled run time based on the user-specified schedule.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp scheduled_run_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getScheduledRunTimeFieldBuilder() {
        if (scheduledRunTimeBuilder_ == null) {
          scheduledRunTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getScheduledRunTime(), getParentForChildren(), isClean());
          scheduledRunTime_ = null;
        }
        return scheduledRunTimeBuilder_;
      }

      private java.lang.Object runResponse_ = "";

      /**
       *
       *
       * <pre>
       * The response of the scheduled run.
       * </pre>
       *
       * <code>string run_response = 2;</code>
       *
       * @return The runResponse.
       */
      public java.lang.String getRunResponse() {
        java.lang.Object ref = runResponse_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          runResponse_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The response of the scheduled run.
       * </pre>
       *
       * <code>string run_response = 2;</code>
       *
       * @return The bytes for runResponse.
       */
      public com.google.protobuf.ByteString getRunResponseBytes() {
        java.lang.Object ref = runResponse_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          runResponse_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The response of the scheduled run.
       * </pre>
       *
       * <code>string run_response = 2;</code>
       *
       * @param value The runResponse to set.
       * @return This builder for chaining.
       */
      public Builder setRunResponse(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        runResponse_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The response of the scheduled run.
       * </pre>
       *
       * <code>string run_response = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRunResponse() {
        runResponse_ = getDefaultInstance().getRunResponse();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The response of the scheduled run.
       * </pre>
       *
       * <code>string run_response = 2;</code>
       *
       * @param value The bytes for runResponse to set.
       * @return This builder for chaining.
       */
      public Builder setRunResponseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        runResponse_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Schedule.RunResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Schedule.RunResponse)
    private static final com.google.cloud.aiplatform.v1.Schedule.RunResponse DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Schedule.RunResponse();
    }

    public static com.google.cloud.aiplatform.v1.Schedule.RunResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RunResponse> PARSER =
        new com.google.protobuf.AbstractParser<RunResponse>() {
          @java.lang.Override
          public RunResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RunResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RunResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schedule.RunResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int timeSpecificationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object timeSpecification_;

  public enum TimeSpecificationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CRON(10),
    TIMESPECIFICATION_NOT_SET(0);
    private final int value;

    private TimeSpecificationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimeSpecificationCase valueOf(int value) {
      return forNumber(value);
    }

    public static TimeSpecificationCase forNumber(int value) {
      switch (value) {
        case 10:
          return CRON;
        case 0:
          return TIMESPECIFICATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TimeSpecificationCase getTimeSpecificationCase() {
    return TimeSpecificationCase.forNumber(timeSpecificationCase_);
  }

  private int requestCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object request_;

  public enum RequestCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CREATE_PIPELINE_JOB_REQUEST(14),
    CREATE_NOTEBOOK_EXECUTION_JOB_REQUEST(20),
    REQUEST_NOT_SET(0);
    private final int value;

    private RequestCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequestCase forNumber(int value) {
      switch (value) {
        case 14:
          return CREATE_PIPELINE_JOB_REQUEST;
        case 20:
          return CREATE_NOTEBOOK_EXECUTION_JOB_REQUEST;
        case 0:
          return REQUEST_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RequestCase getRequestCase() {
    return RequestCase.forNumber(requestCase_);
  }

  public static final int CRON_FIELD_NUMBER = 10;

  /**
   *
   *
   * <pre>
   * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
   * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
   * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
   * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
   * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
   * "TZ=America/New_York 1 * * * *".
   * </pre>
   *
   * <code>string cron = 10;</code>
   *
   * @return Whether the cron field is set.
   */
  public boolean hasCron() {
    return timeSpecificationCase_ == 10;
  }

  /**
   *
   *
   * <pre>
   * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
   * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
   * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
   * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
   * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
   * "TZ=America/New_York 1 * * * *".
   * </pre>
   *
   * <code>string cron = 10;</code>
   *
   * @return The cron.
   */
  public java.lang.String getCron() {
    java.lang.Object ref = "";
    if (timeSpecificationCase_ == 10) {
      ref = timeSpecification_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (timeSpecificationCase_ == 10) {
        timeSpecification_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
   * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
   * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
   * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
   * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
   * "TZ=America/New_York 1 * * * *".
   * </pre>
   *
   * <code>string cron = 10;</code>
   *
   * @return The bytes for cron.
   */
  public com.google.protobuf.ByteString getCronBytes() {
    java.lang.Object ref = "";
    if (timeSpecificationCase_ == 10) {
      ref = timeSpecification_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (timeSpecificationCase_ == 10) {
        timeSpecification_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_PIPELINE_JOB_REQUEST_FIELD_NUMBER = 14;

  /**
   *
   *
   * <pre>
   * Request for
   * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
   * CreatePipelineJobRequest.parent field is required (format:
   * projects/{project}/locations/{location}).
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
   * </code>
   *
   * @return Whether the createPipelineJobRequest field is set.
   */
  @java.lang.Override
  public boolean hasCreatePipelineJobRequest() {
    return requestCase_ == 14;
  }

  /**
   *
   *
   * <pre>
   * Request for
   * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
   * CreatePipelineJobRequest.parent field is required (format:
   * projects/{project}/locations/{location}).
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
   * </code>
   *
   * @return The createPipelineJobRequest.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CreatePipelineJobRequest getCreatePipelineJobRequest() {
    if (requestCase_ == 14) {
      return (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_;
    }
    return com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Request for
   * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
   * CreatePipelineJobRequest.parent field is required (format:
   * projects/{project}/locations/{location}).
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CreatePipelineJobRequestOrBuilder
      getCreatePipelineJobRequestOrBuilder() {
    if (requestCase_ == 14) {
      return (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_;
    }
    return com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.getDefaultInstance();
  }

  public static final int CREATE_NOTEBOOK_EXECUTION_JOB_REQUEST_FIELD_NUMBER = 20;

  /**
   *
   *
   * <pre>
   * Request for
   * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
   * </code>
   *
   * @return Whether the createNotebookExecutionJobRequest field is set.
   */
  @java.lang.Override
  public boolean hasCreateNotebookExecutionJobRequest() {
    return requestCase_ == 20;
  }

  /**
   *
   *
   * <pre>
   * Request for
   * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
   * </code>
   *
   * @return The createNotebookExecutionJobRequest.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest
      getCreateNotebookExecutionJobRequest() {
    if (requestCase_ == 20) {
      return (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_;
    }
    return com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Request for
   * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequestOrBuilder
      getCreateNotebookExecutionJobRequestOrBuilder() {
    if (requestCase_ == 20) {
      return (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_;
    }
    return com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Schedule.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the Schedule.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. User provided name of the Schedule.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. User provided name of the Schedule.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * Optional. Timestamp after which the first run can be scheduled.
   * Default to Schedule create time if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp after which the first run can be scheduled.
   * Default to Schedule create time if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp after which the first run can be scheduled.
   * Default to Schedule create time if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * Optional. Timestamp after which no new runs can be scheduled.
   * If specified, The schedule will be completed when either
   * end_time is reached or when scheduled_run_count &gt;= max_run_count.
   * If not specified, new runs will keep getting scheduled until this Schedule
   * is paused or deleted. Already scheduled runs will be allowed to complete.
   * Unset if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp after which no new runs can be scheduled.
   * If specified, The schedule will be completed when either
   * end_time is reached or when scheduled_run_count &gt;= max_run_count.
   * If not specified, new runs will keep getting scheduled until this Schedule
   * is paused or deleted. Already scheduled runs will be allowed to complete.
   * Unset if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp after which no new runs can be scheduled.
   * If specified, The schedule will be completed when either
   * end_time is reached or when scheduled_run_count &gt;= max_run_count.
   * If not specified, new runs will keep getting scheduled until this Schedule
   * is paused or deleted. Already scheduled runs will be allowed to complete.
   * Unset if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int MAX_RUN_COUNT_FIELD_NUMBER = 16;
  private long maxRunCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Maximum run count of the schedule.
   * If specified, The schedule will be completed when either
   * started_run_count &gt;= max_run_count or when end_time is reached.
   * If not specified, new runs will keep getting scheduled until this Schedule
   * is paused or deleted. Already scheduled runs will be allowed to complete.
   * Unset if not specified.
   * </pre>
   *
   * <code>int64 max_run_count = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxRunCount.
   */
  @java.lang.Override
  public long getMaxRunCount() {
    return maxRunCount_;
  }

  public static final int STARTED_RUN_COUNT_FIELD_NUMBER = 17;
  private long startedRunCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. The number of runs started by this schedule.
   * </pre>
   *
   * <code>int64 started_run_count = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The startedRunCount.
   */
  @java.lang.Override
  public long getStartedRunCount() {
    return startedRunCount_;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The state of this Schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Schedule.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The state of this Schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Schedule.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Schedule.State getState() {
    com.google.cloud.aiplatform.v1.Schedule.State result =
        com.google.cloud.aiplatform.v1.Schedule.State.forNumber(state_);
    return result == null ? com.google.cloud.aiplatform.v1.Schedule.State.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 19;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int NEXT_RUN_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp nextRunTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule should schedule the next run.
   * Having a next_run_time in the past means the runs are being started
   * behind schedule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the nextRunTime field is set.
   */
  @java.lang.Override
  public boolean hasNextRunTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule should schedule the next run.
   * Having a next_run_time in the past means the runs are being started
   * behind schedule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The nextRunTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNextRunTime() {
    return nextRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : nextRunTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule should schedule the next run.
   * Having a next_run_time in the past means the runs are being started
   * behind schedule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNextRunTimeOrBuilder() {
    return nextRunTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : nextRunTime_;
  }

  public static final int LAST_PAUSE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp lastPauseTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was last paused.
   * Unset if never paused.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastPauseTime field is set.
   */
  @java.lang.Override
  public boolean hasLastPauseTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was last paused.
   * Unset if never paused.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastPauseTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastPauseTime() {
    return lastPauseTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastPauseTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was last paused.
   * Unset if never paused.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastPauseTimeOrBuilder() {
    return lastPauseTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastPauseTime_;
  }

  public static final int LAST_RESUME_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp lastResumeTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was last resumed.
   * Unset if never resumed from pause.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastResumeTime field is set.
   */
  @java.lang.Override
  public boolean hasLastResumeTime() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was last resumed.
   * Unset if never resumed from pause.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastResumeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastResumeTime() {
    return lastResumeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastResumeTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Schedule was last resumed.
   * Unset if never resumed from pause.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastResumeTimeOrBuilder() {
    return lastResumeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastResumeTime_;
  }

  public static final int MAX_CONCURRENT_RUN_COUNT_FIELD_NUMBER = 11;
  private long maxConcurrentRunCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Required. Maximum number of runs that can be started concurrently for this
   * Schedule. This is the limit for starting the scheduled requests and not the
   * execution of the operations/jobs created by the requests (if applicable).
   * </pre>
   *
   * <code>int64 max_concurrent_run_count = 11 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The maxConcurrentRunCount.
   */
  @java.lang.Override
  public long getMaxConcurrentRunCount() {
    return maxConcurrentRunCount_;
  }

  public static final int ALLOW_QUEUEING_FIELD_NUMBER = 12;
  private boolean allowQueueing_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether new scheduled runs can be queued when max_concurrent_runs
   * limit is reached. If set to true, new runs will be queued instead of
   * skipped. Default to false.
   * </pre>
   *
   * <code>bool allow_queueing = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The allowQueueing.
   */
  @java.lang.Override
  public boolean getAllowQueueing() {
    return allowQueueing_;
  }

  public static final int CATCH_UP_FIELD_NUMBER = 13;
  private boolean catchUp_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Whether to backfill missed runs when the schedule is resumed
   * from PAUSED state. If set to true, all missed runs will be scheduled. New
   * runs will be scheduled after the backfill is complete. Default to false.
   * </pre>
   *
   * <code>bool catch_up = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The catchUp.
   */
  @java.lang.Override
  public boolean getCatchUp() {
    return catchUp_;
  }

  public static final int LAST_SCHEDULED_RUN_RESPONSE_FIELD_NUMBER = 18;
  private com.google.cloud.aiplatform.v1.Schedule.RunResponse lastScheduledRunResponse_;

  /**
   *
   *
   * <pre>
   * Output only. Response of the last scheduled run.
   * This is the response for starting the scheduled requests and not the
   * execution of the operations/jobs created by the requests (if applicable).
   * Unset if no run has been scheduled yet.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastScheduledRunResponse field is set.
   */
  @java.lang.Override
  public boolean hasLastScheduledRunResponse() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Response of the last scheduled run.
   * This is the response for starting the scheduled requests and not the
   * execution of the operations/jobs created by the requests (if applicable).
   * Unset if no run has been scheduled yet.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastScheduledRunResponse.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Schedule.RunResponse getLastScheduledRunResponse() {
    return lastScheduledRunResponse_ == null
        ? com.google.cloud.aiplatform.v1.Schedule.RunResponse.getDefaultInstance()
        : lastScheduledRunResponse_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Response of the last scheduled run.
   * This is the response for starting the scheduled requests and not the
   * execution of the operations/jobs created by the requests (if applicable).
   * Unset if no run has been scheduled yet.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Schedule.RunResponseOrBuilder
      getLastScheduledRunResponseOrBuilder() {
    return lastScheduledRunResponse_ == null
        ? com.google.cloud.aiplatform.v1.Schedule.RunResponse.getDefaultInstance()
        : lastScheduledRunResponse_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getEndTime());
    }
    if (state_ != com.google.cloud.aiplatform.v1.Schedule.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(7, getNextRunTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(8, getLastPauseTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(9, getLastResumeTime());
    }
    if (timeSpecificationCase_ == 10) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, timeSpecification_);
    }
    if (maxConcurrentRunCount_ != 0L) {
      output.writeInt64(11, maxConcurrentRunCount_);
    }
    if (allowQueueing_ != false) {
      output.writeBool(12, allowQueueing_);
    }
    if (catchUp_ != false) {
      output.writeBool(13, catchUp_);
    }
    if (requestCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_);
    }
    if (maxRunCount_ != 0L) {
      output.writeInt64(16, maxRunCount_);
    }
    if (startedRunCount_ != 0L) {
      output.writeInt64(17, startedRunCount_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(18, getLastScheduledRunResponse());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(19, getUpdateTime());
    }
    if (requestCase_ == 20) {
      output.writeMessage(
          20, (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEndTime());
    }
    if (state_ != com.google.cloud.aiplatform.v1.Schedule.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNextRunTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLastPauseTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLastResumeTime());
    }
    if (timeSpecificationCase_ == 10) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, timeSpecification_);
    }
    if (maxConcurrentRunCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, maxConcurrentRunCount_);
    }
    if (allowQueueing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, allowQueueing_);
    }
    if (catchUp_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, catchUp_);
    }
    if (requestCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_);
    }
    if (maxRunCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(16, maxRunCount_);
    }
    if (startedRunCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(17, startedRunCount_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getLastScheduledRunResponse());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getUpdateTime());
    }
    if (requestCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Schedule)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Schedule other = (com.google.cloud.aiplatform.v1.Schedule) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (getMaxRunCount() != other.getMaxRunCount()) return false;
    if (getStartedRunCount() != other.getStartedRunCount()) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasNextRunTime() != other.hasNextRunTime()) return false;
    if (hasNextRunTime()) {
      if (!getNextRunTime().equals(other.getNextRunTime())) return false;
    }
    if (hasLastPauseTime() != other.hasLastPauseTime()) return false;
    if (hasLastPauseTime()) {
      if (!getLastPauseTime().equals(other.getLastPauseTime())) return false;
    }
    if (hasLastResumeTime() != other.hasLastResumeTime()) return false;
    if (hasLastResumeTime()) {
      if (!getLastResumeTime().equals(other.getLastResumeTime())) return false;
    }
    if (getMaxConcurrentRunCount() != other.getMaxConcurrentRunCount()) return false;
    if (getAllowQueueing() != other.getAllowQueueing()) return false;
    if (getCatchUp() != other.getCatchUp()) return false;
    if (hasLastScheduledRunResponse() != other.hasLastScheduledRunResponse()) return false;
    if (hasLastScheduledRunResponse()) {
      if (!getLastScheduledRunResponse().equals(other.getLastScheduledRunResponse())) return false;
    }
    if (!getTimeSpecificationCase().equals(other.getTimeSpecificationCase())) return false;
    switch (timeSpecificationCase_) {
      case 10:
        if (!getCron().equals(other.getCron())) return false;
        break;
      case 0:
      default:
    }
    if (!getRequestCase().equals(other.getRequestCase())) return false;
    switch (requestCase_) {
      case 14:
        if (!getCreatePipelineJobRequest().equals(other.getCreatePipelineJobRequest()))
          return false;
        break;
      case 20:
        if (!getCreateNotebookExecutionJobRequest()
            .equals(other.getCreateNotebookExecutionJobRequest())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + MAX_RUN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxRunCount());
    hash = (37 * hash) + STARTED_RUN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStartedRunCount());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasNextRunTime()) {
      hash = (37 * hash) + NEXT_RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNextRunTime().hashCode();
    }
    if (hasLastPauseTime()) {
      hash = (37 * hash) + LAST_PAUSE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastPauseTime().hashCode();
    }
    if (hasLastResumeTime()) {
      hash = (37 * hash) + LAST_RESUME_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastResumeTime().hashCode();
    }
    hash = (37 * hash) + MAX_CONCURRENT_RUN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxConcurrentRunCount());
    hash = (37 * hash) + ALLOW_QUEUEING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowQueueing());
    hash = (37 * hash) + CATCH_UP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCatchUp());
    if (hasLastScheduledRunResponse()) {
      hash = (37 * hash) + LAST_SCHEDULED_RUN_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + getLastScheduledRunResponse().hashCode();
    }
    switch (timeSpecificationCase_) {
      case 10:
        hash = (37 * hash) + CRON_FIELD_NUMBER;
        hash = (53 * hash) + getCron().hashCode();
        break;
      case 0:
      default:
    }
    switch (requestCase_) {
      case 14:
        hash = (37 * hash) + CREATE_PIPELINE_JOB_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getCreatePipelineJobRequest().hashCode();
        break;
      case 20:
        hash = (37 * hash) + CREATE_NOTEBOOK_EXECUTION_JOB_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getCreateNotebookExecutionJobRequest().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Schedule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Schedule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An instance of a Schedule periodically schedules runs to make API calls based
   * on user specified time specification and API request type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Schedule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Schedule)
      com.google.cloud.aiplatform.v1.ScheduleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ScheduleProto
          .internal_static_google_cloud_aiplatform_v1_Schedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ScheduleProto
          .internal_static_google_cloud_aiplatform_v1_Schedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Schedule.class,
              com.google.cloud.aiplatform.v1.Schedule.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Schedule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getNextRunTimeFieldBuilder();
        getLastPauseTimeFieldBuilder();
        getLastResumeTimeFieldBuilder();
        getLastScheduledRunResponseFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (createPipelineJobRequestBuilder_ != null) {
        createPipelineJobRequestBuilder_.clear();
      }
      if (createNotebookExecutionJobRequestBuilder_ != null) {
        createNotebookExecutionJobRequestBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      maxRunCount_ = 0L;
      startedRunCount_ = 0L;
      state_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      nextRunTime_ = null;
      if (nextRunTimeBuilder_ != null) {
        nextRunTimeBuilder_.dispose();
        nextRunTimeBuilder_ = null;
      }
      lastPauseTime_ = null;
      if (lastPauseTimeBuilder_ != null) {
        lastPauseTimeBuilder_.dispose();
        lastPauseTimeBuilder_ = null;
      }
      lastResumeTime_ = null;
      if (lastResumeTimeBuilder_ != null) {
        lastResumeTimeBuilder_.dispose();
        lastResumeTimeBuilder_ = null;
      }
      maxConcurrentRunCount_ = 0L;
      allowQueueing_ = false;
      catchUp_ = false;
      lastScheduledRunResponse_ = null;
      if (lastScheduledRunResponseBuilder_ != null) {
        lastScheduledRunResponseBuilder_.dispose();
        lastScheduledRunResponseBuilder_ = null;
      }
      timeSpecificationCase_ = 0;
      timeSpecification_ = null;
      requestCase_ = 0;
      request_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ScheduleProto
          .internal_static_google_cloud_aiplatform_v1_Schedule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schedule getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Schedule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schedule build() {
      com.google.cloud.aiplatform.v1.Schedule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schedule buildPartial() {
      com.google.cloud.aiplatform.v1.Schedule result =
          new com.google.cloud.aiplatform.v1.Schedule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Schedule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maxRunCount_ = maxRunCount_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.startedRunCount_ = startedRunCount_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.nextRunTime_ =
            nextRunTimeBuilder_ == null ? nextRunTime_ : nextRunTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.lastPauseTime_ =
            lastPauseTimeBuilder_ == null ? lastPauseTime_ : lastPauseTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.lastResumeTime_ =
            lastResumeTimeBuilder_ == null ? lastResumeTime_ : lastResumeTimeBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.maxConcurrentRunCount_ = maxConcurrentRunCount_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.allowQueueing_ = allowQueueing_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.catchUp_ = catchUp_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.lastScheduledRunResponse_ =
            lastScheduledRunResponseBuilder_ == null
                ? lastScheduledRunResponse_
                : lastScheduledRunResponseBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.Schedule result) {
      result.timeSpecificationCase_ = timeSpecificationCase_;
      result.timeSpecification_ = this.timeSpecification_;
      result.requestCase_ = requestCase_;
      result.request_ = this.request_;
      if (requestCase_ == 14 && createPipelineJobRequestBuilder_ != null) {
        result.request_ = createPipelineJobRequestBuilder_.build();
      }
      if (requestCase_ == 20 && createNotebookExecutionJobRequestBuilder_ != null) {
        result.request_ = createNotebookExecutionJobRequestBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Schedule) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Schedule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Schedule other) {
      if (other == com.google.cloud.aiplatform.v1.Schedule.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.getMaxRunCount() != 0L) {
        setMaxRunCount(other.getMaxRunCount());
      }
      if (other.getStartedRunCount() != 0L) {
        setStartedRunCount(other.getStartedRunCount());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasNextRunTime()) {
        mergeNextRunTime(other.getNextRunTime());
      }
      if (other.hasLastPauseTime()) {
        mergeLastPauseTime(other.getLastPauseTime());
      }
      if (other.hasLastResumeTime()) {
        mergeLastResumeTime(other.getLastResumeTime());
      }
      if (other.getMaxConcurrentRunCount() != 0L) {
        setMaxConcurrentRunCount(other.getMaxConcurrentRunCount());
      }
      if (other.getAllowQueueing() != false) {
        setAllowQueueing(other.getAllowQueueing());
      }
      if (other.getCatchUp() != false) {
        setCatchUp(other.getCatchUp());
      }
      if (other.hasLastScheduledRunResponse()) {
        mergeLastScheduledRunResponse(other.getLastScheduledRunResponse());
      }
      switch (other.getTimeSpecificationCase()) {
        case CRON:
          {
            timeSpecificationCase_ = 10;
            timeSpecification_ = other.timeSpecification_;
            onChanged();
            break;
          }
        case TIMESPECIFICATION_NOT_SET:
          {
            break;
          }
      }
      switch (other.getRequestCase()) {
        case CREATE_PIPELINE_JOB_REQUEST:
          {
            mergeCreatePipelineJobRequest(other.getCreatePipelineJobRequest());
            break;
          }
        case CREATE_NOTEBOOK_EXECUTION_JOB_REQUEST:
          {
            mergeCreateNotebookExecutionJobRequest(other.getCreateNotebookExecutionJobRequest());
            break;
          }
        case REQUEST_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getNextRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getLastPauseTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getLastResumeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                timeSpecificationCase_ = 10;
                timeSpecification_ = s;
                break;
              } // case 82
            case 88:
              {
                maxConcurrentRunCount_ = input.readInt64();
                bitField0_ |= 0x00008000;
                break;
              } // case 88
            case 96:
              {
                allowQueueing_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case 96
            case 104:
              {
                catchUp_ = input.readBool();
                bitField0_ |= 0x00020000;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(
                    getCreatePipelineJobRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 14;
                break;
              } // case 114
            case 128:
              {
                maxRunCount_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 128
            case 136:
              {
                startedRunCount_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 136
            case 146:
              {
                input.readMessage(
                    getLastScheduledRunResponseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getCreateNotebookExecutionJobRequestFieldBuilder().getBuilder(),
                    extensionRegistry);
                requestCase_ = 20;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int timeSpecificationCase_ = 0;
    private java.lang.Object timeSpecification_;

    public TimeSpecificationCase getTimeSpecificationCase() {
      return TimeSpecificationCase.forNumber(timeSpecificationCase_);
    }

    public Builder clearTimeSpecification() {
      timeSpecificationCase_ = 0;
      timeSpecification_ = null;
      onChanged();
      return this;
    }

    private int requestCase_ = 0;
    private java.lang.Object request_;

    public RequestCase getRequestCase() {
      return RequestCase.forNumber(requestCase_);
    }

    public Builder clearRequest() {
      requestCase_ = 0;
      request_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
     * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 10;</code>
     *
     * @return Whether the cron field is set.
     */
    @java.lang.Override
    public boolean hasCron() {
      return timeSpecificationCase_ == 10;
    }

    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
     * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 10;</code>
     *
     * @return The cron.
     */
    @java.lang.Override
    public java.lang.String getCron() {
      java.lang.Object ref = "";
      if (timeSpecificationCase_ == 10) {
        ref = timeSpecification_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (timeSpecificationCase_ == 10) {
          timeSpecification_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
     * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 10;</code>
     *
     * @return The bytes for cron.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCronBytes() {
      java.lang.Object ref = "";
      if (timeSpecificationCase_ == 10) {
        ref = timeSpecification_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (timeSpecificationCase_ == 10) {
          timeSpecification_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
     * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 10;</code>
     *
     * @param value The cron to set.
     * @return This builder for chaining.
     */
    public Builder setCron(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeSpecificationCase_ = 10;
      timeSpecification_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
     * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCron() {
      if (timeSpecificationCase_ == 10) {
        timeSpecificationCase_ = 0;
        timeSpecification_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
     * runs. To explicitly set a timezone to the cron tab, apply a prefix in the
     * cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
     * The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
     * database. For example, "CRON_TZ=America/New_York 1 * * * *", or
     * "TZ=America/New_York 1 * * * *".
     * </pre>
     *
     * <code>string cron = 10;</code>
     *
     * @param value The bytes for cron to set.
     * @return This builder for chaining.
     */
    public Builder setCronBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeSpecificationCase_ = 10;
      timeSpecification_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CreatePipelineJobRequest,
            com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.Builder,
            com.google.cloud.aiplatform.v1.CreatePipelineJobRequestOrBuilder>
        createPipelineJobRequestBuilder_;

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     *
     * @return Whether the createPipelineJobRequest field is set.
     */
    @java.lang.Override
    public boolean hasCreatePipelineJobRequest() {
      return requestCase_ == 14;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     *
     * @return The createPipelineJobRequest.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CreatePipelineJobRequest getCreatePipelineJobRequest() {
      if (createPipelineJobRequestBuilder_ == null) {
        if (requestCase_ == 14) {
          return (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_;
        }
        return com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 14) {
          return createPipelineJobRequestBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     */
    public Builder setCreatePipelineJobRequest(
        com.google.cloud.aiplatform.v1.CreatePipelineJobRequest value) {
      if (createPipelineJobRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        createPipelineJobRequestBuilder_.setMessage(value);
      }
      requestCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     */
    public Builder setCreatePipelineJobRequest(
        com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.Builder builderForValue) {
      if (createPipelineJobRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        createPipelineJobRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     */
    public Builder mergeCreatePipelineJobRequest(
        com.google.cloud.aiplatform.v1.CreatePipelineJobRequest value) {
      if (createPipelineJobRequestBuilder_ == null) {
        if (requestCase_ == 14
            && request_
                != com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.getDefaultInstance()) {
          request_ =
              com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.newBuilder(
                      (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 14) {
          createPipelineJobRequestBuilder_.mergeFrom(value);
        } else {
          createPipelineJobRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     */
    public Builder clearCreatePipelineJobRequest() {
      if (createPipelineJobRequestBuilder_ == null) {
        if (requestCase_ == 14) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 14) {
          requestCase_ = 0;
          request_ = null;
        }
        createPipelineJobRequestBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.Builder
        getCreatePipelineJobRequestBuilder() {
      return getCreatePipelineJobRequestFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CreatePipelineJobRequestOrBuilder
        getCreatePipelineJobRequestOrBuilder() {
      if ((requestCase_ == 14) && (createPipelineJobRequestBuilder_ != null)) {
        return createPipelineJobRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 14) {
          return (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_;
        }
        return com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1.PipelineService.CreatePipelineJob].
     * CreatePipelineJobRequest.parent field is required (format:
     * projects/{project}/locations/{location}).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.CreatePipelineJobRequest create_pipeline_job_request = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CreatePipelineJobRequest,
            com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.Builder,
            com.google.cloud.aiplatform.v1.CreatePipelineJobRequestOrBuilder>
        getCreatePipelineJobRequestFieldBuilder() {
      if (createPipelineJobRequestBuilder_ == null) {
        if (!(requestCase_ == 14)) {
          request_ = com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.getDefaultInstance();
        }
        createPipelineJobRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.CreatePipelineJobRequest,
                com.google.cloud.aiplatform.v1.CreatePipelineJobRequest.Builder,
                com.google.cloud.aiplatform.v1.CreatePipelineJobRequestOrBuilder>(
                (com.google.cloud.aiplatform.v1.CreatePipelineJobRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 14;
      onChanged();
      return createPipelineJobRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest,
            com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.Builder,
            com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequestOrBuilder>
        createNotebookExecutionJobRequestBuilder_;

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     *
     * @return Whether the createNotebookExecutionJobRequest field is set.
     */
    @java.lang.Override
    public boolean hasCreateNotebookExecutionJobRequest() {
      return requestCase_ == 20;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     *
     * @return The createNotebookExecutionJobRequest.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest
        getCreateNotebookExecutionJobRequest() {
      if (createNotebookExecutionJobRequestBuilder_ == null) {
        if (requestCase_ == 20) {
          return (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_;
        }
        return com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest
            .getDefaultInstance();
      } else {
        if (requestCase_ == 20) {
          return createNotebookExecutionJobRequestBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     */
    public Builder setCreateNotebookExecutionJobRequest(
        com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest value) {
      if (createNotebookExecutionJobRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        createNotebookExecutionJobRequestBuilder_.setMessage(value);
      }
      requestCase_ = 20;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     */
    public Builder setCreateNotebookExecutionJobRequest(
        com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.Builder builderForValue) {
      if (createNotebookExecutionJobRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        createNotebookExecutionJobRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 20;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     */
    public Builder mergeCreateNotebookExecutionJobRequest(
        com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest value) {
      if (createNotebookExecutionJobRequestBuilder_ == null) {
        if (requestCase_ == 20
            && request_
                != com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest
                    .getDefaultInstance()) {
          request_ =
              com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.newBuilder(
                      (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 20) {
          createNotebookExecutionJobRequestBuilder_.mergeFrom(value);
        } else {
          createNotebookExecutionJobRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 20;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     */
    public Builder clearCreateNotebookExecutionJobRequest() {
      if (createNotebookExecutionJobRequestBuilder_ == null) {
        if (requestCase_ == 20) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 20) {
          requestCase_ = 0;
          request_ = null;
        }
        createNotebookExecutionJobRequestBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.Builder
        getCreateNotebookExecutionJobRequestBuilder() {
      return getCreateNotebookExecutionJobRequestFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequestOrBuilder
        getCreateNotebookExecutionJobRequestOrBuilder() {
      if ((requestCase_ == 20) && (createNotebookExecutionJobRequestBuilder_ != null)) {
        return createNotebookExecutionJobRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 20) {
          return (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_;
        }
        return com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Request for
     * [NotebookService.CreateNotebookExecutionJob][google.cloud.aiplatform.v1.NotebookService.CreateNotebookExecutionJob].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest create_notebook_execution_job_request = 20;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest,
            com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.Builder,
            com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequestOrBuilder>
        getCreateNotebookExecutionJobRequestFieldBuilder() {
      if (createNotebookExecutionJobRequestBuilder_ == null) {
        if (!(requestCase_ == 20)) {
          request_ =
              com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.getDefaultInstance();
        }
        createNotebookExecutionJobRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest,
                com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest.Builder,
                com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequestOrBuilder>(
                (com.google.cloud.aiplatform.v1.CreateNotebookExecutionJobRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 20;
      onChanged();
      return createNotebookExecutionJobRequestBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Schedule.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Schedule.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Schedule.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Schedule.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the Schedule.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. User provided name of the Schedule.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. User provided name of the Schedule.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. User provided name of the Schedule.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. User provided name of the Schedule.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. User provided name of the Schedule.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which the first run can be scheduled.
     * Default to Schedule create time if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp after which no new runs can be scheduled.
     * If specified, The schedule will be completed when either
     * end_time is reached or when scheduled_run_count &gt;= max_run_count.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private long maxRunCount_;

    /**
     *
     *
     * <pre>
     * Optional. Maximum run count of the schedule.
     * If specified, The schedule will be completed when either
     * started_run_count &gt;= max_run_count or when end_time is reached.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>int64 max_run_count = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxRunCount.
     */
    @java.lang.Override
    public long getMaxRunCount() {
      return maxRunCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Maximum run count of the schedule.
     * If specified, The schedule will be completed when either
     * started_run_count &gt;= max_run_count or when end_time is reached.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>int64 max_run_count = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxRunCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxRunCount(long value) {

      maxRunCount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Maximum run count of the schedule.
     * If specified, The schedule will be completed when either
     * started_run_count &gt;= max_run_count or when end_time is reached.
     * If not specified, new runs will keep getting scheduled until this Schedule
     * is paused or deleted. Already scheduled runs will be allowed to complete.
     * Unset if not specified.
     * </pre>
     *
     * <code>int64 max_run_count = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxRunCount() {
      bitField0_ = (bitField0_ & ~0x00000080);
      maxRunCount_ = 0L;
      onChanged();
      return this;
    }

    private long startedRunCount_;

    /**
     *
     *
     * <pre>
     * Output only. The number of runs started by this schedule.
     * </pre>
     *
     * <code>int64 started_run_count = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The startedRunCount.
     */
    @java.lang.Override
    public long getStartedRunCount() {
      return startedRunCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of runs started by this schedule.
     * </pre>
     *
     * <code>int64 started_run_count = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The startedRunCount to set.
     * @return This builder for chaining.
     */
    public Builder setStartedRunCount(long value) {

      startedRunCount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of runs started by this schedule.
     * </pre>
     *
     * <code>int64 started_run_count = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartedRunCount() {
      bitField0_ = (bitField0_ & ~0x00000100);
      startedRunCount_ = 0L;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The state of this Schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The state of this Schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The state of this Schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schedule.State getState() {
      com.google.cloud.aiplatform.v1.Schedule.State result =
          com.google.cloud.aiplatform.v1.Schedule.State.forNumber(state_);
      return result == null ? com.google.cloud.aiplatform.v1.Schedule.State.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The state of this Schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1.Schedule.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The state of this Schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp nextRunTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        nextRunTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the nextRunTime field is set.
     */
    public boolean hasNextRunTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The nextRunTime.
     */
    public com.google.protobuf.Timestamp getNextRunTime() {
      if (nextRunTimeBuilder_ == null) {
        return nextRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRunTime_;
      } else {
        return nextRunTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNextRunTime(com.google.protobuf.Timestamp value) {
      if (nextRunTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextRunTime_ = value;
      } else {
        nextRunTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setNextRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (nextRunTimeBuilder_ == null) {
        nextRunTime_ = builderForValue.build();
      } else {
        nextRunTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeNextRunTime(com.google.protobuf.Timestamp value) {
      if (nextRunTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && nextRunTime_ != null
            && nextRunTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getNextRunTimeBuilder().mergeFrom(value);
        } else {
          nextRunTime_ = value;
        }
      } else {
        nextRunTimeBuilder_.mergeFrom(value);
      }
      if (nextRunTime_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearNextRunTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      nextRunTime_ = null;
      if (nextRunTimeBuilder_ != null) {
        nextRunTimeBuilder_.dispose();
        nextRunTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getNextRunTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getNextRunTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getNextRunTimeOrBuilder() {
      if (nextRunTimeBuilder_ != null) {
        return nextRunTimeBuilder_.getMessageOrBuilder();
      } else {
        return nextRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRunTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule should schedule the next run.
     * Having a next_run_time in the past means the runs are being started
     * behind schedule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_run_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNextRunTimeFieldBuilder() {
      if (nextRunTimeBuilder_ == null) {
        nextRunTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNextRunTime(), getParentForChildren(), isClean());
        nextRunTime_ = null;
      }
      return nextRunTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastPauseTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastPauseTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastPauseTime field is set.
     */
    public boolean hasLastPauseTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastPauseTime.
     */
    public com.google.protobuf.Timestamp getLastPauseTime() {
      if (lastPauseTimeBuilder_ == null) {
        return lastPauseTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastPauseTime_;
      } else {
        return lastPauseTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastPauseTime(com.google.protobuf.Timestamp value) {
      if (lastPauseTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastPauseTime_ = value;
      } else {
        lastPauseTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastPauseTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastPauseTimeBuilder_ == null) {
        lastPauseTime_ = builderForValue.build();
      } else {
        lastPauseTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastPauseTime(com.google.protobuf.Timestamp value) {
      if (lastPauseTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && lastPauseTime_ != null
            && lastPauseTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastPauseTimeBuilder().mergeFrom(value);
        } else {
          lastPauseTime_ = value;
        }
      } else {
        lastPauseTimeBuilder_.mergeFrom(value);
      }
      if (lastPauseTime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastPauseTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      lastPauseTime_ = null;
      if (lastPauseTimeBuilder_ != null) {
        lastPauseTimeBuilder_.dispose();
        lastPauseTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastPauseTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getLastPauseTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastPauseTimeOrBuilder() {
      if (lastPauseTimeBuilder_ != null) {
        return lastPauseTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastPauseTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastPauseTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last paused.
     * Unset if never paused.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_pause_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastPauseTimeFieldBuilder() {
      if (lastPauseTimeBuilder_ == null) {
        lastPauseTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastPauseTime(), getParentForChildren(), isClean());
        lastPauseTime_ = null;
      }
      return lastPauseTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastResumeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastResumeTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastResumeTime field is set.
     */
    public boolean hasLastResumeTime() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastResumeTime.
     */
    public com.google.protobuf.Timestamp getLastResumeTime() {
      if (lastResumeTimeBuilder_ == null) {
        return lastResumeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastResumeTime_;
      } else {
        return lastResumeTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastResumeTime(com.google.protobuf.Timestamp value) {
      if (lastResumeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastResumeTime_ = value;
      } else {
        lastResumeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastResumeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastResumeTimeBuilder_ == null) {
        lastResumeTime_ = builderForValue.build();
      } else {
        lastResumeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastResumeTime(com.google.protobuf.Timestamp value) {
      if (lastResumeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && lastResumeTime_ != null
            && lastResumeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastResumeTimeBuilder().mergeFrom(value);
        } else {
          lastResumeTime_ = value;
        }
      } else {
        lastResumeTimeBuilder_.mergeFrom(value);
      }
      if (lastResumeTime_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastResumeTime() {
      bitField0_ = (bitField0_ & ~0x00004000);
      lastResumeTime_ = null;
      if (lastResumeTimeBuilder_ != null) {
        lastResumeTimeBuilder_.dispose();
        lastResumeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastResumeTimeBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getLastResumeTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastResumeTimeOrBuilder() {
      if (lastResumeTimeBuilder_ != null) {
        return lastResumeTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastResumeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastResumeTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Schedule was last resumed.
     * Unset if never resumed from pause.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_resume_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastResumeTimeFieldBuilder() {
      if (lastResumeTimeBuilder_ == null) {
        lastResumeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastResumeTime(), getParentForChildren(), isClean());
        lastResumeTime_ = null;
      }
      return lastResumeTimeBuilder_;
    }

    private long maxConcurrentRunCount_;

    /**
     *
     *
     * <pre>
     * Required. Maximum number of runs that can be started concurrently for this
     * Schedule. This is the limit for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * </pre>
     *
     * <code>int64 max_concurrent_run_count = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The maxConcurrentRunCount.
     */
    @java.lang.Override
    public long getMaxConcurrentRunCount() {
      return maxConcurrentRunCount_;
    }

    /**
     *
     *
     * <pre>
     * Required. Maximum number of runs that can be started concurrently for this
     * Schedule. This is the limit for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * </pre>
     *
     * <code>int64 max_concurrent_run_count = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The maxConcurrentRunCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxConcurrentRunCount(long value) {

      maxConcurrentRunCount_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Maximum number of runs that can be started concurrently for this
     * Schedule. This is the limit for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * </pre>
     *
     * <code>int64 max_concurrent_run_count = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxConcurrentRunCount() {
      bitField0_ = (bitField0_ & ~0x00008000);
      maxConcurrentRunCount_ = 0L;
      onChanged();
      return this;
    }

    private boolean allowQueueing_;

    /**
     *
     *
     * <pre>
     * Optional. Whether new scheduled runs can be queued when max_concurrent_runs
     * limit is reached. If set to true, new runs will be queued instead of
     * skipped. Default to false.
     * </pre>
     *
     * <code>bool allow_queueing = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowQueueing.
     */
    @java.lang.Override
    public boolean getAllowQueueing() {
      return allowQueueing_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether new scheduled runs can be queued when max_concurrent_runs
     * limit is reached. If set to true, new runs will be queued instead of
     * skipped. Default to false.
     * </pre>
     *
     * <code>bool allow_queueing = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The allowQueueing to set.
     * @return This builder for chaining.
     */
    public Builder setAllowQueueing(boolean value) {

      allowQueueing_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether new scheduled runs can be queued when max_concurrent_runs
     * limit is reached. If set to true, new runs will be queued instead of
     * skipped. Default to false.
     * </pre>
     *
     * <code>bool allow_queueing = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowQueueing() {
      bitField0_ = (bitField0_ & ~0x00010000);
      allowQueueing_ = false;
      onChanged();
      return this;
    }

    private boolean catchUp_;

    /**
     *
     *
     * <pre>
     * Output only. Whether to backfill missed runs when the schedule is resumed
     * from PAUSED state. If set to true, all missed runs will be scheduled. New
     * runs will be scheduled after the backfill is complete. Default to false.
     * </pre>
     *
     * <code>bool catch_up = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The catchUp.
     */
    @java.lang.Override
    public boolean getCatchUp() {
      return catchUp_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether to backfill missed runs when the schedule is resumed
     * from PAUSED state. If set to true, all missed runs will be scheduled. New
     * runs will be scheduled after the backfill is complete. Default to false.
     * </pre>
     *
     * <code>bool catch_up = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The catchUp to set.
     * @return This builder for chaining.
     */
    public Builder setCatchUp(boolean value) {

      catchUp_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether to backfill missed runs when the schedule is resumed
     * from PAUSED state. If set to true, all missed runs will be scheduled. New
     * runs will be scheduled after the backfill is complete. Default to false.
     * </pre>
     *
     * <code>bool catch_up = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCatchUp() {
      bitField0_ = (bitField0_ & ~0x00020000);
      catchUp_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.Schedule.RunResponse lastScheduledRunResponse_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Schedule.RunResponse,
            com.google.cloud.aiplatform.v1.Schedule.RunResponse.Builder,
            com.google.cloud.aiplatform.v1.Schedule.RunResponseOrBuilder>
        lastScheduledRunResponseBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastScheduledRunResponse field is set.
     */
    public boolean hasLastScheduledRunResponse() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastScheduledRunResponse.
     */
    public com.google.cloud.aiplatform.v1.Schedule.RunResponse getLastScheduledRunResponse() {
      if (lastScheduledRunResponseBuilder_ == null) {
        return lastScheduledRunResponse_ == null
            ? com.google.cloud.aiplatform.v1.Schedule.RunResponse.getDefaultInstance()
            : lastScheduledRunResponse_;
      } else {
        return lastScheduledRunResponseBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastScheduledRunResponse(
        com.google.cloud.aiplatform.v1.Schedule.RunResponse value) {
      if (lastScheduledRunResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastScheduledRunResponse_ = value;
      } else {
        lastScheduledRunResponseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastScheduledRunResponse(
        com.google.cloud.aiplatform.v1.Schedule.RunResponse.Builder builderForValue) {
      if (lastScheduledRunResponseBuilder_ == null) {
        lastScheduledRunResponse_ = builderForValue.build();
      } else {
        lastScheduledRunResponseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastScheduledRunResponse(
        com.google.cloud.aiplatform.v1.Schedule.RunResponse value) {
      if (lastScheduledRunResponseBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && lastScheduledRunResponse_ != null
            && lastScheduledRunResponse_
                != com.google.cloud.aiplatform.v1.Schedule.RunResponse.getDefaultInstance()) {
          getLastScheduledRunResponseBuilder().mergeFrom(value);
        } else {
          lastScheduledRunResponse_ = value;
        }
      } else {
        lastScheduledRunResponseBuilder_.mergeFrom(value);
      }
      if (lastScheduledRunResponse_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastScheduledRunResponse() {
      bitField0_ = (bitField0_ & ~0x00040000);
      lastScheduledRunResponse_ = null;
      if (lastScheduledRunResponseBuilder_ != null) {
        lastScheduledRunResponseBuilder_.dispose();
        lastScheduledRunResponseBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Schedule.RunResponse.Builder
        getLastScheduledRunResponseBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getLastScheduledRunResponseFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Schedule.RunResponseOrBuilder
        getLastScheduledRunResponseOrBuilder() {
      if (lastScheduledRunResponseBuilder_ != null) {
        return lastScheduledRunResponseBuilder_.getMessageOrBuilder();
      } else {
        return lastScheduledRunResponse_ == null
            ? com.google.cloud.aiplatform.v1.Schedule.RunResponse.getDefaultInstance()
            : lastScheduledRunResponse_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Response of the last scheduled run.
     * This is the response for starting the scheduled requests and not the
     * execution of the operations/jobs created by the requests (if applicable).
     * Unset if no run has been scheduled yet.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Schedule.RunResponse last_scheduled_run_response = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Schedule.RunResponse,
            com.google.cloud.aiplatform.v1.Schedule.RunResponse.Builder,
            com.google.cloud.aiplatform.v1.Schedule.RunResponseOrBuilder>
        getLastScheduledRunResponseFieldBuilder() {
      if (lastScheduledRunResponseBuilder_ == null) {
        lastScheduledRunResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Schedule.RunResponse,
                com.google.cloud.aiplatform.v1.Schedule.RunResponse.Builder,
                com.google.cloud.aiplatform.v1.Schedule.RunResponseOrBuilder>(
                getLastScheduledRunResponse(), getParentForChildren(), isClean());
        lastScheduledRunResponse_ = null;
      }
      return lastScheduledRunResponseBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Schedule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Schedule)
  private static final com.google.cloud.aiplatform.v1.Schedule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Schedule();
  }

  public static com.google.cloud.aiplatform.v1.Schedule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Schedule> PARSER =
      new com.google.protobuf.AbstractParser<Schedule>() {
        @java.lang.Override
        public Schedule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Schedule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Schedule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Schedule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
