/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/job_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies].
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest}
 */
public final class SearchModelDeploymentMonitoringStatsAnomaliesRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
    SearchModelDeploymentMonitoringStatsAnomaliesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SearchModelDeploymentMonitoringStatsAnomaliesRequest.newBuilder() to construct.
  private SearchModelDeploymentMonitoringStatsAnomaliesRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchModelDeploymentMonitoringStatsAnomaliesRequest() {
    modelDeploymentMonitoringJob_ = "";
    deployedModelId_ = "";
    featureDisplayName_ = "";
    objectives_ = java.util.Collections.emptyList();
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchModelDeploymentMonitoringStatsAnomaliesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.JobServiceProto
        .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.JobServiceProto
        .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .class,
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .Builder.class);
  }

  public interface StatsAnomaliesObjectiveOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();

    /**
     * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
     *
     * @return The type.
     */
    com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType getType();

    /**
     *
     *
     * <pre>
     * If set, all attribution scores between
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time]
     * and
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time]
     * are fetched, and page token doesn't take effect in this case. Only used
     * to retrieve attribution score for the top Features which has the highest
     * attribution score in the latest monitoring run.
     * </pre>
     *
     * <code>int32 top_feature_count = 4;</code>
     *
     * @return The topFeatureCount.
     */
    int getTopFeatureCount();
  }

  /**
   *
   *
   * <pre>
   * Stats requested for specific objective.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective}
   */
  public static final class StatsAnomaliesObjective extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
      StatsAnomaliesObjectiveOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use StatsAnomaliesObjective.newBuilder() to construct.
    private StatsAnomaliesObjective(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StatsAnomaliesObjective() {
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StatsAnomaliesObjective();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjective.class,
              com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjective.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;

    /**
     * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType getType() {
      com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType result =
          com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.forNumber(type_);
      return result == null
          ? com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.UNRECOGNIZED
          : result;
    }

    public static final int TOP_FEATURE_COUNT_FIELD_NUMBER = 4;
    private int topFeatureCount_ = 0;

    /**
     *
     *
     * <pre>
     * If set, all attribution scores between
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time]
     * and
     * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time]
     * are fetched, and page token doesn't take effect in this case. Only used
     * to retrieve attribution score for the top Features which has the highest
     * attribution score in the latest monitoring run.
     * </pre>
     *
     * <code>int32 top_feature_count = 4;</code>
     *
     * @return The topFeatureCount.
     */
    @java.lang.Override
    public int getTopFeatureCount() {
      return topFeatureCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType
              .MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      if (topFeatureCount_ != 0) {
        output.writeInt32(4, topFeatureCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType
              .MODEL_DEPLOYMENT_MONITORING_OBJECTIVE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (topFeatureCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, topFeatureCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective
          other =
              (com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                      .StatsAnomaliesObjective)
                  obj;

      if (type_ != other.type_) return false;
      if (getTopFeatureCount() != other.getTopFeatureCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + TOP_FEATURE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTopFeatureCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Stats requested for specific objective.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjectiveOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.JobServiceProto
            .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.JobServiceProto
            .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjective.class,
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjective.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        topFeatureCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.JobServiceProto
            .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_StatsAnomaliesObjective_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective
          build() {
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective
          buildPartial() {
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            result =
                new com.google.cloud.aiplatform.v1
                    .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective(
                    this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjective
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.topFeatureCount_ = topFeatureCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                      .StatsAnomaliesObjective)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjective
              other) {
        if (other
            == com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getTopFeatureCount() != 0) {
          setTopFeatureCount(other.getTopFeatureCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 32:
                {
                  topFeatureCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;

      /**
       * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType getType() {
        com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType result =
            com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.forNumber(type_);
        return result == null
            ? com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType.UNRECOGNIZED
            : result;
      }

      /**
       * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       * <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveType type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private int topFeatureCount_;

      /**
       *
       *
       * <pre>
       * If set, all attribution scores between
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time]
       * and
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time]
       * are fetched, and page token doesn't take effect in this case. Only used
       * to retrieve attribution score for the top Features which has the highest
       * attribution score in the latest monitoring run.
       * </pre>
       *
       * <code>int32 top_feature_count = 4;</code>
       *
       * @return The topFeatureCount.
       */
      @java.lang.Override
      public int getTopFeatureCount() {
        return topFeatureCount_;
      }

      /**
       *
       *
       * <pre>
       * If set, all attribution scores between
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time]
       * and
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time]
       * are fetched, and page token doesn't take effect in this case. Only used
       * to retrieve attribution score for the top Features which has the highest
       * attribution score in the latest monitoring run.
       * </pre>
       *
       * <code>int32 top_feature_count = 4;</code>
       *
       * @param value The topFeatureCount to set.
       * @return This builder for chaining.
       */
      public Builder setTopFeatureCount(int value) {

        topFeatureCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, all attribution scores between
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time]
       * and
       * [SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time][google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time]
       * are fetched, and page token doesn't take effect in this case. Only used
       * to retrieve attribution score for the top Features which has the highest
       * attribution score in the latest monitoring run.
       * </pre>
       *
       * <code>int32 top_feature_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopFeatureCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        topFeatureCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective)
    private static final com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective();
    }

    public static com.google.cloud.aiplatform.v1
            .SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StatsAnomaliesObjective> PARSER =
        new com.google.protobuf.AbstractParser<StatsAnomaliesObjective>() {
          @java.lang.Override
          public StatsAnomaliesObjective parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StatsAnomaliesObjective> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatsAnomaliesObjective> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelDeploymentMonitoringJob_ = "";

  /**
   *
   *
   * <pre>
   * Required. ModelDeploymentMonitoring Job resource name.
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public java.lang.String getModelDeploymentMonitoringJob() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelDeploymentMonitoringJob_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. ModelDeploymentMonitoring Job resource name.
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelDeploymentMonitoringJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_MODEL_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployedModelId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The DeployedModel ID of the
   * [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
   * </pre>
   *
   * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The deployedModelId.
   */
  @java.lang.Override
  public java.lang.String getDeployedModelId() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedModelId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The DeployedModel ID of the
   * [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
   * </pre>
   *
   * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for deployedModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedModelIdBytes() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEATURE_DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object featureDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * The feature display name. If specified, only return the stats belonging to
   * this feature. Format:
   * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
   * example: "user_destination".
   * </pre>
   *
   * <code>string feature_display_name = 3;</code>
   *
   * @return The featureDisplayName.
   */
  @java.lang.Override
  public java.lang.String getFeatureDisplayName() {
    java.lang.Object ref = featureDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      featureDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The feature display name. If specified, only return the stats belonging to
   * this feature. Format:
   * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
   * example: "user_destination".
   * </pre>
   *
   * <code>string feature_display_name = 3;</code>
   *
   * @return The bytes for featureDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeatureDisplayNameBytes() {
    java.lang.Object ref = featureDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      featureDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBJECTIVES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective>
      objectives_;

  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .StatsAnomaliesObjective>
      getObjectivesList() {
    return objectives_;
  }

  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjectiveOrBuilder>
      getObjectivesOrBuilderList() {
    return objectives_;
  }

  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getObjectivesCount() {
    return objectives_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          .StatsAnomaliesObjective
      getObjectives(int index) {
    return objectives_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. Objectives of the stats to retrieve.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          .StatsAnomaliesObjectiveOrBuilder
      getObjectivesOrBuilder(int index) {
    return objectives_.get(index);
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 5;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * The standard list page size.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
   * call.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A page token received from a previous
   * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
   * call.
   * </pre>
   *
   * <code>string page_token = 6;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * The earliest timestamp of stats being generated.
   * If not set, indicates fetching stats till the earliest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The earliest timestamp of stats being generated.
   * If not set, indicates fetching stats till the earliest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * The earliest timestamp of stats being generated.
   * If not set, indicates fetching stats till the earliest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * The latest timestamp of stats being generated.
   * If not set, indicates feching stats till the latest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The latest timestamp of stats being generated.
   * If not set, indicates feching stats till the latest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * The latest timestamp of stats being generated.
   * If not set, indicates feching stats till the latest possible one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDeploymentMonitoringJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelDeploymentMonitoringJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedModelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, featureDisplayName_);
    }
    for (int i = 0; i < objectives_.size(); i++) {
      output.writeMessage(4, objectives_.get(i));
    }
    if (pageSize_ != 0) {
      output.writeInt32(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDeploymentMonitoringJob_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              1, modelDeploymentMonitoringJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedModelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, featureDisplayName_);
    }
    for (int i = 0; i < objectives_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, objectives_.get(i));
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest other =
        (com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest) obj;

    if (!getModelDeploymentMonitoringJob().equals(other.getModelDeploymentMonitoringJob()))
      return false;
    if (!getDeployedModelId().equals(other.getDeployedModelId())) return false;
    if (!getFeatureDisplayName().equals(other.getFeatureDisplayName())) return false;
    if (!getObjectivesList().equals(other.getObjectivesList())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getModelDeploymentMonitoringJob().hashCode();
    hash = (37 * hash) + DEPLOYED_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedModelId().hashCode();
    hash = (37 * hash) + FEATURE_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFeatureDisplayName().hashCode();
    if (getObjectivesCount() > 0) {
      hash = (37 * hash) + OBJECTIVES_FIELD_NUMBER;
      hash = (53 * hash) + getObjectivesList().hashCode();
    }
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
      com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .class,
              com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getObjectivesFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      modelDeploymentMonitoringJob_ = "";
      deployedModelId_ = "";
      featureDisplayName_ = "";
      if (objectivesBuilder_ == null) {
        objectives_ = java.util.Collections.emptyList();
      } else {
        objectives_ = null;
        objectivesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      pageSize_ = 0;
      pageToken_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.JobServiceProto
          .internal_static_google_cloud_aiplatform_v1_SearchModelDeploymentMonitoringStatsAnomaliesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
        build() {
      com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
        buildPartial() {
      com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest result =
          new com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest(
              this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            result) {
      if (objectivesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          objectives_ = java.util.Collections.unmodifiableList(objectives_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.objectives_ = objectives_;
      } else {
        result.objectives_ = objectivesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.modelDeploymentMonitoringJob_ = modelDeploymentMonitoringJob_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployedModelId_ = deployedModelId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.featureDisplayName_ = featureDisplayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pageToken_ = pageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest other) {
      if (other
          == com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
              .getDefaultInstance()) return this;
      if (!other.getModelDeploymentMonitoringJob().isEmpty()) {
        modelDeploymentMonitoringJob_ = other.modelDeploymentMonitoringJob_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDeployedModelId().isEmpty()) {
        deployedModelId_ = other.deployedModelId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFeatureDisplayName().isEmpty()) {
        featureDisplayName_ = other.featureDisplayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (objectivesBuilder_ == null) {
        if (!other.objectives_.isEmpty()) {
          if (objectives_.isEmpty()) {
            objectives_ = other.objectives_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureObjectivesIsMutable();
            objectives_.addAll(other.objectives_);
          }
          onChanged();
        }
      } else {
        if (!other.objectives_.isEmpty()) {
          if (objectivesBuilder_.isEmpty()) {
            objectivesBuilder_.dispose();
            objectivesBuilder_ = null;
            objectives_ = other.objectives_;
            bitField0_ = (bitField0_ & ~0x00000008);
            objectivesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectivesFieldBuilder()
                    : null;
          } else {
            objectivesBuilder_.addAllMessages(other.objectives_);
          }
        }
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                modelDeploymentMonitoringJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                deployedModelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                featureDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                        .StatsAnomaliesObjective
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1
                                .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                                .StatsAnomaliesObjective.parser(),
                            extensionRegistry);
                if (objectivesBuilder_ == null) {
                  ensureObjectivesIsMutable();
                  objectives_.add(m);
                } else {
                  objectivesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object modelDeploymentMonitoringJob_ = "";

    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The modelDeploymentMonitoringJob.
     */
    public java.lang.String getModelDeploymentMonitoringJob() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDeploymentMonitoringJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for modelDeploymentMonitoringJob.
     */
    public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDeploymentMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelDeploymentMonitoringJob_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelDeploymentMonitoringJob() {
      modelDeploymentMonitoringJob_ = getDefaultInstance().getModelDeploymentMonitoringJob();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. ModelDeploymentMonitoring Job resource name.
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelDeploymentMonitoringJob_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object deployedModelId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployedModelId.
     */
    public java.lang.String getDeployedModelId() {
      java.lang.Object ref = deployedModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployedModelId.
     */
    public com.google.protobuf.ByteString getDeployedModelIdBytes() {
      java.lang.Object ref = deployedModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedModelId() {
      deployedModelId_ = getDefaultInstance().getDeployedModelId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The DeployedModel ID of the
     * [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object featureDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @return The featureDisplayName.
     */
    public java.lang.String getFeatureDisplayName() {
      java.lang.Object ref = featureDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @return The bytes for featureDisplayName.
     */
    public com.google.protobuf.ByteString getFeatureDisplayNameBytes() {
      java.lang.Object ref = featureDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @param value The featureDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      featureDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureDisplayName() {
      featureDisplayName_ = getDefaultInstance().getFeatureDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The feature display name. If specified, only return the stats belonging to
     * this feature. Format:
     * [ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name][google.cloud.aiplatform.v1.ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name],
     * example: "user_destination".
     * </pre>
     *
     * <code>string feature_display_name = 3;</code>
     *
     * @param value The bytes for featureDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      featureDisplayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective>
        objectives_ = java.util.Collections.emptyList();

    private void ensureObjectivesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        objectives_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjective>(objectives_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective,
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder,
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjectiveOrBuilder>
        objectivesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective>
        getObjectivesList() {
      if (objectivesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectives_);
      } else {
        return objectivesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getObjectivesCount() {
      if (objectivesBuilder_ == null) {
        return objectives_.size();
      } else {
        return objectivesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective
        getObjectives(int index) {
      if (objectivesBuilder_ == null) {
        return objectives_.get(index);
      } else {
        return objectivesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setObjectives(
        int index,
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            value) {
      if (objectivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectivesIsMutable();
        objectives_.set(index, value);
        onChanged();
      } else {
        objectivesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setObjectives(
        int index,
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder
            builderForValue) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectivesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            value) {
      if (objectivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectivesIsMutable();
        objectives_.add(value);
        onChanged();
      } else {
        objectivesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        int index,
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective
            value) {
      if (objectivesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectivesIsMutable();
        objectives_.add(index, value);
        onChanged();
      } else {
        objectivesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder
            builderForValue) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.add(builderForValue.build());
        onChanged();
      } else {
        objectivesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addObjectives(
        int index,
        com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder
            builderForValue) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectivesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllObjectives(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1
                        .SearchModelDeploymentMonitoringStatsAnomaliesRequest
                        .StatsAnomaliesObjective>
            values) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectives_);
        onChanged();
      } else {
        objectivesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearObjectives() {
      if (objectivesBuilder_ == null) {
        objectives_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        objectivesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeObjectives(int index) {
      if (objectivesBuilder_ == null) {
        ensureObjectivesIsMutable();
        objectives_.remove(index);
        onChanged();
      } else {
        objectivesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective.Builder
        getObjectivesBuilder(int index) {
      return getObjectivesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjectiveOrBuilder
        getObjectivesOrBuilder(int index) {
      if (objectivesBuilder_ == null) {
        return objectives_.get(index);
      } else {
        return objectivesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjectiveOrBuilder>
        getObjectivesOrBuilderList() {
      if (objectivesBuilder_ != null) {
        return objectivesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectives_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective.Builder
        addObjectivesBuilder() {
      return getObjectivesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjective.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
            .StatsAnomaliesObjective.Builder
        addObjectivesBuilder(int index) {
      return getObjectivesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                  .StatsAnomaliesObjective.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. Objectives of the stats to retrieve.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest.StatsAnomaliesObjective objectives = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder>
        getObjectivesBuilderList() {
      return getObjectivesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective,
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjective.Builder,
            com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                .StatsAnomaliesObjectiveOrBuilder>
        getObjectivesFieldBuilder() {
      if (objectivesBuilder_ == null) {
        objectivesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjective,
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjective.Builder,
                com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
                    .StatsAnomaliesObjectiveOrBuilder>(
                objectives_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        objectives_ = null;
      }
      return objectivesBuilder_;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The standard list page size.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000010);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A page token received from a previous
     * [JobService.SearchModelDeploymentMonitoringStatsAnomalies][google.cloud.aiplatform.v1.JobService.SearchModelDeploymentMonitoringStatsAnomalies]
     * call.
     * </pre>
     *
     * <code>string page_token = 6;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The earliest timestamp of stats being generated.
     * If not set, indicates fetching stats till the earliest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The latest timestamp of stats being generated.
     * If not set, indicates feching stats till the latest possible one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest)
  private static final com.google.cloud.aiplatform.v1
          .SearchModelDeploymentMonitoringStatsAnomaliesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest();
  }

  public static com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          SearchModelDeploymentMonitoringStatsAnomaliesRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<
              SearchModelDeploymentMonitoringStatsAnomaliesRequest>() {
            @java.lang.Override
            public SearchModelDeploymentMonitoringStatsAnomaliesRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<SearchModelDeploymentMonitoringStatsAnomaliesRequest>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchModelDeploymentMonitoringStatsAnomaliesRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SearchModelDeploymentMonitoringStatsAnomaliesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
