/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/service_networking.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * DNS peering configuration. These configurations are used to create
 * DNS peering zones in the Vertex tenant project VPC, enabling resolution
 * of records within the specified domain hosted in the target network's
 * Cloud DNS.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DnsPeeringConfig}
 */
public final class DnsPeeringConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DnsPeeringConfig)
    DnsPeeringConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DnsPeeringConfig.newBuilder() to construct.
  private DnsPeeringConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DnsPeeringConfig() {
    domain_ = "";
    targetProject_ = "";
    targetNetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DnsPeeringConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ServiceNetworkingProto
        .internal_static_google_cloud_aiplatform_v1_DnsPeeringConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ServiceNetworkingProto
        .internal_static_google_cloud_aiplatform_v1_DnsPeeringConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DnsPeeringConfig.class,
            com.google.cloud.aiplatform.v1.DnsPeeringConfig.Builder.class);
  }

  public static final int DOMAIN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domain_ = "";

  /**
   *
   *
   * <pre>
   * Required. The DNS name suffix of the zone being peered to, e.g.,
   * "my-internal-domain.corp.". Must end with a dot.
   * </pre>
   *
   * <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The domain.
   */
  @java.lang.Override
  public java.lang.String getDomain() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domain_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The DNS name suffix of the zone being peered to, e.g.,
   * "my-internal-domain.corp.". Must end with a dot.
   * </pre>
   *
   * <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for domain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainBytes() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_PROJECT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetProject_ = "";

  /**
   *
   *
   * <pre>
   * Required. The project ID hosting the Cloud DNS managed zone that
   * contains the 'domain'. The Vertex AI Service Agent requires the
   * dns.peer role on this project.
   * </pre>
   *
   * <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetProject.
   */
  @java.lang.Override
  public java.lang.String getTargetProject() {
    java.lang.Object ref = targetProject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetProject_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The project ID hosting the Cloud DNS managed zone that
   * contains the 'domain'. The Vertex AI Service Agent requires the
   * dns.peer role on this project.
   * </pre>
   *
   * <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetProject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetProjectBytes() {
    java.lang.Object ref = targetProject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetProject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_NETWORK_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetNetwork_ = "";

  /**
   *
   *
   * <pre>
   * Required. The VPC network name
   * in the target_project where the DNS zone specified by 'domain' is
   * visible.
   * </pre>
   *
   * <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetNetwork.
   */
  @java.lang.Override
  public java.lang.String getTargetNetwork() {
    java.lang.Object ref = targetNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetNetwork_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The VPC network name
   * in the target_project where the DNS zone specified by 'domain' is
   * visible.
   * </pre>
   *
   * <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetNetworkBytes() {
    java.lang.Object ref = targetNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domain_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetProject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetProject_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetNetwork_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, domain_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetProject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetProject_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, targetNetwork_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DnsPeeringConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DnsPeeringConfig other =
        (com.google.cloud.aiplatform.v1.DnsPeeringConfig) obj;

    if (!getDomain().equals(other.getDomain())) return false;
    if (!getTargetProject().equals(other.getTargetProject())) return false;
    if (!getTargetNetwork().equals(other.getTargetNetwork())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
    hash = (53 * hash) + getDomain().hashCode();
    hash = (37 * hash) + TARGET_PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getTargetProject().hashCode();
    hash = (37 * hash) + TARGET_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getTargetNetwork().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.DnsPeeringConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * DNS peering configuration. These configurations are used to create
   * DNS peering zones in the Vertex tenant project VPC, enabling resolution
   * of records within the specified domain hosted in the target network's
   * Cloud DNS.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DnsPeeringConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DnsPeeringConfig)
      com.google.cloud.aiplatform.v1.DnsPeeringConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ServiceNetworkingProto
          .internal_static_google_cloud_aiplatform_v1_DnsPeeringConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ServiceNetworkingProto
          .internal_static_google_cloud_aiplatform_v1_DnsPeeringConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DnsPeeringConfig.class,
              com.google.cloud.aiplatform.v1.DnsPeeringConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DnsPeeringConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      domain_ = "";
      targetProject_ = "";
      targetNetwork_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ServiceNetworkingProto
          .internal_static_google_cloud_aiplatform_v1_DnsPeeringConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DnsPeeringConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DnsPeeringConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DnsPeeringConfig build() {
      com.google.cloud.aiplatform.v1.DnsPeeringConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DnsPeeringConfig buildPartial() {
      com.google.cloud.aiplatform.v1.DnsPeeringConfig result =
          new com.google.cloud.aiplatform.v1.DnsPeeringConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.DnsPeeringConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.domain_ = domain_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.targetProject_ = targetProject_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.targetNetwork_ = targetNetwork_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DnsPeeringConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DnsPeeringConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DnsPeeringConfig other) {
      if (other == com.google.cloud.aiplatform.v1.DnsPeeringConfig.getDefaultInstance())
        return this;
      if (!other.getDomain().isEmpty()) {
        domain_ = other.domain_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTargetProject().isEmpty()) {
        targetProject_ = other.targetProject_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getTargetNetwork().isEmpty()) {
        targetNetwork_ = other.targetNetwork_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                domain_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                targetProject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                targetNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object domain_ = "";

    /**
     *
     *
     * <pre>
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     * </pre>
     *
     * <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The domain.
     */
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     * </pre>
     *
     * <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for domain.
     */
    public com.google.protobuf.ByteString getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     * </pre>
     *
     * <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domain_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     * </pre>
     *
     * <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomain() {
      domain_ = getDefaultInstance().getDomain();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The DNS name suffix of the zone being peered to, e.g.,
     * "my-internal-domain.corp.". Must end with a dot.
     * </pre>
     *
     * <code>string domain = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domain_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object targetProject_ = "";

    /**
     *
     *
     * <pre>
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     * </pre>
     *
     * <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetProject.
     */
    public java.lang.String getTargetProject() {
      java.lang.Object ref = targetProject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetProject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     * </pre>
     *
     * <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetProject.
     */
    public com.google.protobuf.ByteString getTargetProjectBytes() {
      java.lang.Object ref = targetProject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetProject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     * </pre>
     *
     * <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetProject to set.
     * @return This builder for chaining.
     */
    public Builder setTargetProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetProject_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     * </pre>
     *
     * <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetProject() {
      targetProject_ = getDefaultInstance().getTargetProject();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The project ID hosting the Cloud DNS managed zone that
     * contains the 'domain'. The Vertex AI Service Agent requires the
     * dns.peer role on this project.
     * </pre>
     *
     * <code>string target_project = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetProject to set.
     * @return This builder for chaining.
     */
    public Builder setTargetProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetProject_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object targetNetwork_ = "";

    /**
     *
     *
     * <pre>
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     * </pre>
     *
     * <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetNetwork.
     */
    public java.lang.String getTargetNetwork() {
      java.lang.Object ref = targetNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     * </pre>
     *
     * <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetNetwork.
     */
    public com.google.protobuf.ByteString getTargetNetworkBytes() {
      java.lang.Object ref = targetNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     * </pre>
     *
     * <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setTargetNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetNetwork_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     * </pre>
     *
     * <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetNetwork() {
      targetNetwork_ = getDefaultInstance().getTargetNetwork();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The VPC network name
     * in the target_project where the DNS zone specified by 'domain' is
     * visible.
     * </pre>
     *
     * <code>string target_network = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setTargetNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetNetwork_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DnsPeeringConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DnsPeeringConfig)
  private static final com.google.cloud.aiplatform.v1.DnsPeeringConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DnsPeeringConfig();
  }

  public static com.google.cloud.aiplatform.v1.DnsPeeringConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DnsPeeringConfig> PARSER =
      new com.google.protobuf.AbstractParser<DnsPeeringConfig>() {
        @java.lang.Override
        public DnsPeeringConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DnsPeeringConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DnsPeeringConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DnsPeeringConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
