/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tool.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Partial argument value of the function call.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.PartialArg}
 */
public final class PartialArg extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PartialArg)
    PartialArgOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PartialArg.newBuilder() to construct.
  private PartialArg(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartialArg() {
    jsonPath_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartialArg();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_PartialArg_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_PartialArg_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.PartialArg.class,
            com.google.cloud.aiplatform.v1.PartialArg.Builder.class);
  }

  private int deltaCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object delta_;

  public enum DeltaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NULL_VALUE(2),
    NUMBER_VALUE(3),
    STRING_VALUE(4),
    BOOL_VALUE(5),
    DELTA_NOT_SET(0);
    private final int value;

    private DeltaCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeltaCase valueOf(int value) {
      return forNumber(value);
    }

    public static DeltaCase forNumber(int value) {
      switch (value) {
        case 2:
          return NULL_VALUE;
        case 3:
          return NUMBER_VALUE;
        case 4:
          return STRING_VALUE;
        case 5:
          return BOOL_VALUE;
        case 0:
          return DELTA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DeltaCase getDeltaCase() {
    return DeltaCase.forNumber(deltaCase_);
  }

  public static final int NULL_VALUE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Optional. Represents a null value.
   * </pre>
   *
   * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the nullValue field is set.
   */
  public boolean hasNullValue() {
    return deltaCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Optional. Represents a null value.
   * </pre>
   *
   * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for nullValue.
   */
  public int getNullValueValue() {
    if (deltaCase_ == 2) {
      return (java.lang.Integer) delta_;
    }
    return 0;
  }

  /**
   *
   *
   * <pre>
   * Optional. Represents a null value.
   * </pre>
   *
   * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nullValue.
   */
  public com.google.protobuf.NullValue getNullValue() {
    if (deltaCase_ == 2) {
      com.google.protobuf.NullValue result =
          com.google.protobuf.NullValue.forNumber((java.lang.Integer) delta_);
      return result == null ? com.google.protobuf.NullValue.UNRECOGNIZED : result;
    }
    return com.google.protobuf.NullValue.NULL_VALUE;
  }

  public static final int NUMBER_VALUE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Optional. Represents a double value.
   * </pre>
   *
   * <code>double number_value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the numberValue field is set.
   */
  @java.lang.Override
  public boolean hasNumberValue() {
    return deltaCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Optional. Represents a double value.
   * </pre>
   *
   * <code>double number_value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The numberValue.
   */
  @java.lang.Override
  public double getNumberValue() {
    if (deltaCase_ == 3) {
      return (java.lang.Double) delta_;
    }
    return 0D;
  }

  public static final int STRING_VALUE_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Optional. Represents a string value.
   * </pre>
   *
   * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the stringValue field is set.
   */
  public boolean hasStringValue() {
    return deltaCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Optional. Represents a string value.
   * </pre>
   *
   * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The stringValue.
   */
  public java.lang.String getStringValue() {
    java.lang.Object ref = "";
    if (deltaCase_ == 4) {
      ref = delta_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (deltaCase_ == 4) {
        delta_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Represents a string value.
   * </pre>
   *
   * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for stringValue.
   */
  public com.google.protobuf.ByteString getStringValueBytes() {
    java.lang.Object ref = "";
    if (deltaCase_ == 4) {
      ref = delta_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (deltaCase_ == 4) {
        delta_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BOOL_VALUE_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Optional. Represents a boolean value.
   * </pre>
   *
   * <code>bool bool_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the boolValue field is set.
   */
  @java.lang.Override
  public boolean hasBoolValue() {
    return deltaCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Optional. Represents a boolean value.
   * </pre>
   *
   * <code>bool bool_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The boolValue.
   */
  @java.lang.Override
  public boolean getBoolValue() {
    if (deltaCase_ == 5) {
      return (java.lang.Boolean) delta_;
    }
    return false;
  }

  public static final int JSON_PATH_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jsonPath_ = "";

  /**
   *
   *
   * <pre>
   * Required. A JSON Path (RFC 9535) to the argument being streamed.
   * https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
   * </pre>
   *
   * <code>string json_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The jsonPath.
   */
  @java.lang.Override
  public java.lang.String getJsonPath() {
    java.lang.Object ref = jsonPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jsonPath_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. A JSON Path (RFC 9535) to the argument being streamed.
   * https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
   * </pre>
   *
   * <code>string json_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for jsonPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJsonPathBytes() {
    java.lang.Object ref = jsonPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jsonPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WILL_CONTINUE_FIELD_NUMBER = 6;
  private boolean willContinue_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether this is not the last part of the same json_path.
   * If true, another PartialArg message for the current json_path is expected
   * to follow.
   * </pre>
   *
   * <code>bool will_continue = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The willContinue.
   */
  @java.lang.Override
  public boolean getWillContinue() {
    return willContinue_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jsonPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jsonPath_);
    }
    if (deltaCase_ == 2) {
      output.writeEnum(2, ((java.lang.Integer) delta_));
    }
    if (deltaCase_ == 3) {
      output.writeDouble(3, (double) ((java.lang.Double) delta_));
    }
    if (deltaCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, delta_);
    }
    if (deltaCase_ == 5) {
      output.writeBool(5, (boolean) ((java.lang.Boolean) delta_));
    }
    if (willContinue_ != false) {
      output.writeBool(6, willContinue_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jsonPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jsonPath_);
    }
    if (deltaCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(2, ((java.lang.Integer) delta_));
    }
    if (deltaCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              3, (double) ((java.lang.Double) delta_));
    }
    if (deltaCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, delta_);
    }
    if (deltaCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              5, (boolean) ((java.lang.Boolean) delta_));
    }
    if (willContinue_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, willContinue_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.PartialArg)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.PartialArg other =
        (com.google.cloud.aiplatform.v1.PartialArg) obj;

    if (!getJsonPath().equals(other.getJsonPath())) return false;
    if (getWillContinue() != other.getWillContinue()) return false;
    if (!getDeltaCase().equals(other.getDeltaCase())) return false;
    switch (deltaCase_) {
      case 2:
        if (getNullValueValue() != other.getNullValueValue()) return false;
        break;
      case 3:
        if (java.lang.Double.doubleToLongBits(getNumberValue())
            != java.lang.Double.doubleToLongBits(other.getNumberValue())) return false;
        break;
      case 4:
        if (!getStringValue().equals(other.getStringValue())) return false;
        break;
      case 5:
        if (getBoolValue() != other.getBoolValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + JSON_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getJsonPath().hashCode();
    hash = (37 * hash) + WILL_CONTINUE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getWillContinue());
    switch (deltaCase_) {
      case 2:
        hash = (37 * hash) + NULL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getNullValueValue();
        break;
      case 3:
        hash = (37 * hash) + NUMBER_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getNumberValue()));
        break;
      case 4:
        hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringValue().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BOOL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBoolValue());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PartialArg parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.PartialArg prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Partial argument value of the function call.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PartialArg}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PartialArg)
      com.google.cloud.aiplatform.v1.PartialArgOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_PartialArg_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_PartialArg_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PartialArg.class,
              com.google.cloud.aiplatform.v1.PartialArg.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.PartialArg.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      jsonPath_ = "";
      willContinue_ = false;
      deltaCase_ = 0;
      delta_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_PartialArg_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PartialArg getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.PartialArg.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PartialArg build() {
      com.google.cloud.aiplatform.v1.PartialArg result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PartialArg buildPartial() {
      com.google.cloud.aiplatform.v1.PartialArg result =
          new com.google.cloud.aiplatform.v1.PartialArg(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.PartialArg result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.jsonPath_ = jsonPath_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.willContinue_ = willContinue_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.PartialArg result) {
      result.deltaCase_ = deltaCase_;
      result.delta_ = this.delta_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.PartialArg) {
        return mergeFrom((com.google.cloud.aiplatform.v1.PartialArg) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.PartialArg other) {
      if (other == com.google.cloud.aiplatform.v1.PartialArg.getDefaultInstance()) return this;
      if (!other.getJsonPath().isEmpty()) {
        jsonPath_ = other.jsonPath_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getWillContinue() != false) {
        setWillContinue(other.getWillContinue());
      }
      switch (other.getDeltaCase()) {
        case NULL_VALUE:
          {
            setNullValueValue(other.getNullValueValue());
            break;
          }
        case NUMBER_VALUE:
          {
            setNumberValue(other.getNumberValue());
            break;
          }
        case STRING_VALUE:
          {
            deltaCase_ = 4;
            delta_ = other.delta_;
            onChanged();
            break;
          }
        case BOOL_VALUE:
          {
            setBoolValue(other.getBoolValue());
            break;
          }
        case DELTA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                jsonPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 10
            case 16:
              {
                int rawValue = input.readEnum();
                deltaCase_ = 2;
                delta_ = rawValue;
                break;
              } // case 16
            case 25:
              {
                delta_ = input.readDouble();
                deltaCase_ = 3;
                break;
              } // case 25
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                deltaCase_ = 4;
                delta_ = s;
                break;
              } // case 34
            case 40:
              {
                delta_ = input.readBool();
                deltaCase_ = 5;
                break;
              } // case 40
            case 48:
              {
                willContinue_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int deltaCase_ = 0;
    private java.lang.Object delta_;

    public DeltaCase getDeltaCase() {
      return DeltaCase.forNumber(deltaCase_);
    }

    public Builder clearDelta() {
      deltaCase_ = 0;
      delta_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Optional. Represents a null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the nullValue field is set.
     */
    @java.lang.Override
    public boolean hasNullValue() {
      return deltaCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for nullValue.
     */
    @java.lang.Override
    public int getNullValueValue() {
      if (deltaCase_ == 2) {
        return ((java.lang.Integer) delta_).intValue();
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for nullValue to set.
     * @return This builder for chaining.
     */
    public Builder setNullValueValue(int value) {
      deltaCase_ = 2;
      delta_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nullValue.
     */
    @java.lang.Override
    public com.google.protobuf.NullValue getNullValue() {
      if (deltaCase_ == 2) {
        com.google.protobuf.NullValue result =
            com.google.protobuf.NullValue.forNumber((java.lang.Integer) delta_);
        return result == null ? com.google.protobuf.NullValue.UNRECOGNIZED : result;
      }
      return com.google.protobuf.NullValue.NULL_VALUE;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The nullValue to set.
     * @return This builder for chaining.
     */
    public Builder setNullValue(com.google.protobuf.NullValue value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deltaCase_ = 2;
      delta_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a null value.
     * </pre>
     *
     * <code>.google.protobuf.NullValue null_value = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNullValue() {
      if (deltaCase_ == 2) {
        deltaCase_ = 0;
        delta_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a double value.
     * </pre>
     *
     * <code>double number_value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the numberValue field is set.
     */
    public boolean hasNumberValue() {
      return deltaCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a double value.
     * </pre>
     *
     * <code>double number_value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The numberValue.
     */
    public double getNumberValue() {
      if (deltaCase_ == 3) {
        return (java.lang.Double) delta_;
      }
      return 0D;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a double value.
     * </pre>
     *
     * <code>double number_value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The numberValue to set.
     * @return This builder for chaining.
     */
    public Builder setNumberValue(double value) {

      deltaCase_ = 3;
      delta_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a double value.
     * </pre>
     *
     * <code>double number_value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumberValue() {
      if (deltaCase_ == 3) {
        deltaCase_ = 0;
        delta_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a string value.
     * </pre>
     *
     * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the stringValue field is set.
     */
    @java.lang.Override
    public boolean hasStringValue() {
      return deltaCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a string value.
     * </pre>
     *
     * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The stringValue.
     */
    @java.lang.Override
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (deltaCase_ == 4) {
        ref = delta_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (deltaCase_ == 4) {
          delta_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a string value.
     * </pre>
     *
     * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for stringValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (deltaCase_ == 4) {
        ref = delta_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (deltaCase_ == 4) {
          delta_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a string value.
     * </pre>
     *
     * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deltaCase_ = 4;
      delta_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a string value.
     * </pre>
     *
     * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValue() {
      if (deltaCase_ == 4) {
        deltaCase_ = 0;
        delta_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a string value.
     * </pre>
     *
     * <code>string string_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deltaCase_ = 4;
      delta_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a boolean value.
     * </pre>
     *
     * <code>bool bool_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the boolValue field is set.
     */
    public boolean hasBoolValue() {
      return deltaCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a boolean value.
     * </pre>
     *
     * <code>bool bool_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The boolValue.
     */
    public boolean getBoolValue() {
      if (deltaCase_ == 5) {
        return (java.lang.Boolean) delta_;
      }
      return false;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a boolean value.
     * </pre>
     *
     * <code>bool bool_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The boolValue to set.
     * @return This builder for chaining.
     */
    public Builder setBoolValue(boolean value) {

      deltaCase_ = 5;
      delta_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Represents a boolean value.
     * </pre>
     *
     * <code>bool bool_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoolValue() {
      if (deltaCase_ == 5) {
        deltaCase_ = 0;
        delta_ = null;
        onChanged();
      }
      return this;
    }

    private java.lang.Object jsonPath_ = "";

    /**
     *
     *
     * <pre>
     * Required. A JSON Path (RFC 9535) to the argument being streamed.
     * https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
     * </pre>
     *
     * <code>string json_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jsonPath.
     */
    public java.lang.String getJsonPath() {
      java.lang.Object ref = jsonPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jsonPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A JSON Path (RFC 9535) to the argument being streamed.
     * https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
     * </pre>
     *
     * <code>string json_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jsonPath.
     */
    public com.google.protobuf.ByteString getJsonPathBytes() {
      java.lang.Object ref = jsonPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jsonPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A JSON Path (RFC 9535) to the argument being streamed.
     * https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
     * </pre>
     *
     * <code>string json_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The jsonPath to set.
     * @return This builder for chaining.
     */
    public Builder setJsonPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jsonPath_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A JSON Path (RFC 9535) to the argument being streamed.
     * https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
     * </pre>
     *
     * <code>string json_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJsonPath() {
      jsonPath_ = getDefaultInstance().getJsonPath();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A JSON Path (RFC 9535) to the argument being streamed.
     * https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
     * </pre>
     *
     * <code>string json_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for jsonPath to set.
     * @return This builder for chaining.
     */
    public Builder setJsonPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jsonPath_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean willContinue_;

    /**
     *
     *
     * <pre>
     * Optional. Whether this is not the last part of the same json_path.
     * If true, another PartialArg message for the current json_path is expected
     * to follow.
     * </pre>
     *
     * <code>bool will_continue = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The willContinue.
     */
    @java.lang.Override
    public boolean getWillContinue() {
      return willContinue_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether this is not the last part of the same json_path.
     * If true, another PartialArg message for the current json_path is expected
     * to follow.
     * </pre>
     *
     * <code>bool will_continue = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The willContinue to set.
     * @return This builder for chaining.
     */
    public Builder setWillContinue(boolean value) {

      willContinue_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether this is not the last part of the same json_path.
     * If true, another PartialArg message for the current json_path is expected
     * to follow.
     * </pre>
     *
     * <code>bool will_continue = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWillContinue() {
      bitField0_ = (bitField0_ & ~0x00000020);
      willContinue_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PartialArg)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PartialArg)
  private static final com.google.cloud.aiplatform.v1.PartialArg DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PartialArg();
  }

  public static com.google.cloud.aiplatform.v1.PartialArg getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartialArg> PARSER =
      new com.google.protobuf.AbstractParser<PartialArg>() {
        @java.lang.Override
        public PartialArg parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PartialArg> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartialArg> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PartialArg getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
