/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tool.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Tool details that the model may use to generate response.
 *
 * A `Tool` is a piece of code that enables the system to interact with
 * external systems to perform an action, or set of actions, outside of
 * knowledge and scope of the model. A Tool object should contain exactly
 * one type of Tool (e.g FunctionDeclaration, Retrieval or
 * GoogleSearchRetrieval).
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Tool}
 */
public final class Tool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Tool)
    ToolOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Tool.newBuilder() to construct.
  private Tool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Tool() {
    functionDeclarations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Tool();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_Tool_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_Tool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Tool.class,
            com.google.cloud.aiplatform.v1.Tool.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * These are available confidence level user can set to block malicious urls
   * with chosen confidence and above. For understanding different confidence of
   * webrisk, please refer to
   * https://cloud.google.com/web-risk/docs/reference/rpc/google.cloud.webrisk.v1eap1#confidencelevel
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.Tool.PhishBlockThreshold}
   */
  public enum PhishBlockThreshold implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Defaults to unspecified.
     * </pre>
     *
     * <code>PHISH_BLOCK_THRESHOLD_UNSPECIFIED = 0;</code>
     */
    PHISH_BLOCK_THRESHOLD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Blocks Low and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_LOW_AND_ABOVE = 30;</code>
     */
    BLOCK_LOW_AND_ABOVE(30),
    /**
     *
     *
     * <pre>
     * Blocks Medium and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_MEDIUM_AND_ABOVE = 40;</code>
     */
    BLOCK_MEDIUM_AND_ABOVE(40),
    /**
     *
     *
     * <pre>
     * Blocks High and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_HIGH_AND_ABOVE = 50;</code>
     */
    BLOCK_HIGH_AND_ABOVE(50),
    /**
     *
     *
     * <pre>
     * Blocks Higher and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_HIGHER_AND_ABOVE = 55;</code>
     */
    BLOCK_HIGHER_AND_ABOVE(55),
    /**
     *
     *
     * <pre>
     * Blocks Very high and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_VERY_HIGH_AND_ABOVE = 60;</code>
     */
    BLOCK_VERY_HIGH_AND_ABOVE(60),
    /**
     *
     *
     * <pre>
     * Blocks Extremely high confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_ONLY_EXTREMELY_HIGH = 100;</code>
     */
    BLOCK_ONLY_EXTREMELY_HIGH(100),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Defaults to unspecified.
     * </pre>
     *
     * <code>PHISH_BLOCK_THRESHOLD_UNSPECIFIED = 0;</code>
     */
    public static final int PHISH_BLOCK_THRESHOLD_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Blocks Low and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_LOW_AND_ABOVE = 30;</code>
     */
    public static final int BLOCK_LOW_AND_ABOVE_VALUE = 30;

    /**
     *
     *
     * <pre>
     * Blocks Medium and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_MEDIUM_AND_ABOVE = 40;</code>
     */
    public static final int BLOCK_MEDIUM_AND_ABOVE_VALUE = 40;

    /**
     *
     *
     * <pre>
     * Blocks High and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_HIGH_AND_ABOVE = 50;</code>
     */
    public static final int BLOCK_HIGH_AND_ABOVE_VALUE = 50;

    /**
     *
     *
     * <pre>
     * Blocks Higher and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_HIGHER_AND_ABOVE = 55;</code>
     */
    public static final int BLOCK_HIGHER_AND_ABOVE_VALUE = 55;

    /**
     *
     *
     * <pre>
     * Blocks Very high and above confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_VERY_HIGH_AND_ABOVE = 60;</code>
     */
    public static final int BLOCK_VERY_HIGH_AND_ABOVE_VALUE = 60;

    /**
     *
     *
     * <pre>
     * Blocks Extremely high confidence URL that is risky.
     * </pre>
     *
     * <code>BLOCK_ONLY_EXTREMELY_HIGH = 100;</code>
     */
    public static final int BLOCK_ONLY_EXTREMELY_HIGH_VALUE = 100;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PhishBlockThreshold valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PhishBlockThreshold forNumber(int value) {
      switch (value) {
        case 0:
          return PHISH_BLOCK_THRESHOLD_UNSPECIFIED;
        case 30:
          return BLOCK_LOW_AND_ABOVE;
        case 40:
          return BLOCK_MEDIUM_AND_ABOVE;
        case 50:
          return BLOCK_HIGH_AND_ABOVE;
        case 55:
          return BLOCK_HIGHER_AND_ABOVE;
        case 60:
          return BLOCK_VERY_HIGH_AND_ABOVE;
        case 100:
          return BLOCK_ONLY_EXTREMELY_HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PhishBlockThreshold>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PhishBlockThreshold>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PhishBlockThreshold>() {
              public PhishBlockThreshold findValueByNumber(int number) {
                return PhishBlockThreshold.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Tool.getDescriptor().getEnumTypes().get(0);
    }

    private static final PhishBlockThreshold[] VALUES = values();

    public static PhishBlockThreshold valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PhishBlockThreshold(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Tool.PhishBlockThreshold)
  }

  public interface GoogleSearchOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Tool.GoogleSearch)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the excludeDomains.
     */
    java.util.List<java.lang.String> getExcludeDomainsList();

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of excludeDomains.
     */
    int getExcludeDomainsCount();

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The excludeDomains at the given index.
     */
    java.lang.String getExcludeDomains(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludeDomains at the given index.
     */
    com.google.protobuf.ByteString getExcludeDomainsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the blockingConfidence field is set.
     */
    boolean hasBlockingConfidence();

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for blockingConfidence.
     */
    int getBlockingConfidenceValue();

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The blockingConfidence.
     */
    com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold getBlockingConfidence();
  }

  /**
   *
   *
   * <pre>
   * GoogleSearch tool type.
   * Tool to support Google Search in Model. Powered by Google.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Tool.GoogleSearch}
   */
  public static final class GoogleSearch extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Tool.GoogleSearch)
      GoogleSearchOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use GoogleSearch.newBuilder() to construct.
    private GoogleSearch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GoogleSearch() {
      excludeDomains_ = com.google.protobuf.LazyStringArrayList.emptyList();
      blockingConfidence_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GoogleSearch();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_GoogleSearch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_GoogleSearch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Tool.GoogleSearch.class,
              com.google.cloud.aiplatform.v1.Tool.GoogleSearch.Builder.class);
    }

    private int bitField0_;
    public static final int EXCLUDE_DOMAINS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludeDomains_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the excludeDomains.
     */
    public com.google.protobuf.ProtocolStringList getExcludeDomainsList() {
      return excludeDomains_;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of excludeDomains.
     */
    public int getExcludeDomainsCount() {
      return excludeDomains_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The excludeDomains at the given index.
     */
    public java.lang.String getExcludeDomains(int index) {
      return excludeDomains_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * Example: ["amazon.com", "facebook.com"].
     * </pre>
     *
     * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludeDomains at the given index.
     */
    public com.google.protobuf.ByteString getExcludeDomainsBytes(int index) {
      return excludeDomains_.getByteString(index);
    }

    public static final int BLOCKING_CONFIDENCE_FIELD_NUMBER = 4;
    private int blockingConfidence_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the blockingConfidence field is set.
     */
    @java.lang.Override
    public boolean hasBlockingConfidence() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for blockingConfidence.
     */
    @java.lang.Override
    public int getBlockingConfidenceValue() {
      return blockingConfidence_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The blockingConfidence.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold getBlockingConfidence() {
      com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold result =
          com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.forNumber(blockingConfidence_);
      return result == null
          ? com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < excludeDomains_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, excludeDomains_.getRaw(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(4, blockingConfidence_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < excludeDomains_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludeDomains_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludeDomainsList().size();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, blockingConfidence_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Tool.GoogleSearch)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Tool.GoogleSearch other =
          (com.google.cloud.aiplatform.v1.Tool.GoogleSearch) obj;

      if (!getExcludeDomainsList().equals(other.getExcludeDomainsList())) return false;
      if (hasBlockingConfidence() != other.hasBlockingConfidence()) return false;
      if (hasBlockingConfidence()) {
        if (blockingConfidence_ != other.blockingConfidence_) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getExcludeDomainsCount() > 0) {
        hash = (37 * hash) + EXCLUDE_DOMAINS_FIELD_NUMBER;
        hash = (53 * hash) + getExcludeDomainsList().hashCode();
      }
      if (hasBlockingConfidence()) {
        hash = (37 * hash) + BLOCKING_CONFIDENCE_FIELD_NUMBER;
        hash = (53 * hash) + blockingConfidence_;
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.aiplatform.v1.Tool.GoogleSearch prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Tool.GoogleSearch}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Tool.GoogleSearch)
        com.google.cloud.aiplatform.v1.Tool.GoogleSearchOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_GoogleSearch_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_GoogleSearch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Tool.GoogleSearch.class,
                com.google.cloud.aiplatform.v1.Tool.GoogleSearch.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Tool.GoogleSearch.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        excludeDomains_ = com.google.protobuf.LazyStringArrayList.emptyList();
        blockingConfidence_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_GoogleSearch_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.GoogleSearch getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Tool.GoogleSearch.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.GoogleSearch build() {
        com.google.cloud.aiplatform.v1.Tool.GoogleSearch result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.GoogleSearch buildPartial() {
        com.google.cloud.aiplatform.v1.Tool.GoogleSearch result =
            new com.google.cloud.aiplatform.v1.Tool.GoogleSearch(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Tool.GoogleSearch result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          excludeDomains_.makeImmutable();
          result.excludeDomains_ = excludeDomains_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.blockingConfidence_ = blockingConfidence_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Tool.GoogleSearch) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Tool.GoogleSearch) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Tool.GoogleSearch other) {
        if (other == com.google.cloud.aiplatform.v1.Tool.GoogleSearch.getDefaultInstance())
          return this;
        if (!other.excludeDomains_.isEmpty()) {
          if (excludeDomains_.isEmpty()) {
            excludeDomains_ = other.excludeDomains_;
            bitField0_ |= 0x00000001;
          } else {
            ensureExcludeDomainsIsMutable();
            excludeDomains_.addAll(other.excludeDomains_);
          }
          onChanged();
        }
        if (other.hasBlockingConfidence()) {
          setBlockingConfidence(other.getBlockingConfidence());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludeDomainsIsMutable();
                  excludeDomains_.add(s);
                  break;
                } // case 26
              case 32:
                {
                  blockingConfidence_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList excludeDomains_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludeDomainsIsMutable() {
        if (!excludeDomains_.isModifiable()) {
          excludeDomains_ = new com.google.protobuf.LazyStringArrayList(excludeDomains_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the excludeDomains.
       */
      public com.google.protobuf.ProtocolStringList getExcludeDomainsList() {
        excludeDomains_.makeImmutable();
        return excludeDomains_;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of excludeDomains.
       */
      public int getExcludeDomainsCount() {
        return excludeDomains_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The excludeDomains at the given index.
       */
      public java.lang.String getExcludeDomains(int index) {
        return excludeDomains_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludeDomains at the given index.
       */
      public com.google.protobuf.ByteString getExcludeDomainsBytes(int index) {
        return excludeDomains_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The excludeDomains to set.
       * @return This builder for chaining.
       */
      public Builder setExcludeDomains(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludeDomainsIsMutable();
        excludeDomains_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The excludeDomains to add.
       * @return This builder for chaining.
       */
      public Builder addExcludeDomains(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludeDomainsIsMutable();
        excludeDomains_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The excludeDomains to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludeDomains(java.lang.Iterable<java.lang.String> values) {
        ensureExcludeDomainsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludeDomains_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludeDomains() {
        excludeDomains_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of domains to be excluded from the search results.
       * The default limit is 2000 domains.
       * Example: ["amazon.com", "facebook.com"].
       * </pre>
       *
       * <code>repeated string exclude_domains = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the excludeDomains to add.
       * @return This builder for chaining.
       */
      public Builder addExcludeDomainsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludeDomainsIsMutable();
        excludeDomains_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int blockingConfidence_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. Sites with confidence level chosen &amp; above this value will be
       * blocked from the search results.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the blockingConfidence field is set.
       */
      @java.lang.Override
      public boolean hasBlockingConfidence() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Sites with confidence level chosen &amp; above this value will be
       * blocked from the search results.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for blockingConfidence.
       */
      @java.lang.Override
      public int getBlockingConfidenceValue() {
        return blockingConfidence_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Sites with confidence level chosen &amp; above this value will be
       * blocked from the search results.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for blockingConfidence to set.
       * @return This builder for chaining.
       */
      public Builder setBlockingConfidenceValue(int value) {
        blockingConfidence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Sites with confidence level chosen &amp; above this value will be
       * blocked from the search results.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The blockingConfidence.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold getBlockingConfidence() {
        com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold result =
            com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.forNumber(blockingConfidence_);
        return result == null
            ? com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Optional. Sites with confidence level chosen &amp; above this value will be
       * blocked from the search results.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The blockingConfidence to set.
       * @return This builder for chaining.
       */
      public Builder setBlockingConfidence(
          com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        blockingConfidence_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Sites with confidence level chosen &amp; above this value will be
       * blocked from the search results.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBlockingConfidence() {
        bitField0_ = (bitField0_ & ~0x00000002);
        blockingConfidence_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Tool.GoogleSearch)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Tool.GoogleSearch)
    private static final com.google.cloud.aiplatform.v1.Tool.GoogleSearch DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Tool.GoogleSearch();
    }

    public static com.google.cloud.aiplatform.v1.Tool.GoogleSearch getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GoogleSearch> PARSER =
        new com.google.protobuf.AbstractParser<GoogleSearch>() {
          @java.lang.Override
          public GoogleSearch parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GoogleSearch> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GoogleSearch> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool.GoogleSearch getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CodeExecutionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Tool.CodeExecution)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Tool that executes code generated by the model, and automatically returns
   * the result to the model.
   *
   * See also [ExecutableCode]and [CodeExecutionResult] which are input and
   * output to this tool.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Tool.CodeExecution}
   */
  public static final class CodeExecution extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Tool.CodeExecution)
      CodeExecutionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CodeExecution.newBuilder() to construct.
    private CodeExecution(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CodeExecution() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CodeExecution();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_CodeExecution_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_CodeExecution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Tool.CodeExecution.class,
              com.google.cloud.aiplatform.v1.Tool.CodeExecution.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Tool.CodeExecution)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Tool.CodeExecution other =
          (com.google.cloud.aiplatform.v1.Tool.CodeExecution) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.aiplatform.v1.Tool.CodeExecution prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Tool that executes code generated by the model, and automatically returns
     * the result to the model.
     *
     * See also [ExecutableCode]and [CodeExecutionResult] which are input and
     * output to this tool.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Tool.CodeExecution}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Tool.CodeExecution)
        com.google.cloud.aiplatform.v1.Tool.CodeExecutionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_CodeExecution_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_CodeExecution_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Tool.CodeExecution.class,
                com.google.cloud.aiplatform.v1.Tool.CodeExecution.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Tool.CodeExecution.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_CodeExecution_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.CodeExecution getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Tool.CodeExecution.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.CodeExecution build() {
        com.google.cloud.aiplatform.v1.Tool.CodeExecution result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.CodeExecution buildPartial() {
        com.google.cloud.aiplatform.v1.Tool.CodeExecution result =
            new com.google.cloud.aiplatform.v1.Tool.CodeExecution(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Tool.CodeExecution) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Tool.CodeExecution) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Tool.CodeExecution other) {
        if (other == com.google.cloud.aiplatform.v1.Tool.CodeExecution.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Tool.CodeExecution)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Tool.CodeExecution)
    private static final com.google.cloud.aiplatform.v1.Tool.CodeExecution DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Tool.CodeExecution();
    }

    public static com.google.cloud.aiplatform.v1.Tool.CodeExecution getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CodeExecution> PARSER =
        new com.google.protobuf.AbstractParser<CodeExecution>() {
          @java.lang.Override
          public CodeExecution parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CodeExecution> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CodeExecution> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool.CodeExecution getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ComputerUseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Tool.ComputerUse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The environment being operated.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for environment.
     */
    int getEnvironmentValue();

    /**
     *
     *
     * <pre>
     * Required. The environment being operated.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The environment.
     */
    com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment getEnvironment();

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the excludedPredefinedFunctions.
     */
    java.util.List<java.lang.String> getExcludedPredefinedFunctionsList();

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of excludedPredefinedFunctions.
     */
    int getExcludedPredefinedFunctionsCount();

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The excludedPredefinedFunctions at the given index.
     */
    java.lang.String getExcludedPredefinedFunctions(int index);

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedPredefinedFunctions at the given index.
     */
    com.google.protobuf.ByteString getExcludedPredefinedFunctionsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Tool to support computer use.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Tool.ComputerUse}
   */
  public static final class ComputerUse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Tool.ComputerUse)
      ComputerUseOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ComputerUse.newBuilder() to construct.
    private ComputerUse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ComputerUse() {
      environment_ = 0;
      excludedPredefinedFunctions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ComputerUse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_ComputerUse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_ComputerUse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Tool.ComputerUse.class,
              com.google.cloud.aiplatform.v1.Tool.ComputerUse.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents the environment being operated, such as a web browser.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1.Tool.ComputerUse.Environment}
     */
    public enum Environment implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Defaults to browser.
       * </pre>
       *
       * <code>ENVIRONMENT_UNSPECIFIED = 0;</code>
       */
      ENVIRONMENT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Operates in a web browser.
       * </pre>
       *
       * <code>ENVIRONMENT_BROWSER = 1;</code>
       */
      ENVIRONMENT_BROWSER(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Defaults to browser.
       * </pre>
       *
       * <code>ENVIRONMENT_UNSPECIFIED = 0;</code>
       */
      public static final int ENVIRONMENT_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Operates in a web browser.
       * </pre>
       *
       * <code>ENVIRONMENT_BROWSER = 1;</code>
       */
      public static final int ENVIRONMENT_BROWSER_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Environment valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Environment forNumber(int value) {
        switch (value) {
          case 0:
            return ENVIRONMENT_UNSPECIFIED;
          case 1:
            return ENVIRONMENT_BROWSER;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Environment> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Environment> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Environment>() {
            public Environment findValueByNumber(int number) {
              return Environment.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Environment[] VALUES = values();

      public static Environment valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Environment(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.Tool.ComputerUse.Environment)
    }

    public static final int ENVIRONMENT_FIELD_NUMBER = 1;
    private int environment_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The environment being operated.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for environment.
     */
    @java.lang.Override
    public int getEnvironmentValue() {
      return environment_;
    }

    /**
     *
     *
     * <pre>
     * Required. The environment being operated.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The environment.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment getEnvironment() {
      com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment result =
          com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment.forNumber(environment_);
      return result == null
          ? com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment.UNRECOGNIZED
          : result;
    }

    public static final int EXCLUDED_PREDEFINED_FUNCTIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludedPredefinedFunctions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the excludedPredefinedFunctions.
     */
    public com.google.protobuf.ProtocolStringList getExcludedPredefinedFunctionsList() {
      return excludedPredefinedFunctions_;
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of excludedPredefinedFunctions.
     */
    public int getExcludedPredefinedFunctionsCount() {
      return excludedPredefinedFunctions_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The excludedPredefinedFunctions at the given index.
     */
    public java.lang.String getExcludedPredefinedFunctions(int index) {
      return excludedPredefinedFunctions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, [predefined
     * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
     * are included in the final model call. Some of them can be explicitly
     * excluded from being automatically included. This can serve two purposes:
     * 1. Using a more restricted / different action space.
     * 2. Improving the definitions / instructions of predefined functions.
     * </pre>
     *
     * <code>
     * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedPredefinedFunctions at the given index.
     */
    public com.google.protobuf.ByteString getExcludedPredefinedFunctionsBytes(int index) {
      return excludedPredefinedFunctions_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (environment_
          != com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment.ENVIRONMENT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, environment_);
      }
      for (int i = 0; i < excludedPredefinedFunctions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, excludedPredefinedFunctions_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (environment_
          != com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment.ENVIRONMENT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, environment_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludedPredefinedFunctions_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludedPredefinedFunctions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludedPredefinedFunctionsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.Tool.ComputerUse)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.Tool.ComputerUse other =
          (com.google.cloud.aiplatform.v1.Tool.ComputerUse) obj;

      if (environment_ != other.environment_) return false;
      if (!getExcludedPredefinedFunctionsList().equals(other.getExcludedPredefinedFunctionsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + environment_;
      if (getExcludedPredefinedFunctionsCount() > 0) {
        hash = (37 * hash) + EXCLUDED_PREDEFINED_FUNCTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getExcludedPredefinedFunctionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.aiplatform.v1.Tool.ComputerUse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Tool to support computer use.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.Tool.ComputerUse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Tool.ComputerUse)
        com.google.cloud.aiplatform.v1.Tool.ComputerUseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_ComputerUse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_ComputerUse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.Tool.ComputerUse.class,
                com.google.cloud.aiplatform.v1.Tool.ComputerUse.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.Tool.ComputerUse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        environment_ = 0;
        excludedPredefinedFunctions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_Tool_ComputerUse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.ComputerUse getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.ComputerUse build() {
        com.google.cloud.aiplatform.v1.Tool.ComputerUse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.ComputerUse buildPartial() {
        com.google.cloud.aiplatform.v1.Tool.ComputerUse result =
            new com.google.cloud.aiplatform.v1.Tool.ComputerUse(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.Tool.ComputerUse result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.environment_ = environment_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          excludedPredefinedFunctions_.makeImmutable();
          result.excludedPredefinedFunctions_ = excludedPredefinedFunctions_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.Tool.ComputerUse) {
          return mergeFrom((com.google.cloud.aiplatform.v1.Tool.ComputerUse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.Tool.ComputerUse other) {
        if (other == com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDefaultInstance())
          return this;
        if (other.environment_ != 0) {
          setEnvironmentValue(other.getEnvironmentValue());
        }
        if (!other.excludedPredefinedFunctions_.isEmpty()) {
          if (excludedPredefinedFunctions_.isEmpty()) {
            excludedPredefinedFunctions_ = other.excludedPredefinedFunctions_;
            bitField0_ |= 0x00000002;
          } else {
            ensureExcludedPredefinedFunctionsIsMutable();
            excludedPredefinedFunctions_.addAll(other.excludedPredefinedFunctions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  environment_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludedPredefinedFunctionsIsMutable();
                  excludedPredefinedFunctions_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int environment_ = 0;

      /**
       *
       *
       * <pre>
       * Required. The environment being operated.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for environment.
       */
      @java.lang.Override
      public int getEnvironmentValue() {
        return environment_;
      }

      /**
       *
       *
       * <pre>
       * Required. The environment being operated.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for environment to set.
       * @return This builder for chaining.
       */
      public Builder setEnvironmentValue(int value) {
        environment_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The environment being operated.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The environment.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment getEnvironment() {
        com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment result =
            com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment.forNumber(environment_);
        return result == null
            ? com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Required. The environment being operated.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The environment to set.
       * @return This builder for chaining.
       */
      public Builder setEnvironment(
          com.google.cloud.aiplatform.v1.Tool.ComputerUse.Environment value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        environment_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The environment being operated.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.Tool.ComputerUse.Environment environment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnvironment() {
        bitField0_ = (bitField0_ & ~0x00000001);
        environment_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludedPredefinedFunctions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludedPredefinedFunctionsIsMutable() {
        if (!excludedPredefinedFunctions_.isModifiable()) {
          excludedPredefinedFunctions_ =
              new com.google.protobuf.LazyStringArrayList(excludedPredefinedFunctions_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the excludedPredefinedFunctions.
       */
      public com.google.protobuf.ProtocolStringList getExcludedPredefinedFunctionsList() {
        excludedPredefinedFunctions_.makeImmutable();
        return excludedPredefinedFunctions_;
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of excludedPredefinedFunctions.
       */
      public int getExcludedPredefinedFunctionsCount() {
        return excludedPredefinedFunctions_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The excludedPredefinedFunctions at the given index.
       */
      public java.lang.String getExcludedPredefinedFunctions(int index) {
        return excludedPredefinedFunctions_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludedPredefinedFunctions at the given index.
       */
      public com.google.protobuf.ByteString getExcludedPredefinedFunctionsBytes(int index) {
        return excludedPredefinedFunctions_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The excludedPredefinedFunctions to set.
       * @return This builder for chaining.
       */
      public Builder setExcludedPredefinedFunctions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedPredefinedFunctionsIsMutable();
        excludedPredefinedFunctions_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The excludedPredefinedFunctions to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedPredefinedFunctions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedPredefinedFunctionsIsMutable();
        excludedPredefinedFunctions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The excludedPredefinedFunctions to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludedPredefinedFunctions(
          java.lang.Iterable<java.lang.String> values) {
        ensureExcludedPredefinedFunctionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, excludedPredefinedFunctions_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludedPredefinedFunctions() {
        excludedPredefinedFunctions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. By default, [predefined
       * functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
       * are included in the final model call. Some of them can be explicitly
       * excluded from being automatically included. This can serve two purposes:
       * 1. Using a more restricted / different action space.
       * 2. Improving the definitions / instructions of predefined functions.
       * </pre>
       *
       * <code>
       * repeated string excluded_predefined_functions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the excludedPredefinedFunctions to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedPredefinedFunctionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludedPredefinedFunctionsIsMutable();
        excludedPredefinedFunctions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Tool.ComputerUse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Tool.ComputerUse)
    private static final com.google.cloud.aiplatform.v1.Tool.ComputerUse DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Tool.ComputerUse();
    }

    public static com.google.cloud.aiplatform.v1.Tool.ComputerUse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ComputerUse> PARSER =
        new com.google.protobuf.AbstractParser<ComputerUse>() {
          @java.lang.Override
          public ComputerUse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ComputerUse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ComputerUse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool.ComputerUse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int FUNCTION_DECLARATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.FunctionDeclaration> functionDeclarations_;

  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
   * in the response. User should provide a
   * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
   * each function call in the next turn. Based on the function responses, Model
   * will generate the final response back to the user. Maximum 128 function
   * declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.FunctionDeclaration>
      getFunctionDeclarationsList() {
    return functionDeclarations_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
   * in the response. User should provide a
   * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
   * each function call in the next turn. Based on the function responses, Model
   * will generate the final response back to the user. Maximum 128 function
   * declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.FunctionDeclarationOrBuilder>
      getFunctionDeclarationsOrBuilderList() {
    return functionDeclarations_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
   * in the response. User should provide a
   * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
   * each function call in the next turn. Based on the function responses, Model
   * will generate the final response back to the user. Maximum 128 function
   * declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFunctionDeclarationsCount() {
    return functionDeclarations_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
   * in the response. User should provide a
   * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
   * each function call in the next turn. Based on the function responses, Model
   * will generate the final response back to the user. Maximum 128 function
   * declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionDeclaration getFunctionDeclarations(int index) {
    return functionDeclarations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Function tool type.
   * One or more function declarations to be passed to the model along with the
   * current user query. Model may decide to call a subset of these functions
   * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
   * in the response. User should provide a
   * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
   * each function call in the next turn. Based on the function responses, Model
   * will generate the final response back to the user. Maximum 128 function
   * declarations can be provided.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FunctionDeclarationOrBuilder
      getFunctionDeclarationsOrBuilder(int index) {
    return functionDeclarations_.get(index);
  }

  public static final int RETRIEVAL_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.Retrieval retrieval_;

  /**
   *
   *
   * <pre>
   * Optional. Retrieval tool type.
   * System will always execute the provided retrieval tool(s) to get external
   * knowledge to answer the prompt. Retrieval results are presented to the
   * model for generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retrieval field is set.
   */
  @java.lang.Override
  public boolean hasRetrieval() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Retrieval tool type.
   * System will always execute the provided retrieval tool(s) to get external
   * knowledge to answer the prompt. Retrieval results are presented to the
   * model for generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retrieval.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Retrieval getRetrieval() {
    return retrieval_ == null
        ? com.google.cloud.aiplatform.v1.Retrieval.getDefaultInstance()
        : retrieval_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Retrieval tool type.
   * System will always execute the provided retrieval tool(s) to get external
   * knowledge to answer the prompt. Retrieval results are presented to the
   * model for generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RetrievalOrBuilder getRetrievalOrBuilder() {
    return retrieval_ == null
        ? com.google.cloud.aiplatform.v1.Retrieval.getDefaultInstance()
        : retrieval_;
  }

  public static final int GOOGLE_SEARCH_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1.Tool.GoogleSearch googleSearch_;

  /**
   *
   *
   * <pre>
   * Optional. GoogleSearch tool type.
   * Tool to support Google Search in Model. Powered by Google.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the googleSearch field is set.
   */
  @java.lang.Override
  public boolean hasGoogleSearch() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. GoogleSearch tool type.
   * Tool to support Google Search in Model. Powered by Google.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The googleSearch.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool.GoogleSearch getGoogleSearch() {
    return googleSearch_ == null
        ? com.google.cloud.aiplatform.v1.Tool.GoogleSearch.getDefaultInstance()
        : googleSearch_;
  }

  /**
   *
   *
   * <pre>
   * Optional. GoogleSearch tool type.
   * Tool to support Google Search in Model. Powered by Google.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool.GoogleSearchOrBuilder getGoogleSearchOrBuilder() {
    return googleSearch_ == null
        ? com.google.cloud.aiplatform.v1.Tool.GoogleSearch.getDefaultInstance()
        : googleSearch_;
  }

  public static final int GOOGLE_SEARCH_RETRIEVAL_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1.GoogleSearchRetrieval googleSearchRetrieval_;

  /**
   *
   *
   * <pre>
   * Optional. GoogleSearchRetrieval tool type.
   * Specialized retrieval tool that is powered by Google search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the googleSearchRetrieval field is set.
   */
  @java.lang.Override
  public boolean hasGoogleSearchRetrieval() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. GoogleSearchRetrieval tool type.
   * Specialized retrieval tool that is powered by Google search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The googleSearchRetrieval.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GoogleSearchRetrieval getGoogleSearchRetrieval() {
    return googleSearchRetrieval_ == null
        ? com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.getDefaultInstance()
        : googleSearchRetrieval_;
  }

  /**
   *
   *
   * <pre>
   * Optional. GoogleSearchRetrieval tool type.
   * Specialized retrieval tool that is powered by Google search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GoogleSearchRetrievalOrBuilder
      getGoogleSearchRetrievalOrBuilder() {
    return googleSearchRetrieval_ == null
        ? com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.getDefaultInstance()
        : googleSearchRetrieval_;
  }

  public static final int GOOGLE_MAPS_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1.GoogleMaps googleMaps_;

  /**
   *
   *
   * <pre>
   * Optional. GoogleMaps tool type.
   * Tool to support Google Maps in Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the googleMaps field is set.
   */
  @java.lang.Override
  public boolean hasGoogleMaps() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. GoogleMaps tool type.
   * Tool to support Google Maps in Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The googleMaps.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GoogleMaps getGoogleMaps() {
    return googleMaps_ == null
        ? com.google.cloud.aiplatform.v1.GoogleMaps.getDefaultInstance()
        : googleMaps_;
  }

  /**
   *
   *
   * <pre>
   * Optional. GoogleMaps tool type.
   * Tool to support Google Maps in Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.GoogleMapsOrBuilder getGoogleMapsOrBuilder() {
    return googleMaps_ == null
        ? com.google.cloud.aiplatform.v1.GoogleMaps.getDefaultInstance()
        : googleMaps_;
  }

  public static final int ENTERPRISE_WEB_SEARCH_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1.EnterpriseWebSearch enterpriseWebSearch_;

  /**
   *
   *
   * <pre>
   * Optional. Tool to support searching public web data, powered by Vertex AI
   * Search and Sec4 compliance.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the enterpriseWebSearch field is set.
   */
  @java.lang.Override
  public boolean hasEnterpriseWebSearch() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool to support searching public web data, powered by Vertex AI
   * Search and Sec4 compliance.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enterpriseWebSearch.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EnterpriseWebSearch getEnterpriseWebSearch() {
    return enterpriseWebSearch_ == null
        ? com.google.cloud.aiplatform.v1.EnterpriseWebSearch.getDefaultInstance()
        : enterpriseWebSearch_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool to support searching public web data, powered by Vertex AI
   * Search and Sec4 compliance.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EnterpriseWebSearchOrBuilder
      getEnterpriseWebSearchOrBuilder() {
    return enterpriseWebSearch_ == null
        ? com.google.cloud.aiplatform.v1.EnterpriseWebSearch.getDefaultInstance()
        : enterpriseWebSearch_;
  }

  public static final int CODE_EXECUTION_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1.Tool.CodeExecution codeExecution_;

  /**
   *
   *
   * <pre>
   * Optional. CodeExecution tool type.
   * Enables the model to execute code as part of generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the codeExecution field is set.
   */
  @java.lang.Override
  public boolean hasCodeExecution() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. CodeExecution tool type.
   * Enables the model to execute code as part of generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The codeExecution.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool.CodeExecution getCodeExecution() {
    return codeExecution_ == null
        ? com.google.cloud.aiplatform.v1.Tool.CodeExecution.getDefaultInstance()
        : codeExecution_;
  }

  /**
   *
   *
   * <pre>
   * Optional. CodeExecution tool type.
   * Enables the model to execute code as part of generation.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool.CodeExecutionOrBuilder getCodeExecutionOrBuilder() {
    return codeExecution_ == null
        ? com.google.cloud.aiplatform.v1.Tool.CodeExecution.getDefaultInstance()
        : codeExecution_;
  }

  public static final int URL_CONTEXT_FIELD_NUMBER = 10;
  private com.google.cloud.aiplatform.v1.UrlContext urlContext_;

  /**
   *
   *
   * <pre>
   * Optional. Tool to support URL context retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the urlContext field is set.
   */
  @java.lang.Override
  public boolean hasUrlContext() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool to support URL context retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The urlContext.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.UrlContext getUrlContext() {
    return urlContext_ == null
        ? com.google.cloud.aiplatform.v1.UrlContext.getDefaultInstance()
        : urlContext_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool to support URL context retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.UrlContextOrBuilder getUrlContextOrBuilder() {
    return urlContext_ == null
        ? com.google.cloud.aiplatform.v1.UrlContext.getDefaultInstance()
        : urlContext_;
  }

  public static final int COMPUTER_USE_FIELD_NUMBER = 11;
  private com.google.cloud.aiplatform.v1.Tool.ComputerUse computerUse_;

  /**
   *
   *
   * <pre>
   * Optional. Tool to support the model interacting directly with the computer.
   * If enabled, it automatically populates computer-use specific Function
   * Declarations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the computerUse field is set.
   */
  @java.lang.Override
  public boolean hasComputerUse() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool to support the model interacting directly with the computer.
   * If enabled, it automatically populates computer-use specific Function
   * Declarations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The computerUse.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool.ComputerUse getComputerUse() {
    return computerUse_ == null
        ? com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDefaultInstance()
        : computerUse_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Tool to support the model interacting directly with the computer.
   * If enabled, it automatically populates computer-use specific Function
   * Declarations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool.ComputerUseOrBuilder getComputerUseOrBuilder() {
    return computerUse_ == null
        ? com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDefaultInstance()
        : computerUse_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < functionDeclarations_.size(); i++) {
      output.writeMessage(1, functionDeclarations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getRetrieval());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getGoogleSearchRetrieval());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(4, getCodeExecution());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getGoogleMaps());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(6, getEnterpriseWebSearch());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getGoogleSearch());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(10, getUrlContext());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(11, getComputerUse());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < functionDeclarations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, functionDeclarations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRetrieval());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getGoogleSearchRetrieval());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCodeExecution());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getGoogleMaps());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEnterpriseWebSearch());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getGoogleSearch());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUrlContext());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getComputerUse());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Tool)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Tool other = (com.google.cloud.aiplatform.v1.Tool) obj;

    if (!getFunctionDeclarationsList().equals(other.getFunctionDeclarationsList())) return false;
    if (hasRetrieval() != other.hasRetrieval()) return false;
    if (hasRetrieval()) {
      if (!getRetrieval().equals(other.getRetrieval())) return false;
    }
    if (hasGoogleSearch() != other.hasGoogleSearch()) return false;
    if (hasGoogleSearch()) {
      if (!getGoogleSearch().equals(other.getGoogleSearch())) return false;
    }
    if (hasGoogleSearchRetrieval() != other.hasGoogleSearchRetrieval()) return false;
    if (hasGoogleSearchRetrieval()) {
      if (!getGoogleSearchRetrieval().equals(other.getGoogleSearchRetrieval())) return false;
    }
    if (hasGoogleMaps() != other.hasGoogleMaps()) return false;
    if (hasGoogleMaps()) {
      if (!getGoogleMaps().equals(other.getGoogleMaps())) return false;
    }
    if (hasEnterpriseWebSearch() != other.hasEnterpriseWebSearch()) return false;
    if (hasEnterpriseWebSearch()) {
      if (!getEnterpriseWebSearch().equals(other.getEnterpriseWebSearch())) return false;
    }
    if (hasCodeExecution() != other.hasCodeExecution()) return false;
    if (hasCodeExecution()) {
      if (!getCodeExecution().equals(other.getCodeExecution())) return false;
    }
    if (hasUrlContext() != other.hasUrlContext()) return false;
    if (hasUrlContext()) {
      if (!getUrlContext().equals(other.getUrlContext())) return false;
    }
    if (hasComputerUse() != other.hasComputerUse()) return false;
    if (hasComputerUse()) {
      if (!getComputerUse().equals(other.getComputerUse())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFunctionDeclarationsCount() > 0) {
      hash = (37 * hash) + FUNCTION_DECLARATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFunctionDeclarationsList().hashCode();
    }
    if (hasRetrieval()) {
      hash = (37 * hash) + RETRIEVAL_FIELD_NUMBER;
      hash = (53 * hash) + getRetrieval().hashCode();
    }
    if (hasGoogleSearch()) {
      hash = (37 * hash) + GOOGLE_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleSearch().hashCode();
    }
    if (hasGoogleSearchRetrieval()) {
      hash = (37 * hash) + GOOGLE_SEARCH_RETRIEVAL_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleSearchRetrieval().hashCode();
    }
    if (hasGoogleMaps()) {
      hash = (37 * hash) + GOOGLE_MAPS_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleMaps().hashCode();
    }
    if (hasEnterpriseWebSearch()) {
      hash = (37 * hash) + ENTERPRISE_WEB_SEARCH_FIELD_NUMBER;
      hash = (53 * hash) + getEnterpriseWebSearch().hashCode();
    }
    if (hasCodeExecution()) {
      hash = (37 * hash) + CODE_EXECUTION_FIELD_NUMBER;
      hash = (53 * hash) + getCodeExecution().hashCode();
    }
    if (hasUrlContext()) {
      hash = (37 * hash) + URL_CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getUrlContext().hashCode();
    }
    if (hasComputerUse()) {
      hash = (37 * hash) + COMPUTER_USE_FIELD_NUMBER;
      hash = (53 * hash) + getComputerUse().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Tool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Tool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Tool details that the model may use to generate response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model. A Tool object should contain exactly
   * one type of Tool (e.g FunctionDeclaration, Retrieval or
   * GoogleSearchRetrieval).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Tool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Tool)
      com.google.cloud.aiplatform.v1.ToolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Tool.class,
              com.google.cloud.aiplatform.v1.Tool.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Tool.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFunctionDeclarationsFieldBuilder();
        getRetrievalFieldBuilder();
        getGoogleSearchFieldBuilder();
        getGoogleSearchRetrievalFieldBuilder();
        getGoogleMapsFieldBuilder();
        getEnterpriseWebSearchFieldBuilder();
        getCodeExecutionFieldBuilder();
        getUrlContextFieldBuilder();
        getComputerUseFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (functionDeclarationsBuilder_ == null) {
        functionDeclarations_ = java.util.Collections.emptyList();
      } else {
        functionDeclarations_ = null;
        functionDeclarationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      retrieval_ = null;
      if (retrievalBuilder_ != null) {
        retrievalBuilder_.dispose();
        retrievalBuilder_ = null;
      }
      googleSearch_ = null;
      if (googleSearchBuilder_ != null) {
        googleSearchBuilder_.dispose();
        googleSearchBuilder_ = null;
      }
      googleSearchRetrieval_ = null;
      if (googleSearchRetrievalBuilder_ != null) {
        googleSearchRetrievalBuilder_.dispose();
        googleSearchRetrievalBuilder_ = null;
      }
      googleMaps_ = null;
      if (googleMapsBuilder_ != null) {
        googleMapsBuilder_.dispose();
        googleMapsBuilder_ = null;
      }
      enterpriseWebSearch_ = null;
      if (enterpriseWebSearchBuilder_ != null) {
        enterpriseWebSearchBuilder_.dispose();
        enterpriseWebSearchBuilder_ = null;
      }
      codeExecution_ = null;
      if (codeExecutionBuilder_ != null) {
        codeExecutionBuilder_.dispose();
        codeExecutionBuilder_ = null;
      }
      urlContext_ = null;
      if (urlContextBuilder_ != null) {
        urlContextBuilder_.dispose();
        urlContextBuilder_ = null;
      }
      computerUse_ = null;
      if (computerUseBuilder_ != null) {
        computerUseBuilder_.dispose();
        computerUseBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_Tool_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Tool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool build() {
      com.google.cloud.aiplatform.v1.Tool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool buildPartial() {
      com.google.cloud.aiplatform.v1.Tool result = new com.google.cloud.aiplatform.v1.Tool(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.Tool result) {
      if (functionDeclarationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          functionDeclarations_ = java.util.Collections.unmodifiableList(functionDeclarations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.functionDeclarations_ = functionDeclarations_;
      } else {
        result.functionDeclarations_ = functionDeclarationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Tool result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.retrieval_ = retrievalBuilder_ == null ? retrieval_ : retrievalBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.googleSearch_ =
            googleSearchBuilder_ == null ? googleSearch_ : googleSearchBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.googleSearchRetrieval_ =
            googleSearchRetrievalBuilder_ == null
                ? googleSearchRetrieval_
                : googleSearchRetrievalBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.googleMaps_ = googleMapsBuilder_ == null ? googleMaps_ : googleMapsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.enterpriseWebSearch_ =
            enterpriseWebSearchBuilder_ == null
                ? enterpriseWebSearch_
                : enterpriseWebSearchBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.codeExecution_ =
            codeExecutionBuilder_ == null ? codeExecution_ : codeExecutionBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.urlContext_ = urlContextBuilder_ == null ? urlContext_ : urlContextBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.computerUse_ =
            computerUseBuilder_ == null ? computerUse_ : computerUseBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Tool) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Tool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Tool other) {
      if (other == com.google.cloud.aiplatform.v1.Tool.getDefaultInstance()) return this;
      if (functionDeclarationsBuilder_ == null) {
        if (!other.functionDeclarations_.isEmpty()) {
          if (functionDeclarations_.isEmpty()) {
            functionDeclarations_ = other.functionDeclarations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFunctionDeclarationsIsMutable();
            functionDeclarations_.addAll(other.functionDeclarations_);
          }
          onChanged();
        }
      } else {
        if (!other.functionDeclarations_.isEmpty()) {
          if (functionDeclarationsBuilder_.isEmpty()) {
            functionDeclarationsBuilder_.dispose();
            functionDeclarationsBuilder_ = null;
            functionDeclarations_ = other.functionDeclarations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            functionDeclarationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFunctionDeclarationsFieldBuilder()
                    : null;
          } else {
            functionDeclarationsBuilder_.addAllMessages(other.functionDeclarations_);
          }
        }
      }
      if (other.hasRetrieval()) {
        mergeRetrieval(other.getRetrieval());
      }
      if (other.hasGoogleSearch()) {
        mergeGoogleSearch(other.getGoogleSearch());
      }
      if (other.hasGoogleSearchRetrieval()) {
        mergeGoogleSearchRetrieval(other.getGoogleSearchRetrieval());
      }
      if (other.hasGoogleMaps()) {
        mergeGoogleMaps(other.getGoogleMaps());
      }
      if (other.hasEnterpriseWebSearch()) {
        mergeEnterpriseWebSearch(other.getEnterpriseWebSearch());
      }
      if (other.hasCodeExecution()) {
        mergeCodeExecution(other.getCodeExecution());
      }
      if (other.hasUrlContext()) {
        mergeUrlContext(other.getUrlContext());
      }
      if (other.hasComputerUse()) {
        mergeComputerUse(other.getComputerUse());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1.FunctionDeclaration m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.FunctionDeclaration.parser(),
                        extensionRegistry);
                if (functionDeclarationsBuilder_ == null) {
                  ensureFunctionDeclarationsIsMutable();
                  functionDeclarations_.add(m);
                } else {
                  functionDeclarationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRetrievalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getGoogleSearchRetrievalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCodeExecutionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getGoogleMapsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getEnterpriseWebSearchFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getGoogleSearchFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            case 82:
              {
                input.readMessage(getUrlContextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getComputerUseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1.FunctionDeclaration>
        functionDeclarations_ = java.util.Collections.emptyList();

    private void ensureFunctionDeclarationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        functionDeclarations_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.FunctionDeclaration>(
                functionDeclarations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FunctionDeclaration,
            com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder,
            com.google.cloud.aiplatform.v1.FunctionDeclarationOrBuilder>
        functionDeclarationsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.FunctionDeclaration>
        getFunctionDeclarationsList() {
      if (functionDeclarationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(functionDeclarations_);
      } else {
        return functionDeclarationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFunctionDeclarationsCount() {
      if (functionDeclarationsBuilder_ == null) {
        return functionDeclarations_.size();
      } else {
        return functionDeclarationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FunctionDeclaration getFunctionDeclarations(int index) {
      if (functionDeclarationsBuilder_ == null) {
        return functionDeclarations_.get(index);
      } else {
        return functionDeclarationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionDeclarations(
        int index, com.google.cloud.aiplatform.v1.FunctionDeclaration value) {
      if (functionDeclarationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.set(index, value);
        onChanged();
      } else {
        functionDeclarationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFunctionDeclarations(
        int index, com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder builderForValue) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.set(index, builderForValue.build());
        onChanged();
      } else {
        functionDeclarationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        com.google.cloud.aiplatform.v1.FunctionDeclaration value) {
      if (functionDeclarationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(value);
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        int index, com.google.cloud.aiplatform.v1.FunctionDeclaration value) {
      if (functionDeclarationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(index, value);
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder builderForValue) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(builderForValue.build());
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFunctionDeclarations(
        int index, com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder builderForValue) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.add(index, builderForValue.build());
        onChanged();
      } else {
        functionDeclarationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFunctionDeclarations(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.FunctionDeclaration> values) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, functionDeclarations_);
        onChanged();
      } else {
        functionDeclarationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFunctionDeclarations() {
      if (functionDeclarationsBuilder_ == null) {
        functionDeclarations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        functionDeclarationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFunctionDeclarations(int index) {
      if (functionDeclarationsBuilder_ == null) {
        ensureFunctionDeclarationsIsMutable();
        functionDeclarations_.remove(index);
        onChanged();
      } else {
        functionDeclarationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder
        getFunctionDeclarationsBuilder(int index) {
      return getFunctionDeclarationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FunctionDeclarationOrBuilder
        getFunctionDeclarationsOrBuilder(int index) {
      if (functionDeclarationsBuilder_ == null) {
        return functionDeclarations_.get(index);
      } else {
        return functionDeclarationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.FunctionDeclarationOrBuilder>
        getFunctionDeclarationsOrBuilderList() {
      if (functionDeclarationsBuilder_ != null) {
        return functionDeclarationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(functionDeclarations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder
        addFunctionDeclarationsBuilder() {
      return getFunctionDeclarationsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.FunctionDeclaration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder
        addFunctionDeclarationsBuilder(int index) {
      return getFunctionDeclarationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.FunctionDeclaration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Function tool type.
     * One or more function declarations to be passed to the model along with the
     * current user query. Model may decide to call a subset of these functions
     * by populating [FunctionCall][google.cloud.aiplatform.v1.Part.function_call]
     * in the response. User should provide a
     * [FunctionResponse][google.cloud.aiplatform.v1.Part.function_response] for
     * each function call in the next turn. Based on the function responses, Model
     * will generate the final response back to the user. Maximum 128 function
     * declarations can be provided.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FunctionDeclaration function_declarations = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder>
        getFunctionDeclarationsBuilderList() {
      return getFunctionDeclarationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FunctionDeclaration,
            com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder,
            com.google.cloud.aiplatform.v1.FunctionDeclarationOrBuilder>
        getFunctionDeclarationsFieldBuilder() {
      if (functionDeclarationsBuilder_ == null) {
        functionDeclarationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FunctionDeclaration,
                com.google.cloud.aiplatform.v1.FunctionDeclaration.Builder,
                com.google.cloud.aiplatform.v1.FunctionDeclarationOrBuilder>(
                functionDeclarations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        functionDeclarations_ = null;
      }
      return functionDeclarationsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.Retrieval retrieval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Retrieval,
            com.google.cloud.aiplatform.v1.Retrieval.Builder,
            com.google.cloud.aiplatform.v1.RetrievalOrBuilder>
        retrievalBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retrieval field is set.
     */
    public boolean hasRetrieval() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retrieval.
     */
    public com.google.cloud.aiplatform.v1.Retrieval getRetrieval() {
      if (retrievalBuilder_ == null) {
        return retrieval_ == null
            ? com.google.cloud.aiplatform.v1.Retrieval.getDefaultInstance()
            : retrieval_;
      } else {
        return retrievalBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetrieval(com.google.cloud.aiplatform.v1.Retrieval value) {
      if (retrievalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retrieval_ = value;
      } else {
        retrievalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetrieval(com.google.cloud.aiplatform.v1.Retrieval.Builder builderForValue) {
      if (retrievalBuilder_ == null) {
        retrieval_ = builderForValue.build();
      } else {
        retrievalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRetrieval(com.google.cloud.aiplatform.v1.Retrieval value) {
      if (retrievalBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && retrieval_ != null
            && retrieval_ != com.google.cloud.aiplatform.v1.Retrieval.getDefaultInstance()) {
          getRetrievalBuilder().mergeFrom(value);
        } else {
          retrieval_ = value;
        }
      } else {
        retrievalBuilder_.mergeFrom(value);
      }
      if (retrieval_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRetrieval() {
      bitField0_ = (bitField0_ & ~0x00000002);
      retrieval_ = null;
      if (retrievalBuilder_ != null) {
        retrievalBuilder_.dispose();
        retrievalBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Retrieval.Builder getRetrievalBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRetrievalFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RetrievalOrBuilder getRetrievalOrBuilder() {
      if (retrievalBuilder_ != null) {
        return retrievalBuilder_.getMessageOrBuilder();
      } else {
        return retrieval_ == null
            ? com.google.cloud.aiplatform.v1.Retrieval.getDefaultInstance()
            : retrieval_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Retrieval tool type.
     * System will always execute the provided retrieval tool(s) to get external
     * knowledge to answer the prompt. Retrieval results are presented to the
     * model for generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Retrieval retrieval = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Retrieval,
            com.google.cloud.aiplatform.v1.Retrieval.Builder,
            com.google.cloud.aiplatform.v1.RetrievalOrBuilder>
        getRetrievalFieldBuilder() {
      if (retrievalBuilder_ == null) {
        retrievalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Retrieval,
                com.google.cloud.aiplatform.v1.Retrieval.Builder,
                com.google.cloud.aiplatform.v1.RetrievalOrBuilder>(
                getRetrieval(), getParentForChildren(), isClean());
        retrieval_ = null;
      }
      return retrievalBuilder_;
    }

    private com.google.cloud.aiplatform.v1.Tool.GoogleSearch googleSearch_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Tool.GoogleSearch,
            com.google.cloud.aiplatform.v1.Tool.GoogleSearch.Builder,
            com.google.cloud.aiplatform.v1.Tool.GoogleSearchOrBuilder>
        googleSearchBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the googleSearch field is set.
     */
    public boolean hasGoogleSearch() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The googleSearch.
     */
    public com.google.cloud.aiplatform.v1.Tool.GoogleSearch getGoogleSearch() {
      if (googleSearchBuilder_ == null) {
        return googleSearch_ == null
            ? com.google.cloud.aiplatform.v1.Tool.GoogleSearch.getDefaultInstance()
            : googleSearch_;
      } else {
        return googleSearchBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleSearch(com.google.cloud.aiplatform.v1.Tool.GoogleSearch value) {
      if (googleSearchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        googleSearch_ = value;
      } else {
        googleSearchBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleSearch(
        com.google.cloud.aiplatform.v1.Tool.GoogleSearch.Builder builderForValue) {
      if (googleSearchBuilder_ == null) {
        googleSearch_ = builderForValue.build();
      } else {
        googleSearchBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGoogleSearch(com.google.cloud.aiplatform.v1.Tool.GoogleSearch value) {
      if (googleSearchBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && googleSearch_ != null
            && googleSearch_
                != com.google.cloud.aiplatform.v1.Tool.GoogleSearch.getDefaultInstance()) {
          getGoogleSearchBuilder().mergeFrom(value);
        } else {
          googleSearch_ = value;
        }
      } else {
        googleSearchBuilder_.mergeFrom(value);
      }
      if (googleSearch_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGoogleSearch() {
      bitField0_ = (bitField0_ & ~0x00000004);
      googleSearch_ = null;
      if (googleSearchBuilder_ != null) {
        googleSearchBuilder_.dispose();
        googleSearchBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Tool.GoogleSearch.Builder getGoogleSearchBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getGoogleSearchFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Tool.GoogleSearchOrBuilder getGoogleSearchOrBuilder() {
      if (googleSearchBuilder_ != null) {
        return googleSearchBuilder_.getMessageOrBuilder();
      } else {
        return googleSearch_ == null
            ? com.google.cloud.aiplatform.v1.Tool.GoogleSearch.getDefaultInstance()
            : googleSearch_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearch tool type.
     * Tool to support Google Search in Model. Powered by Google.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.GoogleSearch google_search = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Tool.GoogleSearch,
            com.google.cloud.aiplatform.v1.Tool.GoogleSearch.Builder,
            com.google.cloud.aiplatform.v1.Tool.GoogleSearchOrBuilder>
        getGoogleSearchFieldBuilder() {
      if (googleSearchBuilder_ == null) {
        googleSearchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Tool.GoogleSearch,
                com.google.cloud.aiplatform.v1.Tool.GoogleSearch.Builder,
                com.google.cloud.aiplatform.v1.Tool.GoogleSearchOrBuilder>(
                getGoogleSearch(), getParentForChildren(), isClean());
        googleSearch_ = null;
      }
      return googleSearchBuilder_;
    }

    private com.google.cloud.aiplatform.v1.GoogleSearchRetrieval googleSearchRetrieval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GoogleSearchRetrieval,
            com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.Builder,
            com.google.cloud.aiplatform.v1.GoogleSearchRetrievalOrBuilder>
        googleSearchRetrievalBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the googleSearchRetrieval field is set.
     */
    public boolean hasGoogleSearchRetrieval() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The googleSearchRetrieval.
     */
    public com.google.cloud.aiplatform.v1.GoogleSearchRetrieval getGoogleSearchRetrieval() {
      if (googleSearchRetrievalBuilder_ == null) {
        return googleSearchRetrieval_ == null
            ? com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.getDefaultInstance()
            : googleSearchRetrieval_;
      } else {
        return googleSearchRetrievalBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleSearchRetrieval(
        com.google.cloud.aiplatform.v1.GoogleSearchRetrieval value) {
      if (googleSearchRetrievalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        googleSearchRetrieval_ = value;
      } else {
        googleSearchRetrievalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleSearchRetrieval(
        com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.Builder builderForValue) {
      if (googleSearchRetrievalBuilder_ == null) {
        googleSearchRetrieval_ = builderForValue.build();
      } else {
        googleSearchRetrievalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGoogleSearchRetrieval(
        com.google.cloud.aiplatform.v1.GoogleSearchRetrieval value) {
      if (googleSearchRetrievalBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && googleSearchRetrieval_ != null
            && googleSearchRetrieval_
                != com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.getDefaultInstance()) {
          getGoogleSearchRetrievalBuilder().mergeFrom(value);
        } else {
          googleSearchRetrieval_ = value;
        }
      } else {
        googleSearchRetrievalBuilder_.mergeFrom(value);
      }
      if (googleSearchRetrieval_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGoogleSearchRetrieval() {
      bitField0_ = (bitField0_ & ~0x00000008);
      googleSearchRetrieval_ = null;
      if (googleSearchRetrievalBuilder_ != null) {
        googleSearchRetrievalBuilder_.dispose();
        googleSearchRetrievalBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.Builder
        getGoogleSearchRetrievalBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGoogleSearchRetrievalFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.GoogleSearchRetrievalOrBuilder
        getGoogleSearchRetrievalOrBuilder() {
      if (googleSearchRetrievalBuilder_ != null) {
        return googleSearchRetrievalBuilder_.getMessageOrBuilder();
      } else {
        return googleSearchRetrieval_ == null
            ? com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.getDefaultInstance()
            : googleSearchRetrieval_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleSearchRetrieval tool type.
     * Specialized retrieval tool that is powered by Google search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleSearchRetrieval google_search_retrieval = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GoogleSearchRetrieval,
            com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.Builder,
            com.google.cloud.aiplatform.v1.GoogleSearchRetrievalOrBuilder>
        getGoogleSearchRetrievalFieldBuilder() {
      if (googleSearchRetrievalBuilder_ == null) {
        googleSearchRetrievalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.GoogleSearchRetrieval,
                com.google.cloud.aiplatform.v1.GoogleSearchRetrieval.Builder,
                com.google.cloud.aiplatform.v1.GoogleSearchRetrievalOrBuilder>(
                getGoogleSearchRetrieval(), getParentForChildren(), isClean());
        googleSearchRetrieval_ = null;
      }
      return googleSearchRetrievalBuilder_;
    }

    private com.google.cloud.aiplatform.v1.GoogleMaps googleMaps_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GoogleMaps,
            com.google.cloud.aiplatform.v1.GoogleMaps.Builder,
            com.google.cloud.aiplatform.v1.GoogleMapsOrBuilder>
        googleMapsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the googleMaps field is set.
     */
    public boolean hasGoogleMaps() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The googleMaps.
     */
    public com.google.cloud.aiplatform.v1.GoogleMaps getGoogleMaps() {
      if (googleMapsBuilder_ == null) {
        return googleMaps_ == null
            ? com.google.cloud.aiplatform.v1.GoogleMaps.getDefaultInstance()
            : googleMaps_;
      } else {
        return googleMapsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleMaps(com.google.cloud.aiplatform.v1.GoogleMaps value) {
      if (googleMapsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        googleMaps_ = value;
      } else {
        googleMapsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGoogleMaps(
        com.google.cloud.aiplatform.v1.GoogleMaps.Builder builderForValue) {
      if (googleMapsBuilder_ == null) {
        googleMaps_ = builderForValue.build();
      } else {
        googleMapsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGoogleMaps(com.google.cloud.aiplatform.v1.GoogleMaps value) {
      if (googleMapsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && googleMaps_ != null
            && googleMaps_ != com.google.cloud.aiplatform.v1.GoogleMaps.getDefaultInstance()) {
          getGoogleMapsBuilder().mergeFrom(value);
        } else {
          googleMaps_ = value;
        }
      } else {
        googleMapsBuilder_.mergeFrom(value);
      }
      if (googleMaps_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGoogleMaps() {
      bitField0_ = (bitField0_ & ~0x00000010);
      googleMaps_ = null;
      if (googleMapsBuilder_ != null) {
        googleMapsBuilder_.dispose();
        googleMapsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.GoogleMaps.Builder getGoogleMapsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getGoogleMapsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.GoogleMapsOrBuilder getGoogleMapsOrBuilder() {
      if (googleMapsBuilder_ != null) {
        return googleMapsBuilder_.getMessageOrBuilder();
      } else {
        return googleMaps_ == null
            ? com.google.cloud.aiplatform.v1.GoogleMaps.getDefaultInstance()
            : googleMaps_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GoogleMaps tool type.
     * Tool to support Google Maps in Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.GoogleMaps google_maps = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.GoogleMaps,
            com.google.cloud.aiplatform.v1.GoogleMaps.Builder,
            com.google.cloud.aiplatform.v1.GoogleMapsOrBuilder>
        getGoogleMapsFieldBuilder() {
      if (googleMapsBuilder_ == null) {
        googleMapsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.GoogleMaps,
                com.google.cloud.aiplatform.v1.GoogleMaps.Builder,
                com.google.cloud.aiplatform.v1.GoogleMapsOrBuilder>(
                getGoogleMaps(), getParentForChildren(), isClean());
        googleMaps_ = null;
      }
      return googleMapsBuilder_;
    }

    private com.google.cloud.aiplatform.v1.EnterpriseWebSearch enterpriseWebSearch_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EnterpriseWebSearch,
            com.google.cloud.aiplatform.v1.EnterpriseWebSearch.Builder,
            com.google.cloud.aiplatform.v1.EnterpriseWebSearchOrBuilder>
        enterpriseWebSearchBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the enterpriseWebSearch field is set.
     */
    public boolean hasEnterpriseWebSearch() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enterpriseWebSearch.
     */
    public com.google.cloud.aiplatform.v1.EnterpriseWebSearch getEnterpriseWebSearch() {
      if (enterpriseWebSearchBuilder_ == null) {
        return enterpriseWebSearch_ == null
            ? com.google.cloud.aiplatform.v1.EnterpriseWebSearch.getDefaultInstance()
            : enterpriseWebSearch_;
      } else {
        return enterpriseWebSearchBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnterpriseWebSearch(
        com.google.cloud.aiplatform.v1.EnterpriseWebSearch value) {
      if (enterpriseWebSearchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enterpriseWebSearch_ = value;
      } else {
        enterpriseWebSearchBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnterpriseWebSearch(
        com.google.cloud.aiplatform.v1.EnterpriseWebSearch.Builder builderForValue) {
      if (enterpriseWebSearchBuilder_ == null) {
        enterpriseWebSearch_ = builderForValue.build();
      } else {
        enterpriseWebSearchBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEnterpriseWebSearch(
        com.google.cloud.aiplatform.v1.EnterpriseWebSearch value) {
      if (enterpriseWebSearchBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && enterpriseWebSearch_ != null
            && enterpriseWebSearch_
                != com.google.cloud.aiplatform.v1.EnterpriseWebSearch.getDefaultInstance()) {
          getEnterpriseWebSearchBuilder().mergeFrom(value);
        } else {
          enterpriseWebSearch_ = value;
        }
      } else {
        enterpriseWebSearchBuilder_.mergeFrom(value);
      }
      if (enterpriseWebSearch_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEnterpriseWebSearch() {
      bitField0_ = (bitField0_ & ~0x00000020);
      enterpriseWebSearch_ = null;
      if (enterpriseWebSearchBuilder_ != null) {
        enterpriseWebSearchBuilder_.dispose();
        enterpriseWebSearchBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EnterpriseWebSearch.Builder
        getEnterpriseWebSearchBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getEnterpriseWebSearchFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EnterpriseWebSearchOrBuilder
        getEnterpriseWebSearchOrBuilder() {
      if (enterpriseWebSearchBuilder_ != null) {
        return enterpriseWebSearchBuilder_.getMessageOrBuilder();
      } else {
        return enterpriseWebSearch_ == null
            ? com.google.cloud.aiplatform.v1.EnterpriseWebSearch.getDefaultInstance()
            : enterpriseWebSearch_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support searching public web data, powered by Vertex AI
     * Search and Sec4 compliance.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EnterpriseWebSearch enterprise_web_search = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EnterpriseWebSearch,
            com.google.cloud.aiplatform.v1.EnterpriseWebSearch.Builder,
            com.google.cloud.aiplatform.v1.EnterpriseWebSearchOrBuilder>
        getEnterpriseWebSearchFieldBuilder() {
      if (enterpriseWebSearchBuilder_ == null) {
        enterpriseWebSearchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EnterpriseWebSearch,
                com.google.cloud.aiplatform.v1.EnterpriseWebSearch.Builder,
                com.google.cloud.aiplatform.v1.EnterpriseWebSearchOrBuilder>(
                getEnterpriseWebSearch(), getParentForChildren(), isClean());
        enterpriseWebSearch_ = null;
      }
      return enterpriseWebSearchBuilder_;
    }

    private com.google.cloud.aiplatform.v1.Tool.CodeExecution codeExecution_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Tool.CodeExecution,
            com.google.cloud.aiplatform.v1.Tool.CodeExecution.Builder,
            com.google.cloud.aiplatform.v1.Tool.CodeExecutionOrBuilder>
        codeExecutionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the codeExecution field is set.
     */
    public boolean hasCodeExecution() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The codeExecution.
     */
    public com.google.cloud.aiplatform.v1.Tool.CodeExecution getCodeExecution() {
      if (codeExecutionBuilder_ == null) {
        return codeExecution_ == null
            ? com.google.cloud.aiplatform.v1.Tool.CodeExecution.getDefaultInstance()
            : codeExecution_;
      } else {
        return codeExecutionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCodeExecution(com.google.cloud.aiplatform.v1.Tool.CodeExecution value) {
      if (codeExecutionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        codeExecution_ = value;
      } else {
        codeExecutionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCodeExecution(
        com.google.cloud.aiplatform.v1.Tool.CodeExecution.Builder builderForValue) {
      if (codeExecutionBuilder_ == null) {
        codeExecution_ = builderForValue.build();
      } else {
        codeExecutionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCodeExecution(com.google.cloud.aiplatform.v1.Tool.CodeExecution value) {
      if (codeExecutionBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && codeExecution_ != null
            && codeExecution_
                != com.google.cloud.aiplatform.v1.Tool.CodeExecution.getDefaultInstance()) {
          getCodeExecutionBuilder().mergeFrom(value);
        } else {
          codeExecution_ = value;
        }
      } else {
        codeExecutionBuilder_.mergeFrom(value);
      }
      if (codeExecution_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCodeExecution() {
      bitField0_ = (bitField0_ & ~0x00000040);
      codeExecution_ = null;
      if (codeExecutionBuilder_ != null) {
        codeExecutionBuilder_.dispose();
        codeExecutionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Tool.CodeExecution.Builder getCodeExecutionBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCodeExecutionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Tool.CodeExecutionOrBuilder getCodeExecutionOrBuilder() {
      if (codeExecutionBuilder_ != null) {
        return codeExecutionBuilder_.getMessageOrBuilder();
      } else {
        return codeExecution_ == null
            ? com.google.cloud.aiplatform.v1.Tool.CodeExecution.getDefaultInstance()
            : codeExecution_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. CodeExecution tool type.
     * Enables the model to execute code as part of generation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.CodeExecution code_execution = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Tool.CodeExecution,
            com.google.cloud.aiplatform.v1.Tool.CodeExecution.Builder,
            com.google.cloud.aiplatform.v1.Tool.CodeExecutionOrBuilder>
        getCodeExecutionFieldBuilder() {
      if (codeExecutionBuilder_ == null) {
        codeExecutionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Tool.CodeExecution,
                com.google.cloud.aiplatform.v1.Tool.CodeExecution.Builder,
                com.google.cloud.aiplatform.v1.Tool.CodeExecutionOrBuilder>(
                getCodeExecution(), getParentForChildren(), isClean());
        codeExecution_ = null;
      }
      return codeExecutionBuilder_;
    }

    private com.google.cloud.aiplatform.v1.UrlContext urlContext_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.UrlContext,
            com.google.cloud.aiplatform.v1.UrlContext.Builder,
            com.google.cloud.aiplatform.v1.UrlContextOrBuilder>
        urlContextBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the urlContext field is set.
     */
    public boolean hasUrlContext() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The urlContext.
     */
    public com.google.cloud.aiplatform.v1.UrlContext getUrlContext() {
      if (urlContextBuilder_ == null) {
        return urlContext_ == null
            ? com.google.cloud.aiplatform.v1.UrlContext.getDefaultInstance()
            : urlContext_;
      } else {
        return urlContextBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUrlContext(com.google.cloud.aiplatform.v1.UrlContext value) {
      if (urlContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        urlContext_ = value;
      } else {
        urlContextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUrlContext(
        com.google.cloud.aiplatform.v1.UrlContext.Builder builderForValue) {
      if (urlContextBuilder_ == null) {
        urlContext_ = builderForValue.build();
      } else {
        urlContextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeUrlContext(com.google.cloud.aiplatform.v1.UrlContext value) {
      if (urlContextBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && urlContext_ != null
            && urlContext_ != com.google.cloud.aiplatform.v1.UrlContext.getDefaultInstance()) {
          getUrlContextBuilder().mergeFrom(value);
        } else {
          urlContext_ = value;
        }
      } else {
        urlContextBuilder_.mergeFrom(value);
      }
      if (urlContext_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearUrlContext() {
      bitField0_ = (bitField0_ & ~0x00000080);
      urlContext_ = null;
      if (urlContextBuilder_ != null) {
        urlContextBuilder_.dispose();
        urlContextBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.UrlContext.Builder getUrlContextBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUrlContextFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.UrlContextOrBuilder getUrlContextOrBuilder() {
      if (urlContextBuilder_ != null) {
        return urlContextBuilder_.getMessageOrBuilder();
      } else {
        return urlContext_ == null
            ? com.google.cloud.aiplatform.v1.UrlContext.getDefaultInstance()
            : urlContext_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support URL context retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UrlContext url_context = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.UrlContext,
            com.google.cloud.aiplatform.v1.UrlContext.Builder,
            com.google.cloud.aiplatform.v1.UrlContextOrBuilder>
        getUrlContextFieldBuilder() {
      if (urlContextBuilder_ == null) {
        urlContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.UrlContext,
                com.google.cloud.aiplatform.v1.UrlContext.Builder,
                com.google.cloud.aiplatform.v1.UrlContextOrBuilder>(
                getUrlContext(), getParentForChildren(), isClean());
        urlContext_ = null;
      }
      return urlContextBuilder_;
    }

    private com.google.cloud.aiplatform.v1.Tool.ComputerUse computerUse_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Tool.ComputerUse,
            com.google.cloud.aiplatform.v1.Tool.ComputerUse.Builder,
            com.google.cloud.aiplatform.v1.Tool.ComputerUseOrBuilder>
        computerUseBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the computerUse field is set.
     */
    public boolean hasComputerUse() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The computerUse.
     */
    public com.google.cloud.aiplatform.v1.Tool.ComputerUse getComputerUse() {
      if (computerUseBuilder_ == null) {
        return computerUse_ == null
            ? com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDefaultInstance()
            : computerUse_;
      } else {
        return computerUseBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setComputerUse(com.google.cloud.aiplatform.v1.Tool.ComputerUse value) {
      if (computerUseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        computerUse_ = value;
      } else {
        computerUseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setComputerUse(
        com.google.cloud.aiplatform.v1.Tool.ComputerUse.Builder builderForValue) {
      if (computerUseBuilder_ == null) {
        computerUse_ = builderForValue.build();
      } else {
        computerUseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeComputerUse(com.google.cloud.aiplatform.v1.Tool.ComputerUse value) {
      if (computerUseBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && computerUse_ != null
            && computerUse_
                != com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDefaultInstance()) {
          getComputerUseBuilder().mergeFrom(value);
        } else {
          computerUse_ = value;
        }
      } else {
        computerUseBuilder_.mergeFrom(value);
      }
      if (computerUse_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearComputerUse() {
      bitField0_ = (bitField0_ & ~0x00000100);
      computerUse_ = null;
      if (computerUseBuilder_ != null) {
        computerUseBuilder_.dispose();
        computerUseBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Tool.ComputerUse.Builder getComputerUseBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getComputerUseFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Tool.ComputerUseOrBuilder getComputerUseOrBuilder() {
      if (computerUseBuilder_ != null) {
        return computerUseBuilder_.getMessageOrBuilder();
      } else {
        return computerUse_ == null
            ? com.google.cloud.aiplatform.v1.Tool.ComputerUse.getDefaultInstance()
            : computerUse_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Tool to support the model interacting directly with the computer.
     * If enabled, it automatically populates computer-use specific Function
     * Declarations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.Tool.ComputerUse computer_use = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Tool.ComputerUse,
            com.google.cloud.aiplatform.v1.Tool.ComputerUse.Builder,
            com.google.cloud.aiplatform.v1.Tool.ComputerUseOrBuilder>
        getComputerUseFieldBuilder() {
      if (computerUseBuilder_ == null) {
        computerUseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Tool.ComputerUse,
                com.google.cloud.aiplatform.v1.Tool.ComputerUse.Builder,
                com.google.cloud.aiplatform.v1.Tool.ComputerUseOrBuilder>(
                getComputerUse(), getParentForChildren(), isClean());
        computerUse_ = null;
      }
      return computerUseBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Tool)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Tool)
  private static final com.google.cloud.aiplatform.v1.Tool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Tool();
  }

  public static com.google.cloud.aiplatform.v1.Tool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Tool> PARSER =
      new com.google.protobuf.AbstractParser<Tool>() {
        @java.lang.Override
        public Tool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Tool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Tool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
