/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/usage_metadata.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Usage metadata about the content generation request and response.
 * This message provides a detailed breakdown of token usage and other
 * relevant metrics.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.UsageMetadata}
 */
public final class UsageMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.UsageMetadata)
    UsageMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UsageMetadata.newBuilder() to construct.
  private UsageMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UsageMetadata() {
    promptTokensDetails_ = java.util.Collections.emptyList();
    cacheTokensDetails_ = java.util.Collections.emptyList();
    candidatesTokensDetails_ = java.util.Collections.emptyList();
    toolUsePromptTokensDetails_ = java.util.Collections.emptyList();
    trafficType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UsageMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.UsageMetadataProto
        .internal_static_google_cloud_aiplatform_v1_UsageMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.UsageMetadataProto
        .internal_static_google_cloud_aiplatform_v1_UsageMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.UsageMetadata.class,
            com.google.cloud.aiplatform.v1.UsageMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of traffic that this request was processed with, indicating which
   * quota gets consumed.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.UsageMetadata.TrafficType}
   */
  public enum TrafficType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified request traffic type.
     * </pre>
     *
     * <code>TRAFFIC_TYPE_UNSPECIFIED = 0;</code>
     */
    TRAFFIC_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Type for Pay-As-You-Go traffic.
     * </pre>
     *
     * <code>ON_DEMAND = 1;</code>
     */
    ON_DEMAND(1),
    /**
     *
     *
     * <pre>
     * Type for Provisioned Throughput traffic.
     * </pre>
     *
     * <code>PROVISIONED_THROUGHPUT = 2;</code>
     */
    PROVISIONED_THROUGHPUT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified request traffic type.
     * </pre>
     *
     * <code>TRAFFIC_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TRAFFIC_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Type for Pay-As-You-Go traffic.
     * </pre>
     *
     * <code>ON_DEMAND = 1;</code>
     */
    public static final int ON_DEMAND_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Type for Provisioned Throughput traffic.
     * </pre>
     *
     * <code>PROVISIONED_THROUGHPUT = 2;</code>
     */
    public static final int PROVISIONED_THROUGHPUT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrafficType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TrafficType forNumber(int value) {
      switch (value) {
        case 0:
          return TRAFFIC_TYPE_UNSPECIFIED;
        case 1:
          return ON_DEMAND;
        case 2:
          return PROVISIONED_THROUGHPUT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TrafficType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TrafficType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TrafficType>() {
          public TrafficType findValueByNumber(int number) {
            return TrafficType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.UsageMetadata.getDescriptor().getEnumTypes().get(0);
    }

    private static final TrafficType[] VALUES = values();

    public static TrafficType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TrafficType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.UsageMetadata.TrafficType)
  }

  public static final int PROMPT_TOKEN_COUNT_FIELD_NUMBER = 1;
  private int promptTokenCount_ = 0;

  /**
   *
   *
   * <pre>
   * The total number of tokens in the prompt. This includes any text, images,
   * or other media provided in the request. When `cached_content` is set,
   * this also includes the number of tokens in the cached content.
   * </pre>
   *
   * <code>int32 prompt_token_count = 1;</code>
   *
   * @return The promptTokenCount.
   */
  @java.lang.Override
  public int getPromptTokenCount() {
    return promptTokenCount_;
  }

  public static final int CANDIDATES_TOKEN_COUNT_FIELD_NUMBER = 2;
  private int candidatesTokenCount_ = 0;

  /**
   *
   *
   * <pre>
   * The total number of tokens in the generated candidates.
   * </pre>
   *
   * <code>int32 candidates_token_count = 2;</code>
   *
   * @return The candidatesTokenCount.
   */
  @java.lang.Override
  public int getCandidatesTokenCount() {
    return candidatesTokenCount_;
  }

  public static final int TOTAL_TOKEN_COUNT_FIELD_NUMBER = 3;
  private int totalTokenCount_ = 0;

  /**
   *
   *
   * <pre>
   * The total number of tokens for the entire request. This is the sum of
   * `prompt_token_count`, `candidates_token_count`,
   * `tool_use_prompt_token_count`, and `thoughts_token_count`.
   * </pre>
   *
   * <code>int32 total_token_count = 3;</code>
   *
   * @return The totalTokenCount.
   */
  @java.lang.Override
  public int getTotalTokenCount() {
    return totalTokenCount_;
  }

  public static final int TOOL_USE_PROMPT_TOKEN_COUNT_FIELD_NUMBER = 13;
  private int toolUsePromptTokenCount_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The number of tokens in the results from tool executions,
   * which are provided back to the model as input, if applicable.
   * </pre>
   *
   * <code>int32 tool_use_prompt_token_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The toolUsePromptTokenCount.
   */
  @java.lang.Override
  public int getToolUsePromptTokenCount() {
    return toolUsePromptTokenCount_;
  }

  public static final int THOUGHTS_TOKEN_COUNT_FIELD_NUMBER = 14;
  private int thoughtsTokenCount_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The number of tokens that were part of the model's generated
   * "thoughts" output, if applicable.
   * </pre>
   *
   * <code>int32 thoughts_token_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The thoughtsTokenCount.
   */
  @java.lang.Override
  public int getThoughtsTokenCount() {
    return thoughtsTokenCount_;
  }

  public static final int CACHED_CONTENT_TOKEN_COUNT_FIELD_NUMBER = 5;
  private int cachedContentTokenCount_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The number of tokens in the cached content that was used for
   * this request.
   * </pre>
   *
   * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The cachedContentTokenCount.
   */
  @java.lang.Override
  public int getCachedContentTokenCount() {
    return cachedContentTokenCount_;
  }

  public static final int PROMPT_TOKENS_DETAILS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount> promptTokensDetails_;

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      getPromptTokensDetailsList() {
    return promptTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getPromptTokensDetailsOrBuilderList() {
    return promptTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPromptTokensDetailsCount() {
    return promptTokensDetails_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCount getPromptTokensDetails(int index) {
    return promptTokensDetails_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder getPromptTokensDetailsOrBuilder(
      int index) {
    return promptTokensDetails_.get(index);
  }

  public static final int CACHE_TOKENS_DETAILS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount> cacheTokensDetails_;

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      getCacheTokensDetailsList() {
    return cacheTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getCacheTokensDetailsOrBuilderList() {
    return cacheTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getCacheTokensDetailsCount() {
    return cacheTokensDetails_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCount getCacheTokensDetails(int index) {
    return cacheTokensDetails_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder getCacheTokensDetailsOrBuilder(
      int index) {
    return cacheTokensDetails_.get(index);
  }

  public static final int CANDIDATES_TOKENS_DETAILS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      candidatesTokensDetails_;

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      getCandidatesTokensDetailsList() {
    return candidatesTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getCandidatesTokensDetailsOrBuilderList() {
    return candidatesTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getCandidatesTokensDetailsCount() {
    return candidatesTokensDetails_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCount getCandidatesTokensDetails(int index) {
    return candidatesTokensDetails_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder
      getCandidatesTokensDetailsOrBuilder(int index) {
    return candidatesTokensDetails_.get(index);
  }

  public static final int TOOL_USE_PROMPT_TOKENS_DETAILS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      toolUsePromptTokensDetails_;

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      getToolUsePromptTokensDetailsList() {
    return toolUsePromptTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getToolUsePromptTokensDetailsOrBuilderList() {
    return toolUsePromptTokensDetails_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getToolUsePromptTokensDetailsCount() {
    return toolUsePromptTokensDetails_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCount getToolUsePromptTokensDetails(
      int index) {
    return toolUsePromptTokensDetails_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder
      getToolUsePromptTokensDetailsOrBuilder(int index) {
    return toolUsePromptTokensDetails_.get(index);
  }

  public static final int TRAFFIC_TYPE_FIELD_NUMBER = 8;
  private int trafficType_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The traffic type for this request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for trafficType.
   */
  @java.lang.Override
  public int getTrafficTypeValue() {
    return trafficType_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The traffic type for this request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The trafficType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType getTrafficType() {
    com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType result =
        com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType.forNumber(trafficType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (promptTokenCount_ != 0) {
      output.writeInt32(1, promptTokenCount_);
    }
    if (candidatesTokenCount_ != 0) {
      output.writeInt32(2, candidatesTokenCount_);
    }
    if (totalTokenCount_ != 0) {
      output.writeInt32(3, totalTokenCount_);
    }
    if (cachedContentTokenCount_ != 0) {
      output.writeInt32(5, cachedContentTokenCount_);
    }
    if (trafficType_
        != com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType.TRAFFIC_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, trafficType_);
    }
    for (int i = 0; i < promptTokensDetails_.size(); i++) {
      output.writeMessage(9, promptTokensDetails_.get(i));
    }
    for (int i = 0; i < cacheTokensDetails_.size(); i++) {
      output.writeMessage(10, cacheTokensDetails_.get(i));
    }
    for (int i = 0; i < candidatesTokensDetails_.size(); i++) {
      output.writeMessage(11, candidatesTokensDetails_.get(i));
    }
    for (int i = 0; i < toolUsePromptTokensDetails_.size(); i++) {
      output.writeMessage(12, toolUsePromptTokensDetails_.get(i));
    }
    if (toolUsePromptTokenCount_ != 0) {
      output.writeInt32(13, toolUsePromptTokenCount_);
    }
    if (thoughtsTokenCount_ != 0) {
      output.writeInt32(14, thoughtsTokenCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (promptTokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, promptTokenCount_);
    }
    if (candidatesTokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, candidatesTokenCount_);
    }
    if (totalTokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, totalTokenCount_);
    }
    if (cachedContentTokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, cachedContentTokenCount_);
    }
    if (trafficType_
        != com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType.TRAFFIC_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, trafficType_);
    }
    for (int i = 0; i < promptTokensDetails_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, promptTokensDetails_.get(i));
    }
    for (int i = 0; i < cacheTokensDetails_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, cacheTokensDetails_.get(i));
    }
    for (int i = 0; i < candidatesTokensDetails_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, candidatesTokensDetails_.get(i));
    }
    for (int i = 0; i < toolUsePromptTokensDetails_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, toolUsePromptTokensDetails_.get(i));
    }
    if (toolUsePromptTokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, toolUsePromptTokenCount_);
    }
    if (thoughtsTokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(14, thoughtsTokenCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.UsageMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.UsageMetadata other =
        (com.google.cloud.aiplatform.v1.UsageMetadata) obj;

    if (getPromptTokenCount() != other.getPromptTokenCount()) return false;
    if (getCandidatesTokenCount() != other.getCandidatesTokenCount()) return false;
    if (getTotalTokenCount() != other.getTotalTokenCount()) return false;
    if (getToolUsePromptTokenCount() != other.getToolUsePromptTokenCount()) return false;
    if (getThoughtsTokenCount() != other.getThoughtsTokenCount()) return false;
    if (getCachedContentTokenCount() != other.getCachedContentTokenCount()) return false;
    if (!getPromptTokensDetailsList().equals(other.getPromptTokensDetailsList())) return false;
    if (!getCacheTokensDetailsList().equals(other.getCacheTokensDetailsList())) return false;
    if (!getCandidatesTokensDetailsList().equals(other.getCandidatesTokensDetailsList()))
      return false;
    if (!getToolUsePromptTokensDetailsList().equals(other.getToolUsePromptTokensDetailsList()))
      return false;
    if (trafficType_ != other.trafficType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROMPT_TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPromptTokenCount();
    hash = (37 * hash) + CANDIDATES_TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCandidatesTokenCount();
    hash = (37 * hash) + TOTAL_TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTotalTokenCount();
    hash = (37 * hash) + TOOL_USE_PROMPT_TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getToolUsePromptTokenCount();
    hash = (37 * hash) + THOUGHTS_TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getThoughtsTokenCount();
    hash = (37 * hash) + CACHED_CONTENT_TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCachedContentTokenCount();
    if (getPromptTokensDetailsCount() > 0) {
      hash = (37 * hash) + PROMPT_TOKENS_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getPromptTokensDetailsList().hashCode();
    }
    if (getCacheTokensDetailsCount() > 0) {
      hash = (37 * hash) + CACHE_TOKENS_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getCacheTokensDetailsList().hashCode();
    }
    if (getCandidatesTokensDetailsCount() > 0) {
      hash = (37 * hash) + CANDIDATES_TOKENS_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getCandidatesTokensDetailsList().hashCode();
    }
    if (getToolUsePromptTokensDetailsCount() > 0) {
      hash = (37 * hash) + TOOL_USE_PROMPT_TOKENS_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getToolUsePromptTokensDetailsList().hashCode();
    }
    hash = (37 * hash) + TRAFFIC_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + trafficType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.UsageMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Usage metadata about the content generation request and response.
   * This message provides a detailed breakdown of token usage and other
   * relevant metrics.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.UsageMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.UsageMetadata)
      com.google.cloud.aiplatform.v1.UsageMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.UsageMetadataProto
          .internal_static_google_cloud_aiplatform_v1_UsageMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.UsageMetadataProto
          .internal_static_google_cloud_aiplatform_v1_UsageMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.UsageMetadata.class,
              com.google.cloud.aiplatform.v1.UsageMetadata.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.UsageMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      promptTokenCount_ = 0;
      candidatesTokenCount_ = 0;
      totalTokenCount_ = 0;
      toolUsePromptTokenCount_ = 0;
      thoughtsTokenCount_ = 0;
      cachedContentTokenCount_ = 0;
      if (promptTokensDetailsBuilder_ == null) {
        promptTokensDetails_ = java.util.Collections.emptyList();
      } else {
        promptTokensDetails_ = null;
        promptTokensDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (cacheTokensDetailsBuilder_ == null) {
        cacheTokensDetails_ = java.util.Collections.emptyList();
      } else {
        cacheTokensDetails_ = null;
        cacheTokensDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (candidatesTokensDetailsBuilder_ == null) {
        candidatesTokensDetails_ = java.util.Collections.emptyList();
      } else {
        candidatesTokensDetails_ = null;
        candidatesTokensDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        toolUsePromptTokensDetails_ = java.util.Collections.emptyList();
      } else {
        toolUsePromptTokensDetails_ = null;
        toolUsePromptTokensDetailsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      trafficType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.UsageMetadataProto
          .internal_static_google_cloud_aiplatform_v1_UsageMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.UsageMetadata getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.UsageMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.UsageMetadata build() {
      com.google.cloud.aiplatform.v1.UsageMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.UsageMetadata buildPartial() {
      com.google.cloud.aiplatform.v1.UsageMetadata result =
          new com.google.cloud.aiplatform.v1.UsageMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.UsageMetadata result) {
      if (promptTokensDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          promptTokensDetails_ = java.util.Collections.unmodifiableList(promptTokensDetails_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.promptTokensDetails_ = promptTokensDetails_;
      } else {
        result.promptTokensDetails_ = promptTokensDetailsBuilder_.build();
      }
      if (cacheTokensDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          cacheTokensDetails_ = java.util.Collections.unmodifiableList(cacheTokensDetails_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.cacheTokensDetails_ = cacheTokensDetails_;
      } else {
        result.cacheTokensDetails_ = cacheTokensDetailsBuilder_.build();
      }
      if (candidatesTokensDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          candidatesTokensDetails_ =
              java.util.Collections.unmodifiableList(candidatesTokensDetails_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.candidatesTokensDetails_ = candidatesTokensDetails_;
      } else {
        result.candidatesTokensDetails_ = candidatesTokensDetailsBuilder_.build();
      }
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          toolUsePromptTokensDetails_ =
              java.util.Collections.unmodifiableList(toolUsePromptTokensDetails_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.toolUsePromptTokensDetails_ = toolUsePromptTokensDetails_;
      } else {
        result.toolUsePromptTokensDetails_ = toolUsePromptTokensDetailsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.UsageMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.promptTokenCount_ = promptTokenCount_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.candidatesTokenCount_ = candidatesTokenCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.totalTokenCount_ = totalTokenCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.toolUsePromptTokenCount_ = toolUsePromptTokenCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.thoughtsTokenCount_ = thoughtsTokenCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.cachedContentTokenCount_ = cachedContentTokenCount_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.trafficType_ = trafficType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.UsageMetadata) {
        return mergeFrom((com.google.cloud.aiplatform.v1.UsageMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.UsageMetadata other) {
      if (other == com.google.cloud.aiplatform.v1.UsageMetadata.getDefaultInstance()) return this;
      if (other.getPromptTokenCount() != 0) {
        setPromptTokenCount(other.getPromptTokenCount());
      }
      if (other.getCandidatesTokenCount() != 0) {
        setCandidatesTokenCount(other.getCandidatesTokenCount());
      }
      if (other.getTotalTokenCount() != 0) {
        setTotalTokenCount(other.getTotalTokenCount());
      }
      if (other.getToolUsePromptTokenCount() != 0) {
        setToolUsePromptTokenCount(other.getToolUsePromptTokenCount());
      }
      if (other.getThoughtsTokenCount() != 0) {
        setThoughtsTokenCount(other.getThoughtsTokenCount());
      }
      if (other.getCachedContentTokenCount() != 0) {
        setCachedContentTokenCount(other.getCachedContentTokenCount());
      }
      if (promptTokensDetailsBuilder_ == null) {
        if (!other.promptTokensDetails_.isEmpty()) {
          if (promptTokensDetails_.isEmpty()) {
            promptTokensDetails_ = other.promptTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensurePromptTokensDetailsIsMutable();
            promptTokensDetails_.addAll(other.promptTokensDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.promptTokensDetails_.isEmpty()) {
          if (promptTokensDetailsBuilder_.isEmpty()) {
            promptTokensDetailsBuilder_.dispose();
            promptTokensDetailsBuilder_ = null;
            promptTokensDetails_ = other.promptTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000040);
            promptTokensDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPromptTokensDetailsFieldBuilder()
                    : null;
          } else {
            promptTokensDetailsBuilder_.addAllMessages(other.promptTokensDetails_);
          }
        }
      }
      if (cacheTokensDetailsBuilder_ == null) {
        if (!other.cacheTokensDetails_.isEmpty()) {
          if (cacheTokensDetails_.isEmpty()) {
            cacheTokensDetails_ = other.cacheTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureCacheTokensDetailsIsMutable();
            cacheTokensDetails_.addAll(other.cacheTokensDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.cacheTokensDetails_.isEmpty()) {
          if (cacheTokensDetailsBuilder_.isEmpty()) {
            cacheTokensDetailsBuilder_.dispose();
            cacheTokensDetailsBuilder_ = null;
            cacheTokensDetails_ = other.cacheTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000080);
            cacheTokensDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCacheTokensDetailsFieldBuilder()
                    : null;
          } else {
            cacheTokensDetailsBuilder_.addAllMessages(other.cacheTokensDetails_);
          }
        }
      }
      if (candidatesTokensDetailsBuilder_ == null) {
        if (!other.candidatesTokensDetails_.isEmpty()) {
          if (candidatesTokensDetails_.isEmpty()) {
            candidatesTokensDetails_ = other.candidatesTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureCandidatesTokensDetailsIsMutable();
            candidatesTokensDetails_.addAll(other.candidatesTokensDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.candidatesTokensDetails_.isEmpty()) {
          if (candidatesTokensDetailsBuilder_.isEmpty()) {
            candidatesTokensDetailsBuilder_.dispose();
            candidatesTokensDetailsBuilder_ = null;
            candidatesTokensDetails_ = other.candidatesTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000100);
            candidatesTokensDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCandidatesTokensDetailsFieldBuilder()
                    : null;
          } else {
            candidatesTokensDetailsBuilder_.addAllMessages(other.candidatesTokensDetails_);
          }
        }
      }
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        if (!other.toolUsePromptTokensDetails_.isEmpty()) {
          if (toolUsePromptTokensDetails_.isEmpty()) {
            toolUsePromptTokensDetails_ = other.toolUsePromptTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureToolUsePromptTokensDetailsIsMutable();
            toolUsePromptTokensDetails_.addAll(other.toolUsePromptTokensDetails_);
          }
          onChanged();
        }
      } else {
        if (!other.toolUsePromptTokensDetails_.isEmpty()) {
          if (toolUsePromptTokensDetailsBuilder_.isEmpty()) {
            toolUsePromptTokensDetailsBuilder_.dispose();
            toolUsePromptTokensDetailsBuilder_ = null;
            toolUsePromptTokensDetails_ = other.toolUsePromptTokensDetails_;
            bitField0_ = (bitField0_ & ~0x00000200);
            toolUsePromptTokensDetailsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getToolUsePromptTokensDetailsFieldBuilder()
                    : null;
          } else {
            toolUsePromptTokensDetailsBuilder_.addAllMessages(other.toolUsePromptTokensDetails_);
          }
        }
      }
      if (other.trafficType_ != 0) {
        setTrafficTypeValue(other.getTrafficTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                promptTokenCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                candidatesTokenCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                totalTokenCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 40:
              {
                cachedContentTokenCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 64:
              {
                trafficType_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 64
            case 74:
              {
                com.google.cloud.aiplatform.v1.ModalityTokenCount m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.ModalityTokenCount.parser(),
                        extensionRegistry);
                if (promptTokensDetailsBuilder_ == null) {
                  ensurePromptTokensDetailsIsMutable();
                  promptTokensDetails_.add(m);
                } else {
                  promptTokensDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.aiplatform.v1.ModalityTokenCount m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.ModalityTokenCount.parser(),
                        extensionRegistry);
                if (cacheTokensDetailsBuilder_ == null) {
                  ensureCacheTokensDetailsIsMutable();
                  cacheTokensDetails_.add(m);
                } else {
                  cacheTokensDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.aiplatform.v1.ModalityTokenCount m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.ModalityTokenCount.parser(),
                        extensionRegistry);
                if (candidatesTokensDetailsBuilder_ == null) {
                  ensureCandidatesTokensDetailsIsMutable();
                  candidatesTokensDetails_.add(m);
                } else {
                  candidatesTokensDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.aiplatform.v1.ModalityTokenCount m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.ModalityTokenCount.parser(),
                        extensionRegistry);
                if (toolUsePromptTokensDetailsBuilder_ == null) {
                  ensureToolUsePromptTokensDetailsIsMutable();
                  toolUsePromptTokensDetails_.add(m);
                } else {
                  toolUsePromptTokensDetailsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 104:
              {
                toolUsePromptTokenCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 104
            case 112:
              {
                thoughtsTokenCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 112
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int promptTokenCount_;

    /**
     *
     *
     * <pre>
     * The total number of tokens in the prompt. This includes any text, images,
     * or other media provided in the request. When `cached_content` is set,
     * this also includes the number of tokens in the cached content.
     * </pre>
     *
     * <code>int32 prompt_token_count = 1;</code>
     *
     * @return The promptTokenCount.
     */
    @java.lang.Override
    public int getPromptTokenCount() {
      return promptTokenCount_;
    }

    /**
     *
     *
     * <pre>
     * The total number of tokens in the prompt. This includes any text, images,
     * or other media provided in the request. When `cached_content` is set,
     * this also includes the number of tokens in the cached content.
     * </pre>
     *
     * <code>int32 prompt_token_count = 1;</code>
     *
     * @param value The promptTokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setPromptTokenCount(int value) {

      promptTokenCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The total number of tokens in the prompt. This includes any text, images,
     * or other media provided in the request. When `cached_content` is set,
     * this also includes the number of tokens in the cached content.
     * </pre>
     *
     * <code>int32 prompt_token_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPromptTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      promptTokenCount_ = 0;
      onChanged();
      return this;
    }

    private int candidatesTokenCount_;

    /**
     *
     *
     * <pre>
     * The total number of tokens in the generated candidates.
     * </pre>
     *
     * <code>int32 candidates_token_count = 2;</code>
     *
     * @return The candidatesTokenCount.
     */
    @java.lang.Override
    public int getCandidatesTokenCount() {
      return candidatesTokenCount_;
    }

    /**
     *
     *
     * <pre>
     * The total number of tokens in the generated candidates.
     * </pre>
     *
     * <code>int32 candidates_token_count = 2;</code>
     *
     * @param value The candidatesTokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setCandidatesTokenCount(int value) {

      candidatesTokenCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The total number of tokens in the generated candidates.
     * </pre>
     *
     * <code>int32 candidates_token_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCandidatesTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      candidatesTokenCount_ = 0;
      onChanged();
      return this;
    }

    private int totalTokenCount_;

    /**
     *
     *
     * <pre>
     * The total number of tokens for the entire request. This is the sum of
     * `prompt_token_count`, `candidates_token_count`,
     * `tool_use_prompt_token_count`, and `thoughts_token_count`.
     * </pre>
     *
     * <code>int32 total_token_count = 3;</code>
     *
     * @return The totalTokenCount.
     */
    @java.lang.Override
    public int getTotalTokenCount() {
      return totalTokenCount_;
    }

    /**
     *
     *
     * <pre>
     * The total number of tokens for the entire request. This is the sum of
     * `prompt_token_count`, `candidates_token_count`,
     * `tool_use_prompt_token_count`, and `thoughts_token_count`.
     * </pre>
     *
     * <code>int32 total_token_count = 3;</code>
     *
     * @param value The totalTokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalTokenCount(int value) {

      totalTokenCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The total number of tokens for the entire request. This is the sum of
     * `prompt_token_count`, `candidates_token_count`,
     * `tool_use_prompt_token_count`, and `thoughts_token_count`.
     * </pre>
     *
     * <code>int32 total_token_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      totalTokenCount_ = 0;
      onChanged();
      return this;
    }

    private int toolUsePromptTokenCount_;

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens in the results from tool executions,
     * which are provided back to the model as input, if applicable.
     * </pre>
     *
     * <code>int32 tool_use_prompt_token_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The toolUsePromptTokenCount.
     */
    @java.lang.Override
    public int getToolUsePromptTokenCount() {
      return toolUsePromptTokenCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens in the results from tool executions,
     * which are provided back to the model as input, if applicable.
     * </pre>
     *
     * <code>int32 tool_use_prompt_token_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The toolUsePromptTokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setToolUsePromptTokenCount(int value) {

      toolUsePromptTokenCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens in the results from tool executions,
     * which are provided back to the model as input, if applicable.
     * </pre>
     *
     * <code>int32 tool_use_prompt_token_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearToolUsePromptTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      toolUsePromptTokenCount_ = 0;
      onChanged();
      return this;
    }

    private int thoughtsTokenCount_;

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens that were part of the model's generated
     * "thoughts" output, if applicable.
     * </pre>
     *
     * <code>int32 thoughts_token_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The thoughtsTokenCount.
     */
    @java.lang.Override
    public int getThoughtsTokenCount() {
      return thoughtsTokenCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens that were part of the model's generated
     * "thoughts" output, if applicable.
     * </pre>
     *
     * <code>int32 thoughts_token_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The thoughtsTokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setThoughtsTokenCount(int value) {

      thoughtsTokenCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens that were part of the model's generated
     * "thoughts" output, if applicable.
     * </pre>
     *
     * <code>int32 thoughts_token_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearThoughtsTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      thoughtsTokenCount_ = 0;
      onChanged();
      return this;
    }

    private int cachedContentTokenCount_;

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens in the cached content that was used for
     * this request.
     * </pre>
     *
     * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cachedContentTokenCount.
     */
    @java.lang.Override
    public int getCachedContentTokenCount() {
      return cachedContentTokenCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens in the cached content that was used for
     * this request.
     * </pre>
     *
     * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The cachedContentTokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setCachedContentTokenCount(int value) {

      cachedContentTokenCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of tokens in the cached content that was used for
     * this request.
     * </pre>
     *
     * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCachedContentTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      cachedContentTokenCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount> promptTokensDetails_ =
        java.util.Collections.emptyList();

    private void ensurePromptTokensDetailsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        promptTokensDetails_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.ModalityTokenCount>(
                promptTokensDetails_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        promptTokensDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
        getPromptTokensDetailsList() {
      if (promptTokensDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(promptTokensDetails_);
      } else {
        return promptTokensDetailsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPromptTokensDetailsCount() {
      if (promptTokensDetailsBuilder_ == null) {
        return promptTokensDetails_.size();
      } else {
        return promptTokensDetailsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount getPromptTokensDetails(int index) {
      if (promptTokensDetailsBuilder_ == null) {
        return promptTokensDetails_.get(index);
      } else {
        return promptTokensDetailsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (promptTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromptTokensDetailsIsMutable();
        promptTokensDetails_.set(index, value);
        onChanged();
      } else {
        promptTokensDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (promptTokensDetailsBuilder_ == null) {
        ensurePromptTokensDetailsIsMutable();
        promptTokensDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        promptTokensDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPromptTokensDetails(com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (promptTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromptTokensDetailsIsMutable();
        promptTokensDetails_.add(value);
        onChanged();
      } else {
        promptTokensDetailsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (promptTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePromptTokensDetailsIsMutable();
        promptTokensDetails_.add(index, value);
        onChanged();
      } else {
        promptTokensDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPromptTokensDetails(
        com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (promptTokensDetailsBuilder_ == null) {
        ensurePromptTokensDetailsIsMutable();
        promptTokensDetails_.add(builderForValue.build());
        onChanged();
      } else {
        promptTokensDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (promptTokensDetailsBuilder_ == null) {
        ensurePromptTokensDetailsIsMutable();
        promptTokensDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        promptTokensDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPromptTokensDetails(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.ModalityTokenCount> values) {
      if (promptTokensDetailsBuilder_ == null) {
        ensurePromptTokensDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, promptTokensDetails_);
        onChanged();
      } else {
        promptTokensDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPromptTokensDetails() {
      if (promptTokensDetailsBuilder_ == null) {
        promptTokensDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        promptTokensDetailsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePromptTokensDetails(int index) {
      if (promptTokensDetailsBuilder_ == null) {
        ensurePromptTokensDetailsIsMutable();
        promptTokensDetails_.remove(index);
        onChanged();
      } else {
        promptTokensDetailsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder getPromptTokensDetailsBuilder(
        int index) {
      return getPromptTokensDetailsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder
        getPromptTokensDetailsOrBuilder(int index) {
      if (promptTokensDetailsBuilder_ == null) {
        return promptTokensDetails_.get(index);
      } else {
        return promptTokensDetailsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getPromptTokensDetailsOrBuilderList() {
      if (promptTokensDetailsBuilder_ != null) {
        return promptTokensDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(promptTokensDetails_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        addPromptTokensDetailsBuilder() {
      return getPromptTokensDetailsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder addPromptTokensDetailsBuilder(
        int index) {
      return getPromptTokensDetailsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder>
        getPromptTokensDetailsBuilderList() {
      return getPromptTokensDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getPromptTokensDetailsFieldBuilder() {
      if (promptTokensDetailsBuilder_ == null) {
        promptTokensDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModalityTokenCount,
                com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
                com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>(
                promptTokensDetails_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        promptTokensDetails_ = null;
      }
      return promptTokensDetailsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount> cacheTokensDetails_ =
        java.util.Collections.emptyList();

    private void ensureCacheTokensDetailsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        cacheTokensDetails_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.ModalityTokenCount>(
                cacheTokensDetails_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        cacheTokensDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
        getCacheTokensDetailsList() {
      if (cacheTokensDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cacheTokensDetails_);
      } else {
        return cacheTokensDetailsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getCacheTokensDetailsCount() {
      if (cacheTokensDetailsBuilder_ == null) {
        return cacheTokensDetails_.size();
      } else {
        return cacheTokensDetailsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount getCacheTokensDetails(int index) {
      if (cacheTokensDetailsBuilder_ == null) {
        return cacheTokensDetails_.get(index);
      } else {
        return cacheTokensDetailsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCacheTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (cacheTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCacheTokensDetailsIsMutable();
        cacheTokensDetails_.set(index, value);
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCacheTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (cacheTokensDetailsBuilder_ == null) {
        ensureCacheTokensDetailsIsMutable();
        cacheTokensDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCacheTokensDetails(com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (cacheTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCacheTokensDetailsIsMutable();
        cacheTokensDetails_.add(value);
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCacheTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (cacheTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCacheTokensDetailsIsMutable();
        cacheTokensDetails_.add(index, value);
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCacheTokensDetails(
        com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (cacheTokensDetailsBuilder_ == null) {
        ensureCacheTokensDetailsIsMutable();
        cacheTokensDetails_.add(builderForValue.build());
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCacheTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (cacheTokensDetailsBuilder_ == null) {
        ensureCacheTokensDetailsIsMutable();
        cacheTokensDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllCacheTokensDetails(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.ModalityTokenCount> values) {
      if (cacheTokensDetailsBuilder_ == null) {
        ensureCacheTokensDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cacheTokensDetails_);
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCacheTokensDetails() {
      if (cacheTokensDetailsBuilder_ == null) {
        cacheTokensDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeCacheTokensDetails(int index) {
      if (cacheTokensDetailsBuilder_ == null) {
        ensureCacheTokensDetailsIsMutable();
        cacheTokensDetails_.remove(index);
        onChanged();
      } else {
        cacheTokensDetailsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder getCacheTokensDetailsBuilder(
        int index) {
      return getCacheTokensDetailsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder
        getCacheTokensDetailsOrBuilder(int index) {
      if (cacheTokensDetailsBuilder_ == null) {
        return cacheTokensDetails_.get(index);
      } else {
        return cacheTokensDetailsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getCacheTokensDetailsOrBuilderList() {
      if (cacheTokensDetailsBuilder_ != null) {
        return cacheTokensDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cacheTokensDetails_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        addCacheTokensDetailsBuilder() {
      return getCacheTokensDetailsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder addCacheTokensDetailsBuilder(
        int index) {
      return getCacheTokensDetailsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the cached content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder>
        getCacheTokensDetailsBuilderList() {
      return getCacheTokensDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getCacheTokensDetailsFieldBuilder() {
      if (cacheTokensDetailsBuilder_ == null) {
        cacheTokensDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModalityTokenCount,
                com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
                com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>(
                cacheTokensDetails_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        cacheTokensDetails_ = null;
      }
      return cacheTokensDetailsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
        candidatesTokensDetails_ = java.util.Collections.emptyList();

    private void ensureCandidatesTokensDetailsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        candidatesTokensDetails_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.ModalityTokenCount>(
                candidatesTokensDetails_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        candidatesTokensDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
        getCandidatesTokensDetailsList() {
      if (candidatesTokensDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(candidatesTokensDetails_);
      } else {
        return candidatesTokensDetailsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getCandidatesTokensDetailsCount() {
      if (candidatesTokensDetailsBuilder_ == null) {
        return candidatesTokensDetails_.size();
      } else {
        return candidatesTokensDetailsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount getCandidatesTokensDetails(int index) {
      if (candidatesTokensDetailsBuilder_ == null) {
        return candidatesTokensDetails_.get(index);
      } else {
        return candidatesTokensDetailsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCandidatesTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (candidatesTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesTokensDetailsIsMutable();
        candidatesTokensDetails_.set(index, value);
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCandidatesTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (candidatesTokensDetailsBuilder_ == null) {
        ensureCandidatesTokensDetailsIsMutable();
        candidatesTokensDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidatesTokensDetails(
        com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (candidatesTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesTokensDetailsIsMutable();
        candidatesTokensDetails_.add(value);
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidatesTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (candidatesTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesTokensDetailsIsMutable();
        candidatesTokensDetails_.add(index, value);
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidatesTokensDetails(
        com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (candidatesTokensDetailsBuilder_ == null) {
        ensureCandidatesTokensDetailsIsMutable();
        candidatesTokensDetails_.add(builderForValue.build());
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCandidatesTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (candidatesTokensDetailsBuilder_ == null) {
        ensureCandidatesTokensDetailsIsMutable();
        candidatesTokensDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllCandidatesTokensDetails(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.ModalityTokenCount> values) {
      if (candidatesTokensDetailsBuilder_ == null) {
        ensureCandidatesTokensDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidatesTokensDetails_);
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCandidatesTokensDetails() {
      if (candidatesTokensDetailsBuilder_ == null) {
        candidatesTokensDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeCandidatesTokensDetails(int index) {
      if (candidatesTokensDetailsBuilder_ == null) {
        ensureCandidatesTokensDetailsIsMutable();
        candidatesTokensDetails_.remove(index);
        onChanged();
      } else {
        candidatesTokensDetailsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        getCandidatesTokensDetailsBuilder(int index) {
      return getCandidatesTokensDetailsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder
        getCandidatesTokensDetailsOrBuilder(int index) {
      if (candidatesTokensDetailsBuilder_ == null) {
        return candidatesTokensDetails_.get(index);
      } else {
        return candidatesTokensDetailsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getCandidatesTokensDetailsOrBuilderList() {
      if (candidatesTokensDetailsBuilder_ != null) {
        return candidatesTokensDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(candidatesTokensDetails_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        addCandidatesTokensDetailsBuilder() {
      return getCandidatesTokensDetailsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        addCandidatesTokensDetailsBuilder(int index) {
      return getCandidatesTokensDetailsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown of the token count for each modality in
     * the generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder>
        getCandidatesTokensDetailsBuilderList() {
      return getCandidatesTokensDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getCandidatesTokensDetailsFieldBuilder() {
      if (candidatesTokensDetailsBuilder_ == null) {
        candidatesTokensDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModalityTokenCount,
                com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
                com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>(
                candidatesTokensDetails_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        candidatesTokensDetails_ = null;
      }
      return candidatesTokensDetailsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
        toolUsePromptTokensDetails_ = java.util.Collections.emptyList();

    private void ensureToolUsePromptTokensDetailsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        toolUsePromptTokensDetails_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.ModalityTokenCount>(
                toolUsePromptTokensDetails_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        toolUsePromptTokensDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
        getToolUsePromptTokensDetailsList() {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(toolUsePromptTokensDetails_);
      } else {
        return toolUsePromptTokensDetailsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getToolUsePromptTokensDetailsCount() {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        return toolUsePromptTokensDetails_.size();
      } else {
        return toolUsePromptTokensDetailsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount getToolUsePromptTokensDetails(
        int index) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        return toolUsePromptTokensDetails_.get(index);
      } else {
        return toolUsePromptTokensDetailsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setToolUsePromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolUsePromptTokensDetailsIsMutable();
        toolUsePromptTokensDetails_.set(index, value);
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setToolUsePromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        ensureToolUsePromptTokensDetailsIsMutable();
        toolUsePromptTokensDetails_.set(index, builderForValue.build());
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addToolUsePromptTokensDetails(
        com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolUsePromptTokensDetailsIsMutable();
        toolUsePromptTokensDetails_.add(value);
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addToolUsePromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount value) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolUsePromptTokensDetailsIsMutable();
        toolUsePromptTokensDetails_.add(index, value);
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addToolUsePromptTokensDetails(
        com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        ensureToolUsePromptTokensDetailsIsMutable();
        toolUsePromptTokensDetails_.add(builderForValue.build());
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addToolUsePromptTokensDetails(
        int index, com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder builderForValue) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        ensureToolUsePromptTokensDetailsIsMutable();
        toolUsePromptTokensDetails_.add(index, builderForValue.build());
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllToolUsePromptTokensDetails(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.ModalityTokenCount> values) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        ensureToolUsePromptTokensDetailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, toolUsePromptTokensDetails_);
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearToolUsePromptTokensDetails() {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        toolUsePromptTokensDetails_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeToolUsePromptTokensDetails(int index) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        ensureToolUsePromptTokensDetailsIsMutable();
        toolUsePromptTokensDetails_.remove(index);
        onChanged();
      } else {
        toolUsePromptTokensDetailsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        getToolUsePromptTokensDetailsBuilder(int index) {
      return getToolUsePromptTokensDetailsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder
        getToolUsePromptTokensDetailsOrBuilder(int index) {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        return toolUsePromptTokensDetails_.get(index);
      } else {
        return toolUsePromptTokensDetailsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getToolUsePromptTokensDetailsOrBuilderList() {
      if (toolUsePromptTokensDetailsBuilder_ != null) {
        return toolUsePromptTokensDetailsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(toolUsePromptTokensDetails_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        addToolUsePromptTokensDetailsBuilder() {
      return getToolUsePromptTokensDetailsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder
        addToolUsePromptTokensDetailsBuilder(int index) {
      return getToolUsePromptTokensDetailsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.ModalityTokenCount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. A detailed breakdown by modality of the token counts from the
     * results of tool executions, which are provided back to the model as input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder>
        getToolUsePromptTokensDetailsBuilderList() {
      return getToolUsePromptTokensDetailsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModalityTokenCount,
            com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
            com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
        getToolUsePromptTokensDetailsFieldBuilder() {
      if (toolUsePromptTokensDetailsBuilder_ == null) {
        toolUsePromptTokensDetailsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModalityTokenCount,
                com.google.cloud.aiplatform.v1.ModalityTokenCount.Builder,
                com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>(
                toolUsePromptTokensDetails_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        toolUsePromptTokensDetails_ = null;
      }
      return toolUsePromptTokensDetailsBuilder_;
    }

    private int trafficType_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The traffic type for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for trafficType.
     */
    @java.lang.Override
    public int getTrafficTypeValue() {
      return trafficType_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The traffic type for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for trafficType to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficTypeValue(int value) {
      trafficType_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The traffic type for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The trafficType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType getTrafficType() {
      com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType result =
          com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType.forNumber(trafficType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The traffic type for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The trafficType to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficType(com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      trafficType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The traffic type for this request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrafficType() {
      bitField0_ = (bitField0_ & ~0x00000400);
      trafficType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.UsageMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.UsageMetadata)
  private static final com.google.cloud.aiplatform.v1.UsageMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.UsageMetadata();
  }

  public static com.google.cloud.aiplatform.v1.UsageMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UsageMetadata> PARSER =
      new com.google.protobuf.AbstractParser<UsageMetadata>() {
        @java.lang.Override
        public UsageMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UsageMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UsageMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.UsageMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
