/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/usage_metadata.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

public interface UsageMetadataOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.UsageMetadata)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The total number of tokens in the prompt. This includes any text, images,
   * or other media provided in the request. When `cached_content` is set,
   * this also includes the number of tokens in the cached content.
   * </pre>
   *
   * <code>int32 prompt_token_count = 1;</code>
   *
   * @return The promptTokenCount.
   */
  int getPromptTokenCount();

  /**
   *
   *
   * <pre>
   * The total number of tokens in the generated candidates.
   * </pre>
   *
   * <code>int32 candidates_token_count = 2;</code>
   *
   * @return The candidatesTokenCount.
   */
  int getCandidatesTokenCount();

  /**
   *
   *
   * <pre>
   * The total number of tokens for the entire request. This is the sum of
   * `prompt_token_count`, `candidates_token_count`,
   * `tool_use_prompt_token_count`, and `thoughts_token_count`.
   * </pre>
   *
   * <code>int32 total_token_count = 3;</code>
   *
   * @return The totalTokenCount.
   */
  int getTotalTokenCount();

  /**
   *
   *
   * <pre>
   * Output only. The number of tokens in the results from tool executions,
   * which are provided back to the model as input, if applicable.
   * </pre>
   *
   * <code>int32 tool_use_prompt_token_count = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The toolUsePromptTokenCount.
   */
  int getToolUsePromptTokenCount();

  /**
   *
   *
   * <pre>
   * Output only. The number of tokens that were part of the model's generated
   * "thoughts" output, if applicable.
   * </pre>
   *
   * <code>int32 thoughts_token_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The thoughtsTokenCount.
   */
  int getThoughtsTokenCount();

  /**
   *
   *
   * <pre>
   * Output only. The number of tokens in the cached content that was used for
   * this request.
   * </pre>
   *
   * <code>int32 cached_content_token_count = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The cachedContentTokenCount.
   */
  int getCachedContentTokenCount();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount> getPromptTokensDetailsList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCount getPromptTokensDetails(int index);

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getPromptTokensDetailsCount();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getPromptTokensDetailsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount prompt_tokens_details = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder getPromptTokensDetailsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount> getCacheTokensDetailsList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCount getCacheTokensDetails(int index);

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getCacheTokensDetailsCount();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getCacheTokensDetailsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the cached content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount cache_tokens_details = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder getCacheTokensDetailsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      getCandidatesTokensDetailsList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCount getCandidatesTokensDetails(int index);

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getCandidatesTokensDetailsCount();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getCandidatesTokensDetailsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown of the token count for each modality in
   * the generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount candidates_tokens_details = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder getCandidatesTokensDetailsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.ModalityTokenCount>
      getToolUsePromptTokensDetailsList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCount getToolUsePromptTokensDetails(int index);

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getToolUsePromptTokensDetailsCount();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder>
      getToolUsePromptTokensDetailsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. A detailed breakdown by modality of the token counts from the
   * results of tool executions, which are provided back to the model as input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.ModalityTokenCount tool_use_prompt_tokens_details = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModalityTokenCountOrBuilder getToolUsePromptTokensDetailsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. The traffic type for this request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for trafficType.
   */
  int getTrafficTypeValue();

  /**
   *
   *
   * <pre>
   * Output only. The traffic type for this request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.UsageMetadata.TrafficType traffic_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The trafficType.
   */
  com.google.cloud.aiplatform.v1.UsageMetadata.TrafficType getTrafficType();
}
