/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/match_service.proto

package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [MatchService.FindNeighbors][google.cloud.aiplatform.v1beta1.MatchService.FindNeighbors].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsRequest}
 */
public final class FindNeighborsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FindNeighborsRequest)
    FindNeighborsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FindNeighborsRequest.newBuilder() to construct.
  private FindNeighborsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FindNeighborsRequest() {
    indexEndpoint_ = "";
    deployedIndexId_ = "";
    queries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FindNeighborsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.class,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Builder.class);
  }

  public interface QueryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the datapoint field is set.
     */
    boolean hasDatapoint();
    /**
     *
     *
     * <pre>
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The datapoint.
     */
    com.google.cloud.aiplatform.v1beta1.IndexDatapoint getDatapoint();
    /**
     *
     *
     * <pre>
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder getDatapointOrBuilder();

    /**
     *
     *
     * <pre>
     * The number of nearest neighbors to be retrieved from database for each
     * query. If not set, will use the default from the service configuration
     * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
     * </pre>
     *
     * <code>int32 neighbor_count = 2;</code>
     *
     * @return The neighborCount.
     */
    int getNeighborCount();

    /**
     *
     *
     * <pre>
     * Crowding is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * It's used for improving result diversity.
     * This field is the maximum number of matches with the same crowding tag.
     * </pre>
     *
     * <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
     *
     * @return The perCrowdingAttributeNeighborCount.
     */
    int getPerCrowdingAttributeNeighborCount();

    /**
     *
     *
     * <pre>
     * The number of neighbors to find via approximate search before
     * exact reordering is performed. If not set, the default value from scam
     * config is used; if set, this value must be &gt; 0.
     * </pre>
     *
     * <code>int32 approximate_neighbor_count = 4;</code>
     *
     * @return The approximateNeighborCount.
     */
    int getApproximateNeighborCount();

    /**
     *
     *
     * <pre>
     * The fraction of the number of leaves to search, set at query time allows
     * user to tune search performance. This value increase result in both
     * search accuracy and latency increase. The value should be between 0.0
     * and 1.0. If not set or set to 0.0, query uses the default value specified
     * in
     * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
     * </pre>
     *
     * <code>double fraction_leaf_nodes_to_search_override = 5;</code>
     *
     * @return The fractionLeafNodesToSearchOverride.
     */
    double getFractionLeafNodesToSearchOverride();
  }
  /**
   *
   *
   * <pre>
   * A query to find a number of the nearest neighbors (most similar vectors)
   * of a vector.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query}
   */
  public static final class Query extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query)
      QueryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Query.newBuilder() to construct.
    private Query(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Query() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Query();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_Query_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_Query_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.class,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder.class);
    }

    public static final int DATAPOINT_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint_;
    /**
     *
     *
     * <pre>
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the datapoint field is set.
     */
    @java.lang.Override
    public boolean hasDatapoint() {
      return datapoint_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The datapoint.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.IndexDatapoint getDatapoint() {
      return datapoint_ == null
          ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
          : datapoint_;
    }
    /**
     *
     *
     * <pre>
     * Required. The datapoint/vector whose nearest neighbors should be searched
     * for.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder getDatapointOrBuilder() {
      return datapoint_ == null
          ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
          : datapoint_;
    }

    public static final int NEIGHBOR_COUNT_FIELD_NUMBER = 2;
    private int neighborCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of nearest neighbors to be retrieved from database for each
     * query. If not set, will use the default from the service configuration
     * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
     * </pre>
     *
     * <code>int32 neighbor_count = 2;</code>
     *
     * @return The neighborCount.
     */
    @java.lang.Override
    public int getNeighborCount() {
      return neighborCount_;
    }

    public static final int PER_CROWDING_ATTRIBUTE_NEIGHBOR_COUNT_FIELD_NUMBER = 3;
    private int perCrowdingAttributeNeighborCount_ = 0;
    /**
     *
     *
     * <pre>
     * Crowding is a constraint on a neighbor list produced by nearest neighbor
     * search requiring that no more than some value k' of the k neighbors
     * returned have the same value of crowding_attribute.
     * It's used for improving result diversity.
     * This field is the maximum number of matches with the same crowding tag.
     * </pre>
     *
     * <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
     *
     * @return The perCrowdingAttributeNeighborCount.
     */
    @java.lang.Override
    public int getPerCrowdingAttributeNeighborCount() {
      return perCrowdingAttributeNeighborCount_;
    }

    public static final int APPROXIMATE_NEIGHBOR_COUNT_FIELD_NUMBER = 4;
    private int approximateNeighborCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of neighbors to find via approximate search before
     * exact reordering is performed. If not set, the default value from scam
     * config is used; if set, this value must be &gt; 0.
     * </pre>
     *
     * <code>int32 approximate_neighbor_count = 4;</code>
     *
     * @return The approximateNeighborCount.
     */
    @java.lang.Override
    public int getApproximateNeighborCount() {
      return approximateNeighborCount_;
    }

    public static final int FRACTION_LEAF_NODES_TO_SEARCH_OVERRIDE_FIELD_NUMBER = 5;
    private double fractionLeafNodesToSearchOverride_ = 0D;
    /**
     *
     *
     * <pre>
     * The fraction of the number of leaves to search, set at query time allows
     * user to tune search performance. This value increase result in both
     * search accuracy and latency increase. The value should be between 0.0
     * and 1.0. If not set or set to 0.0, query uses the default value specified
     * in
     * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
     * </pre>
     *
     * <code>double fraction_leaf_nodes_to_search_override = 5;</code>
     *
     * @return The fractionLeafNodesToSearchOverride.
     */
    @java.lang.Override
    public double getFractionLeafNodesToSearchOverride() {
      return fractionLeafNodesToSearchOverride_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (datapoint_ != null) {
        output.writeMessage(1, getDatapoint());
      }
      if (neighborCount_ != 0) {
        output.writeInt32(2, neighborCount_);
      }
      if (perCrowdingAttributeNeighborCount_ != 0) {
        output.writeInt32(3, perCrowdingAttributeNeighborCount_);
      }
      if (approximateNeighborCount_ != 0) {
        output.writeInt32(4, approximateNeighborCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(fractionLeafNodesToSearchOverride_) != 0) {
        output.writeDouble(5, fractionLeafNodesToSearchOverride_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (datapoint_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDatapoint());
      }
      if (neighborCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, neighborCount_);
      }
      if (perCrowdingAttributeNeighborCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                3, perCrowdingAttributeNeighborCount_);
      }
      if (approximateNeighborCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(4, approximateNeighborCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(fractionLeafNodesToSearchOverride_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                5, fractionLeafNodesToSearchOverride_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query other =
          (com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query) obj;

      if (hasDatapoint() != other.hasDatapoint()) return false;
      if (hasDatapoint()) {
        if (!getDatapoint().equals(other.getDatapoint())) return false;
      }
      if (getNeighborCount() != other.getNeighborCount()) return false;
      if (getPerCrowdingAttributeNeighborCount() != other.getPerCrowdingAttributeNeighborCount())
        return false;
      if (getApproximateNeighborCount() != other.getApproximateNeighborCount()) return false;
      if (java.lang.Double.doubleToLongBits(getFractionLeafNodesToSearchOverride())
          != java.lang.Double.doubleToLongBits(other.getFractionLeafNodesToSearchOverride()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDatapoint()) {
        hash = (37 * hash) + DATAPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getDatapoint().hashCode();
      }
      hash = (37 * hash) + NEIGHBOR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getNeighborCount();
      hash = (37 * hash) + PER_CROWDING_ATTRIBUTE_NEIGHBOR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getPerCrowdingAttributeNeighborCount();
      hash = (37 * hash) + APPROXIMATE_NEIGHBOR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getApproximateNeighborCount();
      hash = (37 * hash) + FRACTION_LEAF_NODES_TO_SEARCH_OVERRIDE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getFractionLeafNodesToSearchOverride()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A query to find a number of the nearest neighbors (most similar vectors)
     * of a vector.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query)
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_Query_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_Query_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.class,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        datapoint_ = null;
        if (datapointBuilder_ != null) {
          datapointBuilder_.dispose();
          datapointBuilder_ = null;
        }
        neighborCount_ = 0;
        perCrowdingAttributeNeighborCount_ = 0;
        approximateNeighborCount_ = 0;
        fractionLeafNodesToSearchOverride_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_Query_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query build() {
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query buildPartial() {
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query result =
            new com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.datapoint_ = datapointBuilder_ == null ? datapoint_ : datapointBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.neighborCount_ = neighborCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.perCrowdingAttributeNeighborCount_ = perCrowdingAttributeNeighborCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.approximateNeighborCount_ = approximateNeighborCount_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.fractionLeafNodesToSearchOverride_ = fractionLeafNodesToSearchOverride_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.getDefaultInstance())
          return this;
        if (other.hasDatapoint()) {
          mergeDatapoint(other.getDatapoint());
        }
        if (other.getNeighborCount() != 0) {
          setNeighborCount(other.getNeighborCount());
        }
        if (other.getPerCrowdingAttributeNeighborCount() != 0) {
          setPerCrowdingAttributeNeighborCount(other.getPerCrowdingAttributeNeighborCount());
        }
        if (other.getApproximateNeighborCount() != 0) {
          setApproximateNeighborCount(other.getApproximateNeighborCount());
        }
        if (other.getFractionLeafNodesToSearchOverride() != 0D) {
          setFractionLeafNodesToSearchOverride(other.getFractionLeafNodesToSearchOverride());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDatapointFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  neighborCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  perCrowdingAttributeNeighborCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  approximateNeighborCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 41:
                {
                  fractionLeafNodesToSearchOverride_ = input.readDouble();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 41
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint,
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder,
              com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder>
          datapointBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the datapoint field is set.
       */
      public boolean hasDatapoint() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The datapoint.
       */
      public com.google.cloud.aiplatform.v1beta1.IndexDatapoint getDatapoint() {
        if (datapointBuilder_ == null) {
          return datapoint_ == null
              ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
              : datapoint_;
        } else {
          return datapointBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDatapoint(com.google.cloud.aiplatform.v1beta1.IndexDatapoint value) {
        if (datapointBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          datapoint_ = value;
        } else {
          datapointBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDatapoint(
          com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder builderForValue) {
        if (datapointBuilder_ == null) {
          datapoint_ = builderForValue.build();
        } else {
          datapointBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeDatapoint(com.google.cloud.aiplatform.v1beta1.IndexDatapoint value) {
        if (datapointBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && datapoint_ != null
              && datapoint_
                  != com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()) {
            getDatapointBuilder().mergeFrom(value);
          } else {
            datapoint_ = value;
          }
        } else {
          datapointBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearDatapoint() {
        bitField0_ = (bitField0_ & ~0x00000001);
        datapoint_ = null;
        if (datapointBuilder_ != null) {
          datapointBuilder_.dispose();
          datapointBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder getDatapointBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDatapointFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder getDatapointOrBuilder() {
        if (datapointBuilder_ != null) {
          return datapointBuilder_.getMessageOrBuilder();
        } else {
          return datapoint_ == null
              ? com.google.cloud.aiplatform.v1beta1.IndexDatapoint.getDefaultInstance()
              : datapoint_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The datapoint/vector whose nearest neighbors should be searched
       * for.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.IndexDatapoint datapoint = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint,
              com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder,
              com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder>
          getDatapointFieldBuilder() {
        if (datapointBuilder_ == null) {
          datapointBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.IndexDatapoint,
                  com.google.cloud.aiplatform.v1beta1.IndexDatapoint.Builder,
                  com.google.cloud.aiplatform.v1beta1.IndexDatapointOrBuilder>(
                  getDatapoint(), getParentForChildren(), isClean());
          datapoint_ = null;
        }
        return datapointBuilder_;
      }

      private int neighborCount_;
      /**
       *
       *
       * <pre>
       * The number of nearest neighbors to be retrieved from database for each
       * query. If not set, will use the default from the service configuration
       * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
       * </pre>
       *
       * <code>int32 neighbor_count = 2;</code>
       *
       * @return The neighborCount.
       */
      @java.lang.Override
      public int getNeighborCount() {
        return neighborCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of nearest neighbors to be retrieved from database for each
       * query. If not set, will use the default from the service configuration
       * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
       * </pre>
       *
       * <code>int32 neighbor_count = 2;</code>
       *
       * @param value The neighborCount to set.
       * @return This builder for chaining.
       */
      public Builder setNeighborCount(int value) {

        neighborCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of nearest neighbors to be retrieved from database for each
       * query. If not set, will use the default from the service configuration
       * (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
       * </pre>
       *
       * <code>int32 neighbor_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNeighborCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        neighborCount_ = 0;
        onChanged();
        return this;
      }

      private int perCrowdingAttributeNeighborCount_;
      /**
       *
       *
       * <pre>
       * Crowding is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * It's used for improving result diversity.
       * This field is the maximum number of matches with the same crowding tag.
       * </pre>
       *
       * <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
       *
       * @return The perCrowdingAttributeNeighborCount.
       */
      @java.lang.Override
      public int getPerCrowdingAttributeNeighborCount() {
        return perCrowdingAttributeNeighborCount_;
      }
      /**
       *
       *
       * <pre>
       * Crowding is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * It's used for improving result diversity.
       * This field is the maximum number of matches with the same crowding tag.
       * </pre>
       *
       * <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
       *
       * @param value The perCrowdingAttributeNeighborCount to set.
       * @return This builder for chaining.
       */
      public Builder setPerCrowdingAttributeNeighborCount(int value) {

        perCrowdingAttributeNeighborCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Crowding is a constraint on a neighbor list produced by nearest neighbor
       * search requiring that no more than some value k' of the k neighbors
       * returned have the same value of crowding_attribute.
       * It's used for improving result diversity.
       * This field is the maximum number of matches with the same crowding tag.
       * </pre>
       *
       * <code>int32 per_crowding_attribute_neighbor_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPerCrowdingAttributeNeighborCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        perCrowdingAttributeNeighborCount_ = 0;
        onChanged();
        return this;
      }

      private int approximateNeighborCount_;
      /**
       *
       *
       * <pre>
       * The number of neighbors to find via approximate search before
       * exact reordering is performed. If not set, the default value from scam
       * config is used; if set, this value must be &gt; 0.
       * </pre>
       *
       * <code>int32 approximate_neighbor_count = 4;</code>
       *
       * @return The approximateNeighborCount.
       */
      @java.lang.Override
      public int getApproximateNeighborCount() {
        return approximateNeighborCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of neighbors to find via approximate search before
       * exact reordering is performed. If not set, the default value from scam
       * config is used; if set, this value must be &gt; 0.
       * </pre>
       *
       * <code>int32 approximate_neighbor_count = 4;</code>
       *
       * @param value The approximateNeighborCount to set.
       * @return This builder for chaining.
       */
      public Builder setApproximateNeighborCount(int value) {

        approximateNeighborCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of neighbors to find via approximate search before
       * exact reordering is performed. If not set, the default value from scam
       * config is used; if set, this value must be &gt; 0.
       * </pre>
       *
       * <code>int32 approximate_neighbor_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearApproximateNeighborCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        approximateNeighborCount_ = 0;
        onChanged();
        return this;
      }

      private double fractionLeafNodesToSearchOverride_;
      /**
       *
       *
       * <pre>
       * The fraction of the number of leaves to search, set at query time allows
       * user to tune search performance. This value increase result in both
       * search accuracy and latency increase. The value should be between 0.0
       * and 1.0. If not set or set to 0.0, query uses the default value specified
       * in
       * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
       * </pre>
       *
       * <code>double fraction_leaf_nodes_to_search_override = 5;</code>
       *
       * @return The fractionLeafNodesToSearchOverride.
       */
      @java.lang.Override
      public double getFractionLeafNodesToSearchOverride() {
        return fractionLeafNodesToSearchOverride_;
      }
      /**
       *
       *
       * <pre>
       * The fraction of the number of leaves to search, set at query time allows
       * user to tune search performance. This value increase result in both
       * search accuracy and latency increase. The value should be between 0.0
       * and 1.0. If not set or set to 0.0, query uses the default value specified
       * in
       * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
       * </pre>
       *
       * <code>double fraction_leaf_nodes_to_search_override = 5;</code>
       *
       * @param value The fractionLeafNodesToSearchOverride to set.
       * @return This builder for chaining.
       */
      public Builder setFractionLeafNodesToSearchOverride(double value) {

        fractionLeafNodesToSearchOverride_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fraction of the number of leaves to search, set at query time allows
       * user to tune search performance. This value increase result in both
       * search accuracy and latency increase. The value should be between 0.0
       * and 1.0. If not set or set to 0.0, query uses the default value specified
       * in
       * NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
       * </pre>
       *
       * <code>double fraction_leaf_nodes_to_search_override = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFractionLeafNodesToSearchOverride() {
        bitField0_ = (bitField0_ & ~0x00000010);
        fractionLeafNodesToSearchOverride_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query)
    private static final com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query();
    }

    public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Query> PARSER =
        new com.google.protobuf.AbstractParser<Query>() {
          @java.lang.Override
          public Query parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Query> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Query> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INDEX_ENDPOINT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object indexEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the index endpoint.
   * Format:
   * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
   * </pre>
   *
   * <code>
   * string index_endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The indexEndpoint.
   */
  @java.lang.Override
  public java.lang.String getIndexEndpoint() {
    java.lang.Object ref = indexEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      indexEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the index endpoint.
   * Format:
   * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
   * </pre>
   *
   * <code>
   * string index_endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for indexEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexEndpointBytes() {
    java.lang.Object ref = indexEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      indexEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_INDEX_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployedIndexId_ = "";
  /**
   *
   *
   * <pre>
   * The ID of the DeployedIndex that will serve the request. This request is
   * sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
   * IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
   * has a DeployedIndex.id field.
   * The value of the field below must equal one of the DeployedIndex.id
   * fields of the IndexEndpoint that is being called for this request.
   * </pre>
   *
   * <code>string deployed_index_id = 2;</code>
   *
   * @return The deployedIndexId.
   */
  @java.lang.Override
  public java.lang.String getDeployedIndexId() {
    java.lang.Object ref = deployedIndexId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedIndexId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the DeployedIndex that will serve the request. This request is
   * sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
   * IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
   * has a DeployedIndex.id field.
   * The value of the field below must equal one of the DeployedIndex.id
   * fields of the IndexEndpoint that is being called for this request.
   * </pre>
   *
   * <code>string deployed_index_id = 2;</code>
   *
   * @return The bytes for deployedIndexId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedIndexIdBytes() {
    java.lang.Object ref = deployedIndexId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedIndexId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERIES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query> queries_;
  /**
   *
   *
   * <pre>
   * The list of queries.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query>
      getQueriesList() {
    return queries_;
  }
  /**
   *
   *
   * <pre>
   * The list of queries.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder>
      getQueriesOrBuilderList() {
    return queries_;
  }
  /**
   *
   *
   * <pre>
   * The list of queries.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;</code>
   */
  @java.lang.Override
  public int getQueriesCount() {
    return queries_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of queries.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query getQueries(int index) {
    return queries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of queries.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder
      getQueriesOrBuilder(int index) {
    return queries_.get(index);
  }

  public static final int RETURN_FULL_DATAPOINT_FIELD_NUMBER = 4;
  private boolean returnFullDatapoint_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, the full datapoints (including all vector values and
   * restricts) of the nearest neighbors are returned.
   * Note that returning full datapoint will significantly increase the
   * latency and cost of the query.
   * </pre>
   *
   * <code>bool return_full_datapoint = 4;</code>
   *
   * @return The returnFullDatapoint.
   */
  @java.lang.Override
  public boolean getReturnFullDatapoint() {
    return returnFullDatapoint_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, indexEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedIndexId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedIndexId_);
    }
    for (int i = 0; i < queries_.size(); i++) {
      output.writeMessage(3, queries_.get(i));
    }
    if (returnFullDatapoint_ != false) {
      output.writeBool(4, returnFullDatapoint_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, indexEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedIndexId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedIndexId_);
    }
    for (int i = 0; i < queries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, queries_.get(i));
    }
    if (returnFullDatapoint_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, returnFullDatapoint_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest other =
        (com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest) obj;

    if (!getIndexEndpoint().equals(other.getIndexEndpoint())) return false;
    if (!getDeployedIndexId().equals(other.getDeployedIndexId())) return false;
    if (!getQueriesList().equals(other.getQueriesList())) return false;
    if (getReturnFullDatapoint() != other.getReturnFullDatapoint()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INDEX_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getIndexEndpoint().hashCode();
    hash = (37 * hash) + DEPLOYED_INDEX_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedIndexId().hashCode();
    if (getQueriesCount() > 0) {
      hash = (37 * hash) + QUERIES_FIELD_NUMBER;
      hash = (53 * hash) + getQueriesList().hashCode();
    }
    hash = (37 * hash) + RETURN_FULL_DATAPOINT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnFullDatapoint());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [MatchService.FindNeighbors][google.cloud.aiplatform.v1beta1.MatchService.FindNeighbors].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FindNeighborsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FindNeighborsRequest)
      com.google.cloud.aiplatform.v1beta1.FindNeighborsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.class,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      indexEndpoint_ = "";
      deployedIndexId_ = "";
      if (queriesBuilder_ == null) {
        queries_ = java.util.Collections.emptyList();
      } else {
        queries_ = null;
        queriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      returnFullDatapoint_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MatchServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_FindNeighborsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest build() {
      com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest result =
          new com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest result) {
      if (queriesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          queries_ = java.util.Collections.unmodifiableList(queries_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.queries_ = queries_;
      } else {
        result.queries_ = queriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.indexEndpoint_ = indexEndpoint_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployedIndexId_ = deployedIndexId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.returnFullDatapoint_ = returnFullDatapoint_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.getDefaultInstance())
        return this;
      if (!other.getIndexEndpoint().isEmpty()) {
        indexEndpoint_ = other.indexEndpoint_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDeployedIndexId().isEmpty()) {
        deployedIndexId_ = other.deployedIndexId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (queriesBuilder_ == null) {
        if (!other.queries_.isEmpty()) {
          if (queries_.isEmpty()) {
            queries_ = other.queries_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureQueriesIsMutable();
            queries_.addAll(other.queries_);
          }
          onChanged();
        }
      } else {
        if (!other.queries_.isEmpty()) {
          if (queriesBuilder_.isEmpty()) {
            queriesBuilder_.dispose();
            queriesBuilder_ = null;
            queries_ = other.queries_;
            bitField0_ = (bitField0_ & ~0x00000004);
            queriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQueriesFieldBuilder()
                    : null;
          } else {
            queriesBuilder_.addAllMessages(other.queries_);
          }
        }
      }
      if (other.getReturnFullDatapoint() != false) {
        setReturnFullDatapoint(other.getReturnFullDatapoint());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                indexEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                deployedIndexId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.parser(),
                        extensionRegistry);
                if (queriesBuilder_ == null) {
                  ensureQueriesIsMutable();
                  queries_.add(m);
                } else {
                  queriesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                returnFullDatapoint_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object indexEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the index endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>
     * string index_endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The indexEndpoint.
     */
    public java.lang.String getIndexEndpoint() {
      java.lang.Object ref = indexEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        indexEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the index endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>
     * string index_endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for indexEndpoint.
     */
    public com.google.protobuf.ByteString getIndexEndpointBytes() {
      java.lang.Object ref = indexEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        indexEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the index endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>
     * string index_endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The indexEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setIndexEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      indexEndpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the index endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>
     * string index_endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndexEndpoint() {
      indexEndpoint_ = getDefaultInstance().getIndexEndpoint();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the index endpoint.
     * Format:
     * `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
     * </pre>
     *
     * <code>
     * string index_endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for indexEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setIndexEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      indexEndpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object deployedIndexId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the DeployedIndex that will serve the request. This request is
     * sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
     * IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
     * has a DeployedIndex.id field.
     * The value of the field below must equal one of the DeployedIndex.id
     * fields of the IndexEndpoint that is being called for this request.
     * </pre>
     *
     * <code>string deployed_index_id = 2;</code>
     *
     * @return The deployedIndexId.
     */
    public java.lang.String getDeployedIndexId() {
      java.lang.Object ref = deployedIndexId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedIndexId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the DeployedIndex that will serve the request. This request is
     * sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
     * IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
     * has a DeployedIndex.id field.
     * The value of the field below must equal one of the DeployedIndex.id
     * fields of the IndexEndpoint that is being called for this request.
     * </pre>
     *
     * <code>string deployed_index_id = 2;</code>
     *
     * @return The bytes for deployedIndexId.
     */
    public com.google.protobuf.ByteString getDeployedIndexIdBytes() {
      java.lang.Object ref = deployedIndexId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedIndexId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the DeployedIndex that will serve the request. This request is
     * sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
     * IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
     * has a DeployedIndex.id field.
     * The value of the field below must equal one of the DeployedIndex.id
     * fields of the IndexEndpoint that is being called for this request.
     * </pre>
     *
     * <code>string deployed_index_id = 2;</code>
     *
     * @param value The deployedIndexId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedIndexId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployedIndexId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the DeployedIndex that will serve the request. This request is
     * sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
     * IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
     * has a DeployedIndex.id field.
     * The value of the field below must equal one of the DeployedIndex.id
     * fields of the IndexEndpoint that is being called for this request.
     * </pre>
     *
     * <code>string deployed_index_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedIndexId() {
      deployedIndexId_ = getDefaultInstance().getDeployedIndexId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the DeployedIndex that will serve the request. This request is
     * sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That
     * IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index
     * has a DeployedIndex.id field.
     * The value of the field below must equal one of the DeployedIndex.id
     * fields of the IndexEndpoint that is being called for this request.
     * </pre>
     *
     * <code>string deployed_index_id = 2;</code>
     *
     * @param value The bytes for deployedIndexId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedIndexIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployedIndexId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query>
        queries_ = java.util.Collections.emptyList();

    private void ensureQueriesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        queries_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query>(
                queries_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder>
        queriesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query>
        getQueriesList() {
      if (queriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(queries_);
      } else {
        return queriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public int getQueriesCount() {
      if (queriesBuilder_ == null) {
        return queries_.size();
      } else {
        return queriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query getQueries(int index) {
      if (queriesBuilder_ == null) {
        return queries_.get(index);
      } else {
        return queriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder setQueries(
        int index, com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query value) {
      if (queriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueriesIsMutable();
        queries_.set(index, value);
        onChanged();
      } else {
        queriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder setQueries(
        int index,
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder builderForValue) {
      if (queriesBuilder_ == null) {
        ensureQueriesIsMutable();
        queries_.set(index, builderForValue.build());
        onChanged();
      } else {
        queriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder addQueries(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query value) {
      if (queriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueriesIsMutable();
        queries_.add(value);
        onChanged();
      } else {
        queriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder addQueries(
        int index, com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query value) {
      if (queriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueriesIsMutable();
        queries_.add(index, value);
        onChanged();
      } else {
        queriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder addQueries(
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder builderForValue) {
      if (queriesBuilder_ == null) {
        ensureQueriesIsMutable();
        queries_.add(builderForValue.build());
        onChanged();
      } else {
        queriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder addQueries(
        int index,
        com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder builderForValue) {
      if (queriesBuilder_ == null) {
        ensureQueriesIsMutable();
        queries_.add(index, builderForValue.build());
        onChanged();
      } else {
        queriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder addAllQueries(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query>
            values) {
      if (queriesBuilder_ == null) {
        ensureQueriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queries_);
        onChanged();
      } else {
        queriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder clearQueries() {
      if (queriesBuilder_ == null) {
        queries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        queriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public Builder removeQueries(int index) {
      if (queriesBuilder_ == null) {
        ensureQueriesIsMutable();
        queries_.remove(index);
        onChanged();
      } else {
        queriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder getQueriesBuilder(
        int index) {
      return getQueriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder
        getQueriesOrBuilder(int index) {
      if (queriesBuilder_ == null) {
        return queries_.get(index);
      } else {
        return queriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder>
        getQueriesOrBuilderList() {
      if (queriesBuilder_ != null) {
        return queriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(queries_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder
        addQueriesBuilder() {
      return getQueriesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder addQueriesBuilder(
        int index) {
      return getQueriesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of queries.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query queries = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder>
        getQueriesBuilderList() {
      return getQueriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder,
            com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder>
        getQueriesFieldBuilder() {
      if (queriesBuilder_ == null) {
        queriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.Query.Builder,
                com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest.QueryOrBuilder>(
                queries_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        queries_ = null;
      }
      return queriesBuilder_;
    }

    private boolean returnFullDatapoint_;
    /**
     *
     *
     * <pre>
     * If set to true, the full datapoints (including all vector values and
     * restricts) of the nearest neighbors are returned.
     * Note that returning full datapoint will significantly increase the
     * latency and cost of the query.
     * </pre>
     *
     * <code>bool return_full_datapoint = 4;</code>
     *
     * @return The returnFullDatapoint.
     */
    @java.lang.Override
    public boolean getReturnFullDatapoint() {
      return returnFullDatapoint_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, the full datapoints (including all vector values and
     * restricts) of the nearest neighbors are returned.
     * Note that returning full datapoint will significantly increase the
     * latency and cost of the query.
     * </pre>
     *
     * <code>bool return_full_datapoint = 4;</code>
     *
     * @param value The returnFullDatapoint to set.
     * @return This builder for chaining.
     */
    public Builder setReturnFullDatapoint(boolean value) {

      returnFullDatapoint_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, the full datapoints (including all vector values and
     * restricts) of the nearest neighbors are returned.
     * Note that returning full datapoint will significantly increase the
     * latency and cost of the query.
     * </pre>
     *
     * <code>bool return_full_datapoint = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReturnFullDatapoint() {
      bitField0_ = (bitField0_ & ~0x00000008);
      returnFullDatapoint_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FindNeighborsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FindNeighborsRequest)
  private static final com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FindNeighborsRequest> PARSER =
      new com.google.protobuf.AbstractParser<FindNeighborsRequest>() {
        @java.lang.Override
        public FindNeighborsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FindNeighborsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FindNeighborsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FindNeighborsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
