/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TrialName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_STUDY_TRIAL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/studies/{study}/trials/{trial}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String study;
    private final String trial;

    @Deprecated
    protected TrialName() {
        this.project = null;
        this.location = null;
        this.study = null;
        this.trial = null;
    }

    private TrialName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.study = (String)Preconditions.checkNotNull((Object)builder.getStudy());
        this.trial = (String)Preconditions.checkNotNull((Object)builder.getTrial());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStudy() {
        return this.study;
    }

    public String getTrial() {
        return this.trial;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TrialName of(String project, String location, String study, String trial) {
        return TrialName.newBuilder().setProject(project).setLocation(location).setStudy(study).setTrial(trial).build();
    }

    public static String format(String project, String location, String study, String trial) {
        return TrialName.newBuilder().setProject(project).setLocation(location).setStudy(study).setTrial(trial).build().toString();
    }

    public static TrialName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_STUDY_TRIAL.validatedMatch(formattedString, "TrialName.parse: formattedString not in valid format");
        return TrialName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("study"), (String)matchMap.get("trial"));
    }

    public static List<TrialName> parseList(List<String> formattedStrings) {
        ArrayList<TrialName> list = new ArrayList<TrialName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TrialName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TrialName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TrialName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_STUDY_TRIAL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TrialName trialName = this;
            synchronized (trialName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.study != null) {
                        fieldMapBuilder.put((Object)"study", (Object)this.study);
                    }
                    if (this.trial != null) {
                        fieldMapBuilder.put((Object)"trial", (Object)this.trial);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_STUDY_TRIAL.instantiate(new String[]{"project", this.project, "location", this.location, "study", this.study, "trial", this.trial});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TrialName that = (TrialName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.study, that.study) && Objects.equals(this.trial, that.trial);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.study);
        h *= 1000003;
        return h ^= Objects.hashCode(this.trial);
    }

    public static class Builder {
        private String project;
        private String location;
        private String study;
        private String trial;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getStudy() {
            return this.study;
        }

        public String getTrial() {
            return this.trial;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setStudy(String study) {
            this.study = study;
            return this;
        }

        public Builder setTrial(String trial) {
            this.trial = trial;
            return this;
        }

        private Builder(TrialName trialName) {
            this.project = trialName.project;
            this.location = trialName.location;
            this.study = trialName.study;
            this.trial = trialName.trial;
        }

        public TrialName build() {
            return new TrialName(this);
        }
    }
}

