/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/index_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [IndexService.ImportIndex][google.cloud.aiplatform.v1beta1.IndexService.ImportIndex].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportIndexRequest}
 */
public final class ImportIndexRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest)
    ImportIndexRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ImportIndexRequest.newBuilder() to construct.
  private ImportIndexRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportIndexRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportIndexRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.class,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.Builder.class);
  }

  public interface ConnectorConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Configuration for importing data from a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
     * </code>
     *
     * @return Whether the bigQuerySourceConfig field is set.
     */
    boolean hasBigQuerySourceConfig();

    /**
     *
     *
     * <pre>
     * Configuration for importing data from a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
     * </code>
     *
     * @return The bigQuerySourceConfig.
     */
    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig
        getBigQuerySourceConfig();

    /**
     *
     *
     * <pre>
     * Configuration for importing data from a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
            .BigQuerySourceConfigOrBuilder
        getBigQuerySourceConfigOrBuilder();

    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.SourceCase
        getSourceCase();
  }

  /**
   *
   *
   * <pre>
   * Configuration for importing data from an external source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig}
   */
  public static final class ConnectorConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig)
      ConnectorConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ConnectorConfig.newBuilder() to construct.
    private ConnectorConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConnectorConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConnectorConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.class,
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.Builder.class);
    }

    public interface DatapointFieldMappingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The column with unique identifiers for each data point.
       * </pre>
       *
       * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The idColumn.
       */
      java.lang.String getIdColumn();

      /**
       *
       *
       * <pre>
       * Required. The column with unique identifiers for each data point.
       * </pre>
       *
       * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for idColumn.
       */
      com.google.protobuf.ByteString getIdColumnBytes();

      /**
       *
       *
       * <pre>
       * Required. The column with the vector embeddings for each data point.
       * </pre>
       *
       * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The embeddingColumn.
       */
      java.lang.String getEmbeddingColumn();

      /**
       *
       *
       * <pre>
       * Required. The column with the vector embeddings for each data point.
       * </pre>
       *
       * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for embeddingColumn.
       */
      com.google.protobuf.ByteString getEmbeddingColumnBytes();

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict>
          getRestrictsList();

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping
              .Restrict
          getRestricts(int index);

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getRestrictsCount();

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.RestrictOrBuilder>
          getRestrictsOrBuilderList();

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping
              .RestrictOrBuilder
          getRestrictsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict>
          getNumericRestrictsList();

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping
              .NumericRestrict
          getNumericRestricts(int index);

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getNumericRestrictsCount();

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrictOrBuilder>
          getNumericRestrictsOrBuilderList();

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping
              .NumericRestrictOrBuilder
          getNumericRestrictsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the metadataColumns.
       */
      java.util.List<java.lang.String> getMetadataColumnsList();

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of metadataColumns.
       */
      int getMetadataColumnsCount();

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The metadataColumns at the given index.
       */
      java.lang.String getMetadataColumns(int index);

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the metadataColumns at the given index.
       */
      com.google.protobuf.ByteString getMetadataColumnsBytes(int index);
    }

    /**
     *
     *
     * <pre>
     * Mapping of datapoint fields to column names for columnar data sources.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping}
     */
    public static final class DatapointFieldMapping extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping)
        DatapointFieldMappingOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use DatapointFieldMapping.newBuilder() to construct.
      private DatapointFieldMapping(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DatapointFieldMapping() {
        idColumn_ = "";
        embeddingColumn_ = "";
        restricts_ = java.util.Collections.emptyList();
        numericRestricts_ = java.util.Collections.emptyList();
        metadataColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DatapointFieldMapping();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.class,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Builder.class);
      }

      public interface RestrictOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict in the index.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The namespace.
         */
        java.lang.String getNamespace();

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict in the index.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for namespace.
         */
        com.google.protobuf.ByteString getNamespaceBytes();

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the allowColumn.
         */
        java.util.List<java.lang.String> getAllowColumnList();

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of allowColumn.
         */
        int getAllowColumnCount();

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The allowColumn at the given index.
         */
        java.lang.String getAllowColumn(int index);

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the allowColumn at the given index.
         */
        com.google.protobuf.ByteString getAllowColumnBytes(int index);

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the denyColumn.
         */
        java.util.List<java.lang.String> getDenyColumnList();

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of denyColumn.
         */
        int getDenyColumnCount();

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The denyColumn at the given index.
         */
        java.lang.String getDenyColumn(int index);

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the denyColumn at the given index.
         */
        com.google.protobuf.ByteString getDenyColumnBytes(int index);
      }

      /**
       *
       *
       * <pre>
       * Restrictions on string values.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict}
       */
      public static final class Restrict extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict)
          RestrictOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use Restrict.newBuilder() to construct.
        private Restrict(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Restrict() {
          namespace_ = "";
          allowColumn_ = com.google.protobuf.LazyStringArrayList.emptyList();
          denyColumn_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Restrict();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_Restrict_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_Restrict_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.Restrict.class,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.Restrict.Builder.class);
        }

        public static final int NAMESPACE_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object namespace_ = "";

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict in the index.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The namespace.
         */
        @java.lang.Override
        public java.lang.String getNamespace() {
          java.lang.Object ref = namespace_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            namespace_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict in the index.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for namespace.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNamespaceBytes() {
          java.lang.Object ref = namespace_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            namespace_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int ALLOW_COLUMN_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList allowColumn_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the allowColumn.
         */
        public com.google.protobuf.ProtocolStringList getAllowColumnList() {
          return allowColumn_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of allowColumn.
         */
        public int getAllowColumnCount() {
          return allowColumn_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The allowColumn at the given index.
         */
        public java.lang.String getAllowColumn(int index) {
          return allowColumn_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the allow values.
         * </pre>
         *
         * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the allowColumn at the given index.
         */
        public com.google.protobuf.ByteString getAllowColumnBytes(int index) {
          return allowColumn_.getByteString(index);
        }

        public static final int DENY_COLUMN_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList denyColumn_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the denyColumn.
         */
        public com.google.protobuf.ProtocolStringList getDenyColumnList() {
          return denyColumn_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of denyColumn.
         */
        public int getDenyColumnCount() {
          return denyColumn_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The denyColumn at the given index.
         */
        public java.lang.String getDenyColumn(int index) {
          return denyColumn_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. The columns containing the deny values.
         * </pre>
         *
         * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the denyColumn at the given index.
         */
        public com.google.protobuf.ByteString getDenyColumnBytes(int index) {
          return denyColumn_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, namespace_);
          }
          for (int i = 0; i < allowColumn_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, allowColumn_.getRaw(i));
          }
          for (int i = 0; i < denyColumn_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, denyColumn_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, namespace_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < allowColumn_.size(); i++) {
              dataSize += computeStringSizeNoTag(allowColumn_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getAllowColumnList().size();
          }
          {
            int dataSize = 0;
            for (int i = 0; i < denyColumn_.size(); i++) {
              dataSize += computeStringSizeNoTag(denyColumn_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getDenyColumnList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict
              other =
                  (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                          .DatapointFieldMapping.Restrict)
                      obj;

          if (!getNamespace().equals(other.getNamespace())) return false;
          if (!getAllowColumnList().equals(other.getAllowColumnList())) return false;
          if (!getDenyColumnList().equals(other.getDenyColumnList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
          hash = (53 * hash) + getNamespace().hashCode();
          if (getAllowColumnCount() > 0) {
            hash = (37 * hash) + ALLOW_COLUMN_FIELD_NUMBER;
            hash = (53 * hash) + getAllowColumnList().hashCode();
          }
          if (getDenyColumnCount() > 0) {
            hash = (37 * hash) + DENY_COLUMN_FIELD_NUMBER;
            hash = (53 * hash) + getDenyColumnList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Restrictions on string values.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict)
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.RestrictOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_Restrict_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_Restrict_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.Restrict.class,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.Restrict.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            namespace_ = "";
            allowColumn_ = com.google.protobuf.LazyStringArrayList.emptyList();
            denyColumn_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_Restrict_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict
              build() {
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict
              buildPartial() {
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict
                result =
                    new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.Restrict(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.Restrict
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.namespace_ = namespace_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              allowColumn_.makeImmutable();
              result.allowColumn_ = allowColumn_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              denyColumn_.makeImmutable();
              result.denyColumn_ = denyColumn_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                          .DatapointFieldMapping.Restrict)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.Restrict
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict.getDefaultInstance()) return this;
            if (!other.getNamespace().isEmpty()) {
              namespace_ = other.namespace_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.allowColumn_.isEmpty()) {
              if (allowColumn_.isEmpty()) {
                allowColumn_ = other.allowColumn_;
                bitField0_ |= 0x00000002;
              } else {
                ensureAllowColumnIsMutable();
                allowColumn_.addAll(other.allowColumn_);
              }
              onChanged();
            }
            if (!other.denyColumn_.isEmpty()) {
              if (denyColumn_.isEmpty()) {
                denyColumn_ = other.denyColumn_;
                bitField0_ |= 0x00000004;
              } else {
                ensureDenyColumnIsMutable();
                denyColumn_.addAll(other.denyColumn_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      namespace_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureAllowColumnIsMutable();
                      allowColumn_.add(s);
                      break;
                    } // case 18
                  case 26:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureDenyColumnIsMutable();
                      denyColumn_.add(s);
                      break;
                    } // case 26
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object namespace_ = "";

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict in the index.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The namespace.
           */
          public java.lang.String getNamespace() {
            java.lang.Object ref = namespace_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              namespace_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict in the index.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for namespace.
           */
          public com.google.protobuf.ByteString getNamespaceBytes() {
            java.lang.Object ref = namespace_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              namespace_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict in the index.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The namespace to set.
           * @return This builder for chaining.
           */
          public Builder setNamespace(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            namespace_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict in the index.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearNamespace() {
            namespace_ = getDefaultInstance().getNamespace();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict in the index.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for namespace to set.
           * @return This builder for chaining.
           */
          public Builder setNamespaceBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            namespace_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList allowColumn_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureAllowColumnIsMutable() {
            if (!allowColumn_.isModifiable()) {
              allowColumn_ = new com.google.protobuf.LazyStringArrayList(allowColumn_);
            }
            bitField0_ |= 0x00000002;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return A list containing the allowColumn.
           */
          public com.google.protobuf.ProtocolStringList getAllowColumnList() {
            allowColumn_.makeImmutable();
            return allowColumn_;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The count of allowColumn.
           */
          public int getAllowColumnCount() {
            return allowColumn_.size();
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the element to return.
           * @return The allowColumn at the given index.
           */
          public java.lang.String getAllowColumn(int index) {
            return allowColumn_.get(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the allowColumn at the given index.
           */
          public com.google.protobuf.ByteString getAllowColumnBytes(int index) {
            return allowColumn_.getByteString(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index to set the value at.
           * @param value The allowColumn to set.
           * @return This builder for chaining.
           */
          public Builder setAllowColumn(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAllowColumnIsMutable();
            allowColumn_.set(index, value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The allowColumn to add.
           * @return This builder for chaining.
           */
          public Builder addAllowColumn(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureAllowColumnIsMutable();
            allowColumn_.add(value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param values The allowColumn to add.
           * @return This builder for chaining.
           */
          public Builder addAllAllowColumn(java.lang.Iterable<java.lang.String> values) {
            ensureAllowColumnIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowColumn_);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAllowColumn() {
            allowColumn_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            ;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the allow values.
           * </pre>
           *
           * <code>repeated string allow_column = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The bytes of the allowColumn to add.
           * @return This builder for chaining.
           */
          public Builder addAllowColumnBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureAllowColumnIsMutable();
            allowColumn_.add(value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList denyColumn_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureDenyColumnIsMutable() {
            if (!denyColumn_.isModifiable()) {
              denyColumn_ = new com.google.protobuf.LazyStringArrayList(denyColumn_);
            }
            bitField0_ |= 0x00000004;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return A list containing the denyColumn.
           */
          public com.google.protobuf.ProtocolStringList getDenyColumnList() {
            denyColumn_.makeImmutable();
            return denyColumn_;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The count of denyColumn.
           */
          public int getDenyColumnCount() {
            return denyColumn_.size();
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param index The index of the element to return.
           * @return The denyColumn at the given index.
           */
          public java.lang.String getDenyColumn(int index) {
            return denyColumn_.get(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the denyColumn at the given index.
           */
          public com.google.protobuf.ByteString getDenyColumnBytes(int index) {
            return denyColumn_.getByteString(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param index The index to set the value at.
           * @param value The denyColumn to set.
           * @return This builder for chaining.
           */
          public Builder setDenyColumn(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenyColumnIsMutable();
            denyColumn_.set(index, value);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The denyColumn to add.
           * @return This builder for chaining.
           */
          public Builder addDenyColumn(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDenyColumnIsMutable();
            denyColumn_.add(value);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param values The denyColumn to add.
           * @return This builder for chaining.
           */
          public Builder addAllDenyColumn(java.lang.Iterable<java.lang.String> values) {
            ensureDenyColumnIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, denyColumn_);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDenyColumn() {
            denyColumn_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            ;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The columns containing the deny values.
           * </pre>
           *
           * <code>repeated string deny_column = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes of the denyColumn to add.
           * @return This builder for chaining.
           */
          public Builder addDenyColumnBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureDenyColumnIsMutable();
            denyColumn_.add(value);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict)
        private static final com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict();
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Restrict> PARSER =
            new com.google.protobuf.AbstractParser<Restrict>() {
              @java.lang.Override
              public Restrict parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Restrict> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Restrict> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface NumericRestrictOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The namespace.
         */
        java.lang.String getNamespace();

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for namespace.
         */
        com.google.protobuf.ByteString getNamespaceBytes();

        /**
         *
         *
         * <pre>
         * Optional. The column containing the numeric value.
         * </pre>
         *
         * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The valueColumn.
         */
        java.lang.String getValueColumn();

        /**
         *
         *
         * <pre>
         * Optional. The column containing the numeric value.
         * </pre>
         *
         * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for valueColumn.
         */
        com.google.protobuf.ByteString getValueColumnBytes();

        /**
         *
         *
         * <pre>
         * Required. Numeric type of the restrict. Must be consistent for
         * all datapoints within the namespace.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for valueType.
         */
        int getValueTypeValue();

        /**
         *
         *
         * <pre>
         * Required. Numeric type of the restrict. Must be consistent for
         * all datapoints within the namespace.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The valueType.
         */
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping
                .NumericRestrict.ValueType
            getValueType();
      }

      /**
       *
       *
       * <pre>
       * Restrictions on numeric values.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict}
       */
      public static final class NumericRestrict extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict)
          NumericRestrictOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use NumericRestrict.newBuilder() to construct.
        private NumericRestrict(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private NumericRestrict() {
          namespace_ = "";
          valueColumn_ = "";
          valueType_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new NumericRestrict();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_NumericRestrict_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_NumericRestrict_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict.class,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * The type of numeric value for the restrict.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType}
         */
        public enum ValueType implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Should not be used.
           * </pre>
           *
           * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
           */
          VALUE_TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * Represents 64 bit integer.
           * </pre>
           *
           * <code>INT = 1;</code>
           */
          INT(1),
          /**
           *
           *
           * <pre>
           * Represents 32 bit float.
           * </pre>
           *
           * <code>FLOAT = 2;</code>
           */
          FLOAT(2),
          /**
           *
           *
           * <pre>
           * Represents 64 bit float.
           * </pre>
           *
           * <code>DOUBLE = 3;</code>
           */
          DOUBLE(3),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Should not be used.
           * </pre>
           *
           * <code>VALUE_TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int VALUE_TYPE_UNSPECIFIED_VALUE = 0;

          /**
           *
           *
           * <pre>
           * Represents 64 bit integer.
           * </pre>
           *
           * <code>INT = 1;</code>
           */
          public static final int INT_VALUE = 1;

          /**
           *
           *
           * <pre>
           * Represents 32 bit float.
           * </pre>
           *
           * <code>FLOAT = 2;</code>
           */
          public static final int FLOAT_VALUE = 2;

          /**
           *
           *
           * <pre>
           * Represents 64 bit float.
           * </pre>
           *
           * <code>DOUBLE = 3;</code>
           */
          public static final int DOUBLE_VALUE = 3;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static ValueType valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static ValueType forNumber(int value) {
            switch (value) {
              case 0:
                return VALUE_TYPE_UNSPECIFIED;
              case 1:
                return INT;
              case 2:
                return FLOAT;
              case 3:
                return DOUBLE;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<ValueType> internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<ValueType>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<ValueType>() {
                    public ValueType findValueByNumber(int number) {
                      return ValueType.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict.getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final ValueType[] VALUES = values();

          public static ValueType valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private ValueType(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType)
        }

        public static final int NAMESPACE_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object namespace_ = "";

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The namespace.
         */
        @java.lang.Override
        public java.lang.String getNamespace() {
          java.lang.Object ref = namespace_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            namespace_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The namespace of the restrict.
         * </pre>
         *
         * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for namespace.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNamespaceBytes() {
          java.lang.Object ref = namespace_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            namespace_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int VALUE_COLUMN_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object valueColumn_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The column containing the numeric value.
         * </pre>
         *
         * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The valueColumn.
         */
        @java.lang.Override
        public java.lang.String getValueColumn() {
          java.lang.Object ref = valueColumn_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            valueColumn_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The column containing the numeric value.
         * </pre>
         *
         * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for valueColumn.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getValueColumnBytes() {
          java.lang.Object ref = valueColumn_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            valueColumn_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int VALUE_TYPE_FIELD_NUMBER = 3;
        private int valueType_ = 0;

        /**
         *
         *
         * <pre>
         * Required. Numeric type of the restrict. Must be consistent for
         * all datapoints within the namespace.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for valueType.
         */
        @java.lang.Override
        public int getValueTypeValue() {
          return valueType_;
        }

        /**
         *
         *
         * <pre>
         * Required. Numeric type of the restrict. Must be consistent for
         * all datapoints within the namespace.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The valueType.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict.ValueType
            getValueType() {
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict.ValueType
              result =
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict.ValueType.forNumber(valueType_);
          return result == null
              ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict.ValueType.UNRECOGNIZED
              : result;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, namespace_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueColumn_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, valueColumn_);
          }
          if (valueType_
              != com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict.ValueType.VALUE_TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(3, valueType_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, namespace_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueColumn_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, valueColumn_);
          }
          if (valueType_
              != com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict.ValueType.VALUE_TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, valueType_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict
              other =
                  (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                          .DatapointFieldMapping.NumericRestrict)
                      obj;

          if (!getNamespace().equals(other.getNamespace())) return false;
          if (!getValueColumn().equals(other.getValueColumn())) return false;
          if (valueType_ != other.valueType_) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
          hash = (53 * hash) + getNamespace().hashCode();
          hash = (37 * hash) + VALUE_COLUMN_FIELD_NUMBER;
          hash = (53 * hash) + getValueColumn().hashCode();
          hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + valueType_;
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Restrictions on numeric values.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict)
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrictOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_NumericRestrict_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_NumericRestrict_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrict.class,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrict.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            namespace_ = "";
            valueColumn_ = "";
            valueType_ = 0;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_NumericRestrict_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict
              build() {
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict
              buildPartial() {
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict
                result =
                    new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrict(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.namespace_ = namespace_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.valueColumn_ = valueColumn_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.valueType_ = valueType_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                          .DatapointFieldMapping.NumericRestrict)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.getDefaultInstance()) return this;
            if (!other.getNamespace().isEmpty()) {
              namespace_ = other.namespace_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getValueColumn().isEmpty()) {
              valueColumn_ = other.valueColumn_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (other.valueType_ != 0) {
              setValueTypeValue(other.getValueTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      namespace_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      valueColumn_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 24:
                    {
                      valueType_ = input.readEnum();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object namespace_ = "";

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The namespace.
           */
          public java.lang.String getNamespace() {
            java.lang.Object ref = namespace_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              namespace_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for namespace.
           */
          public com.google.protobuf.ByteString getNamespaceBytes() {
            java.lang.Object ref = namespace_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              namespace_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The namespace to set.
           * @return This builder for chaining.
           */
          public Builder setNamespace(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            namespace_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearNamespace() {
            namespace_ = getDefaultInstance().getNamespace();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Required. The namespace of the restrict.
           * </pre>
           *
           * <code>string namespace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for namespace to set.
           * @return This builder for chaining.
           */
          public Builder setNamespaceBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            namespace_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object valueColumn_ = "";

          /**
           *
           *
           * <pre>
           * Optional. The column containing the numeric value.
           * </pre>
           *
           * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The valueColumn.
           */
          public java.lang.String getValueColumn() {
            java.lang.Object ref = valueColumn_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              valueColumn_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. The column containing the numeric value.
           * </pre>
           *
           * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for valueColumn.
           */
          public com.google.protobuf.ByteString getValueColumnBytes() {
            java.lang.Object ref = valueColumn_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              valueColumn_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. The column containing the numeric value.
           * </pre>
           *
           * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The valueColumn to set.
           * @return This builder for chaining.
           */
          public Builder setValueColumn(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            valueColumn_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The column containing the numeric value.
           * </pre>
           *
           * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValueColumn() {
            valueColumn_ = getDefaultInstance().getValueColumn();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The column containing the numeric value.
           * </pre>
           *
           * <code>string value_column = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for valueColumn to set.
           * @return This builder for chaining.
           */
          public Builder setValueColumnBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            valueColumn_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private int valueType_ = 0;

          /**
           *
           *
           * <pre>
           * Required. Numeric type of the restrict. Must be consistent for
           * all datapoints within the namespace.
           * </pre>
           *
           * <code>
           * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The enum numeric value on the wire for valueType.
           */
          @java.lang.Override
          public int getValueTypeValue() {
            return valueType_;
          }

          /**
           *
           *
           * <pre>
           * Required. Numeric type of the restrict. Must be consistent for
           * all datapoints within the namespace.
           * </pre>
           *
           * <code>
           * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The enum numeric value on the wire for valueType to set.
           * @return This builder for chaining.
           */
          public Builder setValueTypeValue(int value) {
            valueType_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Required. Numeric type of the restrict. Must be consistent for
           * all datapoints within the namespace.
           * </pre>
           *
           * <code>
           * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The valueType.
           */
          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict.ValueType
              getValueType() {
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.ValueType
                result =
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrict.ValueType.forNumber(valueType_);
            return result == null
                ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.ValueType.UNRECOGNIZED
                : result;
          }

          /**
           *
           *
           * <pre>
           * Required. Numeric type of the restrict. Must be consistent for
           * all datapoints within the namespace.
           * </pre>
           *
           * <code>
           * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The valueType to set.
           * @return This builder for chaining.
           */
          public Builder setValueType(
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict.ValueType
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000004;
            valueType_ = value.getNumber();
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Required. Numeric type of the restrict. Must be consistent for
           * all datapoints within the namespace.
           * </pre>
           *
           * <code>
           * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict.ValueType value_type = 3 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValueType() {
            bitField0_ = (bitField0_ & ~0x00000004);
            valueType_ = 0;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict)
        private static final com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict();
        }

        public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<NumericRestrict> PARSER =
            new com.google.protobuf.AbstractParser<NumericRestrict>() {
              @java.lang.Override
              public NumericRestrict parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<NumericRestrict> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<NumericRestrict> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int ID_COLUMN_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object idColumn_ = "";

      /**
       *
       *
       * <pre>
       * Required. The column with unique identifiers for each data point.
       * </pre>
       *
       * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The idColumn.
       */
      @java.lang.Override
      public java.lang.String getIdColumn() {
        java.lang.Object ref = idColumn_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          idColumn_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The column with unique identifiers for each data point.
       * </pre>
       *
       * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for idColumn.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIdColumnBytes() {
        java.lang.Object ref = idColumn_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          idColumn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int EMBEDDING_COLUMN_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object embeddingColumn_ = "";

      /**
       *
       *
       * <pre>
       * Required. The column with the vector embeddings for each data point.
       * </pre>
       *
       * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The embeddingColumn.
       */
      @java.lang.Override
      public java.lang.String getEmbeddingColumn() {
        java.lang.Object ref = embeddingColumn_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          embeddingColumn_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The column with the vector embeddings for each data point.
       * </pre>
       *
       * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for embeddingColumn.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEmbeddingColumnBytes() {
        java.lang.Object ref = embeddingColumn_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          embeddingColumn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RESTRICTS_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict>
          restricts_;

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.Restrict>
          getRestrictsList() {
        return restricts_;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.RestrictOrBuilder>
          getRestrictsOrBuilderList() {
        return restricts_;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public int getRestrictsCount() {
        return restricts_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping.Restrict
          getRestricts(int index) {
        return restricts_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for string values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping.RestrictOrBuilder
          getRestrictsOrBuilder(int index) {
        return restricts_.get(index);
      }

      public static final int NUMERIC_RESTRICTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict>
          numericRestricts_;

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.NumericRestrict>
          getNumericRestrictsList() {
        return numericRestricts_;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrictOrBuilder>
          getNumericRestrictsOrBuilderList() {
        return numericRestricts_;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public int getNumericRestrictsCount() {
        return numericRestricts_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping.NumericRestrict
          getNumericRestricts(int index) {
        return numericRestricts_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. List of restricts for numeric values.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping.NumericRestrictOrBuilder
          getNumericRestrictsOrBuilder(int index) {
        return numericRestricts_.get(index);
      }

      public static final int METADATA_COLUMNS_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList metadataColumns_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the metadataColumns.
       */
      public com.google.protobuf.ProtocolStringList getMetadataColumnsList() {
        return metadataColumns_;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of metadataColumns.
       */
      public int getMetadataColumnsCount() {
        return metadataColumns_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The metadataColumns at the given index.
       */
      public java.lang.String getMetadataColumns(int index) {
        return metadataColumns_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. List of columns containing metadata to be included in the
       * index.
       * </pre>
       *
       * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the metadataColumns at the given index.
       */
      public com.google.protobuf.ByteString getMetadataColumnsBytes(int index) {
        return metadataColumns_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(idColumn_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, idColumn_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(embeddingColumn_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, embeddingColumn_);
        }
        for (int i = 0; i < restricts_.size(); i++) {
          output.writeMessage(3, restricts_.get(i));
        }
        for (int i = 0; i < numericRestricts_.size(); i++) {
          output.writeMessage(4, numericRestricts_.get(i));
        }
        for (int i = 0; i < metadataColumns_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, metadataColumns_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(idColumn_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, idColumn_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(embeddingColumn_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, embeddingColumn_);
        }
        for (int i = 0; i < restricts_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, restricts_.get(i));
        }
        for (int i = 0; i < numericRestricts_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, numericRestricts_.get(i));
        }
        {
          int dataSize = 0;
          for (int i = 0; i < metadataColumns_.size(); i++) {
            dataSize += computeStringSizeNoTag(metadataColumns_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getMetadataColumnsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping
            other =
                (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping)
                    obj;

        if (!getIdColumn().equals(other.getIdColumn())) return false;
        if (!getEmbeddingColumn().equals(other.getEmbeddingColumn())) return false;
        if (!getRestrictsList().equals(other.getRestrictsList())) return false;
        if (!getNumericRestrictsList().equals(other.getNumericRestrictsList())) return false;
        if (!getMetadataColumnsList().equals(other.getMetadataColumnsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ID_COLUMN_FIELD_NUMBER;
        hash = (53 * hash) + getIdColumn().hashCode();
        hash = (37 * hash) + EMBEDDING_COLUMN_FIELD_NUMBER;
        hash = (53 * hash) + getEmbeddingColumn().hashCode();
        if (getRestrictsCount() > 0) {
          hash = (37 * hash) + RESTRICTS_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictsList().hashCode();
        }
        if (getNumericRestrictsCount() > 0) {
          hash = (37 * hash) + NUMERIC_RESTRICTS_FIELD_NUMBER;
          hash = (53 * hash) + getNumericRestrictsList().hashCode();
        }
        if (getMetadataColumnsCount() > 0) {
          hash = (37 * hash) + METADATA_COLUMNS_FIELD_NUMBER;
          hash = (53 * hash) + getMetadataColumnsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Mapping of datapoint fields to column names for columnar data sources.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping)
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMappingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.class,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          idColumn_ = "";
          embeddingColumn_ = "";
          if (restrictsBuilder_ == null) {
            restricts_ = java.util.Collections.emptyList();
          } else {
            restricts_ = null;
            restrictsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          if (numericRestrictsBuilder_ == null) {
            numericRestricts_ = java.util.Collections.emptyList();
          } else {
            numericRestricts_ = null;
            numericRestrictsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          metadataColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_DatapointFieldMapping_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping
            build() {
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping
              result =
                  new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping
                result) {
          if (restrictsBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              restricts_ = java.util.Collections.unmodifiableList(restricts_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.restricts_ = restricts_;
          } else {
            result.restricts_ = restrictsBuilder_.build();
          }
          if (numericRestrictsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              numericRestricts_ = java.util.Collections.unmodifiableList(numericRestricts_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.numericRestricts_ = numericRestricts_;
          } else {
            result.numericRestricts_ = numericRestrictsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.idColumn_ = idColumn_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.embeddingColumn_ = embeddingColumn_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            metadataColumns_.makeImmutable();
            result.metadataColumns_ = metadataColumns_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .DatapointFieldMapping.getDefaultInstance()) return this;
          if (!other.getIdColumn().isEmpty()) {
            idColumn_ = other.idColumn_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getEmbeddingColumn().isEmpty()) {
            embeddingColumn_ = other.embeddingColumn_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (restrictsBuilder_ == null) {
            if (!other.restricts_.isEmpty()) {
              if (restricts_.isEmpty()) {
                restricts_ = other.restricts_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureRestrictsIsMutable();
                restricts_.addAll(other.restricts_);
              }
              onChanged();
            }
          } else {
            if (!other.restricts_.isEmpty()) {
              if (restrictsBuilder_.isEmpty()) {
                restrictsBuilder_.dispose();
                restrictsBuilder_ = null;
                restricts_ = other.restricts_;
                bitField0_ = (bitField0_ & ~0x00000004);
                restrictsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getRestrictsFieldBuilder()
                        : null;
              } else {
                restrictsBuilder_.addAllMessages(other.restricts_);
              }
            }
          }
          if (numericRestrictsBuilder_ == null) {
            if (!other.numericRestricts_.isEmpty()) {
              if (numericRestricts_.isEmpty()) {
                numericRestricts_ = other.numericRestricts_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureNumericRestrictsIsMutable();
                numericRestricts_.addAll(other.numericRestricts_);
              }
              onChanged();
            }
          } else {
            if (!other.numericRestricts_.isEmpty()) {
              if (numericRestrictsBuilder_.isEmpty()) {
                numericRestrictsBuilder_.dispose();
                numericRestrictsBuilder_ = null;
                numericRestricts_ = other.numericRestricts_;
                bitField0_ = (bitField0_ & ~0x00000008);
                numericRestrictsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getNumericRestrictsFieldBuilder()
                        : null;
              } else {
                numericRestrictsBuilder_.addAllMessages(other.numericRestricts_);
              }
            }
          }
          if (!other.metadataColumns_.isEmpty()) {
            if (metadataColumns_.isEmpty()) {
              metadataColumns_ = other.metadataColumns_;
              bitField0_ |= 0x00000010;
            } else {
              ensureMetadataColumnsIsMutable();
              metadataColumns_.addAll(other.metadataColumns_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    idColumn_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    embeddingColumn_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                            .DatapointFieldMapping.Restrict
                        m =
                            input.readMessage(
                                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest
                                    .ConnectorConfig.DatapointFieldMapping.Restrict.parser(),
                                extensionRegistry);
                    if (restrictsBuilder_ == null) {
                      ensureRestrictsIsMutable();
                      restricts_.add(m);
                    } else {
                      restrictsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                            .DatapointFieldMapping.NumericRestrict
                        m =
                            input.readMessage(
                                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest
                                    .ConnectorConfig.DatapointFieldMapping.NumericRestrict.parser(),
                                extensionRegistry);
                    if (numericRestrictsBuilder_ == null) {
                      ensureNumericRestrictsIsMutable();
                      numericRestricts_.add(m);
                    } else {
                      numericRestrictsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                case 42:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureMetadataColumnsIsMutable();
                    metadataColumns_.add(s);
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object idColumn_ = "";

        /**
         *
         *
         * <pre>
         * Required. The column with unique identifiers for each data point.
         * </pre>
         *
         * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The idColumn.
         */
        public java.lang.String getIdColumn() {
          java.lang.Object ref = idColumn_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            idColumn_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The column with unique identifiers for each data point.
         * </pre>
         *
         * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for idColumn.
         */
        public com.google.protobuf.ByteString getIdColumnBytes() {
          java.lang.Object ref = idColumn_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            idColumn_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The column with unique identifiers for each data point.
         * </pre>
         *
         * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The idColumn to set.
         * @return This builder for chaining.
         */
        public Builder setIdColumn(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          idColumn_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The column with unique identifiers for each data point.
         * </pre>
         *
         * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIdColumn() {
          idColumn_ = getDefaultInstance().getIdColumn();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The column with unique identifiers for each data point.
         * </pre>
         *
         * <code>string id_column = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for idColumn to set.
         * @return This builder for chaining.
         */
        public Builder setIdColumnBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          idColumn_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object embeddingColumn_ = "";

        /**
         *
         *
         * <pre>
         * Required. The column with the vector embeddings for each data point.
         * </pre>
         *
         * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The embeddingColumn.
         */
        public java.lang.String getEmbeddingColumn() {
          java.lang.Object ref = embeddingColumn_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            embeddingColumn_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The column with the vector embeddings for each data point.
         * </pre>
         *
         * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for embeddingColumn.
         */
        public com.google.protobuf.ByteString getEmbeddingColumnBytes() {
          java.lang.Object ref = embeddingColumn_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            embeddingColumn_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The column with the vector embeddings for each data point.
         * </pre>
         *
         * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The embeddingColumn to set.
         * @return This builder for chaining.
         */
        public Builder setEmbeddingColumn(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          embeddingColumn_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The column with the vector embeddings for each data point.
         * </pre>
         *
         * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEmbeddingColumn() {
          embeddingColumn_ = getDefaultInstance().getEmbeddingColumn();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The column with the vector embeddings for each data point.
         * </pre>
         *
         * <code>string embedding_column = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for embeddingColumn to set.
         * @return This builder for chaining.
         */
        public Builder setEmbeddingColumnBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          embeddingColumn_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict>
            restricts_ = java.util.Collections.emptyList();

        private void ensureRestrictsIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            restricts_ =
                new java.util.ArrayList<
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.Restrict>(restricts_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.RestrictOrBuilder>
            restrictsBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict>
            getRestrictsList() {
          if (restrictsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(restricts_);
          } else {
            return restrictsBuilder_.getMessageList();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public int getRestrictsCount() {
          if (restrictsBuilder_ == null) {
            return restricts_.size();
          } else {
            return restrictsBuilder_.getCount();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict
            getRestricts(int index) {
          if (restrictsBuilder_ == null) {
            return restricts_.get(index);
          } else {
            return restrictsBuilder_.getMessage(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict
                value) {
          if (restrictsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRestrictsIsMutable();
            restricts_.set(index, value);
            onChanged();
          } else {
            restrictsBuilder_.setMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict.Builder
                builderForValue) {
          if (restrictsBuilder_ == null) {
            ensureRestrictsIsMutable();
            restricts_.set(index, builderForValue.build());
            onChanged();
          } else {
            restrictsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addRestricts(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict
                value) {
          if (restrictsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRestrictsIsMutable();
            restricts_.add(value);
            onChanged();
          } else {
            restrictsBuilder_.addMessage(value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict
                value) {
          if (restrictsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRestrictsIsMutable();
            restricts_.add(index, value);
            onChanged();
          } else {
            restrictsBuilder_.addMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addRestricts(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict.Builder
                builderForValue) {
          if (restrictsBuilder_ == null) {
            ensureRestrictsIsMutable();
            restricts_.add(builderForValue.build());
            onChanged();
          } else {
            restrictsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict.Builder
                builderForValue) {
          if (restrictsBuilder_ == null) {
            ensureRestrictsIsMutable();
            restricts_.add(index, builderForValue.build());
            onChanged();
          } else {
            restrictsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addAllRestricts(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                            .DatapointFieldMapping.Restrict>
                values) {
          if (restrictsBuilder_ == null) {
            ensureRestrictsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, restricts_);
            onChanged();
          } else {
            restrictsBuilder_.addAllMessages(values);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearRestricts() {
          if (restrictsBuilder_ == null) {
            restricts_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            restrictsBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeRestricts(int index) {
          if (restrictsBuilder_ == null) {
            ensureRestrictsIsMutable();
            restricts_.remove(index);
            onChanged();
          } else {
            restrictsBuilder_.remove(index);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict.Builder
            getRestrictsBuilder(int index) {
          return getRestrictsFieldBuilder().getBuilder(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.RestrictOrBuilder
            getRestrictsOrBuilder(int index) {
          if (restrictsBuilder_ == null) {
            return restricts_.get(index);
          } else {
            return restrictsBuilder_.getMessageOrBuilder(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.RestrictOrBuilder>
            getRestrictsOrBuilderList() {
          if (restrictsBuilder_ != null) {
            return restrictsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(restricts_);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict.Builder
            addRestrictsBuilder() {
          return getRestrictsFieldBuilder()
              .addBuilder(
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.Restrict.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Restrict.Builder
            addRestrictsBuilder(int index) {
          return getRestrictsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.Restrict.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for string values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.Restrict restricts = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict.Builder>
            getRestrictsBuilderList() {
          return getRestrictsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Restrict.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.RestrictOrBuilder>
            getRestrictsFieldBuilder() {
          if (restrictsBuilder_ == null) {
            restrictsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.Restrict,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.Restrict.Builder,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.RestrictOrBuilder>(
                    restricts_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            restricts_ = null;
          }
          return restrictsBuilder_;
        }

        private java.util.List<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict>
            numericRestricts_ = java.util.Collections.emptyList();

        private void ensureNumericRestrictsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            numericRestricts_ =
                new java.util.ArrayList<
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrict>(numericRestricts_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrictOrBuilder>
            numericRestrictsBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict>
            getNumericRestrictsList() {
          if (numericRestrictsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(numericRestricts_);
          } else {
            return numericRestrictsBuilder_.getMessageList();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public int getNumericRestrictsCount() {
          if (numericRestrictsBuilder_ == null) {
            return numericRestricts_.size();
          } else {
            return numericRestrictsBuilder_.getCount();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict
            getNumericRestricts(int index) {
          if (numericRestrictsBuilder_ == null) {
            return numericRestricts_.get(index);
          } else {
            return numericRestrictsBuilder_.getMessage(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setNumericRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict
                value) {
          if (numericRestrictsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNumericRestrictsIsMutable();
            numericRestricts_.set(index, value);
            onChanged();
          } else {
            numericRestrictsBuilder_.setMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setNumericRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.Builder
                builderForValue) {
          if (numericRestrictsBuilder_ == null) {
            ensureNumericRestrictsIsMutable();
            numericRestricts_.set(index, builderForValue.build());
            onChanged();
          } else {
            numericRestrictsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addNumericRestricts(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict
                value) {
          if (numericRestrictsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNumericRestrictsIsMutable();
            numericRestricts_.add(value);
            onChanged();
          } else {
            numericRestrictsBuilder_.addMessage(value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addNumericRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict
                value) {
          if (numericRestrictsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNumericRestrictsIsMutable();
            numericRestricts_.add(index, value);
            onChanged();
          } else {
            numericRestrictsBuilder_.addMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addNumericRestricts(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.Builder
                builderForValue) {
          if (numericRestrictsBuilder_ == null) {
            ensureNumericRestrictsIsMutable();
            numericRestricts_.add(builderForValue.build());
            onChanged();
          } else {
            numericRestrictsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addNumericRestricts(
            int index,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.Builder
                builderForValue) {
          if (numericRestrictsBuilder_ == null) {
            ensureNumericRestrictsIsMutable();
            numericRestricts_.add(index, builderForValue.build());
            onChanged();
          } else {
            numericRestrictsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addAllNumericRestricts(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                            .DatapointFieldMapping.NumericRestrict>
                values) {
          if (numericRestrictsBuilder_ == null) {
            ensureNumericRestrictsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, numericRestricts_);
            onChanged();
          } else {
            numericRestrictsBuilder_.addAllMessages(values);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearNumericRestricts() {
          if (numericRestrictsBuilder_ == null) {
            numericRestricts_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            numericRestrictsBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeNumericRestricts(int index) {
          if (numericRestrictsBuilder_ == null) {
            ensureNumericRestrictsIsMutable();
            numericRestricts_.remove(index);
            onChanged();
          } else {
            numericRestrictsBuilder_.remove(index);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict.Builder
            getNumericRestrictsBuilder(int index) {
          return getNumericRestrictsFieldBuilder().getBuilder(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrictOrBuilder
            getNumericRestrictsOrBuilder(int index) {
          if (numericRestrictsBuilder_ == null) {
            return numericRestricts_.get(index);
          } else {
            return numericRestrictsBuilder_.getMessageOrBuilder(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrictOrBuilder>
            getNumericRestrictsOrBuilderList() {
          if (numericRestrictsBuilder_ != null) {
            return numericRestrictsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(numericRestricts_);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict.Builder
            addNumericRestrictsBuilder() {
          return getNumericRestrictsFieldBuilder()
              .addBuilder(
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.NumericRestrict.Builder
            addNumericRestrictsBuilder(int index) {
          return getNumericRestrictsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .DatapointFieldMapping.NumericRestrict.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Optional. List of restricts for numeric values.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping.NumericRestrict numeric_restricts = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.Builder>
            getNumericRestrictsBuilderList() {
          return getNumericRestrictsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrict.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.NumericRestrictOrBuilder>
            getNumericRestrictsFieldBuilder() {
          if (numericRestrictsBuilder_ == null) {
            numericRestrictsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrict,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrict.Builder,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.NumericRestrictOrBuilder>(
                    numericRestricts_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            numericRestricts_ = null;
          }
          return numericRestrictsBuilder_;
        }

        private com.google.protobuf.LazyStringArrayList metadataColumns_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureMetadataColumnsIsMutable() {
          if (!metadataColumns_.isModifiable()) {
            metadataColumns_ = new com.google.protobuf.LazyStringArrayList(metadataColumns_);
          }
          bitField0_ |= 0x00000010;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the metadataColumns.
         */
        public com.google.protobuf.ProtocolStringList getMetadataColumnsList() {
          metadataColumns_.makeImmutable();
          return metadataColumns_;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of metadataColumns.
         */
        public int getMetadataColumnsCount() {
          return metadataColumns_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The metadataColumns at the given index.
         */
        public java.lang.String getMetadataColumns(int index) {
          return metadataColumns_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the metadataColumns at the given index.
         */
        public com.google.protobuf.ByteString getMetadataColumnsBytes(int index) {
          return metadataColumns_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The metadataColumns to set.
         * @return This builder for chaining.
         */
        public Builder setMetadataColumns(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMetadataColumnsIsMutable();
          metadataColumns_.set(index, value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The metadataColumns to add.
         * @return This builder for chaining.
         */
        public Builder addMetadataColumns(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMetadataColumnsIsMutable();
          metadataColumns_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param values The metadataColumns to add.
         * @return This builder for chaining.
         */
        public Builder addAllMetadataColumns(java.lang.Iterable<java.lang.String> values) {
          ensureMetadataColumnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metadataColumns_);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMetadataColumns() {
          metadataColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of columns containing metadata to be included in the
         * index.
         * </pre>
         *
         * <code>repeated string metadata_columns = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes of the metadataColumns to add.
         * @return This builder for chaining.
         */
        public Builder addMetadataColumnsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureMetadataColumnsIsMutable();
          metadataColumns_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping)
      private static final com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping();
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DatapointFieldMapping> PARSER =
          new com.google.protobuf.AbstractParser<DatapointFieldMapping>() {
            @java.lang.Override
            public DatapointFieldMapping parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DatapointFieldMapping> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DatapointFieldMapping> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface BigQuerySourceConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The path to the BigQuery table containing the index data, in
       * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
       * </pre>
       *
       * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The tablePath.
       */
      java.lang.String getTablePath();

      /**
       *
       *
       * <pre>
       * Required. The path to the BigQuery table containing the index data, in
       * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
       * </pre>
       *
       * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for tablePath.
       */
      com.google.protobuf.ByteString getTablePathBytes();

      /**
       *
       *
       * <pre>
       * Required. Mapping of datapoint fields to BigQuery column names.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the datapointFieldMapping field is set.
       */
      boolean hasDatapointFieldMapping();

      /**
       *
       *
       * <pre>
       * Required. Mapping of datapoint fields to BigQuery column names.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The datapointFieldMapping.
       */
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping
          getDatapointFieldMapping();

      /**
       *
       *
       * <pre>
       * Required. Mapping of datapoint fields to BigQuery column names.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMappingOrBuilder
          getDatapointFieldMappingOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configuration for importing data from a BigQuery table.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig}
     */
    public static final class BigQuerySourceConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig)
        BigQuerySourceConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use BigQuerySourceConfig.newBuilder() to construct.
      private BigQuerySourceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BigQuerySourceConfig() {
        tablePath_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BigQuerySourceConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_BigQuerySourceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_BigQuerySourceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig.class,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig.Builder.class);
      }

      private int bitField0_;
      public static final int TABLE_PATH_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object tablePath_ = "";

      /**
       *
       *
       * <pre>
       * Required. The path to the BigQuery table containing the index data, in
       * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
       * </pre>
       *
       * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The tablePath.
       */
      @java.lang.Override
      public java.lang.String getTablePath() {
        java.lang.Object ref = tablePath_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tablePath_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The path to the BigQuery table containing the index data, in
       * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
       * </pre>
       *
       * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for tablePath.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTablePathBytes() {
        java.lang.Object ref = tablePath_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tablePath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DATAPOINT_FIELD_MAPPING_FIELD_NUMBER = 2;
      private com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          datapointFieldMapping_;

      /**
       *
       *
       * <pre>
       * Required. Mapping of datapoint fields to BigQuery column names.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the datapointFieldMapping field is set.
       */
      @java.lang.Override
      public boolean hasDatapointFieldMapping() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Mapping of datapoint fields to BigQuery column names.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The datapointFieldMapping.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMapping
          getDatapointFieldMapping() {
        return datapointFieldMapping_ == null
            ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.getDefaultInstance()
            : datapointFieldMapping_;
      }

      /**
       *
       *
       * <pre>
       * Required. Mapping of datapoint fields to BigQuery column names.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .DatapointFieldMappingOrBuilder
          getDatapointFieldMappingOrBuilder() {
        return datapointFieldMapping_ == null
            ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.getDefaultInstance()
            : datapointFieldMapping_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tablePath_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tablePath_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getDatapointFieldMapping());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tablePath_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tablePath_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, getDatapointFieldMapping());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .BigQuerySourceConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig
            other =
                (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .BigQuerySourceConfig)
                    obj;

        if (!getTablePath().equals(other.getTablePath())) return false;
        if (hasDatapointFieldMapping() != other.hasDatapointFieldMapping()) return false;
        if (hasDatapointFieldMapping()) {
          if (!getDatapointFieldMapping().equals(other.getDatapointFieldMapping())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TABLE_PATH_FIELD_NUMBER;
        hash = (53 * hash) + getTablePath().hashCode();
        if (hasDatapointFieldMapping()) {
          hash = (37 * hash) + DATAPOINT_FIELD_MAPPING_FIELD_NUMBER;
          hash = (53 * hash) + getDatapointFieldMapping().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig)
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_BigQuerySourceConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_BigQuerySourceConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .BigQuerySourceConfig.class,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .BigQuerySourceConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getDatapointFieldMappingFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          tablePath_ = "";
          datapointFieldMapping_ = null;
          if (datapointFieldMappingBuilder_ != null) {
            datapointFieldMappingBuilder_.dispose();
            datapointFieldMappingBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
              .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_BigQuerySourceConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .BigQuerySourceConfig
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .BigQuerySourceConfig
            build() {
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .BigQuerySourceConfig
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig
              result =
                  new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .BigQuerySourceConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.tablePath_ = tablePath_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.datapointFieldMapping_ =
                datapointFieldMappingBuilder_ == null
                    ? datapointFieldMapping_
                    : datapointFieldMappingBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .BigQuerySourceConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig.getDefaultInstance()) return this;
          if (!other.getTablePath().isEmpty()) {
            tablePath_ = other.tablePath_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasDatapointFieldMapping()) {
            mergeDatapointFieldMapping(other.getDatapointFieldMapping());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    tablePath_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getDatapointFieldMappingFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object tablePath_ = "";

        /**
         *
         *
         * <pre>
         * Required. The path to the BigQuery table containing the index data, in
         * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
         * </pre>
         *
         * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The tablePath.
         */
        public java.lang.String getTablePath() {
          java.lang.Object ref = tablePath_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            tablePath_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The path to the BigQuery table containing the index data, in
         * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
         * </pre>
         *
         * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for tablePath.
         */
        public com.google.protobuf.ByteString getTablePathBytes() {
          java.lang.Object ref = tablePath_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            tablePath_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The path to the BigQuery table containing the index data, in
         * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
         * </pre>
         *
         * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The tablePath to set.
         * @return This builder for chaining.
         */
        public Builder setTablePath(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          tablePath_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The path to the BigQuery table containing the index data, in
         * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
         * </pre>
         *
         * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTablePath() {
          tablePath_ = getDefaultInstance().getTablePath();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The path to the BigQuery table containing the index data, in
         * the format of `bq://&lt;project_id&gt;.&lt;dataset_id&gt;.&lt;table&gt;`.
         * </pre>
         *
         * <code>string table_path = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for tablePath to set.
         * @return This builder for chaining.
         */
        public Builder setTablePathBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          tablePath_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping
            datapointFieldMapping_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMappingOrBuilder>
            datapointFieldMappingBuilder_;

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the datapointFieldMapping field is set.
         */
        public boolean hasDatapointFieldMapping() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The datapointFieldMapping.
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping
            getDatapointFieldMapping() {
          if (datapointFieldMappingBuilder_ == null) {
            return datapointFieldMapping_ == null
                ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.getDefaultInstance()
                : datapointFieldMapping_;
          } else {
            return datapointFieldMappingBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDatapointFieldMapping(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping
                value) {
          if (datapointFieldMappingBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            datapointFieldMapping_ = value;
          } else {
            datapointFieldMappingBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDatapointFieldMapping(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Builder
                builderForValue) {
          if (datapointFieldMappingBuilder_ == null) {
            datapointFieldMapping_ = builderForValue.build();
          } else {
            datapointFieldMappingBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeDatapointFieldMapping(
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping
                value) {
          if (datapointFieldMappingBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && datapointFieldMapping_ != null
                && datapointFieldMapping_
                    != com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.getDefaultInstance()) {
              getDatapointFieldMappingBuilder().mergeFrom(value);
            } else {
              datapointFieldMapping_ = value;
            }
          } else {
            datapointFieldMappingBuilder_.mergeFrom(value);
          }
          if (datapointFieldMapping_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearDatapointFieldMapping() {
          bitField0_ = (bitField0_ & ~0x00000002);
          datapointFieldMapping_ = null;
          if (datapointFieldMappingBuilder_ != null) {
            datapointFieldMappingBuilder_.dispose();
            datapointFieldMappingBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMapping.Builder
            getDatapointFieldMappingBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getDatapointFieldMappingFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .DatapointFieldMappingOrBuilder
            getDatapointFieldMappingOrBuilder() {
          if (datapointFieldMappingBuilder_ != null) {
            return datapointFieldMappingBuilder_.getMessageOrBuilder();
          } else {
            return datapointFieldMapping_ == null
                ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.getDefaultInstance()
                : datapointFieldMapping_;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. Mapping of datapoint fields to BigQuery column names.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.DatapointFieldMapping datapoint_field_mapping = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMapping.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .DatapointFieldMappingOrBuilder>
            getDatapointFieldMappingFieldBuilder() {
          if (datapointFieldMappingBuilder_ == null) {
            datapointFieldMappingBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMapping.Builder,
                    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .DatapointFieldMappingOrBuilder>(
                    getDatapointFieldMapping(), getParentForChildren(), isClean());
            datapointFieldMapping_ = null;
          }
          return datapointFieldMappingBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig)
      private static final com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .BigQuerySourceConfig();
      }

      public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BigQuerySourceConfig> PARSER =
          new com.google.protobuf.AbstractParser<BigQuerySourceConfig>() {
            @java.lang.Override
            public BigQuerySourceConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BigQuerySourceConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BigQuerySourceConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      BIG_QUERY_SOURCE_CONFIG(1),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return BIG_QUERY_SOURCE_CONFIG;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int BIG_QUERY_SOURCE_CONFIG_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Configuration for importing data from a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
     * </code>
     *
     * @return Whether the bigQuerySourceConfig field is set.
     */
    @java.lang.Override
    public boolean hasBigQuerySourceConfig() {
      return sourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Configuration for importing data from a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
     * </code>
     *
     * @return The bigQuerySourceConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
            .BigQuerySourceConfig
        getBigQuerySourceConfig() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .BigQuerySourceConfig)
            source_;
      }
      return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
          .BigQuerySourceConfig.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Configuration for importing data from a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
            .BigQuerySourceConfigOrBuilder
        getBigQuerySourceConfigOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .BigQuerySourceConfig)
            source_;
      }
      return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
          .BigQuerySourceConfig.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig)
                source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                        .BigQuerySourceConfig)
                    source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig other =
          (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig) obj;

      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getBigQuerySourceConfig().equals(other.getBigQuerySourceConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + BIG_QUERY_SOURCE_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getBigQuerySourceConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for importing data from an external source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig)
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.class,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (bigQuerySourceConfigBuilder_ != null) {
          bigQuerySourceConfigBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_ConnectorConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig build() {
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig result =
            new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && bigQuerySourceConfigBuilder_ != null) {
          result.source_ = bigQuerySourceConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .getDefaultInstance()) return this;
        switch (other.getSourceCase()) {
          case BIG_QUERY_SOURCE_CONFIG:
            {
              mergeBigQuerySourceConfig(other.getBigQuerySourceConfig());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getBigQuerySourceConfigFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig,
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfigOrBuilder>
          bigQuerySourceConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       *
       * @return Whether the bigQuerySourceConfig field is set.
       */
      @java.lang.Override
      public boolean hasBigQuerySourceConfig() {
        return sourceCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       *
       * @return The bigQuerySourceConfig.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig
          getBigQuerySourceConfig() {
        if (bigQuerySourceConfigBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig)
                source_;
          }
          return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig.getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return bigQuerySourceConfigBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       */
      public Builder setBigQuerySourceConfig(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig
              value) {
        if (bigQuerySourceConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          bigQuerySourceConfigBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       */
      public Builder setBigQuerySourceConfig(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig.Builder
              builderForValue) {
        if (bigQuerySourceConfigBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          bigQuerySourceConfigBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       */
      public Builder mergeBigQuerySourceConfig(
          com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig
              value) {
        if (bigQuerySourceConfigBuilder_ == null) {
          if (sourceCase_ == 1
              && source_
                  != com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .BigQuerySourceConfig.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                                .BigQuerySourceConfig)
                            source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            bigQuerySourceConfigBuilder_.mergeFrom(value);
          } else {
            bigQuerySourceConfigBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       */
      public Builder clearBigQuerySourceConfig() {
        if (bigQuerySourceConfigBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          bigQuerySourceConfigBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig.Builder
          getBigQuerySourceConfigBuilder() {
        return getBigQuerySourceConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfigOrBuilder
          getBigQuerySourceConfigOrBuilder() {
        if ((sourceCase_ == 1) && (bigQuerySourceConfigBuilder_ != null)) {
          return bigQuerySourceConfigBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig)
                source_;
          }
          return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
              .BigQuerySourceConfig.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Configuration for importing data from a BigQuery table.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.BigQuerySourceConfig big_query_source_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig,
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfig.Builder,
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                  .BigQuerySourceConfigOrBuilder>
          getBigQuerySourceConfigFieldBuilder() {
        if (bigQuerySourceConfigBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .BigQuerySourceConfig.getDefaultInstance();
          }
          bigQuerySourceConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .BigQuerySourceConfig,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .BigQuerySourceConfig.Builder,
                  com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                      .BigQuerySourceConfigOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                          .BigQuerySourceConfig)
                      source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return bigQuerySourceConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig)
    private static final com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConnectorConfig> PARSER =
        new com.google.protobuf.AbstractParser<ConnectorConfig>() {
          @java.lang.Override
          public ConnectorConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConnectorConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConnectorConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the Index resource to import data to.
   * Format:
   * `projects/{project}/locations/{location}/indexes/{index}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the Index resource to import data to.
   * Format:
   * `projects/{project}/locations/{location}/indexes/{index}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_COMPLETE_OVERWRITE_FIELD_NUMBER = 2;
  private boolean isCompleteOverwrite_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, completely replace existing index data. Must be true for
   * streaming update indexes.
   * </pre>
   *
   * <code>bool is_complete_overwrite = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The isCompleteOverwrite.
   */
  @java.lang.Override
  public boolean getIsCompleteOverwrite() {
    return isCompleteOverwrite_;
  }

  public static final int CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config_;

  /**
   *
   *
   * <pre>
   * Required. Configuration for importing data from an external source.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Configuration for importing data from an external source.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig getConfig() {
    return config_ == null
        ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
            .getDefaultInstance()
        : config_;
  }

  /**
   *
   *
   * <pre>
   * Required. Configuration for importing data from an external source.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfigOrBuilder
      getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
            .getDefaultInstance()
        : config_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (isCompleteOverwrite_ != false) {
      output.writeBool(2, isCompleteOverwrite_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (isCompleteOverwrite_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isCompleteOverwrite_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ImportIndexRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ImportIndexRequest other =
        (com.google.cloud.aiplatform.v1beta1.ImportIndexRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (getIsCompleteOverwrite() != other.getIsCompleteOverwrite()) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + IS_COMPLETE_OVERWRITE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsCompleteOverwrite());
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [IndexService.ImportIndex][google.cloud.aiplatform.v1beta1.IndexService.ImportIndex].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ImportIndexRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ImportIndexRequest)
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.class,
              com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      isCompleteOverwrite_ = false;
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.IndexServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ImportIndexRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest build() {
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ImportIndexRequest result =
          new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ImportIndexRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.isCompleteOverwrite_ = isCompleteOverwrite_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ImportIndexRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ImportIndexRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ImportIndexRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getIsCompleteOverwrite() != false) {
        setIsCompleteOverwrite(other.getIsCompleteOverwrite());
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                isCompleteOverwrite_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the Index resource to import data to.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Index resource to import data to.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Index resource to import data to.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Index resource to import data to.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Index resource to import data to.
     * Format:
     * `projects/{project}/locations/{location}/indexes/{index}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean isCompleteOverwrite_;

    /**
     *
     *
     * <pre>
     * Optional. If true, completely replace existing index data. Must be true for
     * streaming update indexes.
     * </pre>
     *
     * <code>bool is_complete_overwrite = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isCompleteOverwrite.
     */
    @java.lang.Override
    public boolean getIsCompleteOverwrite() {
      return isCompleteOverwrite_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, completely replace existing index data. Must be true for
     * streaming update indexes.
     * </pre>
     *
     * <code>bool is_complete_overwrite = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The isCompleteOverwrite to set.
     * @return This builder for chaining.
     */
    public Builder setIsCompleteOverwrite(boolean value) {

      isCompleteOverwrite_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, completely replace existing index data. Must be true for
     * streaming update indexes.
     * </pre>
     *
     * <code>bool is_complete_overwrite = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsCompleteOverwrite() {
      bitField0_ = (bitField0_ & ~0x00000002);
      isCompleteOverwrite_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfigOrBuilder>
        configBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.Builder
            builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConfig(
        com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && config_ != null
            && config_
                != com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                    .getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      if (config_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.Builder
        getConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfigOrBuilder
        getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig
                .getDefaultInstance()
            : config_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Configuration for importing data from an external source.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ImportIndexRequest.ConnectorConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ImportIndexRequest)
  private static final com.google.cloud.aiplatform.v1beta1.ImportIndexRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ImportIndexRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.ImportIndexRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportIndexRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportIndexRequest>() {
        @java.lang.Override
        public ImportIndexRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportIndexRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportIndexRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ImportIndexRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
