/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/session.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A session contains a set of actions between users and Vertex agents.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.Session}
 */
public final class Session extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.Session)
    SessionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Session.newBuilder() to construct.
  private Session(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Session() {
    name_ = "";
    displayName_ = "";
    userId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Session();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_Session_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.SessionProto
        .internal_static_google_cloud_aiplatform_v1beta1_Session_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.Session.class,
            com.google.cloud.aiplatform.v1beta1.Session.Builder.class);
  }

  private int bitField0_;
  private int expirationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object expiration_;

  public enum ExpirationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPIRE_TIME(13),
    TTL(14),
    EXPIRATION_NOT_SET(0);
    private final int value;

    private ExpirationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExpirationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExpirationCase forNumber(int value) {
      switch (value) {
        case 13:
          return EXPIRE_TIME;
        case 14:
          return TTL;
        case 0:
          return EXPIRATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExpirationCase getExpirationCase() {
    return ExpirationCase.forNumber(expirationCase_);
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 13;

  /**
   *
   *
   * <pre>
   * Optional. Timestamp of when this session is considered expired.
   * This is *always* provided on output, regardless of what was sent
   * on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expirationCase_ == 13;
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp of when this session is considered expired.
   * This is *always* provided on output, regardless of what was sent
   * on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    if (expirationCase_ == 13) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp of when this session is considered expired.
   * This is *always* provided on output, regardless of what was sent
   * on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    if (expirationCase_ == 13) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TTL_FIELD_NUMBER = 14;

  /**
   *
   *
   * <pre>
   * Optional. Input only. The TTL for this session.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return expirationCase_ == 14;
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. The TTL for this session.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    if (expirationCase_ == 14) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. The TTL for this session.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    if (expirationCase_ == 14) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the session.
   * Format:
   * 'projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}'.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the session.
   * Format:
   * 'projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}'.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the session was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the session was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the session was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the session was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the session was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the session was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The display name of the session.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The display name of the session.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SESSION_STATE_FIELD_NUMBER = 10;
  private com.google.protobuf.Struct sessionState_;

  /**
   *
   *
   * <pre>
   * Optional. Session specific memory which stores key conversation points.
   * </pre>
   *
   * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sessionState field is set.
   */
  @java.lang.Override
  public boolean hasSessionState() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Session specific memory which stores key conversation points.
   * </pre>
   *
   * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sessionState.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getSessionState() {
    return sessionState_ == null ? com.google.protobuf.Struct.getDefaultInstance() : sessionState_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Session specific memory which stores key conversation points.
   * </pre>
   *
   * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getSessionStateOrBuilder() {
    return sessionState_ == null ? com.google.protobuf.Struct.getDefaultInstance() : sessionState_;
  }

  public static final int USER_ID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userId_ = "";

  /**
   *
   *
   * <pre>
   * Required. Immutable. String id provided by the user
   * </pre>
   *
   * <code>
   * string user_id = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The userId.
   */
  @java.lang.Override
  public java.lang.String getUserId() {
    java.lang.Object ref = userId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Immutable. String id provided by the user
   * </pre>
   *
   * <code>
   * string user_id = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for userId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserIdBytes() {
    java.lang.Object ref = userId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getSessionState());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, userId_);
    }
    if (expirationCase_ == 13) {
      output.writeMessage(13, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 14) {
      output.writeMessage(14, (com.google.protobuf.Duration) expiration_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getSessionState());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, userId_);
    }
    if (expirationCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.protobuf.Duration) expiration_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.Session)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.Session other =
        (com.google.cloud.aiplatform.v1beta1.Session) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasSessionState() != other.hasSessionState()) return false;
    if (hasSessionState()) {
      if (!getSessionState().equals(other.getSessionState())) return false;
    }
    if (!getUserId().equals(other.getUserId())) return false;
    if (!getExpirationCase().equals(other.getExpirationCase())) return false;
    switch (expirationCase_) {
      case 13:
        if (!getExpireTime().equals(other.getExpireTime())) return false;
        break;
      case 14:
        if (!getTtl().equals(other.getTtl())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasSessionState()) {
      hash = (37 * hash) + SESSION_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getSessionState().hashCode();
    }
    hash = (37 * hash) + USER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserId().hashCode();
    switch (expirationCase_) {
      case 13:
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
        break;
      case 14:
        hash = (37 * hash) + TTL_FIELD_NUMBER;
        hash = (53 * hash) + getTtl().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.Session parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.Session prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A session contains a set of actions between users and Vertex agents.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.Session}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.Session)
      com.google.cloud.aiplatform.v1beta1.SessionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_Session_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_Session_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.Session.class,
              com.google.cloud.aiplatform.v1beta1.Session.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.Session.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getSessionStateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.clear();
      }
      if (ttlBuilder_ != null) {
        ttlBuilder_.clear();
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      displayName_ = "";
      sessionState_ = null;
      if (sessionStateBuilder_ != null) {
        sessionStateBuilder_.dispose();
        sessionStateBuilder_ = null;
      }
      userId_ = "";
      expirationCase_ = 0;
      expiration_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.SessionProto
          .internal_static_google_cloud_aiplatform_v1beta1_Session_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Session getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.Session.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Session build() {
      com.google.cloud.aiplatform.v1beta1.Session result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Session buildPartial() {
      com.google.cloud.aiplatform.v1beta1.Session result =
          new com.google.cloud.aiplatform.v1beta1.Session(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.Session result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sessionState_ =
            sessionStateBuilder_ == null ? sessionState_ : sessionStateBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.userId_ = userId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.Session result) {
      result.expirationCase_ = expirationCase_;
      result.expiration_ = this.expiration_;
      if (expirationCase_ == 13 && expireTimeBuilder_ != null) {
        result.expiration_ = expireTimeBuilder_.build();
      }
      if (expirationCase_ == 14 && ttlBuilder_ != null) {
        result.expiration_ = ttlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.Session) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.Session) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.Session other) {
      if (other == com.google.cloud.aiplatform.v1beta1.Session.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasSessionState()) {
        mergeSessionState(other.getSessionState());
      }
      if (!other.getUserId().isEmpty()) {
        userId_ = other.userId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      switch (other.getExpirationCase()) {
        case EXPIRE_TIME:
          {
            mergeExpireTime(other.getExpireTime());
            break;
          }
        case TTL:
          {
            mergeTtl(other.getTtl());
            break;
          }
        case EXPIRATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 82:
              {
                input.readMessage(getSessionStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            case 98:
              {
                userId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 14;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int expirationCase_ = 0;
    private java.lang.Object expiration_;

    public ExpirationCase getExpirationCase() {
      return ExpirationCase.forNumber(expirationCase_);
    }

    public Builder clearExpiration() {
      expirationCase_ = 0;
      expiration_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return expirationCase_ == 13;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 13) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (expirationCase_ == 13) {
          return expireTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      expirationCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 13
            && expiration_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 13) {
          expireTimeBuilder_.mergeFrom(value);
        } else {
          expireTimeBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 13) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 13) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        expireTimeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      return getExpireTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if ((expirationCase_ == 13) && (expireTimeBuilder_ != null)) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 13) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp of when this session is considered expired.
     * This is *always* provided on output, regardless of what was sent
     * on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        if (!(expirationCase_ == 13)) {
          expiration_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 13;
      onChanged();
      return expireTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the ttl field is set.
     */
    @java.lang.Override
    public boolean hasTtl() {
      return expirationCase_ == 14;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The ttl.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 14) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (expirationCase_ == 14) {
          return ttlBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        ttlBuilder_.setMessage(value);
      }
      expirationCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 14
            && expiration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 14) {
          ttlBuilder_.mergeFrom(value);
        } else {
          ttlBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 14) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 14) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        ttlBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      return getTtlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if ((expirationCase_ == 14) && (ttlBuilder_ != null)) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 14) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. The TTL for this session.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration ttl = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        if (!(expirationCase_ == 14)) {
          expiration_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 14;
      onChanged();
      return ttlBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the session.
     * Format:
     * 'projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}'.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the session.
     * Format:
     * 'projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}'.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the session.
     * Format:
     * 'projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}'.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the session.
     * Format:
     * 'projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}'.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the session.
     * Format:
     * 'projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}'.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the session was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The display name of the session.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the session.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the session.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the session.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the session.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct sessionState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        sessionStateBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sessionState field is set.
     */
    public boolean hasSessionState() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sessionState.
     */
    public com.google.protobuf.Struct getSessionState() {
      if (sessionStateBuilder_ == null) {
        return sessionState_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : sessionState_;
      } else {
        return sessionStateBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSessionState(com.google.protobuf.Struct value) {
      if (sessionStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sessionState_ = value;
      } else {
        sessionStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSessionState(com.google.protobuf.Struct.Builder builderForValue) {
      if (sessionStateBuilder_ == null) {
        sessionState_ = builderForValue.build();
      } else {
        sessionStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSessionState(com.google.protobuf.Struct value) {
      if (sessionStateBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && sessionState_ != null
            && sessionState_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getSessionStateBuilder().mergeFrom(value);
        } else {
          sessionState_ = value;
        }
      } else {
        sessionStateBuilder_.mergeFrom(value);
      }
      if (sessionState_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSessionState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      sessionState_ = null;
      if (sessionStateBuilder_ != null) {
        sessionStateBuilder_.dispose();
        sessionStateBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getSessionStateBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSessionStateFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getSessionStateOrBuilder() {
      if (sessionStateBuilder_ != null) {
        return sessionStateBuilder_.getMessageOrBuilder();
      } else {
        return sessionState_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : sessionState_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Session specific memory which stores key conversation points.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_state = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getSessionStateFieldBuilder() {
      if (sessionStateBuilder_ == null) {
        sessionStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getSessionState(), getParentForChildren(), isClean());
        sessionState_ = null;
      }
      return sessionStateBuilder_;
    }

    private java.lang.Object userId_ = "";

    /**
     *
     *
     * <pre>
     * Required. Immutable. String id provided by the user
     * </pre>
     *
     * <code>
     * string user_id = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The userId.
     */
    public java.lang.String getUserId() {
      java.lang.Object ref = userId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. String id provided by the user
     * </pre>
     *
     * <code>
     * string user_id = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for userId.
     */
    public com.google.protobuf.ByteString getUserIdBytes() {
      java.lang.Object ref = userId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. String id provided by the user
     * </pre>
     *
     * <code>
     * string user_id = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. String id provided by the user
     * </pre>
     *
     * <code>
     * string user_id = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserId() {
      userId_ = getDefaultInstance().getUserId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. String id provided by the user
     * </pre>
     *
     * <code>
     * string user_id = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.Session)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.Session)
  private static final com.google.cloud.aiplatform.v1beta1.Session DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.Session();
  }

  public static com.google.cloud.aiplatform.v1beta1.Session getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Session> PARSER =
      new com.google.protobuf.AbstractParser<Session>() {
        @java.lang.Override
        public Session parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Session> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Session> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Session getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
